/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.standalone;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class CardInfo {
    @NotNull
    private final String holder;
    @NotNull
    private final String iccsn;
    @NotNull
    private final SimpleCardType cardType;

    @NotNull
    public String getDescription() {
        return String.format("%s von %s (ID:%s)", new Object[]{this.cardType, this.holder, this.iccsn});
    }

    public CardInfo(@NotNull String holder, @NotNull String iccsn, @NotNull SimpleCardType cardType) {
        this.holder = holder;
        this.iccsn = iccsn;
        this.cardType = cardType;
    }

    @JsonCreator
    public CardInfo(@NotNull Map<String, Object> properties) {
        this.holder = properties.get("holder").toString();
        this.iccsn = properties.get("iccsn").toString();
        this.cardType = SimpleCardType.valueOf(properties.get("cardType").toString());
    }

    @NotNull
    public String getIccsn() {
        return this.iccsn;
    }

    @NotNull
    public String toString() {
        return this.getDescription();
    }

    @NotNull
    String storeIntoString() {
        Properties p = new Properties();
        p.put("holder", this.holder);
        p.put("iccsn", this.iccsn);
        p.put("cardtype", this.cardType.name());
        StringWriter stringWriter = new StringWriter();
        try {
            p.store(stringWriter, "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    @NotNull
    static CardInfo loadFromString(@NotNull String s) {
        Properties p = new Properties();
        StringReader stringReader = new StringReader(s);
        try {
            p.load(stringReader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CardInfo(p.getProperty("holder"), p.getProperty("iccsn"), SimpleCardType.valueOf(p.getProperty("cardtype")));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardInfo cardInfo = (CardInfo)o;
        return this.holder.equals(cardInfo.holder) && this.iccsn.equals(cardInfo.iccsn) && this.cardType == cardInfo.cardType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.holder, this.iccsn, this.cardType});
    }

    public static enum SimpleCardType {
        SMC_B,
        HBA;

    }
}

