/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.model;

import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.model.VaccineType;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum KnownVaccine {
    COVID_BIONTECH("37cc84da-cfbd-4a94-9412-778792daeecc", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_BIONTECH_BA1("064b82c1-18fd-4777-b24e-653d4d6d0489", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_BIONTECH_BA45("a199e590-f4e6-4381-a07e-43057f251db4", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_BIONTECH_XBB("73bf9215-d6c5-4ed5-b86d-0a1e4a76b8a1", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_BIONTECH_XBB_KINDER("163cf81b-ca98-4d36-9b1e-d4b957363342", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_BIONTECH_XBB_KLEINKINDER("6ef77b8a-a50f-4bfd-94d1-5aa756184e7d", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_BIONTECH_KINDER("1b635d21-ca3d-4e98-9719-067e59a84969", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_BIONTECH_KINDER_BA45("f355a757-066e-4558-8602-7723913bec58", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_BIONTECH_KLEINKINDER("84eff41a-6ed4-4e9f-9411-28e0c569000d", "Comirnaty", "EU/1/20/1528", "ORG-100030215", "BioNTech-Pfizer", VaccineType.MRNA),
    COVID_MODERNA("736d8327-f117-4709-83b9-07964bc2bdfd", "Covid-19 (Moderna)", "EU/1/20/1507", "ORG-100031184", "Moderna", VaccineType.MRNA),
    COVID_MODERNA_BA1("e4b76b42-7ed0-492d-a964-b89a3b39540a", "Covid-19 (Moderna)", "EU/1/20/1507", "ORG-100031184", "Moderna", VaccineType.MRNA),
    COVID_MODERNA_BA45("f3f2443e-0ac5-4a13-9e06-ca46a02d547d", "Covid-19 (Moderna)", "EU/1/20/1507", "ORG-100031184", "Moderna", VaccineType.MRNA),
    COVID_MODERNA_AI("3b39b742-ec22-48be-8473-403996dc550e", "Covid-19 (Moderna)", "EU/1/20/1507", "ORG-100031184", "Moderna", VaccineType.MRNA),
    COVID_ASTRAZENECA("5f82b04f-1bf1-462c-8477-b658a3732ca7", "Vaxzevria", "EU/1/21/1529", "ORG-100001699", "AstraZeneca", VaccineType.VECTOR),
    COVID_JANSSEN("0a3c5d07-9b57-479b-ab0f-153a64904522", "Janssen", "EU/1/20/1525", "ORG-100001417", "Johnson&Johnson", VaccineType.VECTOR),
    COVID_NOVAVAX("ea070b42-46a6-4888-9906-cc697e18c4ce", "Nuvaxovid", "EU/1/21/1618", "ORG-100032020", "Novavax CZ a.s.", VaccineType.VECTOR),
    COVID_VALNEVA("9d4043fd-8221-454d-8f92-4fa154084e44", "COVID-19 Vaccine Valneva", "EU/1/21/1624", "ORG-100036422", "Valneva France", VaccineType.UNKNOWN),
    COVID_UNBEKANNT("824555e3-df3a-49a8-9e82-c5a8ff326ac8", "Covid-19 (unbekannt)", null, null, null, VaccineType.UNKNOWN);

    @NotNull
    private final UUID identifier;
    @NotNull
    private final String name;
    @Nullable
    private final String euCode;
    @Nullable
    private final String manufacturerCode;
    @Nullable
    private final String manufacturerName;
    private final VaccineType vaccineType;

    private KnownVaccine(@Nullable String identifier, @Nullable String name, @Nullable String euCode, @Nullable String manufacturerCode, String manufacturerName, VaccineType vaccineType) {
        this.identifier = UUID.fromString(identifier);
        this.name = name;
        this.euCode = euCode;
        this.manufacturerCode = manufacturerCode;
        this.manufacturerName = manufacturerName;
        this.vaccineType = vaccineType;
    }

    public boolean isMRNA() {
        return this.vaccineType == VaccineType.MRNA;
    }

    @NotNull
    public UUID getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public String getProductName() {
        return this.name;
    }

    @NotNull
    public Optional<String> getManufacturerName() {
        return Optional.ofNullable(this.manufacturerName);
    }

    @NotNull
    public Optional<String> getEUCode() {
        return Optional.ofNullable(this.euCode);
    }

    @NotNull
    public Optional<String> getManufacturerCode() {
        return Optional.ofNullable(this.manufacturerCode);
    }

    @NotNull
    public static KnownVaccine findById(@NotNull UUID id) {
        for (KnownVaccine knownVaccine : KnownVaccine.values()) {
            if (!knownVaccine.getIdentifier().equals(id)) continue;
            return knownVaccine;
        }
        throw new ImpfZertException(ImpfZertException.Type.InvalidVaccine, String.format("F\u00fcr die ID %s wurde kein Impfstoff gefunden", id.toString()), null);
    }
}

