/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.model;

import de.impfdoc.impfzert.model.KnownVaccine;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImpfZertVaccine {
    @NotNull
    private final UUID identifier;
    @NotNull
    private final String name;
    @Nullable
    private final String atc;

    public ImpfZertVaccine(@NotNull UUID identifier, @NotNull String name, @Nullable String atc) {
        this.identifier = identifier;
        this.name = name;
        this.atc = atc;
    }

    @NotNull
    public Optional<String> getAtc() {
        return Optional.ofNullable(this.atc);
    }

    @NotNull
    public UUID getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isCovidVaccine() {
        return Arrays.stream(KnownVaccine.values()).anyMatch(v -> v.getIdentifier().equals(this.getIdentifier()));
    }
}

