/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.model;

import de.impfdoc.impfzert.model.ImpfZertDose;
import de.impfdoc.impfzert.model.ImpfZertVaccine;
import java.time.LocalDate;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImpfZertVaccination {
    @NotNull
    private final ImpfZertVaccine vaccine;
    @NotNull
    private final LocalDate vaccinationDate;
    @NotNull
    private final String charge;
    @Nullable
    private final ImpfZertDose dose;

    private ImpfZertVaccination(@NotNull ImpfZertVaccine vaccine, @NotNull LocalDate vaccinationDate, @NotNull String charge, @Nullable ImpfZertDose dose) {
        this.vaccine = vaccine;
        this.vaccinationDate = vaccinationDate;
        this.charge = charge;
        this.dose = dose;
    }

    @NotNull
    public String getCharge() {
        return this.charge;
    }

    @NotNull
    public ImpfZertVaccine getVaccine() {
        return this.vaccine;
    }

    @NotNull
    public LocalDate getVaccinationDate() {
        return this.vaccinationDate;
    }

    @NotNull
    public Optional<ImpfZertDose> getDose() {
        return Optional.ofNullable(this.dose);
    }

    @NotNull
    public static ImpfZertVaccination create(@NotNull ImpfZertVaccine vaccine, @NotNull LocalDate vaccinationDate, @NotNull String charge) {
        return new ImpfZertVaccination(vaccine, vaccinationDate, charge, null);
    }

    @NotNull
    public static ImpfZertVaccination createWithDose(@NotNull ImpfZertVaccine vaccine, @NotNull LocalDate vaccinationDate, @NotNull String charge, @Nullable ImpfZertDose dose) {
        return new ImpfZertVaccination(vaccine, vaccinationDate, charge, dose);
    }
}

