/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.util;

import de.impfdoc.impfzert.model.ImpfZertDose;
import de.impfdoc.impfzert.model.ImpfZertVaccination;
import de.impfdoc.impfzert.model.KnownVaccine;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EuZertDoseCalculator {
    @NotNull
    public static ImpfZertDose calculateDoses(@NotNull List<ImpfZertVaccination> vaccinations, @Nullable LocalDate recoveryDate) {
        boolean singleDoseGi;
        boolean primaryImmunizationBeforeRecovery;
        boolean giWithJanssen;
        List<ImpfZertVaccination> sortedVaccinations = vaccinations.stream().sorted(Comparator.comparing(ImpfZertVaccination::getVaccinationDate)).collect(Collectors.toList());
        boolean bl = giWithJanssen = !vaccinations.isEmpty() && ((ImpfZertVaccination)sortedVaccinations.get(0)).getVaccine().getIdentifier().equals(KnownVaccine.COVID_JANSSEN.getIdentifier());
        if (recoveryDate != null) {
            List vaccinationsBeforeRecovery = sortedVaccinations.stream().filter(v -> v.getVaccinationDate().isBefore(recoveryDate)).collect(Collectors.toList());
            ImpfZertDose notFirstDose = vaccinationsBeforeRecovery.stream().map(v -> v.getDose().orElse(null)).filter(d -> d != null && d.getDose() > 1).findAny().orElse(null);
            primaryImmunizationBeforeRecovery = !vaccinationsBeforeRecovery.isEmpty() && (vaccinationsBeforeRecovery.size() > 1 || notFirstDose != null);
        } else {
            primaryImmunizationBeforeRecovery = true;
        }
        boolean bl2 = singleDoseGi = !primaryImmunizationBeforeRecovery || giWithJanssen;
        if (singleDoseGi) {
            return EuZertDoseCalculator.calculateDosesForSingleDoseGi(sortedVaccinations);
        }
        return EuZertDoseCalculator.calculateDosesForDoubleDoseGi(sortedVaccinations);
    }

    @NotNull
    private static ImpfZertDose calculateDosesForSingleDoseGi(@NotNull List<ImpfZertVaccination> vaccinations) {
        boolean totalDoses = true;
        int dose = 0;
        for (ImpfZertVaccination vaccination : vaccinations) {
            ImpfZertDose impfZertDose = vaccination.getDose().orElse(null);
            if (impfZertDose != null) {
                if (impfZertDose.equals(ImpfZertDose.AI_DOSE)) {
                    dose = Math.max(dose + 1, 2);
                    continue;
                }
                if (impfZertDose.equals(ImpfZertDose.LAST_GI_DOSE)) {
                    dose = Math.max(dose + 1, 1);
                    continue;
                }
                dose = Math.max(dose + 1, impfZertDose.getDose());
                continue;
            }
            ++dose;
        }
        return new ImpfZertDose(dose, 1);
    }

    @NotNull
    private static ImpfZertDose calculateDosesForDoubleDoseGi(@NotNull List<ImpfZertVaccination> vaccinations) {
        int dose = 0;
        for (ImpfZertVaccination vaccination : vaccinations) {
            ImpfZertDose impfZertDose = vaccination.getDose().orElse(null);
            if (impfZertDose != null) {
                if (impfZertDose.equals(ImpfZertDose.AI_DOSE)) {
                    dose = Math.max(dose + 1, 3);
                    continue;
                }
                if (impfZertDose.equals(ImpfZertDose.LAST_GI_DOSE)) {
                    dose = Math.max(dose + 1, 2);
                    continue;
                }
                dose = Math.max(dose + 1, impfZertDose.getDose());
                continue;
            }
            ++dose;
        }
        int totalDoses = dose <= 2 ? 2 : dose;
        return new ImpfZertDose(dose, totalDoses);
    }
}

