/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.util;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import de.impfdoc.impfzert.eu.util.EuCertificateDesc;
import de.impfdoc.impfzert.eu.util.EuCertificateQrDecoder;
import de.impfdoc.impfzert.eu.util.EuCertificateReadException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.jetbrains.annotations.NotNull;

public class EuCertificateReader {
    @NotNull
    private BufferedImage extractQRCodeFromPdf(@NotNull InputStream is) throws EuCertificateReadException {
        BufferedImage bestGuess = null;
        try (PDDocument document = PDDocument.load((InputStream)is);){
            PDPageTree pages = document.getDocumentCatalog().getPages();
            for (int i = 0; i < pages.getCount(); ++i) {
                PDPage page = pages.get(i);
                PDResources resources = page.getResources();
                for (COSName name : resources.getXObjectNames()) {
                    PDXObject object = resources.getXObject(name);
                    if (!(object instanceof PDImageXObject)) continue;
                    PDImageXObject image = (PDImageXObject)resources.getXObject(name);
                    BufferedImage bufferedImage = image.getImage();
                    if (bestGuess == null) {
                        bestGuess = bufferedImage;
                        continue;
                    }
                    if (bestGuess.getHeight() >= image.getHeight() || bestGuess.getWidth() >= image.getWidth()) continue;
                    bestGuess = bufferedImage;
                }
            }
        }
        catch (IOException e) {
            throw new EuCertificateReadException(EuCertificateReadException.Type.IO, "Could not read pdf document", e);
        }
        if (bestGuess == null) {
            throw new EuCertificateReadException(EuCertificateReadException.Type.OTHER, "Could not find any qr code in document", null);
        }
        return bestGuess;
    }

    private String readQRCode(@NotNull BufferedImage image) throws EuCertificateReadException {
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        RGBLuminanceSource source = new RGBLuminanceSource(image.getWidth(), image.getHeight(), pixels);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        QRCodeReader reader = new QRCodeReader();
        try {
            HashMap<DecodeHintType, Boolean> hints = new HashMap<DecodeHintType, Boolean>();
            hints.put(DecodeHintType.PURE_BARCODE, true);
            return reader.decode(bitmap, hints).getText();
        }
        catch (ChecksumException | FormatException | NotFoundException e) {
            throw new EuCertificateReadException(EuCertificateReadException.Type.QR_CODE_NOT_READABLE, "Could not read QR-Code", e);
        }
    }

    @NotNull
    public EuCertificateDesc readEuCertificate(@NotNull InputStream pdf) throws EuCertificateReadException {
        BufferedImage image = this.extractQRCodeFromPdf(pdf);
        String qrCodeContent = this.readQRCode(image);
        return new EuCertificateDesc(EuCertificateQrDecoder.decodeQrContent(qrCodeContent), qrCodeContent, image);
    }
}

