/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.upokecenter.cbor.CBOREncodeOptions;
import com.upokecenter.cbor.CBORObject;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.eu.util.Base45;
import de.impfdoc.impfzert.eu.util.EuCertificateReadException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jetbrains.annotations.NotNull;

public class EuCertificateQrDecoder {
    private static byte[] decodeBase45(@NotNull String base45EncodedContent) {
        return Base45.getDecoder().decode(base45EncodedContent);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] decompress(byte[] input) throws EuCertificateReadException {
        if (input.length < 2 || input[0] != 120) {
            throw new EuCertificateReadException(EuCertificateReadException.Type.UNABLE_TO_DECOMPRESS, "Unable to decompress QR-Code", null);
        }
        try {
            Inflater inflater = new Inflater();
            try {
                byte[] byArray;
                inflater.setInput(input);
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    int len;
                    byte[] buf = new byte[4096];
                    while (!inflater.finished() && (len = inflater.inflate(buf, 0, buf.length)) != 0) {
                        out.write(buf, 0, len);
                    }
                    byArray = out.toByteArray();
                }
                return byArray;
            }
            finally {
                inflater.end();
            }
        }
        catch (IOException | DataFormatException ioe) {
            throw new EuCertificateReadException(EuCertificateReadException.Type.UNABLE_TO_DECOMPRESS, "Unable to decompress QR-Code", ioe);
        }
    }

    @NotNull
    public static CertificationData readCBOR(byte[] input) throws EuCertificateReadException {
        try {
            CBORObject rootObject = CBORObject.DecodeFromBytes((byte[])input, (CBOREncodeOptions)CBOREncodeOptions.Default);
            CBORObject dataObject = CBORObject.DecodeFromBytes((byte[])rootObject.get(2).GetByteString());
            CBORObject bodyObject = dataObject.get(-260);
            CBORObject subBodyObject = bodyObject.get(1);
            return (CertificationData)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor(CertificationData.class).readValue(new String(subBodyObject.ToJSONBytes(), StandardCharsets.UTF_8));
        }
        catch (Throwable t) {
            throw new EuCertificateReadException(EuCertificateReadException.Type.OTHER, "test", t);
        }
    }

    public static byte[] qrContentToByte(@NotNull String qrCodeContent) {
        String cleanedContent = qrCodeContent.replaceAll("^HC1:", "");
        return EuCertificateQrDecoder.decodeBase45(cleanedContent);
    }

    @NotNull
    public static CertificationData decodeQrContent(@NotNull String qrCodeContent) throws EuCertificateReadException {
        return EuCertificateQrDecoder.compressedContentToCertData(EuCertificateQrDecoder.qrContentToByte(qrCodeContent));
    }

    @NotNull
    public static CertificationData compressedContentToCertData(byte[] compressedContent) throws EuCertificateReadException {
        byte[] decompressedResult = EuCertificateQrDecoder.decompress(compressedContent);
        return EuCertificateQrDecoder.readCBOR(decompressedResult);
    }
}

