/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.api.VaccinationInfo;
import de.impfdoc.impfzert.model.ImpfZertVaccination;
import de.impfdoc.impfzert.model.KnownVaccine;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class VaccinationData {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @JsonProperty(value="tg")
    @NotNull
    private String disease = "840539006";
    @JsonProperty(value="vp")
    @NotNull
    private String snowMedCode;
    @JsonProperty(value="dn")
    private int dose;
    @JsonProperty(value="sd")
    private int totalDoses;
    @JsonProperty(value="dt")
    private String vaccinationDate;
    @JsonProperty(value="mp")
    private String productEUCode;
    @JsonProperty(value="ma")
    private String manufacturer;
    @JsonProperty(value="id")
    private String bsnr;
    @JsonProperty(value="ci")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String uvci;
    @JsonProperty(value="co")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String country;
    @JsonProperty(value="is")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String institute;

    public VaccinationData() {
    }

    public VaccinationData(@NotNull VaccinationInfo vaccinationInfo) {
        ImpfZertVaccination lastVaccination = (ImpfZertVaccination)vaccinationInfo.getVaccinations().stream().reduce((first, second) -> second).orElseThrow(() -> new ImpfZertException(ImpfZertException.Type.IllegalArgument, "no vaccination given", null));
        KnownVaccine knownVaccine = KnownVaccine.findById(lastVaccination.getVaccine().getIdentifier());
        this.snowMedCode = knownVaccine.isMRNA() ? "1119349007" : "J07BX03";
        this.vaccinationDate = lastVaccination.getVaccinationDate().format(formatter);
        this.dose = vaccinationInfo.getDose();
        this.totalDoses = vaccinationInfo.getTotalDoses();
        this.productEUCode = knownVaccine.getEUCode().orElseThrow(() -> new ImpfZertException(ImpfZertException.Type.IllegalArgument, "f\u00fcr den Impfstoff " + knownVaccine.name() + " ist kein Zulassungscode hinterlegt.", null));
        this.manufacturer = knownVaccine.getManufacturerCode().orElseThrow(() -> new ImpfZertException(ImpfZertException.Type.IllegalArgument, "f\u00fcr den Impfstoff " + knownVaccine.name() + " ist kein Hersteller bekannt.", null));
        this.bsnr = vaccinationInfo.getOperatingSite().getBsnr();
    }

    @NotNull
    public String getVaccineName() {
        for (KnownVaccine knownVaccine : KnownVaccine.values()) {
            String euCode = knownVaccine.getEUCode().orElse(null);
            if (!this.productEUCode.equals(euCode)) continue;
            return knownVaccine.getProductName();
        }
        return "";
    }

    @NotNull
    public String getVaccineType() {
        if ("1119349007".equals(this.snowMedCode)) {
            return "SARS-CoV-2 mRNA vaccine";
        }
        return "covid-19 vaccines";
    }

    @NotNull
    public Optional<UUID> getVaccineId() {
        for (KnownVaccine knownVaccine : KnownVaccine.values()) {
            String euCode = knownVaccine.getEUCode().orElse(null);
            if (!this.productEUCode.equals(euCode)) continue;
            return Optional.of(knownVaccine.getIdentifier());
        }
        return Optional.empty();
    }

    @NotNull
    public String getManufacturerName() {
        for (KnownVaccine knownVaccine : KnownVaccine.values()) {
            String euCode = knownVaccine.getEUCode().orElse(null);
            if (!this.productEUCode.equals(euCode)) continue;
            return knownVaccine.getManufacturerName().orElse("");
        }
        return "";
    }

    @NotNull
    public String getDoses() {
        return String.format("%d / %d", this.dose, this.totalDoses);
    }

    @NotNull
    public String getVaccinationDate() {
        return this.vaccinationDate;
    }

    @NotNull
    public String getInstitute() {
        return this.institute;
    }

    @NotNull
    public String getUvci() {
        return this.uvci;
    }

    @NotNull
    public String getCountry() {
        return this.country;
    }
}

