/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.impfdoc.impfzert.api.VaccinationInfo;
import de.impfdoc.impfzert.eu.json.PatientName;
import de.impfdoc.impfzert.eu.json.RecoveryData;
import de.impfdoc.impfzert.eu.json.TestResultData;
import de.impfdoc.impfzert.eu.json.VaccinationData;
import de.impfdoc.impfzert.model.ImpfZertPatient;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class CertificationData {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @JsonProperty(value="ver")
    @NotNull
    private String version = "1.0.0";
    @JsonProperty(value="nam")
    @NotNull
    private PatientName name;
    @JsonProperty(value="dob")
    @NotNull
    private String birthday;
    @JsonProperty(value="v")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    private List<VaccinationData> vaccinationData;
    @JsonProperty(value="r")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private List<RecoveryData> recoveryData;
    @JsonProperty(value="t")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private List<TestResultData> testResultData;

    public CertificationData() {
    }

    private CertificationData(@NotNull ImpfZertPatient patient, @Nullable VaccinationInfo vaccinationInfo, @Nullable RecoveryData recoveryData, @Nullable TestResultData testResultData) {
        this.name = new PatientName(patient.getLastname(), patient.getFirstname());
        this.birthday = patient.getBirthday().format(formatter);
        this.vaccinationData = vaccinationInfo != null ? Collections.singletonList(new VaccinationData(vaccinationInfo)) : null;
        this.recoveryData = recoveryData != null ? Collections.singletonList(recoveryData) : null;
        this.testResultData = testResultData != null ? Collections.singletonList(testResultData) : null;
    }

    @NotNull
    public PatientName getPatientName() {
        return this.name;
    }

    @NotNull
    public String getName() {
        return String.format("%s, %s", this.name.getFamilyname(), this.name.getGivenname());
    }

    @NotNull
    public String getBirthday() {
        return this.birthday;
    }

    @NotNull
    public Optional<VaccinationData> getVaccinationData() {
        if (this.vaccinationData == null || this.vaccinationData.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.vaccinationData.get(0));
    }

    @NotNull
    public Optional<RecoveryData> getRecoveryData() {
        if (this.recoveryData == null || this.recoveryData.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.recoveryData.get(0));
    }

    @NotNull
    public static CertificationData forVaccinationCertificate(@NotNull VaccinationInfo vaccinationInfo) {
        return new CertificationData(vaccinationInfo.getPatient(), vaccinationInfo, null, null);
    }

    @NotNull
    public static CertificationData forRecoveryCertificate(@NotNull ImpfZertPatient patient, @NotNull RecoveryData recoveryData) {
        return new CertificationData(patient, null, recoveryData, null);
    }

    @NotNull
    public static CertificationData forTestCertificate(@NotNull ImpfZertPatient patient, @NotNull TestResultData testResultData) {
        return new CertificationData(patient, null, null, testResultData);
    }
}

