/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class Token {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="not-before-policy")
    private long notBefore;
    @JsonProperty(value="expires_in")
    private long expiresIn;
    @JsonProperty(value="refresh_expires_in")
    private long refreshExpiresIn;
    private long creationTime = Token.getTime();

    public Token() {
    }

    public Token(@NotNull String token) {
        this.accessToken = token;
    }

    @NotNull
    public String getAccessToken() {
        return this.accessToken;
    }

    @NotNull
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isExpired() {
        return this.timeSinceCreation() > this.expiresIn - 5L;
    }

    public boolean isRefreshPossible() {
        return this.timeSinceCreation() < this.refreshExpiresIn + 5L;
    }

    private long timeSinceCreation() {
        return Token.getTime() - this.creationTime;
    }

    private static long getTime() {
        return System.currentTimeMillis() / 1000L;
    }
}

