/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.customizer;

import de.impfdoc.impfzert.eu.json.CertificationData;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class PdfItem {
    private final float x;
    private final float y;
    private final float r;
    private final Function<CertificationData, String> mapper;

    public PdfItem(float x, float y, Function<CertificationData, String> mapper) {
        this.x = x;
        this.y = y;
        this.mapper = mapper;
        this.r = 0.0f;
    }

    public PdfItem(float x, float y, double r, Function<CertificationData, String> mapper) {
        this.x = x;
        this.y = y;
        this.mapper = mapper;
        this.r = (float)r;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getR() {
        return this.r;
    }

    @NotNull
    public String getText(@NotNull CertificationData data) {
        return this.mapper.apply(data);
    }
}

