/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.customizer;

import de.impfdoc.impfzert.common.pdf.PdfUtils;
import de.impfdoc.impfzert.eu.customizer.PdfItem;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.eu.json.VaccinationData;
import de.impfdoc.impfzert.eu.util.EuCertificateDesc;
import de.impfdoc.impfzert.model.ImpfZert;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.jetbrains.annotations.NotNull;

public class EuVaccinationCertCustomizer {
    private final float DOC_HEIGHT = 1411.0f;
    private final float DOC_WIDTH = 1000.0f;
    private final float FONT_SIZE = 9.0f;
    @NotNull
    private final List<PdfItem> items = Arrays.asList(new PdfItem(0.039f, 0.6080794f, data -> "COVID-19"), new PdfItem(0.039f, 0.6523742f, data -> data.getVaccinationData().map(VaccinationData::getVaccineType).orElse("")), new PdfItem(0.039f, 0.7115521f, data -> data.getVaccinationData().map(VaccinationData::getVaccineName).orElse("")), new PdfItem(0.039f, 0.7647059f, data -> data.getVaccinationData().map(VaccinationData::getManufacturerName).orElse("")), new PdfItem(0.039f, 0.83699507f, data -> data.getVaccinationData().map(VaccinationData::getDoses).orElse("")), new PdfItem(0.039f, 0.87987244f, data -> data.getVaccinationData().map(VaccinationData::getVaccinationDate).orElse("")), new PdfItem(0.039f, 0.92062366f, data -> "DE"), new PdfItem(0.039f, 0.9617293f, data -> data.getVaccinationData().map(VaccinationData::getInstitute).orElse("")), new PdfItem(0.949f, 0.19985826f, Math.toRadians(180.0), CertificationData::getName), new PdfItem(0.949f, 0.13465627f, Math.toRadians(180.0), CertificationData::getBirthday), new PdfItem(0.949f, 0.056697376f, Math.toRadians(180.0), data -> data.getVaccinationData().map(vaccinationData -> vaccinationData.getUvci().replace("URN:UVCI", "")).orElse("")));
    private final PDRectangle qrCodeBox = new PDRectangle(0.786f, 0.3245925f, 0.157f, 0.111977324f);

    @NotNull
    public ImpfZert customizeVaccinationCertificate(@NotNull EuCertificateDesc euCode) throws IOException {
        CertificationData certificationData = euCode.getCertificationData();
        if (!certificationData.getVaccinationData().isPresent()) {
            throw new UnsupportedOperationException("Kann nur Impfzertifikate customisieren!");
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/content/impfzertifikat_eu_vorlage.pdf");
        PDDocument originalDoc = PDDocument.load((InputStream)inputStream);
        PDDocument overlayDoc = new PDDocument();
        PDColor color = new PDColor(new float[]{0.85f, 0.44f, 0.0f, 0.33f}, (PDColorSpace)PDDeviceCMYK.INSTANCE);
        PDPage page1 = new PDPage(originalDoc.getPage(0).getMediaBox());
        try (PDPageContentStream contentStream1 = new PDPageContentStream(overlayDoc, page1, PDPageContentStream.AppendMode.APPEND, true);){
            float h = page1.getMediaBox().getHeight();
            float w = page1.getMediaBox().getWidth();
            for (PdfItem item : this.items) {
                float x = item.getX() * w;
                float y = h - item.getY() * h;
                float r = item.getR();
                String s = item.getText(certificationData);
                if (r == 0.0f) {
                    PdfUtils.addTextAt(contentStream1, s, x, y, 9.0f, color);
                    continue;
                }
                PdfUtils.addTextRotatedAt(contentStream1, s, x, y, 9.0f, r, color);
            }
            PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)overlayDoc, (BufferedImage)euCode.getQrCode());
            float ix = w * (this.qrCodeBox.getLowerLeftX() + this.qrCodeBox.getWidth());
            float iy = h - h * this.qrCodeBox.getLowerLeftY();
            float is = Math.min(this.qrCodeBox.getHeight() * h, this.qrCodeBox.getWidth() * w);
            Matrix m = Matrix.getTranslateInstance((float)ix, (float)iy);
            m.rotate(Math.toRadians(180.0));
            m.translate(-ix, -iy);
            contentStream1.transform(m);
            contentStream1.drawImage(imageXObject, ix, iy, is, is);
        }
        overlayDoc.addPage(page1);
        Overlay overlayObj = new Overlay();
        overlayObj.setOverlayPosition(Overlay.Position.FOREGROUND);
        overlayObj.setInputPDF(originalDoc);
        overlayObj.setAllPagesOverlayPDF(overlayDoc);
        overlayObj.overlay(new HashMap());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        originalDoc.save((OutputStream)byteArrayOutputStream);
        originalDoc.close();
        overlayDoc.close();
        return new ImpfZert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), euCode.getQrCodeContent());
    }
}

