/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.customizer;

import de.impfdoc.impfzert.common.pdf.PdfUtils;
import de.impfdoc.impfzert.eu.customizer.PdfItem;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.eu.json.RecoveryData;
import de.impfdoc.impfzert.eu.util.EuCertificateDesc;
import de.impfdoc.impfzert.eu.util.EuCertificateReader;
import de.impfdoc.impfzert.model.ImpfZert;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.jetbrains.annotations.NotNull;

public class EuRecoveryCertCustomizer {
    @NotNull
    private final EuCertificateReader certificateReader = new EuCertificateReader();
    private final float DOC_HEIGHT = 1411.0f;
    private final float DOC_WIDTH = 1000.0f;
    private final float FONT_SIZE = 9.0f;
    @NotNull
    private final List<PdfItem> items = Arrays.asList(new PdfItem(0.048f, 0.621545f, data -> "COVID-19"), new PdfItem(0.048f, 0.68036854f, data -> data.getRecoveryData().map(RecoveryData::getFirstPositiveResultDate).orElse("")), new PdfItem(0.048f, 0.7264351f, data -> data.getRecoveryData().map(RecoveryData::getCountry).orElse("")), new PdfItem(0.048f, 0.77321047f, data -> data.getRecoveryData().map(RecoveryData::getInstitute).orElse("")), new PdfItem(0.048f, 0.8185684f, data -> data.getRecoveryData().map(RecoveryData::getValidFrom).orElse("")), new PdfItem(0.048f, 0.907158f, data -> data.getRecoveryData().map(RecoveryData::getValidUntil).orElse("")), new PdfItem(0.952f, 0.2019844f, Math.toRadians(180.0), CertificationData::getName), new PdfItem(0.952f, 0.13465627f, Math.toRadians(180.0), CertificationData::getBirthday), new PdfItem(0.952f, 0.05386251f, Math.toRadians(180.0), date -> date.getRecoveryData().map(RecoveryData::getUvci).orElse("")));
    private final PDRectangle qrCodeBox = new PDRectangle(0.786f, 0.3245925f, 0.157f, 0.111977324f);

    @NotNull
    public ImpfZert customizeRecoveryCertificate(@NotNull EuCertificateDesc euCode) throws IOException {
        CertificationData certificationData = euCode.getCertificationData();
        if (!certificationData.getRecoveryData().isPresent()) {
            throw new UnsupportedOperationException("Kann nur Genesenenzertfikate customisieren!");
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/content/genesenenzertifikat_eu_vorlage.pdf");
        PDDocument originalDoc = PDDocument.load((InputStream)inputStream);
        PDDocument overlayDoc = new PDDocument();
        PDColor color = new PDColor(new float[]{0.85f, 0.44f, 0.0f, 0.33f}, (PDColorSpace)PDDeviceCMYK.INSTANCE);
        PDPage page1 = new PDPage(originalDoc.getPage(0).getMediaBox());
        try (PDPageContentStream contentStream1 = new PDPageContentStream(overlayDoc, page1, PDPageContentStream.AppendMode.APPEND, true);){
            float h = page1.getMediaBox().getHeight();
            float w = page1.getMediaBox().getWidth();
            for (PdfItem item : this.items) {
                float x = item.getX() * w;
                float y = h - item.getY() * h;
                float r = item.getR();
                String s = item.getText(certificationData);
                if (r == 0.0f) {
                    PdfUtils.addTextAt(contentStream1, s, x, y, 9.0f, color);
                    continue;
                }
                PdfUtils.addTextRotatedAt(contentStream1, s, x, y, 9.0f, r, color);
            }
            PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)overlayDoc, (BufferedImage)euCode.getQrCode());
            float ix = w * (this.qrCodeBox.getLowerLeftX() + this.qrCodeBox.getWidth());
            float iy = h - h * this.qrCodeBox.getLowerLeftY();
            float is = Math.min(this.qrCodeBox.getHeight() * h, this.qrCodeBox.getWidth() * w);
            Matrix m = Matrix.getTranslateInstance((float)ix, (float)iy);
            m.rotate(Math.toRadians(180.0));
            m.translate(-ix, -iy);
            contentStream1.transform(m);
            contentStream1.drawImage(imageXObject, ix, iy, is, is);
        }
        overlayDoc.addPage(page1);
        Overlay overlayObj = new Overlay();
        overlayObj.setOverlayPosition(Overlay.Position.FOREGROUND);
        overlayObj.setInputPDF(originalDoc);
        overlayObj.setAllPagesOverlayPDF(overlayDoc);
        overlayObj.overlay(new HashMap());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        originalDoc.save((OutputStream)byteArrayOutputStream);
        originalDoc.close();
        overlayDoc.close();
        return new ImpfZert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), euCode.getQrCodeContent());
    }
}

