/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu.customizer;

import de.impfdoc.impfzert.eu.customizer.EuRecoveryCertCustomizer;
import de.impfdoc.impfzert.eu.customizer.EuVaccinationCertCustomizer;
import de.impfdoc.impfzert.eu.util.EuCertificateDesc;
import de.impfdoc.impfzert.eu.util.EuCertificateReadException;
import de.impfdoc.impfzert.eu.util.EuCertificateReader;
import de.impfdoc.impfzert.model.ImpfZert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class EuCertCustomizer {
    @NotNull
    private final EuRecoveryCertCustomizer recoveryCertCustomizer = new EuRecoveryCertCustomizer();
    @NotNull
    private final EuVaccinationCertCustomizer vaccinationCertCustomizer = new EuVaccinationCertCustomizer();
    @NotNull
    private final EuCertificateReader certificateReader = new EuCertificateReader();

    @NotNull
    public ImpfZert customizeEuCertificate(@NotNull ImpfZert euCert) throws EuCertificateReadException, IOException {
        boolean enableCustomizer = Boolean.parseBoolean(System.getProperty("impfzert.customizer.enabled", "true"));
        if (!enableCustomizer) {
            return euCert;
        }
        EuCertificateDesc euCode = this.certificateReader.readEuCertificate(new ByteArrayInputStream(euCert.getPdf()));
        if (euCode.getCertificationData().getVaccinationData().isPresent()) {
            return this.vaccinationCertCustomizer.customizeVaccinationCertificate(euCode);
        }
        if (euCode.getCertificationData().getRecoveryData().isPresent()) {
            return this.recoveryCertCustomizer.customizeRecoveryCertificate(euCode);
        }
        throw new IllegalArgumentException("unbekannter zertifikatstyp:" + euCode.getQrCodeContent());
    }
}

