/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu;

import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import de.gematik.ws.conn.certificateservicecommon.v2.CertRefEnum;
import de.gematik.ws.conn.certificateservicecommon.v2.X509DataInfoListType;
import de.gematik.ws.conn.signatureservice.v7.ExternalAuthenticateResponse;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.eu.EuCertService;
import de.impfdoc.impfzert.eu.EuImpfZertConfiguration;
import de.impfdoc.impfzert.eu.customizer.EuCertCustomizer;
import de.impfdoc.impfzert.eu.data.AuthLink;
import de.impfdoc.impfzert.eu.data.Challenge;
import de.impfdoc.impfzert.eu.data.Token;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.eu.util.TokenCache;
import de.impfdoc.impfzert.model.ImpfZert;
import de.impfsoft.ticonnector.ConnectorException;
import de.impfsoft.ticonnector.TIConnectorConfiguration;
import de.impfsoft.ticonnector.TIConnectorService;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpfZertFactoryEu {
    @NotNull
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final TIConnectorService tiConnectorService;
    @NotNull
    private final EuCertCustomizer certCustomizer = new EuCertCustomizer();
    private final TokenCache tokenCache = new TokenCache();

    public ImpfZertFactoryEu(@NotNull TIConnectorService tiConnectorService) {
        this.tiConnectorService = tiConnectorService;
    }

    @NotNull
    public synchronized ImpfZert createImpfZert(@NotNull CertificationData certificationData, @NotNull EuImpfZertConfiguration euImpfZertConfiguration, @NotNull TIConnectorConfiguration connectorConfiguration) throws IOException {
        EuCertService service = new EuCertService(euImpfZertConfiguration);
        Token token = this.getToken(connectorConfiguration, service);
        try {
            return service.getPdf(token, certificationData);
        }
        catch (Throwable t) {
            this.logger.info("An error occured during certification creation. token cache cleared. try again...");
            this.tokenCache.clear(token);
            Token newToken = this.getToken(connectorConfiguration, service);
            return service.getPdf(newToken, certificationData);
        }
    }

    private Token getToken(@NotNull TIConnectorConfiguration connectorConfiguration, @NotNull EuCertService service) {
        return this.getToken(connectorConfiguration, service, 0);
    }

    private Token getToken(@NotNull TIConnectorConfiguration connectorConfiguration, @NotNull EuCertService service, int tries) {
        Token token;
        if (tries > 1) {
            throw new ImpfZertException(ImpfZertException.Type.InvalidIoken, "Token konnte im zweiten Versuch nicht abgerufen werden", null);
        }
        String predefinedIccsn = connectorConfiguration.getCardIccsn().orElse(null);
        if (predefinedIccsn != null) {
            this.logger.info("Use predefined icssn: " + predefinedIccsn);
            token = this.tokenCache.getToken(predefinedIccsn).orElseGet(() -> {
                CardInfoType cardInfoType = this.getCardInfoType(connectorConfiguration);
                return this.requestToken(service, connectorConfiguration, cardInfoType);
            });
        } else {
            CardInfoType cardInfoType = this.getCardInfoType(connectorConfiguration);
            this.logger.info("Use card with icssn: " + cardInfoType.getIccsn());
            token = this.tokenCache.getToken(cardInfoType.getIccsn()).orElseGet(() -> this.requestToken(service, connectorConfiguration, cardInfoType));
        }
        if (token.isExpired()) {
            if (token.isRefreshPossible()) {
                try {
                    return service.refreshToken(token);
                }
                catch (Throwable t) {
                    this.logger.error(t.toString(), t);
                }
            }
            this.tokenCache.clear(token);
            return this.getToken(connectorConfiguration, service, tries + 1);
        }
        return token;
    }

    private CardInfoType getCardInfoType(@NotNull TIConnectorConfiguration connectorConfiguration) {
        CardInfoType cardInfoType = this.tiConnectorService.queryCards(connectorConfiguration).getCards().getCard().stream().filter(c -> c.getCardType() == CardTypeType.SMC_B).filter(c -> c.getIccsn() != null).filter(c -> connectorConfiguration.getCardIccsn().map(x -> x.equals(c.getIccsn())).orElse(true)).findAny().orElseThrow(() -> new ConnectorException("Es wurde keine geeignete SMC-B gefunden.", ConnectorException.ExceptionType.NO_CARD));
        return cardInfoType;
    }

    @NotNull
    public ImpfZert createCustomizedImpfZert(@NotNull CertificationData certificationData, @NotNull EuImpfZertConfiguration euImpfZertConfiguration, @NotNull TIConnectorConfiguration connectorConfiguration) throws IOException {
        ImpfZert originalCert = this.createImpfZert(certificationData, euImpfZertConfiguration, connectorConfiguration);
        try {
            return this.certCustomizer.customizeEuCertificate(originalCert);
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error(t.toString(), t);
            return originalCert;
        }
    }

    @NotNull
    private Token requestToken(@NotNull EuCertService service, @NotNull TIConnectorConfiguration connectorConfiguration, @NotNull CardInfoType cardInfoType) {
        try {
            Challenge challenge = service.getChallenge();
            ExternalAuthenticateResponse externalAuthenticateResponse = this.tiConnectorService.externalAuthenticate(connectorConfiguration, cardInfoType, challenge.getChallenge());
            byte[] signature = externalAuthenticateResponse.getSignatureObject().getBase64Signature().getValue();
            X509DataInfoListType.X509DataInfo certInfo = this.tiConnectorService.queryCertificateViaCardInfoType(connectorConfiguration, cardInfoType, Collections.singletonList(CertRefEnum.C_AUT));
            byte[] certificate = certInfo.getX509Data().getX509Certificate();
            AuthLink authLink = service.submitSignedChallenge(challenge, signature, certificate);
            return this.tokenCache.putToken(cardInfoType.getIccsn(), service.tokenExchange(authLink));
        }
        catch (ImpfZertException ize) {
            throw ize;
        }
        catch (Throwable t) {
            throw new ImpfZertException(ImpfZertException.Type.ChallengeError, t.toString(), t);
        }
    }
}

