/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.eu;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.eu.EuImpfZertConfiguration;
import de.impfdoc.impfzert.eu.data.AuthLink;
import de.impfdoc.impfzert.eu.data.Challenge;
import de.impfdoc.impfzert.eu.data.Token;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.model.ImpfZert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.Timeout;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EuCertService {
    @NotNull
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @NotNull
    private final SecureRandom random = new SecureRandom();
    private final EuImpfZertConfiguration euImpfZertConfiguration;
    private final HttpClient client = HttpClientBuilder.create().build();

    public EuCertService(@NotNull EuImpfZertConfiguration euImpfZertConfiguration) {
        this.euImpfZertConfiguration = euImpfZertConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfServiceIsAvailable(@NotNull String url) {
        this.log.info("check if service is available at " + url);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)3L)).setResponseTimeout(Timeout.ofSeconds((long)3L)).setConnectionRequestTimeout(Timeout.ofSeconds((long)3L)).build();
        HttpGet request = new HttpGet(url);
        request.setConfig(config);
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)this.client.execute((ClassicHttpRequest)request);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this.log.error(t.toString(), t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Challenge getChallenge() throws IOException {
        if (!this.checkIfServiceIsAvailable(this.euImpfZertConfiguration.getServerUrl()) || !this.checkIfServiceIsAvailable(this.euImpfZertConfiguration.getIssuerUrl())) {
            throw new ImpfZertException(ImpfZertException.Type.NoConnection, "Entschuldigung! Der Server zur Ausstellung der EU-Zertifikate kann nicht erreicht werden. Wahrscheinlich ist die entsprechende Route nicht gesetzt oder die Einstellungen f\u00fcr den TI-Konnektor sind nicht korrekt.Bitte \u00fcberpr\u00fcfen Sie ob die Route gesetzt ist und Ihre TI-Einstellungen korrekt sind. Falls Sie unsicher sind, wenden Sie sich bitte an Ihren IT-Administrator. Falls alle Einstellungen korrekt sind, probieren Sie es bitte sp\u00e4ter nochmals.", null);
        }
        String nonce = this.randomDigitString(30);
        String challengeUrl = String.format("%s/auth/realms/%s/protocol/openid-connect/auth", this.euImpfZertConfiguration.getServerUrl(), this.euImpfZertConfiguration.getRealm());
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)challengeUrl).addParameter("redirect_uri", "connector://authenticated").addParameter("response_type", "code").addParameter("scope", "openid").addParameter("client_id", this.euImpfZertConfiguration.getClientId()).addParameter("nonce", nonce).build();
        this.log.debug("getChallenge with nonce {} from {}", (Object)nonce, (Object)challengeUrl);
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)this.client.execute(request);
            if (response.getCode() != 200) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                throw new ImpfZertException(ImpfZertException.Type.ChallengeError, String.format("GetChallenge to %s failed with error %d and message %s", challengeUrl, response.getCode(), result), null);
            }
            this.log.debug("request suceeded");
            String challenge = response.getFirstHeader("X-Auth-Challenge").getValue();
            String location = response.getFirstHeader("Location").getValue();
            Challenge result = new Challenge(challenge, location);
            this.log.debug(result.toString());
            Challenge challenge2 = result;
            return challenge2;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    @NotNull
    public AuthLink submitSignedChallenge(@NotNull Challenge challenge, @NotNull byte[] signature, @NotNull byte[] certificate) throws IOException, URISyntaxException {
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
        HttpGet request = new HttpGet(challenge.getLocation());
        request.addHeader("x-auth-signed-challenge", (Object)Base64.getEncoder().encodeToString(signature));
        request.addHeader("x-auth-certificate", (Object)Base64.getEncoder().encodeToString(certificate));
        request.setConfig(config);
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)this.client.execute((ClassicHttpRequest)request);
            if (response.getCode() != 302) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                throw new ImpfZertException(ImpfZertException.Type.ChallengeError, String.format("SubmitSignedChallenge to %s failed with error %d and message %s", challenge.getLocation(), response.getCode(), result), null);
            }
            this.log.debug("request suceeded");
            AuthLink result = new AuthLink(new URI(Arrays.stream(response.getHeaders("Location")).findFirst().orElseThrow(() -> new ImpfZertException(ImpfZertException.Type.ChallengeError, "no location found in AuthLink", null)).getValue()));
            return result;
        }
        catch (SocketTimeoutException ste) {
            throw new ImpfZertException(ImpfZertException.Type.ServiceUnavailable, "Der Server zur Ausstellung der EU-Zertifikaten antwortet nicht. Eventuell ist dieser \u00fcberlastet oder es gibt eine St\u00f6rung im Netzwerk. Bitte versuchen Sie es sp\u00e4ter noch einmal.", ste);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Token tokenExchange(@NotNull AuthLink authLink) throws IOException {
        String tokenUrl = String.format("%s/auth/realms/%s/protocol/openid-connect/token", this.euImpfZertConfiguration.getServerUrl(), this.euImpfZertConfiguration.getRealm());
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)tokenUrl).addParameter("grant_type", "authorization_code").addParameter("redirect_uri", "connector://authenticated").addParameter("client_id", this.euImpfZertConfiguration.getClientId()).addParameter("session_state", authLink.getSessionState()).addParameter("code", authLink.getCode()).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)this.client.execute(request);
            if (response.getCode() != 200) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                throw new ImpfZertException(ImpfZertException.Type.ChallengeError, String.format("tokenExchange to %s failed with error %d and message %s", tokenUrl, response.getCode(), result), null);
            }
            this.log.debug("request suceeded");
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Token token = (Token)this.mapper.readerFor(Token.class).readValue(result);
            return token;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Token refreshToken(@NotNull Token token) throws IOException {
        String tokenUrl = String.format("%s/auth/realms/%s/protocol/openid-connect/token", this.euImpfZertConfiguration.getServerUrl(), this.euImpfZertConfiguration.getRealm());
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)tokenUrl).addParameter("grant_type", "refresh_token").addParameter("refresh_token", token.getRefreshToken()).addParameter("redirect_uri", "connector://authenticated").addParameter("client_id", this.euImpfZertConfiguration.getClientId()).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)this.client.execute(request);
            if (response.getCode() != 200) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                throw new ImpfZertException(ImpfZertException.Type.ChallengeError, String.format("tokenExchange to %s failed with error %d and message %s", tokenUrl, response.getCode(), result), null);
            }
            this.log.debug("request suceeded");
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Token token2 = (Token)this.mapper.readerFor(Token.class).readValue(result);
            return token2;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImpfZert getPdf(@NotNull Token token, @NotNull CertificationData certificationData) throws IOException {
        String json = this.mapper.writeValueAsString((Object)certificationData);
        this.log.debug("JSON is: " + json);
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)this.euImpfZertConfiguration.getIssuerUrl()).addHeader("Authorization", "Bearer " + token.getAccessToken()).addHeader("Accept", "application/pdf").addHeader("Content-Type", "application/vnd.dgc.v1+json").setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8)).build();
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)this.client.execute(request);
            if (response.getCode() != 200) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                throw new ImpfZertException(ImpfZertException.Type.ChallengeError, String.format("tokenExchange to %s failed with error %d and message %s", this.euImpfZertConfiguration.getIssuerUrl(), response.getCode(), result), null);
            }
            this.log.debug("request suceeded");
            byte[] result = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            ImpfZert impfZert = new ImpfZert(new ByteArrayInputStream(result), null);
            return impfZert;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private String randomDigitString(int len) {
        return this.random.ints(0L, 10, len).mapToObj(Integer::toString).collect(Collectors.joining());
    }
}

