/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.common.utils;

import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class SignatureLogger {
    private static LogEntry currentEntry = null;

    public static void init(boolean isActive) {
        currentEntry = isActive ? new LogEntry() : null;
    }

    public static void logJSON(@NotNull String json) {
        if (currentEntry == null) {
            return;
        }
        LogEntry.access$102(currentEntry, json.getBytes(StandardCharsets.UTF_8));
    }

    public static void logHash(@NotNull String hashAsHex) {
        if (currentEntry == null) {
            return;
        }
        currentEntry.hashAsHex = hashAsHex;
    }

    public static void logFhir(@NotNull String fhir) {
        if (currentEntry == null) {
            return;
        }
        currentEntry.fhir = fhir;
    }

    public static void logTiCert(@NotNull byte[] tiCert) {
        if (currentEntry == null) {
            return;
        }
        LogEntry.access$402(currentEntry, tiCert);
    }

    public static void logTiCertPart(@NotNull byte[] tiCert) {
        if (currentEntry == null) {
            return;
        }
        LogEntry.access$502(currentEntry, tiCert);
    }

    public static void logQrCode(@NotNull String code) {
        if (currentEntry == null) {
            return;
        }
        currentEntry.qrCode = code;
    }

    public static void logQrCodeDocument(@NotNull BufferedImage pdfDocument) {
        if (currentEntry == null) {
            return;
        }
        currentEntry.qrCodeDocument = pdfDocument;
    }

    public static void finish() {
        if (currentEntry == null) {
            return;
        }
        try {
            File varDir = Files.createTempDir();
            File entry = new File(varDir, currentEntry.time.toString());
            entry.mkdirs();
            if (currentEntry.json != null) {
                FileUtils.writeByteArrayToFile((File)new File(entry, "01.json"), (byte[])currentEntry.json);
            }
            if (currentEntry.hashAsHex != null) {
                FileUtils.write((File)new File(entry, "02_hash.txt"), (CharSequence)currentEntry.hashAsHex, (Charset)StandardCharsets.UTF_8);
            }
            if (currentEntry.fhir != null) {
                FileUtils.write((File)new File(entry, "03_fhir.xml"), (CharSequence)currentEntry.fhir, (Charset)StandardCharsets.UTF_8);
            }
            if (currentEntry.tiCert != null) {
                FileUtils.writeByteArrayToFile((File)new File(entry, "04_ticert.cert"), (byte[])currentEntry.tiCert);
            }
            if (currentEntry.tiCert != null) {
                FileUtils.writeByteArrayToFile((File)new File(entry, "04_ticertpart.cert"), (byte[])currentEntry.tiCertPart);
            }
            if (currentEntry.qrCode != null) {
                FileUtils.write((File)new File(entry, "05_qrcode.txt"), (CharSequence)currentEntry.qrCode, (Charset)StandardCharsets.UTF_8);
            }
            if (currentEntry.qrCodeDocument != null) {
                ImageIO.write((RenderedImage)currentEntry.qrCodeDocument, "png", new File(entry, "06_qrcode.png"));
            }
        }
        catch (IOException ioe) {
            LoggerFactory.getLogger(SignatureLogger.class).error(ioe.toString(), (Throwable)ioe);
        }
        currentEntry = null;
    }

    private static class LogEntry {
        @NotNull
        private final LocalDateTime time = LocalDateTime.now();
        private byte[] json;
        private String hashAsHex;
        private String fhir;
        private byte[] tiCert;
        private byte[] tiCertPart;
        private String qrCode;
        private BufferedImage qrCodeDocument;

        private LogEntry() {
        }

        static /* synthetic */ byte[] access$102(LogEntry x0, byte[] x1) {
            x0.json = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$402(LogEntry x0, byte[] x1) {
            x0.tiCert = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$502(LogEntry x0, byte[] x1) {
            x0.tiCertPart = x1;
            return x1;
        }
    }
}

