/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.common.utils;

import de.gematik.ws.conn.certificateservicecommon.v2.X509DataInfoListType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class CertificateParser {
    @NotNull
    public static CertificateData parse(final @NotNull X509DataInfoListType.X509DataInfo certInfo) {
        return new CertificateData(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @NotNull
            public Optional<String> getCommonName() {
                try {
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    try (ByteArrayInputStream bais = new ByteArrayInputStream(certInfo.getX509Data().getX509Certificate());){
                        X509Certificate certificate = (X509Certificate)factory.generateCertificate(bais);
                        RDN[] rdns = new JcaX509CertificateHolder(certificate).getSubject().getRDNs(BCStyle.CN);
                        if (rdns.length <= 0) return Optional.empty();
                        Optional<String> optional = Optional.of(IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue()));
                        return optional;
                    }
                }
                catch (IOException | CertificateException e) {
                    LoggerFactory.getLogger(this.getClass()).error(e.toString(), (Throwable)e);
                }
                return Optional.empty();
            }
        };
    }

    @NotNull
    public static CertificateData parse(final @NotNull X509Certificate certificate) {
        return new CertificateData(){

            @Override
            @NotNull
            public Optional<String> getCommonName() {
                try {
                    RDN[] rdns = new JcaX509CertificateHolder(certificate).getSubject().getRDNs(BCStyle.CN);
                    if (rdns.length > 0) {
                        return Optional.of(IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue()));
                    }
                }
                catch (CertificateEncodingException e) {
                    LoggerFactory.getLogger(this.getClass()).error(e.toString(), (Throwable)e);
                }
                return Optional.empty();
            }
        };
    }

    public static interface CertificateData {
        @NotNull
        public Optional<String> getCommonName();
    }
}

