/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.common.pdf;

import de.impfdoc.impfzert.api.ImpfZertException;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.util.Matrix;
import org.jetbrains.annotations.NotNull;

public class PdfUtils {
    public static void addTextAt(@NotNull PDPageContentStream contentStream, @NotNull String value, float x, float y) throws IOException {
        PdfUtils.addTextAt(contentStream, value, x, y, 11.0f);
    }

    public static void addTextAt(@NotNull PDPageContentStream contentStream, @NotNull String value, float x, float y, float fontSize) throws IOException {
        float leading = 1.25f * fontSize;
        contentStream.setFont((PDFont)PDType1Font.HELVETICA, fontSize);
        contentStream.beginText();
        contentStream.newLineAtOffset(x, y);
        for (String line : value.split("\n")) {
            contentStream.showText(line);
            contentStream.moveTextPositionByAmount(0.0f, -leading);
        }
        contentStream.endText();
    }

    public static void addTextAt(@NotNull PDPageContentStream contentStream, @NotNull String value, float x, float y, float fontSize, @NotNull PDColor color) {
        try {
            float leading = 1.25f * fontSize;
            contentStream.setFont((PDFont)PDType1Font.HELVETICA, fontSize);
            contentStream.beginText();
            contentStream.setNonStrokingColor(color);
            contentStream.newLineAtOffset(x, y);
            for (String line : value.split("\n")) {
                contentStream.showText(line);
                contentStream.moveTextPositionByAmount(0.0f, -leading);
            }
            contentStream.endText();
        }
        catch (IOException ioe) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
        }
    }

    public static void addTextRotatedAt(@NotNull PDPageContentStream contentStream, @NotNull String value, float x, float y, float fontSize, float r, @NotNull PDColor color) {
        try {
            float leading = 1.25f * fontSize;
            contentStream.setFont((PDFont)PDType1Font.HELVETICA, fontSize);
            contentStream.beginText();
            contentStream.setNonStrokingColor(color);
            Matrix matrix = Matrix.getTranslateInstance((float)x, (float)y);
            matrix.rotate((double)r);
            matrix.translate(-x, -y);
            contentStream.setTextMatrix(matrix);
            contentStream.newLineAtOffset(x, y);
            for (String line : value.split("\n")) {
                contentStream.showText(line);
                contentStream.moveTextPositionByAmount(0.0f, -leading);
            }
            contentStream.endText();
        }
        catch (IOException ioe) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
        }
    }
}

