/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.common.model;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignatureDesc {
    @NotNull
    private final ContentType contentType;
    @NotNull
    private final SignatureType type;
    @NotNull
    private final String signature;

    public SignatureDesc(@NotNull ContentType contentType, @NotNull SignatureType type, @NotNull String signature) {
        this.contentType = contentType;
        this.type = type;
        this.signature = signature;
    }

    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @NotNull
    public SignatureType signatureType() {
        return this.type;
    }

    @NotNull
    public String getSignature() {
        return this.signature;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureDesc that = (SignatureDesc)o;
        return this.contentType == that.contentType && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.type});
    }

    public static enum SignatureType {
        EHBA,
        SMBC;

    }

    public static interface ContentTypeHandler<T> {
        @NotNull
        public T handleHash_Signature();

        @NotNull
        public T handleFhir_Signature();
    }

    public static enum ContentType {
        Hash_Signature,
        FHIR_Signature;


        @NotNull
        public <T> T handle(@NotNull ContentTypeHandler<T> handler) {
            switch (this) {
                case FHIR_Signature: {
                    return handler.handleFhir_Signature();
                }
            }
            return handler.handleHash_Signature();
        }
    }
}

