/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.common.encoder.dictionary;

import de.impfdoc.impfzert.ImpfZertQrAnalyzer;
import de.impfdoc.impfzert.QRStructure;
import de.impfdoc.impfzert.api.ImpfZertVersion;
import de.impfdoc.impfzert.common.encoder.QRCodeEncoder;
import de.impfsoft.ticonnector.utils.ResourceEnumerator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class DeflationDictionaryPerfomanceTester {
    private static QRCodeEncoder encoder;
    private static final List<String> dictList;
    private static final List<String> dictFileNameList;

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> initTestContent() {
        ArrayList<String> exampleContent = new ArrayList<String>();
        try (ResourceEnumerator resourceEnumerator = ResourceEnumerator.findResources((String)"qrOptimization/qrExamples/all");){
            for (Path resource : resourceEnumerator.getFiles()) {
                LoggerFactory.getLogger(DeflationDictionaryPerfomanceTester.class).info("Loading dictionary " + resource.getFileName());
                try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(resource, new OpenOption[0])));){
                    StringBuilder sb = new StringBuilder();
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);
                        sb.append(System.lineSeparator());
                        line = br.readLine();
                    }
                    String qrContent = sb.toString();
                    QRStructure qrStructure = ImpfZertQrAnalyzer.determineQRStructure(qrContent, ImpfZertVersion.V1);
                    byte[] decodedQrContent = qrStructure.getDecodedContent();
                    exampleContent.add(new String(decodedQrContent, StandardCharsets.ISO_8859_1));
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(DeflationDictionaryPerfomanceTester.class).error(t.toString());
                }
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(DeflationDictionaryPerfomanceTester.class).error(t.toString(), t);
        }
        return exampleContent;
    }

    static {
        dictList = new ArrayList<String>();
        dictFileNameList = new ArrayList<String>();
    }

    private static class DictPerformance {
        private final String name;
        private final int encodedSize;
        private final long encodingTime;
        private final int dictSize;

        public DictPerformance(String name, int encodedSize, long encodingTime, int dictSize) {
            this.name = name;
            this.encodedSize = encodedSize;
            this.encodingTime = encodingTime;
            this.dictSize = dictSize;
        }

        public String getName() {
            return this.name;
        }

        public int getEncodedSize() {
            return this.encodedSize;
        }

        public long getEncodingTime() {
            return this.encodingTime;
        }

        public int getDictSize() {
            return this.dictSize;
        }
    }
}

