/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.common.encoder.dictionary;

import de.impfdoc.impfzert.ImpfZertQrAnalyzer;
import de.impfdoc.impfzert.QRStructure;
import de.impfdoc.impfzert.api.ImpfZertVersion;
import de.impfsoft.ticonnector.utils.ResourceEnumerator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class DeflationDictionaryGenerator {
    private static final String outputDir = "/Users/user/Downloads/dict/";
    private static List<String> dictionary = new ArrayList<String>();
    private static int numberOfFiles = 0;
    private static int maxArraySize = 1000;

    public static void main(String[] args) {
        long start = System.nanoTime();
        List<String> txtDictList = DeflationDictionaryGenerator.convertAllQrExamplesToDicts();
        String allContentTxtDict1 = "";
        String allContentTxtDict2 = "";
        String contentTxtDict1 = "";
        String contentTxtDict2 = "";
        int index = 1;
        for (String txtDict : txtDictList) {
            if (index == 1) {
                contentTxtDict1 = txtDict;
            } else if (index == 2) {
                contentTxtDict2 = txtDict;
            }
            allContentTxtDict1 = allContentTxtDict1 + txtDict;
            allContentTxtDict2 = txtDict + allContentTxtDict2;
            String dict = Base64.getEncoder().encodeToString(txtDict.getBytes(StandardCharsets.ISO_8859_1));
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(String.format("/Users/user/Downloads/dict/contentDict_%s.txt", index)));
                writer.write(dict);
                ++index;
                writer.close();
            }
            catch (IOException e) {
                System.out.printf("Writing contentDict_%s.txt failed\n " + e, index);
            }
        }
        String allContentDict1 = Base64.getEncoder().encodeToString(allContentTxtDict1.getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_content_dict_1.txt"));){
            writer.write(allContentDict1);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_content_dict_1 failed");
        }
        String allContentDict2 = Base64.getEncoder().encodeToString(allContentTxtDict2.getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_content_dict_2.txt"));){
            writer.write(allContentDict2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_content_dict_2 failed");
        }
        List<String> dicts = DeflationDictionaryGenerator.getDicts(1);
        Iterator<String> it = dicts.iterator();
        String txtDictA1 = it.next();
        String txtDictA2 = it.next();
        String dictA1 = Base64.getEncoder().encodeToString(txtDictA1.getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/dict_a1.txt"));){
            writer.write(dictA1);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing dict_a1 failed");
        }
        String dictA2 = Base64.getEncoder().encodeToString(txtDictA2.getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/dict_a2.txt"));){
            writer.write(dictA2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing dict_a2 failed");
        }
        dicts = DeflationDictionaryGenerator.getDicts(2);
        it = dicts.iterator();
        String txtDictB1 = it.next();
        String txtDictB2 = it.next();
        String dictB1 = Base64.getEncoder().encodeToString(txtDictB1.getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/dict_b1.txt"));){
            writer.write(dictB1);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing dict_b1 failed");
        }
        String dictB2 = Base64.getEncoder().encodeToString(txtDictB2.getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/dict_b2.txt"));){
            writer.write(dictB2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing dict_b2 failed");
        }
        String dictAB1 = Base64.getEncoder().encodeToString((txtDictA1 + txtDictB1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/dict_ab1.txt"));){
            writer.write(dictAB1);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing dict_ab1 failed");
        }
        String dictBA1 = Base64.getEncoder().encodeToString((txtDictB1 + txtDictA1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/dict_ba1.txt"));){
            writer.write(dictBA1);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing dict_ba1 failed");
        }
        String dictAB2 = Base64.getEncoder().encodeToString((txtDictA2 + txtDictB2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/dict_ab2.txt"));){
            writer.write(dictAB2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing dict_ab2 failed");
        }
        String dictBA2 = Base64.getEncoder().encodeToString((txtDictB2 + txtDictA2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/dict_ba2.txt"));){
            writer.write(dictBA2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing dict_ba2 failed");
        }
        String fullDict1 = Base64.getEncoder().encodeToString((allContentTxtDict1 + txtDictB1 + txtDictA1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_dict_1.txt"));){
            writer.write(fullDict1);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_dict_1 failed");
        }
        String fullDict2 = Base64.getEncoder().encodeToString((allContentTxtDict2 + txtDictB1 + txtDictA1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_dict_2.txt"));){
            writer.write(fullDict2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_dict_2 failed");
        }
        String fullDict3 = Base64.getEncoder().encodeToString((txtDictA1 + txtDictB1 + allContentTxtDict1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_dict_3.txt"));){
            writer.write(fullDict3);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_dict_3 failed");
        }
        String fullDict4 = Base64.getEncoder().encodeToString((txtDictA1 + txtDictB1 + allContentTxtDict2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_dict_4.txt"));){
            writer.write(fullDict4);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_dict_4 failed");
        }
        String fullDict1_2 = Base64.getEncoder().encodeToString((allContentTxtDict1 + txtDictB2 + txtDictA2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_dict_1_2.txt"));){
            writer.write(fullDict1_2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_dict_1_2 failed");
        }
        String fullDict2_2 = Base64.getEncoder().encodeToString((allContentTxtDict2 + txtDictB2 + txtDictA2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_dict_2_2.txt"));){
            writer.write(fullDict2_2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_dict_2_2 failed");
        }
        String fullDict3_2 = Base64.getEncoder().encodeToString((txtDictA2 + txtDictB2 + allContentTxtDict1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_dict_3_2.txt"));){
            writer.write(fullDict3_2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_dict_3_2 failed");
        }
        String fullDict4_2 = Base64.getEncoder().encodeToString((txtDictA2 + txtDictB2 + allContentTxtDict2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/full_dict_4_2.txt"));){
            writer.write(fullDict4_2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing full_dict_4_2 failed");
        }
        String halfDict1 = Base64.getEncoder().encodeToString((contentTxtDict1 + txtDictB1 + txtDictA1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/half_dict_1.txt"));){
            writer.write(halfDict1);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing half_dict_1 failed");
        }
        String halfDict2 = Base64.getEncoder().encodeToString((contentTxtDict2 + txtDictB1 + txtDictA1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/half_dict_2.txt"));){
            writer.write(halfDict2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing half_dict_2 failed");
        }
        String halfDict3 = Base64.getEncoder().encodeToString((txtDictA1 + txtDictB1 + contentTxtDict1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/half_dict_3.txt"));){
            writer.write(halfDict3);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing half_dict_3 failed");
        }
        String halfDict4 = Base64.getEncoder().encodeToString((txtDictA1 + txtDictB1 + contentTxtDict2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/half_dict_4.txt"));){
            writer.write(halfDict4);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing half_dict_4 failed");
        }
        String halfDict1_2 = Base64.getEncoder().encodeToString((contentTxtDict1 + txtDictB2 + txtDictA2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/half_dict_1_2.txt"));){
            writer.write(halfDict1_2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing half_dict_1_2 failed");
        }
        String halfDict2_2 = Base64.getEncoder().encodeToString((contentTxtDict2 + txtDictB2 + txtDictA2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/half_dict_2_2.txt"));){
            writer.write(halfDict2_2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing half_dict_2_2 failed");
        }
        String halfDict3_2 = Base64.getEncoder().encodeToString((txtDictA2 + txtDictB2 + contentTxtDict1).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/half_dict_3_2.txt"));){
            writer.write(halfDict3_2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing half_dict_3_2 failed");
        }
        String halfDict4_2 = Base64.getEncoder().encodeToString((txtDictA2 + txtDictB2 + contentTxtDict2).getBytes(StandardCharsets.ISO_8859_1));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("/Users/user/Downloads/dict/half_dict_4_2.txt"));){
            writer.write(halfDict4_2);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("Writing half_dict_4_2 failed");
        }
        long finish = System.nanoTime();
        long duration = (finish - start) / 1000000000L;
        System.out.println("\n\n\n\n\n\nDuration: " + duration / 60L / 60L + " h : " + duration / 60L % 60L + " min : " + duration % 60L + " s");
    }

    private static List<String> convertAllQrExamplesToDicts() {
        dictionary.clear();
        List<String> exampleContent = DeflationDictionaryGenerator.getAllQrExamples();
        ArrayList<String> dictList = new ArrayList<String>();
        int previousSize = 0;
        String dict = "";
        int counter = 0;
        for (String content : exampleContent) {
            previousSize += content.length();
            dict = dict + content;
            if (++counter != 10) continue;
            dictList.add(dict);
            dict = "";
            counter = 0;
        }
        if (!dict.trim().isEmpty()) {
            dictList.add(dict);
        }
        System.out.println("Previous size = " + previousSize);
        return dictList;
    }

    private static List<String> getAllQrExamples() {
        ArrayList<String> exampleContent = new ArrayList<String>();
        try (ResourceEnumerator resourceEnumerator = ResourceEnumerator.findResources((String)"qrOptimization/qrExamples/all/");){
            for (Path resource : resourceEnumerator.getFiles()) {
                LoggerFactory.getLogger(DeflationDictionaryGenerator.class).info("Loading dictionary " + resource.getFileName().toString());
                try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(resource, new OpenOption[0])));){
                    StringBuilder sb = new StringBuilder();
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);
                        sb.append(System.lineSeparator());
                        line = br.readLine();
                    }
                    String qrContent = sb.toString();
                    QRStructure qrStructure = ImpfZertQrAnalyzer.determineQRStructure(qrContent, ImpfZertVersion.V1);
                    byte[] decodedQrContent = qrStructure.getDecodedContent();
                    exampleContent.add(new String(decodedQrContent, StandardCharsets.ISO_8859_1));
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(DeflationDictionaryGenerator.class).error(t.toString());
                }
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(DeflationDictionaryGenerator.class).error(t.toString(), t);
        }
        return exampleContent;
    }

    private static List<String> getDicts(int version) {
        LinkedHashMap<String, Integer> efficiencies;
        dictionary.clear();
        String exampleContent = DeflationDictionaryGenerator.initExampleContent();
        LinkedHashMap<String, Integer> linkedHashMap = efficiencies = version == 1 ? DeflationDictionaryGenerator.getEfficiencies(exampleContent) : DeflationDictionaryGenerator.getEfficiencies2(exampleContent);
        while (!efficiencies.isEmpty()) {
            DeflationDictionaryGenerator.extendDictionary(efficiencies);
        }
        String dict1 = "";
        String dict2 = "";
        ArrayList<String> dicts = new ArrayList<String>();
        for (String entry : dictionary) {
            dict1 = dict1 + entry;
            dict2 = entry + dict2;
        }
        dicts.add(dict1);
        dicts.add(dict2);
        return dicts;
    }

    private static void extendDictionary(LinkedHashMap<String, Integer> efficiencies) {
        Map.Entry<String, Integer> nextEntry;
        String sequence;
        Iterator<Map.Entry<String, Integer>> iterator = efficiencies.entrySet().iterator();
        Map.Entry<String, Integer> currentEntry = iterator.next();
        int currentefficiency = currentEntry.getValue();
        String currentSequence = sequence = currentEntry.getKey();
        int efficiency = currentefficiency;
        int index = DeflationDictionaryGenerator.findIndexOfSubString(dictionary, sequence);
        if (index > -1) {
            dictionary.set(index, sequence);
            efficiencies.remove(sequence);
            return;
        }
        while (iterator.hasNext() && (efficiency = (nextEntry = iterator.next()).getValue().intValue()) == currentefficiency) {
            sequence = nextEntry.getKey();
            index = DeflationDictionaryGenerator.findIndexOfSubString(dictionary, sequence);
            if (index <= -1) continue;
            dictionary.set(index, sequence);
            efficiencies.remove(sequence);
            return;
        }
        dictionary.add(currentSequence);
        efficiencies.remove(currentSequence);
    }

    private static int findIndexOfSubString(List<String> dictionary, String longerChain) {
        for (int i = 0; i < longerChain.length(); ++i) {
            for (int j = i + 1; j <= longerChain.length(); ++j) {
                int index = dictionary.indexOf(longerChain.substring(i, j));
                if (index <= -1) continue;
                return index;
            }
        }
        return -1;
    }

    private static LinkedHashMap<String, Integer> getEfficiencies(String exampleContent) {
        LinkedHashMap<String, Integer> efficiencies = new LinkedHashMap<String, Integer>();
        int minMatches = (int)Math.sqrt(numberOfFiles);
        if (numberOfFiles > 1) {
            ++minMatches;
        }
        for (int slidingWindowSize = exampleContent.length() / numberOfFiles; slidingWindowSize > 1 && efficiencies.size() < maxArraySize && !exampleContent.trim().isEmpty(); --slidingWindowSize) {
            for (int i = 0; i <= exampleContent.length() - slidingWindowSize; ++i) {
                String currentSequence = exampleContent.substring(i, i + slidingWindowSize);
                int matches = StringUtils.countMatches((CharSequence)exampleContent, (CharSequence)currentSequence);
                if (matches < minMatches) continue;
                int efficiency = matches * currentSequence.length();
                System.out.println("Content Length: " + exampleContent.length());
                System.out.println("Entry: " + currentSequence);
                System.out.println("Efficiency: " + efficiency);
                efficiencies.put(currentSequence, efficiency);
                exampleContent = exampleContent.replace(currentSequence, "");
                slidingWindowSize = exampleContent.length() / numberOfFiles + 1;
            }
        }
        return efficiencies;
    }

    private static LinkedHashMap<String, Integer> getEfficiencies2(String exampleContent) {
        LinkedHashMap<String, Integer> efficiencies = new LinkedHashMap<String, Integer>();
        int minMatches = (int)Math.sqrt(numberOfFiles);
        if (numberOfFiles > 1) {
            ++minMatches;
        }
        while (efficiencies.size() < maxArraySize && !exampleContent.trim().isEmpty()) {
            String bestPerformingEntry = "";
            String bestPerformingEntry2 = "";
            int maxEfficiency = 0;
            int maxEfficiency2 = 0;
            int slidingWindowSize = Math.min(exampleContent.length() / numberOfFiles, 400);
            if (slidingWindowSize <= 1) break;
            while (slidingWindowSize > 1) {
                for (int i = 0; i <= exampleContent.length() - slidingWindowSize; ++i) {
                    String currentSequence = exampleContent.substring(i, i + slidingWindowSize);
                    int matches = StringUtils.countMatches((CharSequence)exampleContent, (CharSequence)currentSequence);
                    int efficiency = matches * currentSequence.length();
                    if (efficiency > maxEfficiency && matches >= minMatches) {
                        System.out.println(slidingWindowSize);
                        maxEfficiency = efficiency;
                        bestPerformingEntry = currentSequence;
                    }
                    if (efficiency <= maxEfficiency2) continue;
                    maxEfficiency2 = efficiency;
                    bestPerformingEntry2 = currentSequence;
                }
                --slidingWindowSize;
            }
            if (maxEfficiency != 0) {
                System.out.println("Content Length: " + exampleContent.length());
                System.out.println("Entry: " + bestPerformingEntry);
                System.out.println("Efficiency: " + maxEfficiency);
                efficiencies.put(bestPerformingEntry, maxEfficiency);
                exampleContent = exampleContent.replace(bestPerformingEntry, "");
                continue;
            }
            efficiencies.put(bestPerformingEntry2, maxEfficiency2);
            exampleContent = exampleContent.replace(bestPerformingEntry2, "");
        }
        return efficiencies;
    }

    private static String initExampleContent() {
        String exampleContent = "";
        try (ResourceEnumerator resourceEnumerator = ResourceEnumerator.findResources((String)"qrOptimization/qrExamples/used/");){
            numberOfFiles = 0;
            for (Path resource : resourceEnumerator.getFiles()) {
                ++numberOfFiles;
                LoggerFactory.getLogger(DeflationDictionaryGenerator.class).info("Loading dictionary " + resource.getFileName());
                try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(resource, new OpenOption[0])));){
                    StringBuilder sb = new StringBuilder();
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);
                        sb.append(System.lineSeparator());
                        line = br.readLine();
                    }
                    String qrContent = sb.toString();
                    QRStructure qrStructure = ImpfZertQrAnalyzer.determineQRStructure(qrContent, ImpfZertVersion.V1);
                    byte[] decodedQrContent = qrStructure.getDecodedContent();
                    exampleContent = exampleContent + new String(decodedQrContent, StandardCharsets.ISO_8859_1);
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(DeflationDictionaryGenerator.class).error(t.toString());
                }
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(DeflationDictionaryGenerator.class).error(t.toString(), t);
        }
        return exampleContent;
    }
}

