/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.common;

import de.impfsoft.ticonnector.utils.ResourceEnumerator;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class KnownRoots {
    private static final String testTICert = "-----BEGIN CERTIFICATE-----\nMIIESjCCAzKgAwIBAgIE8LTzJDANBgkqhkiG9w0BAQsFADCBhzEjMCEGA1UEAwwa\nQy5FSEVYLkhVTUFOLUNBMSBURVNULU9OTFkxNTAzBgNVBAsMLGVIZWFsdGhFeHBl\ncnRzLUNBIGRlciBUZWxlbWF0aWtpbmZyYXN0cnVrdHVyMRwwGgYDVQQKDBNlSGVh\nbHRoRXhwZXJ0cyBHbWJIMQswCQYDVQQGEwJERTAeFw0yMDEyMDgwODEyNDFaFw0y\nMzEyMDgwODEyNDFaMIGHMSMwIQYDVQQDDBpDLkVIRVguSFVNQU4tQ0ExIFRFU1Qt\nT05MWTE1MDMGA1UECwwsZUhlYWx0aEV4cGVydHMtQ0EgZGVyIFRlbGVtYXRpa2lu\nZnJhc3RydWt0dXIxHDAaBgNVBAoME2VIZWFsdGhFeHBlcnRzIEdtYkgxCzAJBgNV\nBAYTAkRFMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtIqXjJfkRon8\nhJURV7rTssTkqQUlXh+SDys3XPUIrV4MQPS45LmITBaV4FxWSfAI6mu9+JFVnI1X\n+2uAkJONML4tL4eqUEgkfwF5IeYilSho1C9iZLZV+URCRqkL7Iy/mdutbBHrQWFs\nijVKl2KOLvYYRq5IhcFmuWes46K/5luqJ4qYPcRSQWA6nebvq5QW8SQ4/0FME96d\nWd4HBzH/six4RGMymBRfamWsfDfG7iewdFUCGARVFSkUQGjgYtkH2tyvBfX4SwNE\nl+dzDkdzOGscOPUrHHlcH9CD12LDrw+KtNZbnI1U6dT2E+gZ/4++p4nBrlwaBtCP\nDi4WgS1OLQIDAQABo4G7MIG4MB8GA1UdIwQYMBaAFMKbl+gWHGcLveQmfz+kNTAt\ntP0tMB0GA1UdDgQWBBTCm5foFhxnC73kJn8/pDUwLbT9LTASBgNVHRMBAf8ECDAG\nAQH/AgEAMA4GA1UdDwEB/wQEAwIBBjBSBggrBgEFBQcBAQRGMEQwQgYIKwYBBQUH\nMAGGNmh0dHA6Ly9vY3NwLmVoZXguZGU6MjU2MC9lamJjYS9wcml2YXRlL3dlYi9z\ndGF0dXMvb2NzcDANBgkqhkiG9w0BAQsFAAOCAQEAlzvGIqqpCsNtpdwInK4hAIPw\nYoZY6Ar0Q67u/Xq9ffn/SoqQLO6r8MCUYR2kxhgRMV40kweX/uaOI8rh4SbLtmoH\nD7UCCUjgrHL3R9TM4WjQJ8QBBcEusv4hRwuNNyKsJDVcwedIXuoQV5XmLse0qEEr\nvDGJgGRe97m0Uf95hdpRVRepfQSlaK6tI5pYvKGMIJAmXn0oUOHX7yYhqN+1KDhp\nZLTEzfGTHS2M9zpjbh4C33f+a0MOFAKRsPLk9nQsgtbTudfLIcmtjRG2HfSKVwi1\nqM3wlbFsLEgbsrx7Y9RtQq0SyMHG135uwYPvyyrcnc4eF1ph+RlloUPuTknvCA==\n-----END CERTIFICATE-----\n";
    @NotNull
    private final List<String> knownTestCAs = new ArrayList<String>(){
        {
            this.add(KnownRoots.testTICert);
        }
    };
    @NotNull
    private final Map<Principal, X509Certificate> rootCAs = new HashMap<Principal, X509Certificate>();
    private final boolean isWithTest;

    public KnownRoots(boolean isWithTest) {
        this.isWithTest = isWithTest;
        this.init();
    }

    @NotNull
    public Optional<X509Certificate> findRoot(@NotNull X509Certificate certificate) {
        if (this.rootCAs.isEmpty()) {
            this.init();
        }
        return Optional.ofNullable(this.rootCAs.get(certificate.getIssuerDN()));
    }

    private void init() {
        try {
            X509Certificate certificate;
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            if (this.isWithTest) {
                for (String knownCA : this.knownTestCAs) {
                    try (ByteArrayInputStream bis = new ByteArrayInputStream(knownCA.getBytes(StandardCharsets.UTF_8));){
                        certificate = (X509Certificate)factory.generateCertificate(bis);
                        this.rootCAs.put(certificate.getSubjectDN(), certificate);
                    }
                }
            }
            try (ResourceEnumerator resourceEnumerator = ResourceEnumerator.findResources((String)"roots");){
                for (Path resource : resourceEnumerator.getFiles()) {
                    if (Files.isDirectory(resource, new LinkOption[0])) continue;
                    LoggerFactory.getLogger(this.getClass()).info("Loading trustet-cert " + resource.getFileName());
                    try {
                        certificate = (X509Certificate)factory.generateCertificate(Files.newInputStream(resource, new OpenOption[0]));
                        this.rootCAs.put(certificate.getSubjectDN(), certificate);
                    }
                    catch (Throwable t) {
                        LoggerFactory.getLogger(this.getClass()).error(t.toString());
                    }
                }
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(KnownRoots.class).error(t.toString(), t);
        }
    }

    private void reload() {
        this.rootCAs.clear();
    }
}

