/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.api;

import de.impfdoc.impfzert.eu.util.EuZertDoseCalculator;
import de.impfdoc.impfzert.model.ImpfZertDose;
import de.impfdoc.impfzert.model.ImpfZertEmployee;
import de.impfdoc.impfzert.model.ImpfZertOperatingSite;
import de.impfdoc.impfzert.model.ImpfZertPatient;
import de.impfdoc.impfzert.model.ImpfZertVaccination;
import java.time.LocalDate;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaccinationInfo {
    @NotNull
    private final ImpfZertPatient patient;
    @NotNull
    private final ImpfZertEmployee employee;
    @NotNull
    private final ImpfZertOperatingSite operatingSite;
    @NotNull
    private final List<ImpfZertVaccination> vaccinations;
    private final LocalDate recoveryDate;
    private final boolean keepDoses;

    public VaccinationInfo(@NotNull ImpfZertPatient patient, @NotNull ImpfZertEmployee employee, @NotNull ImpfZertOperatingSite operatingSite, @NotNull List<ImpfZertVaccination> vaccinations, @Nullable LocalDate recoveryDate, boolean keepDoses) {
        this.patient = patient;
        this.employee = employee;
        this.operatingSite = operatingSite;
        this.vaccinations = vaccinations;
        this.recoveryDate = recoveryDate;
        this.keepDoses = keepDoses;
    }

    @NotNull
    public ImpfZertPatient getPatient() {
        return this.patient;
    }

    @NotNull
    public ImpfZertEmployee getEmployee() {
        return this.employee;
    }

    @NotNull
    public ImpfZertOperatingSite getOperatingSite() {
        return this.operatingSite;
    }

    @NotNull
    public List<ImpfZertVaccination> getVaccinations() {
        return this.vaccinations;
    }

    public int getDose() {
        int dose = 0;
        for (ImpfZertVaccination vaccination : this.getVaccinations()) {
            dose = vaccination.getDose().map(ImpfZertDose::getDose).orElse(dose + 1);
        }
        if (this.keepDoses) {
            return dose;
        }
        return EuZertDoseCalculator.calculateDoses(this.getVaccinations(), this.recoveryDate).getDose();
    }

    public int getTotalDoses() {
        int dose = 0;
        for (ImpfZertVaccination vaccination : this.getVaccinations()) {
            dose = vaccination.getDose().map(ImpfZertDose::getTotalDoses).orElse(dose + 1);
        }
        if (this.keepDoses) {
            return dose;
        }
        return EuZertDoseCalculator.calculateDoses(this.getVaccinations(), this.recoveryDate).getTotalDoses();
    }
}

