/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.api;

import de.impfsoft.ticonnector.ConnectorException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImpfZertException
extends RuntimeException {
    private final Type type;

    public ImpfZertException(@NotNull Type type, @NotNull String message, @Nullable Throwable cause) {
        super(message, cause);
        this.type = type;
    }

    public ImpfZertException(@NotNull ConnectorException ce) {
        super(ce.getMessage(), (Throwable)ce);
        switch (ce.getType()) {
            case NO_CARD: {
                this.type = Type.NoCard;
                break;
            }
            case CONNECTOR_ERROR: {
                this.type = Type.TiConnectorError;
                break;
            }
            case CONFIGURATION_ERROR: {
                this.type = Type.TiConnectorConfigurationError;
                break;
            }
            case PIN_NEEDS_VERIFICATION: {
                this.type = Type.PinVerificationRequired;
                break;
            }
            default: {
                this.type = Type.Unknown;
            }
        }
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public static enum Type {
        NoCard,
        TiConnectorError,
        TiConnectorConfigurationError,
        Unknown,
        SigningServiceError,
        OnlyDoctor,
        NoConnection,
        ServiceUnavailable,
        ChallengeError,
        IllegalArgument,
        InvalidVaccine,
        InvalidIoken,
        PinVerificationRequired;

    }
}

