/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert;

import de.impfdoc.impfzert.QRStructure;
import de.impfdoc.impfzert.api.ImpfZertQrReader;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.eu.util.EuCertificateQrDecoder;
import de.impfdoc.impfzert.eu.util.EuCertificateReadException;
import de.impfdoc.impfzert.model.ImpfZertCertifiedVaccination;
import de.impfdoc.impfzert.v1.ImpfZertQrReaderV1;
import de.impfdoc.impfzert.v2.ImpfZertQrReaderV2;
import org.jetbrains.annotations.NotNull;

public class ImpfZertValidator {
    private ImpfZertQrReader impfzertQrReader;
    boolean isWithTests;

    public ImpfZertValidator(boolean isWithTests) {
        this.isWithTests = isWithTests;
    }

    @NotNull
    public ImpfZertCertifiedVaccination validateZollsoftCert(@NotNull QRStructure qrStructure) {
        switch (qrStructure.getVersion()) {
            case V1: {
                this.impfzertQrReader = new ImpfZertQrReaderV1(this.isWithTests);
                break;
            }
            default: {
                this.impfzertQrReader = new ImpfZertQrReaderV2(this.isWithTests);
            }
        }
        return this.impfzertQrReader.read(qrStructure);
    }

    @NotNull
    public CertificationData validateEuCert(@NotNull QRStructure qrStructure) throws EuCertificateReadException {
        return EuCertificateQrDecoder.compressedContentToCertData(qrStructure.getDecodedContent());
    }
}

