/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert;

import de.impfdoc.impfzert.QRStructure;
import de.impfdoc.impfzert.api.ImpfZertVersion;
import de.impfdoc.impfzert.common.encoder.QRCodeEncoder;
import de.impfdoc.impfzert.eu.util.EuCertificateQrDecoder;
import de.impfdoc.impfzert.v1.encoder.QRCodeEncoderV1;
import de.impfdoc.impfzert.v2.encoder.QRCodeEncoderV2;
import org.jetbrains.annotations.NotNull;

public class ImpfZertQrAnalyzer {
    public static QRStructure determineQRStructure(@NotNull String content, @NotNull ImpfZertVersion defaultImpfzertVersion) {
        ImpfZertVersion impfZertVersion;
        String versionTag = "";
        String actualContent = content;
        int versionSeparatorIndex = content.indexOf(45);
        if (versionSeparatorIndex > 0 && versionSeparatorIndex < 4) {
            versionTag = content.substring(0, versionSeparatorIndex);
            actualContent = content.substring(versionSeparatorIndex + 1);
        }
        switch (versionTag) {
            case "1": {
                impfZertVersion = ImpfZertVersion.V1;
                break;
            }
            case "2": {
                impfZertVersion = ImpfZertVersion.V2;
                break;
            }
            default: {
                impfZertVersion = defaultImpfzertVersion;
            }
        }
        if (impfZertVersion.equals((Object)ImpfZertVersion.EU)) {
            return new QRStructure(0, 0, impfZertVersion, EuCertificateQrDecoder.qrContentToByte(content));
        }
        QRCodeEncoder generator = impfZertVersion.equals((Object)ImpfZertVersion.V1) ? new QRCodeEncoderV1() : new QRCodeEncoderV2();
        byte[] decodedContent = generator.decode(actualContent);
        int signatureBegin = 0;
        int codeBegin = 0;
        boolean codeBeginFound = false;
        for (int i = 0; i < decodedContent.length; ++i) {
            if (!codeBeginFound) {
                if (decodedContent[i] != 63) continue;
                codeBeginFound = true;
                codeBegin = i;
                continue;
            }
            if (decodedContent[i] != 63) continue;
            signatureBegin = i;
            break;
        }
        return new QRStructure(signatureBegin, codeBegin, impfZertVersion, decodedContent);
    }
}

