/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules;

import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.VORSORGE)
public class o {
    private static final g a = new g("01", "02", "03", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46");

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="Gesundheitsuntersuchung ohne gesicherte Z00.0", action=ActionType.UEBERPRUEFEN, gnr="01732")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasLeistung("01732", c2.c) && !patient.hasDiagnose("Z00.0", true, c2.c);
    }

    @Rule(name="U1 bis U9 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ})
    public static String c(c c2, Patient patient) {
        for (String string : "01711|01712|01713|01714|01715|01716|01717|01718|01719|01723".split("[|]")) {
            if (!patient.hasLeistung(string, c2.c) || patient.hasDiagnose("Z00.1", true, c2.c)) continue;
            return string;
        }
        return null;
    }

    @Rule(name="J1 ohne gesicherte Z00.3", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ})
    public static String d(c c2, Patient patient) {
        for (String string : "01720".split("[|]")) {
            if (!patient.hasLeistung(string, c2.c) || patient.hasDiagnose("Z00.3", true, c2.c)) continue;
            return string;
        }
        return null;
    }

    @Rule(name="Vorsorgeuntersuchung {gnr} ist nur ein Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="01711|01712|01713|01714|01715|01716|01717|01718|01719|01720|01723|01734")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getLeistungCount(string, Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="U-Vorsorgediagnose Z00.1 gesichert vorhanden, eventuell Abrechnungsziffer U-Untersuchung vergessen", action=ActionType.UEBERPRUEFEN, gnr="01711/01712/01713/01714/01715/01716/01717/01718/01719/01723", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return !(patient.hasLeistung("01711|01712|01713|01714|01715|01716|01717|01718|01719|01723", c2.c) || !patient.hasDiagnose("Z00.1", true, c2.c) || c2.a("Sachsen") && patient.hasLeistung("92302|81102|92303|81120", c2.c) || c2.a("Hessen") && patient.hasLeistung("81102|81120|91102|91120", c2.c) || c2.a("Baden-W\u00fcrttemberg") && patient.hasLeistung("81102|81120", c2.c) || !patient.hasLeistungBeginntMit("0300|0400", c2.c));
    }

    @Rule(name="J-Vorsorgediagnose Z00.3 gesichert vorhanden, eventuell Abrechnungsziffer J-Untersuchung vergessen", action=ActionType.UEBERPRUEFEN, gnr="01720", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return !patient.hasLeistung("01720", c2.c) && patient.hasDiagnose("Z00.3", true, c2.c) && (!c2.a("Hessen") || !patient.hasLeistung("81121|91121", c2.c)) && patient.hasLeistungBeginntMit("0300|0400", c2.c);
    }

    @Rule(name="01731 ohne gesicherte Z12.5", action=ActionType.UEBERPRUEFEN, gnr="01731")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return !c2.a("Westfalen-Lippe") && patient.hasLeistung("01731", c2.c) && !patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="Hautkrebsscreening {gnr} ohne entsprechend gesicherte Vorsorgediagnose {dia}", action=ActionType.UEBERPRUEFEN, gnr="01745|01746|01745M|01746M")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Action action) {
        if (!patient.hasLeistung(string, c2.c)) {
            return false;
        }
        if (c2.a("Baden-W\u00fcrttemberg")) {
            action.setParameter("dia", "Z12.8");
            return !patient.hasDiagnose("Z12.8", true, c2.c);
        }
        action.setParameter("dia", "Z12.8 oder Z12.9");
        return !patient.hasDiagnose("Z12.8|Z12.9", true, c2.c);
    }

    @Rule(name="Gesundheitsuntersuchung 01732 ohne entsprechende Laboruntersuchungen 32880-32882", action=ActionType.NACHTRAGEN, gnr="32880/32881/32882")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung("01732", c2.c) && !patient.hasLeistung("32880|32881|32882", Arrays.asList(c2.c, c2.d)) && patient.getAlterAnTag(patient.getLeistungBeginntMit("01732", 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="Laboruntersuchungen 32880-32882 in AQ oder VQ ohne Gesundheitsuntersuchung 01732", action=ActionType.UEBERPRUEFEN, gnr="01732")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean i(c c2, Patient patient) {
        if (c2.a("Niedersachsen")) {
            return false;
        }
        if (c2.a("Sachsen-Anhalt") && patient.hasLeistung("99022", c2.c)) {
            return false;
        }
        return patient.hasLeistungBeginntMit("03|13", c2.c) && patient.hasLeistung("32880|32881|32882", Arrays.asList(c2.c, c2.d)) && !patient.hasLeistung("01732", Arrays.asList(c2.c, c2.d)) && (!c2.a(patient) || !c2.a("Westfalen-Lippe"));
    }

    @Rule(name="gesicherte Z00.0 ohne 01732", action=ActionType.UEBERPRUEFEN, gnr="01732", apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean j(c c2, Patient patient) {
        if (c2.a("Sachsen-Anhalt") && patient.hasLeistung("99022", c2.c)) {
            return false;
        }
        return !(!patient.hasDiagnose("Z00.0", true, c2.c) || patient.hasLeistung("01732|32880", Quartal.getBisVorvorjahr(c2.c)) || c2.a("Sachsen") && patient.hasLeistung("99130|99131", c2.c) || c2.a("Th\u00fcringen") && patient.hasLeistung("99729|99730", c2.c) || !patient.hasLeistungBeginntMit("0300", c2.c));
    }

    @Rule(name="Hautkrebsscreening neben der Gesundheitsuntersuchung 01746/M ohne Gesundheitsuntersuchung 01732", action=ActionType.NACHTRAGEN, gnr="01732")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        if (c2.a("Niedersachsen")) {
            return false;
        }
        return patient.hasLeistung("01746|01746M", c2.c) && (patient.hasDiagnose("Z00.0", true, c2.c) || patient.hasLeistung("32880|32881|32882", c2.c)) && !patient.hasLeistung("01732", c2.c);
    }

    @Rule(name="gesicherte {dia} ohne Hautkrebsscreening 01745", action=ActionType.NACHTRAGEN, gnr="01745", apk=ApkModus.HA_DERMATOLOGIE)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, Action action) {
        String string = "Z12.8|Z12.9";
        if (c2.a("Baden-W\u00fcrttemberg")) {
            string = "Z12.8";
        }
        action.setParameter("dia", string);
        return !(!"W".equals(patient.getGeschlecht()) && (!"M".equals(patient.getGeschlecht()) || !c2.a("Brandenburg") && !c2.a("Berlin") && !c2.a("Hessen") && !c2.a("Nordrhein") && !c2.a("Westfalen-Lippe")) || !patient.hasLeistungBeginntMit("03|10", c2.c) || !patient.hasDiagnose(string, true, c2.c) || patient.hasLeistung("01745|01745M|01746|01746M", Quartal.getBisVorjahr(c2.c)) || patient.hasLeistung("01732", c2.c) || c2.a("Sachsen") && patient.hasLeistung("99190", Quartal.getBisVorjahr(c2.c)) || c2.a("Hessen") && patient.hasLeistung("93030|93031|93040|93041", Quartal.getBisVorjahr(c2.c)) || c2.a("Sachsen-Anhalt") && patient.hasLeistung("99130|99131", Quartal.getBisVorjahr(c2.c)) || c2.a("Niedersachsen") && patient.hasLeistung("99210|01745K|99214", Quartal.getBisVorjahr(c2.c)) || c2.a("Saarland") && patient.hasLeistung("98200", Quartal.getBisVorjahr(c2.c)) || c2.a("Berlin") && patient.hasLeistung("99400", Quartal.getBisVorjahr(c2.c)) || c2.a("Westfalen-Lippe") && patient.hasLeistung("91051|91051G|91051C|01745K|91051R|91051B|91051H|91051T", Quartal.getBisVorjahr(c2.c)) || c2.a("Nordrhein") && patient.hasLeistung("92701K|92701O|92701C|92701T|92701H|92701B|92701Q", Quartal.getBisVorjahr(c2.c)) || c2.a("Brandenburg") && patient.hasLeistung("94100", Quartal.getBisVorjahr(c2.c)) || c2.a("Schleswig-Holstein") && patient.hasLeistung("99473C|99473E|99473D|99470A|99472A", Quartal.getBisVorjahr(c2.c)) || c2.a("Baden-W\u00fcrttemberg") && patient.hasLeistung("99841|99843", Quartal.getBisVorjahr(c2.c)) || c2.a("Th\u00fcringen") && patient.hasLeistung("99191|99201|99200|99203|99203B|99129", Quartal.getBisVorjahr(c2.c)) || c2.a("Hamburg") && patient.hasLeistung("94501|94502|94500|94503|94505|94504", Quartal.getBisVorjahr(c2.c)) || c2.a("Rheinland-Pfalz") && patient.hasLeistung("92071|92071Q", Quartal.getBisVorjahr(c2.c)) || c2.a("Mecklenburg-Vorpommern") && patient.hasLeistung("99070|99070O", Quartal.getBisVorjahr(c2.c)) || c2.a("Bremen") && patient.hasLeistung("99225|99227|99230|99230M", Quartal.getBisVorjahr(c2.c)) || c2.a("Bayern") && patient.hasLeistung("97825|97825M|97826", Quartal.getBisVorjahr(c2.c)) || !patient.hasScheinInQuartal(c2.c));
    }

    @Rule(name="gesicherte {dia} ohne Hautkrebsscreening 01745M", action=ActionType.NACHTRAGEN, gnr="01745M", apk=ApkModus.HA_DERMATOLOGIE)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean b(c c2, Patient patient, Action action) {
        String string = "Z12.8|Z12.9";
        if (c2.a("Baden-W\u00fcrttemberg")) {
            string = "Z12.8";
        }
        action.setParameter("dia", string);
        return !(!"M".equals(patient.getGeschlecht()) || c2.a("Brandenburg") || c2.a("Berlin") || c2.a("Hessen") || c2.a("Nordrhein") || c2.a("Westfalen-Lippe") || !patient.hasLeistungBeginntMit("03|10", c2.c) || !patient.hasDiagnose(string, true, c2.c) || patient.hasLeistung("01745|01745M|01746|01746M", Quartal.getBisVorjahr(c2.c)) || patient.hasLeistung("01732", c2.c) || c2.a("Sachsen") && patient.hasLeistung("99190", Quartal.getBisVorjahr(c2.c)) || c2.a("Hessen") && patient.hasLeistung("93031|93041", Quartal.getBisVorjahr(c2.c)) || c2.a("Sachsen-Anhalt") && patient.hasLeistung("99130|99131", Quartal.getBisVorjahr(c2.c)) || c2.a("Niedersachsen") && patient.hasLeistung("99210|01745K|99214", Quartal.getBisVorjahr(c2.c)) || c2.a("Saarland") && patient.hasLeistung("98200", Quartal.getBisVorjahr(c2.c)) || c2.a("Berlin") && patient.hasLeistung("99400", Quartal.getBisVorjahr(c2.c)) || c2.a("Westfalen-Lippe") && patient.hasLeistung("91051|91051G|91051C|01745K|91051R|91051B|91051H|91051T", Quartal.getBisVorjahr(c2.c)) || c2.a("Nordrhein") && patient.hasLeistung("92701K|92701O|92701C|92701T|92701H|92701B|92701Q", Quartal.getBisVorjahr(c2.c)) || c2.a("Brandenburg") && patient.hasLeistung("94100", Quartal.getBisVorjahr(c2.c)) || c2.a("Schleswig-Holstein") && patient.hasLeistung("99473C|99473E|99473D|99470A|99472A", Quartal.getBisVorjahr(c2.c)) || c2.a("Baden-W\u00fcrttemberg") && patient.hasLeistung("99841|99843", Quartal.getBisVorjahr(c2.c)) || c2.a("Th\u00fcringen") && patient.hasLeistung("99191|99201|99200|99203|99203B|99129", Quartal.getBisVorjahr(c2.c)) || c2.a("Hamburg") && patient.hasLeistung("94501|94502|94500|94503|94505|94504", Quartal.getBisVorjahr(c2.c)) || c2.a("Rheinland-Pfalz") && patient.hasLeistung("92071|92071Q", Quartal.getBisVorjahr(c2.c)) || c2.a("Mecklenburg-Vorpommern") && patient.hasLeistung("99070|99070O", Quartal.getBisVorjahr(c2.c)) || c2.a("Bremen") && patient.hasLeistung("99227|99225|99227|99230|99230M", Quartal.getBisVorjahr(c2.c)) || c2.a("Bayern") && patient.hasLeistung("97825|97825M|97826", Quartal.getBisVorjahr(c2.c)) || !patient.hasScheinInQuartal(c2.c));
    }

    @Rule(name="gesicherte {dia} ohne Hautkrebsscreening 01746", action=ActionType.NACHTRAGEN, gnr="01746", apk=ApkModus.HA_DERMATOLOGIE)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean c(c c2, Patient patient, Action action) {
        String string = "Z12.8|Z12.9";
        if (c2.a("Baden-W\u00fcrttemberg")) {
            string = "Z12.8";
        }
        action.setParameter("dia", string);
        return "W".equals(patient.getGeschlecht()) && patient.hasDiagnose(string, true, c2.c) && !patient.hasLeistung("01745|01745M|01746|01746M", Quartal.getBisVorjahr(c2.c)) && patient.hasLeistung("01732", c2.c);
    }

    @Rule(name="gesicherte {dia} ohne Hautkrebsscreening 01746M", action=ActionType.NACHTRAGEN, gnr="01746M", apk=ApkModus.HA_DERMATOLOGIE)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean d(c c2, Patient patient, Action action) {
        String string = "Z12.8|Z12.9";
        if (c2.a("Baden-W\u00fcrttemberg")) {
            string = "Z12.8";
        }
        action.setParameter("dia", string);
        return "M".equals(patient.getGeschlecht()) && patient.hasDiagnose(string, true, c2.c) && !patient.hasLeistung("01745|01745M|01746|01746M", Quartal.getBisVorjahr(c2.c)) && patient.hasLeistung("01732", c2.c);
    }

    @Rule(name="gesicherte Z12.5 ohne Krebsvorsorgeuntersuchung M\u00e4nner 01731", action=ActionType.NACHTRAGEN, gnr="01731")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean l(c c2, Patient patient) {
        return patient.hasDiagnose("Z12.5", true, c2.c) && !patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c)) && patient.hasScheinInQuartal(c2.c);
    }

    @Rule(name="Aufkl\u00e4rung zur Koloskopie 01740 schon ein Mal abgerechnet", action=ActionType.ENTFERNEN, gnr="01740")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung("01740", c2.c) && patient.getLeistungCount("01740", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="Gesundheitsuntersuchung 01732 noch nicht wieder abrechenbar", action=ActionType.ENTFERNEN, gnr="01732")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean n(c c2, Patient patient) {
        if (c2.a("Sachsen-Anhalt") && patient.hasLeistung("99022", c2.c)) {
            return false;
        }
        return patient.hasLeistung("01732", c2.c) && patient.getLeistungCount("01732", Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="Hautkrebsscreening {gnr} noch nicht wieder abrechenbar", action=ActionType.ENTFERNEN, gnr="01745|01745M|01746|01746M")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getLeistungCount("01745|01745M|01746|01746M", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="Krebsvorsorgeuntersuchung Mann 01731 in diesem Jahr bereits abgerechnet", action=ActionType.ENTFERNEN, gnr="01731")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistung("01731", c2.c) && patient.getLeistungCount("01731", Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="Stuhluntersuchung {gnr} noch nicht wieder abrechenbar", action=ActionType.ENTFERNEN, gnr="01737|01737M")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getLeistungCount("01737|01737M", Quartal.getBisJahresanfang(c2.c)) > 1 && patient.getAlterAnTag(patient.getLeistung(string, 1L, c2.c).getDatum()) > 49 && patient.getAlterAnTag(patient.getLeistung(string, 1L, c2.c).getDatum()) < 55;
    }

    @Rule(name="Stuhluntersuchung {gnr} noch nicht wieder abrechenbar", action=ActionType.ENTFERNEN, gnr="01737|01737M")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getLeistungCount("01737|01737M", Quartal.getBisVorjahr(c2.c)) > 1 && patient.getAlterAnTag(patient.getLeistung(string, 1L, c2.c).getDatum()) > 54;
    }

    @Rule(name="Patient ist noch zu jung f\u00fcr die Gesundheitsuntersuchung 01732", action=ActionType.ENTFERNEN, gnr="01732", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01732", c2.c, date) && patient.getAlterAnTag(date) < 18;
    }

    @Rule(name="Patient ist noch zu jung f\u00fcr das Hautkrebsscreening {gnr}", action=ActionType.ENTFERNEN, gnr="01745|01745M|01746|01746M", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(string, c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="Patient ist noch zu jung f\u00fcr das Screening auf Hepatitis-B- und/oder auf Hepatitis-C-Virusinfektion (01734)", action=ActionType.ENTFERNEN, gnr="01734", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01734", c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="Patient ist noch zu jung f\u00fcr die Krebsvorsorge Mann 01731", action=ActionType.ENTFERNEN, gnr="01731", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01731", c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="Patient ist noch zu jung f\u00fcr die Stuhluntersuchung {gnr}", action=ActionType.ENTFERNEN, gnr="01737|01737M", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(string, c2.c, date) && patient.getAlterAnTag(date) < 50;
    }

    @Rule(name="Patient ist noch zu jung f\u00fcr die Aufkl\u00e4rung zur Koloskopie {gnr}", action=ActionType.ENTFERNEN, gnr="01740|01740M", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(string, c2.c, date) && patient.getAlterAnTag(date) < 50;
    }

    @Rule(name="Gesundheitsuntersuchung bei Erwachsenen ab dem vollendeten 18. Lebensjahr gem\u00e4\u00df der Gesundheitsuntersuchungs-Richtlinie (01732) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="27310|32025|32033|32057|32060|32061|32062|32063", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(string, c2.c, date) && patient.hasLeistung("01732 ", c2.c, date);
    }

    @Rule(name="koloskopischer Komplex gem\u00e4\u00df Teil II. \u00a7 3 der Richtlinie f\u00fcr organisierte Krebsfr\u00fcherkennungsprogramme (oKFE-RL) (01741) am Behandlungstag nicht neben der {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="02300|02301|02302|02401|04514|04518|10340|10342|13421|13422|13425|32110|32111|32112|32113|32114|32115|32116|32117|32120", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(string, c2.c, date) && patient.hasLeistung("01741 ", c2.c, date);
    }

    @Rule(name="Prophylaxe gegen RSV (01941) ben\u00f6tigt im Behandlungsfall mind. einen Arzt-Patienten-Kontakt", action=ActionType.ENTFERNEN, gnr="01941")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung("01941", c2.c) && !patient.hasLeistungBeginntMit("03|04", c2.c);
    }

    @Rule(name="Prophylaxe gegen RSV (01941) nur bis zum vollendeten 1. LJ abrechenbar", action=ActionType.ENTFERNEN, gnr="01941", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01941", c2.c, date) && patient.getAlterAnTag(date) > 1;
    }

    @Rule(name="Prophylaxe gegen RSV (01941) nur 1 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01941")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung("01941", c2.c) && patient.getLeistungCount("01941", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Prophylaxe gegen RSV (01943) ben\u00f6tigt im Behandlungsfall einen Arzt-Patienten-Kontakt", action=ActionType.ENTFERNEN, gnr="01943")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung("01943", c2.c) && !patient.hasAPK(true, c2.c, a);
    }

    @Rule(name="Aufkl\u00e4rung und Beratung zur Prophylaxe gegen RSV (01943) nur bis zum vollendeten 1. LJ abrechenbar", action=ActionType.ENTFERNEN, gnr="01943", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01943", c2.c, date) && patient.getAlterAnTag(date) > 1;
    }

    @Rule(name="Aufkl\u00e4rung und Beratung zur Prophylaxe gegen RSV (01943) nur 1 Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01943")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung("01943", c2.c) && patient.getLeistungCount("01943", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Aufkl\u00e4rung und Beratung zur Prophylaxe gegen RSV (01943) im Krankheitsfall nicht neben 01941 abrechenbar", action=ActionType.ENTFERNEN, gnr="01943")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung("01943", c2.c) && patient.hasLeistung("01941", Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }
}

