/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.b.a;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.HZV)
public class i {
    private static final String a = "101002970|101003005|101500154|101534564|101534575|101900443|102100389|102100540|102300600|102700557|103500693|103500706|103500740|103500784|103500819|103500820|103500842|103500864|103500886|103500900|103500944|103500999|103501013|103501024|103501046|103501068|103529026|103529071|103700719|103700720|103700731|103700753|103700764|103700775|103700797|103700800|103700833|103700855|103700877|103700899|103700924|103700935|103700957|103700968|103700979|103700980|103701004|103701059|103701071|104001441|104101113|104201158|104401252|104401412|104501173|104601129|104601130|104601185|104601301|104601403|104801198|104801223|105201516|105201527|105301540|105301551|105301562|105301584|105401530|105501575|105801603|105903116|106003120|106103132|106801672|106801730|106901797|107001756|107001825|107101699|107101859|107202793|107401705|107401727|107401807|107501784|107501864|107501900|107501955|107601843|107702776|107702787|107801878|107801890|107801947|107902723|107902734|107902745|107902756|107902767|108001656|108001667|108001689|108001714|108001747|108001769|108001770|108001816|108001838|108001883|108001918|108001929|108001930|108001963|108001974|108202717|108302002|108303526|108402081|108403516|108502048|108502071|108502106|108602038|108602061|108702051|108702120|108702142|108702175|108703508|108802165|108902019|108902111|108902133|108902155|108902199|109102024|109102091|109102182";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Bayern");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BUNDESWEIT_IKK);
    }

    @Rule(name="HzV IKK Grundpauschale (0000) ist maximal 1 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0000", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Chronikerpauschale (0003) angesetzt ohne gesicherte, endstellig codierte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0003"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.g(), true, c2.c);
    }

    @Rule(name="HzV IKK Chronikerpauschale (0003) ansetzbar", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004"), c2.c)) {
            return false;
        }
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.g(), true, c2.c);
    }

    @Rule(name="HzV IKK kontaktabh\u00e4ngige Vertreterpauschale (0004) in BAG oder MVZ nicht abrechenbar, nur bei Einrichtungswechsel des Patienten", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004"), c2.c) && (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.e) || patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.d));
    }

    @Rule(name="HzV IKK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht \u00f6fter als 1 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV IKK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht neben Zielauftragspauschale (0005) am selben Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV IKK Zielauftragspauschale (0005) nicht neben {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="03221|33012|33042", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0005"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr(string), c2.c, date);
    }

    @Rule(name="HzV IKK f\u00fcr Patienten welche mit der Pseudoziffer 88192 gekennzeichnet wurden HzV-Schein anlegen und Pauschale ansetzen", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String g(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000|0004"), c2.c) && patient.hasLeistung("88192", c2.c)) {
            if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004"), Arrays.asList(c2.d, c2.e))) {
                return "0004";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV IKK die Kennzeichnungsziffer (88192) ist nur im KV-Schein abzurechnen, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("88192"), c2.c);
    }

    @Rule(name="HzV IKK die lebenslangen Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        if (patient.hasLeistung("88192", c2.c)) {
            String string = patient.getAPK(false, c2.c, 1L, com.nhochdrei.kvdt.optimizer.misc.i.a("88192")).getLanr();
            String string2 = null;
            if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, com.nhochdrei.kvdt.optimizer.misc.i.a(Hzv.BUNDESWEIT_IKK.gnr("0000"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, com.nhochdrei.kvdt.optimizer.misc.i.a(Hzv.BUNDESWEIT_IKK.gnr("0004"))).getLanr();
            }
            return string2 != null && !string2.equals(string);
        }
        return false;
    }

    @Rule(name="HzV IKK eine Doppelabrechnung von Betreuungspauschalen (0000, 0004) im HzV-Schein und der Versichertenpauschale (0300x) im KV-Schein ist ausgeschlossen", action=ActionType.ENTFERNEN, gnr="0300*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000|0004"), c2.c) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="HzV IKK {gnr} ist bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32880|32881|32882|32030|32025|32031|32042|32035|32036|32037|32038|32039|32045", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr(string), c2.c);
    }

    @Rule(name="HzV IKK {gnr} ist bei HzV eingeschriebenen Patienten nicht zu Lasten KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32880|32881|32882|32030|32025|32031|32042|32035|32036|32037|32038|32039|32045")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV IKK {gnr} ist bei HzV eingeschriebenen Patienten \u00fcber den KV-Schein abzurechnen", action=ActionType.UEBERPRUEFEN, gnr="32135|32150", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr(string), c2.c);
    }

    @Rule(name="HzV IKK Inanspruchnahme zur Unzeit Tag (01100/01100B/01100C) ist nicht neben dem Zielauftrag (0005) am selben Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0005"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01100|01100B|01100C"), c2.c, date);
    }

    @Rule(name="HzV IKK Inanspruchnahme zur Unzeit Nacht (01101/01101B/01101C) ist nicht neben dem Zielauftrag (0005) am selben Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0005"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01101|01101B|01101C"), c2.c, date);
    }

    @Rule(name="HzV IKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732*) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01732*", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01732*"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV IKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732*) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="01732*", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01732*"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV IKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist alle 2 Kalenderjahre abrechenbar", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean m(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV IKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732B) ein Mal im Leben abrechenbar", action=ActionType.POTENTIAL, gnr="01732B", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean n(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01732B"), Quartal.getBisVorvorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c).getDatum()) > 17 && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c).getDatum()) < 35;
    }

    @Rule(name="HzV IKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV IKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732B) ist nur zwischen 18 und 34 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01732B", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01732"), c2.c, date) && (patient.getAlterAnTag(date) < 18 || patient.getAlterAnTag(date) > 34);
    }

    @Rule(name="HzV IKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist nur 1 Mal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01732"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01732"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV IKK Krebsvorsorge Mann (01731) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.HAUSARZT_UROLOGIE)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean p(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c).getDatum()) > 44 && "M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV IKK Krebsvorsorge Mann (01731) ist erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01731"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("01731"), 1L, c2.c).getDatum()) < 45;
    }

    @Rule(name="HzV IKK Krebsvorsorge Mann (01731) ist nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV IKK Krebsvorsorge Mann (01731) ist nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01731"), c2.c) && !"M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV IKK f\u00fcr die Krebsvorsorge Mann (01731) ist die Vorsorgediagnose Z12.5 gesichert zur Abrechung vorgesehen", action=ActionType.UEBERPRUEFEN, gnr="01731", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01731"), c2.c) && !patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV IKK Vorsorgediagnose Z12.5 gesichert wurde abgerechnet, die Krebsvorsorge Mann (01731) in der Ansetzung vergessen", action=ActionType.NACHTRAGEN, gnr="01731", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01731"), c2.c) && patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U2 (01712) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01712", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean v(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01712"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 2 && patient.getAlterInTage() < 15;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U3 (01713) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01713", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean w(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01713"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 14 && patient.getAlterInTage() < 50;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U4 (01714) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01714", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean x(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01714"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 30 && patient.getAlterInTage() < 136;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U5 (01715) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01715", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean y(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01715"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 120 && patient.getAlterInTage() < 241;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U6 (01716) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01716", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean z(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01716"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 240 && patient.getAlterInTage() < 421;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U7 (01717) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean A(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01717"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 570 && patient.getAlterInTage() < 811;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U7a (01723) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean B(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01723"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 960 && patient.getAlterInTage() < 1141;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U8 (01718) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean C(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01718"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 1260 && patient.getAlterInTage() < 1501;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U9 (01719) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean D(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlterInTage() > 1710 && patient.getAlterInTage() < 1981;
    }

    @Rule(name="HzV IKK Jugendvorsorgeuntersuchung J1 (01720) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01720", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01720"), Quartal.getBisVorvorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c).getDatum()) > 11 && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c).getDatum()) < 16;
    }

    @Rule(name="HzV IKK U-Untersuchung ohne Vorsorgediagnose Z00.1 gesichert vorhanden", action=ActionType.UEBERPRUEFEN, gnr="01712|01713|01714|01715|01716|01717|01718|01719|01723", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr(string), c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV IKK J-Untersuchung ohne Vorsorgediagnose Z00.3 gesichert vorhanden", action=ActionType.UEBERPRUEFEN, gnr="01720", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01720"), c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV IKK U-Vorsorgediagnose Z00.1 gesichert vorhanden und eventuell Abrechnungsziffer U-Untersuchung noch nicht angesetzt", action=ActionType.NACHTRAGEN, gnr="01712/01713/01714/01715/01716/01717/01718/01719/01723", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01712|01713|01714|01715|01716|01717|01718|01719|01723"), c2.c) && patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV IKK J-Vorsorgediagnose Z00.3 gesichert vorhanden und eventuell Abrechnungsziffer J-Untersuchung noch nicht angesetzt", action=ActionType.NACHTRAGEN, gnr="01720", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01720"), c2.c) && patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV IKK Impfziffern ({gnr}) sind nur auf dem HzV-Schein abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="89*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        if (Hzv.BUNDESWEIT_IKK.hasVertragsIdentifikator(string)) {
            return false;
        }
        return patient.hasLeistung(string, c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV IKK pr\u00e4operative Leistung ({gnr}) ist in den Grundpauschalen enthalten und damit nicht zu Lasten der Kasse abrechenbar", action=ActionType.ENTFERNEN, gnr="31010|31011|31012|31013")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, String string) {
        return (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr(string), c2.c) || patient.hasLeistung(string, c2.c)) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV IKK Sonographie Abdomen (33042) ist maximal 2 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("33042"), c2.c) > 2;
    }

    @Rule(name="HzV IKK {gnr} ist nicht gesondert abrechenbar, da diese in der 0000 enthalten ist", action=ActionType.ENTFERNEN, gnr="03322|03324|35100|35110|30130|30790|30791|30201", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr(string), c2.c);
    }

    @Rule(name="HzV IKK CW-Doppler extrakranielle Gef\u00e4\u00dfe oder extremit\u00e4tenversorgende Gef\u00e4\u00dfe (33060, 33061) sind nur \u00fcber den KV-Schein abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="33060|33061", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("33060|33061"), c2.c);
    }

    @Rule(name="HzV IKK haus\u00e4rztliches geriatrisches Basisassessment (03240) ist nur 2 Mal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03240"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="HzV IKK haus\u00e4rztliches geriatrisches Basisassessment (03240) Patient \u00e4lter als 69 Jahre", action=ActionType.POTENTIAL, gnr="03240", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean L(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03240"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) < 2 && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c).getDatum()) > 69;
    }

    @Rule(name="HzV IKK haus\u00e4rztliches geriatrisches Basisassessment (03240) Patient j\u00fcnger als 70 Jahre, es liegt eine spezifische geriatrische Diagnose vor", action=ActionType.POTENTIAL, gnr="03240", hzv=Hzv.BUNDESWEIT_IKK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean M(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03240"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) < 2 && patient.getAlterAnTag(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c).getDatum()) < 70 && patient.hasDiagnoseBeginntMit("F00|F01|F02|G20.1|G20.2|G30", "G", c2.c);
    }

    @Rule(name="HzV IKK Chronikerpauschale (0003) h\u00f6chstens ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Chronikerpauschale (0003) ohne pers\u00f6nlichen Arzt-Patienten-Kontakt angesetzt", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0003"), c2.c) && patient.getAPKCount(true, c2.c) < 1L;
    }

    @Rule(name="HzV IKK Chronikerpauschale (0003) h\u00f6chstens vier Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean P(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0003"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("0003"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 4;
    }

    @Rule(name="HzV IKK Mitbesuch (01413) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01413", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_IKK.gnr("01413"), c2.c, date) > 1;
    }

    @Rule(name="HzV IKK Mitbesuch (01413) am Behandlungstag nicht neben der 01410 abrechenbar", action=ActionType.ENTFERNEN, gnr="01413", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01413"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01410"), c2.c, date);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U1 (01711) nur einmal bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01711"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U1 (01711) nur bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01711"), c2.c, date) && patient.getAlterAnTag(date) > 2;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U2 (01712) nur einmal zwischen 3. und 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01712"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U2 (01712) erst ab 3. Lebenstag und nur bis 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01712"), c2.c, date) && (patient.getAlterAnTag(date) < 3 || patient.getAlterAnTag(date) > 14);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U3 (01713) nur einmal bis 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01713"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U3 (01713) nur zwischen 3. und 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01713"), c2.c, date) && (patient.getAlterAnTag(date) < 15 || patient.getAlterAnTag(date) > 49);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U4 (01714) nur einmal bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01714"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U4 (01714) nur zwischen 2. und 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01714"), c2.c, date) && (patient.getAlterAnTag(date) < 30 || patient.getAlterAnTag(date) > 136);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U5 (01715) nur einmal bis 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01715"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U5 (01715) nur zwischen 5. und 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01715"), c2.c, date) && (patient.getAlterAnTag(date) < 120 || patient.getAlterAnTag(date) > 241);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U6 (01716) nur einmal bis 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01716"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U6 (01716) nur zwischen 9. und 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01716"), c2.c, date) && (patient.getAlterAnTag(date) < 241 || patient.getAlterAnTag(date) > 420);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U7 (01717) nur einmal bis 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01717"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U7 (01717) nur zwischen 20. und 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01717"), c2.c, date) && (patient.getAlterAnTag(date) < 571 || patient.getAlterAnTag(date) > 810);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U7a (01723) nur einmal bis 38. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01723"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U7a (01723) nur zwischen 34. und 36. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01723"), c2.c, date) && (patient.getAlterAnTag(date) < 960 || patient.getAlterAnTag(date) > 1141);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U8 (01718) nur einmal bis 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01718"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U8 (01718) nur zwischen 43. und 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01718"), c2.c, date) && (patient.getAlterAnTag(date) < 1260 || patient.getAlterAnTag(date) > 1501);
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U9 (01719) nur einmal bis 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Z(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("01719"), c2.c) > 1;
    }

    @Rule(name="HzV IKK Kindervorsorgeuntersuchung U9 (01719) nur zwischen 58. und 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01719"), c2.c, date) && (patient.getAlterAnTag(date) < 1711 || patient.getAlterAnTag(date) > 1980);
    }

    @Rule(name="HzV IKK classic Modul Einsatz von arriba (3101) nur 1 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="3101", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("3101"), c2.c) > 1;
    }

    @Rule(name="HzV IKK classic Modul Einsatz von arriba (3101) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="3101", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3101"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV IKK classic Ambulante geriatrische Betreuung (3250) max. 1 Mal je Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="3250", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ac(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3250"), Arrays.asList(c2.c)) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3250"), Arrays.asList(c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV IKK classic Ambulante geriatrische Betreuung (3250) 1 Mal je Versichertenteilnahmejahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="3250", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3250"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01410|01413|1417"), Arrays.asList(c2.c, c2.d)) && patient.getAlterAnTag(date) > 69 && patient.hasDiagnose("A88.1|F00.0|F00.1|F00.2|F00.9|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8|F03|F04|F05.0|F05.1|F05.8|F05.9|F06.0|F06.1|F06.2|F06.3|F06.4|F06.5|F06.6|F06.7|F06.8|F06.9|F07.0|F07.1|F07.2|F07.8|F07.9|F10.1|F10.2|F10.3|F10.4|F10.5|F10.6|F10.7|F10.8|F10.9|F20.0|F20.1|F20.2|F20.3|F20.4|F20.5|F20.6|F20.8|F20.9|F21|F22.0|F22.8|F22.9|F24|F25.0|F25.1|F25.2|F25.8|F25.9|G20.10|G20.11|G20.20|G20.21|G20.90|G20.91|G21.1|G21.2|G21.3|G21.4|G21.8|G21.9|G22|G23.2|G30.0|G30.1|G30.8|G30.9|G35.10|G35.11|G35.20|G35.21|G35.30|G35.31|G35.9|H81.0|H81.1|H81.2|H81.3|H81.4|H81.8|H81.9|H82|I25.20|I25.21|I25.22|I25.29|I25.5|I25.8|I25.9|I69.0|I69.1|I69.2|I69.3|I69.4|I69.8|R26.0|R26.1|R26.2|R26.3|R26.8|R29.6|R29.8|R42|R52.1|R52.2|R52.9|Z74.0|Z74.1|Z74.2|Z74.3|Z74.8|Z74.9", true, c2.c);
    }

    @Rule(name="HzV IKK classic Ambulante geriatrische Betreuung (3250) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="3250", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3250"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV IKK classic Ambulante geriatrische Betreuung (3250) ohne entsprechende GOP nicht abrechenbar", action=ActionType.ENTFERNEN, gnr="3250", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ae(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3250"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01410|01413|1417"), Arrays.asList(c2.c, c2.d)) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV IKK classic Ambulante geriatrische Betreuung (3250) erst ab dem 70. LJ abrechenbar", action=ActionType.ENTFERNEN, gnr="3250", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3250"), c2.c, date) && patient.getAlterAnTag(date) < 70;
    }

    @Rule(name="HzV IKK classic Ambulante geriatrische Betreuung (3250) nur mit entsprechenden Diagnosen abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="3250", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean af(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3250"), c2.c) && !patient.hasDiagnose("A88.1|F00.0|F00.1|F00.2|F00.9|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8|F03|F04|F05.0|F05.1|F05.8|F05.9|F06.0|F06.1|F06.2|F06.3|F06.4|F06.5|F06.6|F06.7|F06.8|F06.9|F07.0|F07.1|F07.2|F07.8|F07.9|F10.1|F10.2|F10.3|F10.4|F10.5|F10.6|F10.7|F10.8|F10.9|F20.0|F20.1|F20.2|F20.3|F20.4|F20.5|F20.6|F20.8|F20.9|F21|F22.0|F22.8|F22.9|F24|F25.0|F25.1|F25.2|F25.8|F25.9|G20.10|G20.11|G20.20|G20.21|G20.90|G20.91|G21.1|G21.2|G21.3|G21.4|G21.8|G21.9|G22|G23.2|G30.0|G30.1|G30.8|G30.9|G35.10|G35.11|G35.20|G35.21|G35.30|G35.31|G35.9|H81.0|H81.1|H81.2|H81.3|H81.4|H81.8|H81.9|H82|I25.20|I25.21|I25.22|I25.29|I25.5|I25.8|I25.9|I69.0|I69.1|I69.2|I69.3|I69.4|I69.8|R26.0|R26.1|R26.2|R26.3|R26.8|R29.6|R29.8|R42|R52.1|R52.2|R52.9|Z74.0|Z74.1|Z74.2|Z74.3|Z74.8|Z74.9", true, Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV IKK classic Telefon-/Videofallkonferenz (3251) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="3251", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3251"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV IKK classic Telefon-/Videofallkonferenz (3251) erst ab dem 70. LJ abrechenbar", action=ActionType.ENTFERNEN, gnr="3251", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3251"), c2.c, date) && patient.getAlterAnTag(date) < 70;
    }

    @Rule(name="HzV IKK classic Telefon-/Videofallkonferenz (3251) ohne GOP 3250 nicht abrechenbar", action=ActionType.ENTFERNEN, gnr="3251", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ah(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3251"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("3250"), Arrays.asList(c2.c, c2.d, c2.e, c2.f));
    }

    @Rule(name="HzV IKK classic Telefon-/Videofallkonferenz (3251) max. 12 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="3251", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ai(c c2, Patient patient) {
        return patient.getLeistungCount("3251", c2.c) > 12;
    }

    @Rule(name="HzV IKK classic Telefon-/Videofallkonferenz (3251) bis zu 12 Mal im Behandlungsfall m\u00f6glich", action=ActionType.POTENTIAL, gnr="3251", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aj(c c2, Patient patient) {
        return patient.hasLeistung("0000", c2.c) && !patient.hasLeistung("0004|0005", c2.c) && patient.hasLeistung("3250", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.getLeistungCount("3251", c2.c) < 12;
    }

    @Rule(name="HzV IKK classic COPD-Screening (03330A) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="03330A", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ak(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330A"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV IKK classic COPD-Screening (03330A) ben\u00f6tigt im Behandlungsfall einen Arzt-Patienten-Kontakt", action=ActionType.UEBERPRUEFEN, gnr="03330A", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean al(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330A"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV IKK classic COPD-Screening (03330A) max. 1 Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03330A", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean am(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330A"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330A"), Quartal.getBisJahresanfang(c2.c));
    }

    @Rule(name="HzV IKK classic COPD-Screening (03330A) erst ab dem 35. LJ abrechenbar", action=ActionType.ENTFERNEN, gnr="03330A", hzv=Hzv.BUNDESWEIT_IKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330A"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV IKK classic COPD-Screening (03330A) nur ohne bisher bekannte COPD-Diagnose abrechenbar", action=ActionType.ENTFERNEN, gnr="03330A", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean an(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330A"), c2.c) && patient.hasDiagnose("J44.19|J44.89|J44.99", true, Quartal.getBisVorvorjahr(c2.c));
    }

    @Rule(name="HzV IKK classic COPD Weiterbehandlung (03330B) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="03330B", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ao(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330B"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV IKK classic COPD Weiterbehandlung (03330B) ben\u00f6tigt im Behandlungsfall einen Arzt-Patienten-Kontakt", action=ActionType.UEBERPRUEFEN, gnr="03330B", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ap(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330B"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV IKK classic COPD Weiterbehandlung (03330B) 1 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="03330B", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aq(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_IKK.gnr("03330B"), c2.c) > 1;
    }

    @Rule(name="HzV IKK classic COPD Weiterbehandlung (03330B) nur mit gesicherter COPD-Diagnose abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="03330B", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ar(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330B"), c2.c) && !patient.hasDiagnose("J44.00|J44.01|J44.02|J44.10|J44.11|J44.12|J44.80|J44.81|J44.82|J44.90|J44.91|J44.92", true, c2.c);
    }

    @Rule(name="HzV IKK classic COPD Weiterbehandlung (03330B) 1 Mal pro Quartal m\u00f6glich", action=ActionType.POTENTIAL, gnr="03330B", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean as(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c) && patient.hasDiagnose("J44.00|J44.01|J44.02|J44.10|J44.11|J44.12|J44.80|J44.81|J44.82|J44.90|J44.91|J44.92", true, c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("03330B"), c2.c);
    }

    @Rule(name="HzV IKK classic Besuch durch VERAH (1417) wird nur dem Betreuarzt verg\u00fctet", action=ActionType.ENTFERNEN, gnr="1417", hzv=Hzv.BUNDESWEIT_IKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean at(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("1417"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BUNDESWEIT_IKK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

