/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.b.a;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.HZV)
public class e {
    private static final String a = "102020985|108023388|108036098|108036123";
    private static final String b = "F32|F33|F34.1|F40|F41|F42|F45|F44|F43|F50|F51|F52|F6|F90|F91|F92|F93|F94|F95|F96|F97|F98";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Bayern");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BAYERN_BKK);
    }

    @Rule(name="HzV Bosch BKK kontaktabh\u00e4ngige Grundpauschale (0000) \u00f6fter als 1 Mal im Quartal abgerechnet", action=ActionType.ENTFERNEN, gnr="0000", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("0000"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK kontaktabh\u00e4ngige Grundpauschale (0000) kann nur von Betreuungsarzt abgerechnet werden", action=ActionType.ENTFERNEN, gnr="0000", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP|VP"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (BBP)  angesetzt ohne gesicherte, endstellig codierte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="BBP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("BBP"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.h(), true, c2.c);
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (BBP) ansetzbar", action=ActionType.NACHTRAGEN, gnr="BBP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0004"), c2.c)) {
            return false;
        }
        return !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("BBP"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.h(), true, c2.c);
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (BBP) kann nur vom Betreuungsarzt abgerechnet werden", action=ActionType.ENTFERNEN, gnr="BBP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("BBP"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP|VP"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (BBP) \u00f6fter als 1 Mal im Quartal abgerechnet", action=ActionType.ENTFERNEN, gnr="BBP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("BBP"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (BBP) und Zuschlag f\u00fcr haus\u00e4rztliche Betreuung von Palliativpatienten (0001Z) nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="BBP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("BBP"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0001Z"), c2.c);
    }

    @Rule(name="HzV Bosch BKK kontaktabh\u00e4ngige Vertreterpauschale (VP) nicht \u00f6fter als 1 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="VP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("VP"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK kontaktabh\u00e4ngige Vertreterpauschale (VP) nicht neben Zielauftragspauschale (ZP) am selben Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="ZP", hzv=Hzv.BAYERN_BKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("VP"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP"), c2.c, date);
    }

    @Rule(name="HzV Bosch BKK kontaktabh\u00e4ngige Vertreterpauschale (VP) nicht innerhalb einer BAG/MVZ abrechenbar", action=ActionType.ENTFERNEN, gnr="VP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("VP"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Zielauftragspauschale (ZP) nicht neben {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="03321|33012|33042|35100|35110|35110B|35110C", hzv=Hzv.BAYERN_BKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c, date);
    }

    @Rule(name="HzV Bosch BKK Zielauftragspauschale (ZP) nicht innerhalb einer BAG/MVZ abrechenbar", action=ActionType.ENTFERNEN, gnr="ZP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Pflegeheimpauschale (0008) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0008"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP|VP"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Pflegeheimpauschale (0008) ist nur ein Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("0008"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK Pflegeheimpauschale (0008) ist nur als Zuschlag zur Grundpauschale (0000) abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0008"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Zuschlag Pflegeheimpauschale (0008) eventuell m\u00f6glich, da der Patient im Vorquartal diese Pauschale erhalten hat", action=ActionType.NACHTRAGEN, gnr="0008", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean o(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0008"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0008"), Arrays.asList(c2.d, c2.e));
    }

    @Rule(name="HzV Bosch BKK Zuschlag f\u00fcr die haus\u00e4rztliche Betreuung von Palliativpatienten (0001Z) ohne gesicherte Leitdiagnose Palliativbehandlung Z51.5", action=ActionType.UEBERPRUEFEN, gnr="0001Z", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0001Z"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV Bosch BKK gesicherte Leitdiagnose Palliativbehandlung Z51.5 bei einem haus\u00e4rztlich betreuten Patienten vorhanden, ohne Zuschlag f\u00fcr die haus\u00e4rztliche Betreuung von Palliativpatienten (0001Z)", action=ActionType.NACHTRAGEN, gnr="0001Z", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0004"), c2.c)) {
            return false;
        }
        return !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0001Z"), c2.c) && patient.hasDiagnose("Z51.5", true, c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK kontaktabh\u00e4ngige Vertreterpauschale (VP) nicht neben Zuschlag f\u00fcr die haus\u00e4rztliche Betreuung von Palliativpatienten (0001Z) abrechenbar", action=ActionType.ENTFERNEN, gnr="VP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0001Z"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("VP"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Zielauftragspauschale (ZP) nicht neben Zuschlag f\u00fcr die haus\u00e4rztliche Betreuung von Palliativpatienten (0001Z) abrechenbar", action=ActionType.ENTFERNEN, gnr="ZP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0001Z"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Zuschlag f\u00fcr die haus\u00e4rztliche Betreuung von Palliativpatienten (0001Z) \u00f6fter als 1 Mal im Quartal abgerechnet", action=ActionType.ENTFERNEN, gnr="0001Z", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("0001Z"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK f\u00fcr Patienten welche mit der Pseudoziffer 88192 gekennzeichnet wurden HzV-Schein anlegen und Pauschale ansetzen", action=ActionType.UEBERPRUEFEN, gnr="0000|VP", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String u(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000|VP"), c2.c) && patient.hasLeistung("88192", c2.c)) {
            if (patient.hasLeistung(Hzv.BAYERN_BKK.gnr("VP"), Arrays.asList(c2.d, c2.e))) {
                return "VP";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV Bosch BKK die Kennzeichnungsziffer (88192) ist nur im KV-Schein abzurechnen, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("88192"), c2.c);
    }

    @Rule(name="HzV Bosch BKK die lebenslangen Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.hasLeistung("88192", c2.c)) {
            return !patient.getLeistung(Hzv.BAYERN_BKK.gnr("0000"), 1L, c2.c).getLanr().equals(patient.getLeistung("88192", 1L, c2.c).getLanr());
        }
        return false;
    }

    @Rule(name="HzV Bosch BKK eine Doppelabrechnung von Betreuungspauschale (0000, VP, ZP) im HzV-Schein und der Versichertenpauschale (0300x) im KV-Schein ist ausgeschlossen", action=ActionType.UEBERPRUEFEN, gnr="0300*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient) {
        if (patient.hasLeistungBeginntMit("03008|04008", c2.c) && patient.hasLeistungBeginntMit("88196", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000|VP|ZP"), c2.c) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="HzV Bosch BKK {gnr} ist bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32880|32881|32882|32030|32025|32031|32042|32035|32036|32037|32038|32039|32045|32026|32027|32128", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c);
    }

    @Rule(name="HzV Bosch BKK {gnr} ist bei HzV eingeschriebenen Patienten nicht zu Lasten der KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32880|32881|32882|32030|32025|32031|32042|32035|32036|32037|32038|32039|32045|32026|32027|32128")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV Bosch BKK OP-Vorbereitungsziffern ({gnr}) sind in der Grundpauschale (0000) vorhanden und damit nicht zu Lasten der Kasse abrechenbar", action=ActionType.ENTFERNEN, gnr="31010|31011|31012|31013")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && (patient.hasLeistung(string, c2.c) || patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c));
    }

    @Rule(name="HzV Bosch BKK {gnr} ist bei in die HzV eingeschriebenen Patienten \u00fcber den KV-Schein abzurechnen", action=ActionType.UEBERPRUEFEN, gnr="32135|32150", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c);
    }

    @Rule(name="HzV Bosch BKK Inanspruchnahme zur Unzeit Tag (01100/01100B/01100C) ist nicht neben dem Zielauftrag (ZP) abrechenbar", action=ActionType.ENTFERNEN, gnr="ZP", hzv=Hzv.BAYERN_BKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("01100|01100B|01100C"), c2.c, date);
    }

    @Rule(name="HzV Bosch BKK Inanspruchnahme zur Unzeit Nacht (01101/01101B/01101C) ist nicht neben dem Zielauftrag (ZP) abrechenbar", action=ActionType.ENTFERNEN, gnr="ZP", hzv=Hzv.BAYERN_BKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("ZP"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("01101|01101B|01101C"), c2.c, date);
    }

    @Rule(name="HzV Bosch BKK \u00dcberpr\u00fcfung Impfstatus (8989) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="8989", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean y(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("8989"), Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="HzV Bosch BKK \u00dcberpr\u00fcfung Impfstatus (8989) ist nur 1 Mal alle 2 Kalenderjahre abrechenbar", action=ActionType.ENTFERNEN, gnr="8989", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("8989"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("8989"), Quartal.getBisVorjahrOhneAq(c2.c));
    }

    @Rule(name="HzV Bosch BKK \u00dcberpr\u00fcfung Impfstatus (8989) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="8989", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("8989"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("VP|ZP"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Einschaltung der Patientenbegleitung (2008) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="2008", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("2008"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("VP|ZP"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Einschaltung der Patientenbegleitung (2008) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="2008", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("2008"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Einschaltung der Patientenbegleitung (2008) ist nur 1 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="2008", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("2008"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK Geriatriezuschlag in F\u00e4llen der Patientenbegleitung (2008Z) nur neben Einschaltung der Patientenbegleitung (2008) m\u00f6glich, ev. wurde 2008 vergessen", action=ActionType.NACHTRAGEN, gnr="2008", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("2008"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("2008Z"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Geriatriezuschlag in F\u00e4llen der Patientenbegleitung (2008Z) neben Einschaltung der Patientenbegleitung (2008) ev. m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="2008Z", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("2008"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("2008Z"), c2.c) && (patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_BKK.gnr("2008Z"), 1L, c2.c).getDatum()) > 69 || patient.hasDiagnoseBeginntMit("F00|F01|F02|G30|G20.1|G20.2", "G", c2.c));
    }

    @Rule(name="HzV Bosch BKK Geriatriezuschlag in F\u00e4llen der Patientenbegleitung (2008Z) ist nur bei Patienten \u00e4lter 69 Jahren oder bei Vorliegen von schwerer Demenz, Alzheimer oder Parkinson abrechenbar", action=ActionType.ENTFERNEN, gnr="2008Z", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("2008Z"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_BKK.gnr("2008Z"), 1L, c2.c).getDatum()) <= 69 && !patient.hasDiagnoseBeginntMit("F00|F01|F02|G30|G20.1|G20.2", "G", c2.c);
    }

    @Rule(name="HzV Bosch BKK abdominelle Sonographie (33042) \u00f6fter als 2 Mal im Quartal abgerechnet", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("33042"), c2.c) > 2;
    }

    @Rule(name="HzV Bosch BKK Psychosomatik / Differentialdiagnostik (35100) ist nicht am gleichen Tag wie die verbale Intervention (35110) abrechenbar", action=ActionType.ENTFERNEN, gnr="35100", hzv=Hzv.BAYERN_BKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("35100"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("35110"), c2.c, date);
    }

    @Rule(name="HzV Bosch BKK psychosomatische verbale Intervention ({gnr}) ist maximal 3 Mal pro Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="35100", hzv=Hzv.BAYERN_BKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_BKK.gnr("35110|35110B|35110C"), c2.c, date) > 3;
    }

    @Rule(name="HzV Bosch BKK Psychosomatik / Differentialdiagnostik (35100) und die verbale Intervention (35110) erfordern eine leitliniengerechte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="35100|35110|35110B|35110C", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c) && !patient.hasDiagnose(b, true, c2.c);
    }

    @Rule(name="HzV Bosch BKK gesicherte leitliniengerechte Diagnose ohne psychosomatische Ziffer ({gnr})", action=ActionType.UEBERPRUEFEN, gnr="35100|35110", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, String string) {
        return !patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c) && patient.hasDiagnoseBeginntMit(b, "G", c2.c);
    }

    @Rule(name="HzV Bosch BKK CW-Doppler extrakranielle Gef\u00e4\u00dfe (33060) kann nur \u00fcber KV-Schein abgerechnet werden", action=ActionType.ENTFERNEN, gnr="33060", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("33060"), c2.c);
    }

    @Rule(name="HzV Bosch BKK CW-Doppler extremit\u00e4tenversorgende Gef\u00e4\u00dfe (33061) kann nur \u00fcber KV-Schein abgerechnet werden", action=ActionType.ENTFERNEN, gnr="33061", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("33061"), c2.c);
    }

    @Rule(name="HzV Bosch BKK haus\u00e4rztliches geriatrisches Basisassessment (03240) ist nur zwei Mal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("03240"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="HzV Bosch BKK haus\u00e4rztliches geriatrisches Basisassessment (03240) Patient \u00e4lter als 69 Jahre", action=ActionType.POTENTIAL, gnr="03240", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean L(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_BKK.gnr("03240"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) < 2 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_BKK.gnr("0000"), 1L, c2.c).getDatum()) > 69;
    }

    @Rule(name="HzV Bosch BKK haus\u00e4rztliches geriatrisches Basisassessment (03240) Patient j\u00fcnger als 70 Jahre, es liegt eine spezifische geriatrische Diagnose vor", action=ActionType.POTENTIAL, gnr="03240", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean M(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_BKK.gnr("03240"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) < 2 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_BKK.gnr("0000"), 1L, c2.c).getDatum()) < 70 && patient.hasDiagnoseBeginntMit("F00|F01|F02|G20.1|G20.2|G30", "G", c2.c);
    }

    @Rule(name="HzV Bosch BKK Rufbereitschaft am Lebensende {gnr} nur ein Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="3730|3730B|3730C|3730D|3730E", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean g(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c) && patient.getLeistungCount(Hzv.BAYERN_BKK.gnr(string), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV Bosch BKK Rufbereitschaft am Lebensende {gnr} ohne entsprechende gesicherte Diagnose (Z51.5)", action=ActionType.UEBERPRUEFEN, gnr="3730|3730B|3730C|3730D|3730E", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV Bosch BKK Rufbereitschaft am Lebensende {gnr} nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="3730|3730B|3730C|3730D|3730E", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("VP|ZP"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Rufbereitschaft am Lebensende {gnr} ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="3730|3730B|3730C|3730D|3730E", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr(string), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Rufbereitschaft am Lebensende 3730B nur mit 3730 in Vorwoche abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="3730", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3730B"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3730"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Rufbereitschaft am Lebensende 3730C nur mit 3730B in Vorwoche abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="3730B", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3730C"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3730B"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Rufbereitschaft am Lebensende 3730D nur mit 3730C in Vorwoche abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="3730C", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3730D"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3730C"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Rufbereitschaft am Lebensende 3730E nur mit 3730D in Vorwoche abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="3730D", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3730E"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3730D"), c2.c);
    }

    @Rule(name="HzV BKK LUTS (Lower Urinary Tract Symptoms) (3001) und Nachsorgekontrolle bei positiven Befund (3001N) im Behandlungsfall nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="3001", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3001"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3001N"), c2.c);
    }

    @Rule(name="HzV BKK LUTS (Lower Urinary Tract Symptoms) (3001) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="3001", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3001"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("VP|ZP"), c2.c);
    }

    @Rule(name="HzV BKK LUTS (Lower Urinary Tract Symptoms) (3001) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="3001", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3001"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BKK Nachsorgekontrolle bei positiven Befund (3001N) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="3001N", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("3001N"), c2.c) > 1;
    }

    @Rule(name="HzV BKK Nachsorgekontrolle bei positiven Befund (3001N) h\u00f6chstens zwei Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="3001N", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3001N"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("3001N"), Arrays.asList(c2.f, c2.e, c2.d)) > 2;
    }

    @Rule(name="HzV BKK Nachsorgekontrolle bei positiven Befund (3001N) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="3001N", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3001N"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV BKK Nachsorgekontrolle bei positiven Befund (3001N) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="3001N", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3001N"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BKK pAVK (Diagnostik und Therapie der peripheren arteriellen Verschlusskrankheit) (3003) ist nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="3003", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean Y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3003"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("3003"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV BKK pAVK (Diagnostik und Therapie der peripheren arteriellen Verschlusskrankheit) (3003) und Nachsorgekontrolle bei positiven Befund (3003N) im Behandlungsfall nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="3003", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3003"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3003N"), c2.c);
    }

    @Rule(name="HzV BKK pAVK (Diagnostik und Therapie der peripheren arteriellen Verschlusskrankheit) (3003) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="3003", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3003"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV BKK pAVK (Diagnostik und Therapie der peripheren arteriellen Verschlusskrankheit) (3003) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="3003", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3003"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BKK Einsatz von arriba (3101) h\u00f6chstens 2 Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="3101", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean ac(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3101"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("3101"), Quartal.getBisJahresanfang(c2.c)) > 2;
    }

    @Rule(name="HzV BKK Einsatz von arriba (3101) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="3101", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_BKK.gnr("31011"), c2.c) > 1;
    }

    @Rule(name="HzV BKK Einsatz von arriba (3101) und Nachsorgekontrolle bei positiven Befund (3101N) im Behandlungsfall nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="3101", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3101"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3101N"), c2.c);
    }

    @Rule(name="HzV BKK Einsatz von arriba (3101) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="3101", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3101"), c2.c) && patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV BKK Einsatz von arriba (3101) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal ", action=ActionType.ENTFERNEN, gnr="3101", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3101"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BKK Nachsorgekontrolle bei positiven Befund (3101N) angesetzt ohne gesicherte, endstellig codierte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="3101N", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ah(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3101N"), c2.c) && !patient.hasDiagnoseBeginntMit("F32.0|F32.1|F32.s|F32.3|F33.0|F33.1|F33.2|F33.3|F33.4", "G", c2.c);
    }

    @Rule(name="HzV BKK Nachsorgekontrolle bei positiven Befund (3101N) ohne Einsatz von arriba (3101) im Vorquartal", action=ActionType.ENTFERNEN, gnr="3101N", hzv=Hzv.BAYERN_BKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ai(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3101N"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_BKK.gnr("3101"), c2.d);
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BAYERN_BKK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BAYERN_BKK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

