/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.DateConverter;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinDiagnose;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class Schein {
    public static final Comparator<Schein> DEFAULT_ORDER = Comparator.comparing(Schein::getQuartal).thenComparing(Schein::getPatientVersichertenId, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Schein::getPatientNummer, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Schein::getAusstellungsdatum, Comparator.nullsLast(Comparator.naturalOrder()));
    private Quartal quartal;
    private ContainerType art;
    private String abrechnungBsnr;
    private String abrechnungsVknr;
    private String kostentraegerKennung;
    private String kostentraegerName;
    private String kostentraegerAbrechnungsbereich;
    private String besonderePersonengruppe;
    private String sktZusatzangaben;
    private String untergruppe;
    private String tsvg;
    private Date ausstellungsdatum;
    private String patientNummer;
    private String patientVersichertenId;
    private String patientVersichertenArt;
    private String patientName;
    private String patientVorname;
    private Date patientGeburtsdatum;
    private String patientPlz;
    private String patientOrt;
    private String patientStrasse;
    private String patientGeschlecht;
    private String ueberweiserBsnr;
    private String ueberweiserLanr;
    private String ueberweisungAn;
    private Hzv hzvVertrag;
    private Boolean isIgel;
    private List<ScheinLeistung> leistungen = new ArrayList<ScheinLeistung>();
    private List<ScheinDiagnose> diagnosen = new ArrayList<ScheinDiagnose>();
    private List<ScheinDiagnose> dauerdiagnosen = new ArrayList<ScheinDiagnose>();

    public Quartal getQuartal() {
        return this.quartal;
    }

    public void setQuartal(Quartal quartal) {
        this.quartal = quartal;
    }

    public ContainerType getArt() {
        return this.art;
    }

    public void setArt(ContainerType art) {
        this.art = art;
    }

    public String getAbrechnungBsnr() {
        return this.abrechnungBsnr;
    }

    public void setAbrechnungBsnr(String abrechnungBsnr) {
        this.abrechnungBsnr = abrechnungBsnr;
    }

    public String getAbrechnungsVknr() {
        return this.abrechnungsVknr;
    }

    public void setAbrechnungsVknr(String abrechnungsVknr) {
        this.abrechnungsVknr = abrechnungsVknr;
    }

    public String getKostentraegerKennung() {
        return this.kostentraegerKennung;
    }

    public void setKostentraegerKennung(String kostentraegerKennung) {
        this.kostentraegerKennung = kostentraegerKennung;
    }

    public String getKostentraegerName() {
        return this.kostentraegerName;
    }

    public void setKostentraegerName(String kostentraegerName) {
        this.kostentraegerName = kostentraegerName;
    }

    public String getKostentraegerAbrechnungsbereich() {
        return this.kostentraegerAbrechnungsbereich;
    }

    public void setKostentraegerAbrechnungsbereich(String kostentraegerAbrechnungsbereich) {
        this.kostentraegerAbrechnungsbereich = kostentraegerAbrechnungsbereich;
    }

    public String getBesonderePersonengruppe() {
        return this.besonderePersonengruppe;
    }

    public void setBesonderePersonengruppe(String besonderePersonengruppe) {
        this.besonderePersonengruppe = besonderePersonengruppe;
    }

    public String getSktZusatzangaben() {
        return this.sktZusatzangaben;
    }

    public void setSktZusatzangaben(String sktZusatzangaben) {
        this.sktZusatzangaben = sktZusatzangaben;
    }

    public String getUntergruppe() {
        return this.untergruppe;
    }

    public void setUntergruppe(String untergruppe) {
        this.untergruppe = untergruppe;
    }

    public String getTsvg() {
        return this.tsvg;
    }

    public void setTsvg(String tsvg) {
        this.tsvg = tsvg;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="Europe/Berlin")
    public Date getAusstellungsdatum() {
        return this.ausstellungsdatum;
    }

    public void setAusstellungsdatum(Date ausstellungsdatum) {
        this.ausstellungsdatum = DateConverter.truncateDate(ausstellungsdatum);
    }

    public String getPatientNummer() {
        return this.patientNummer;
    }

    public void setPatientNummer(String patientNummer) {
        this.patientNummer = patientNummer;
    }

    public String getPatientVersichertenId() {
        return this.patientVersichertenId;
    }

    public void setPatientVersichertenId(String patientVersichertenId) {
        this.patientVersichertenId = patientVersichertenId;
    }

    public String getPatientVersichertenArt() {
        return this.patientVersichertenArt;
    }

    public void setPatientVersichertenArt(String patientVersichertenArt) {
        this.patientVersichertenArt = patientVersichertenArt;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public void setPatientName(String patientName) {
        this.patientName = patientName;
    }

    public String getPatientVorname() {
        return this.patientVorname;
    }

    public void setPatientVorname(String patientVorname) {
        this.patientVorname = patientVorname;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="Europe/Berlin")
    public Date getPatientGeburtsdatum() {
        return this.patientGeburtsdatum;
    }

    public void setPatientGeburtsdatum(Date patientGeburtsdatum) {
        this.patientGeburtsdatum = DateConverter.truncateDate(patientGeburtsdatum);
    }

    public String getPatientPlz() {
        return this.patientPlz;
    }

    public void setPatientPlz(String patientPlz) {
        this.patientPlz = patientPlz;
    }

    public String getPatientOrt() {
        return this.patientOrt;
    }

    public void setPatientOrt(String patientOrt) {
        this.patientOrt = patientOrt;
    }

    public String getPatientStrasse() {
        return this.patientStrasse;
    }

    public void setPatientStrasse(String patientStrasse) {
        this.patientStrasse = patientStrasse;
    }

    public String getPatientGeschlecht() {
        return this.patientGeschlecht;
    }

    public void setPatientGeschlecht(String patientGeschlecht) {
        this.patientGeschlecht = patientGeschlecht;
    }

    public String getUeberweiserBsnr() {
        return this.ueberweiserBsnr;
    }

    public void setUeberweiserBsnr(String ueberweiserBsnr) {
        this.ueberweiserBsnr = ueberweiserBsnr;
    }

    public String getUeberweiserLanr() {
        return this.ueberweiserLanr;
    }

    public void setUeberweiserLanr(String ueberweiserLanr) {
        this.ueberweiserLanr = ueberweiserLanr;
    }

    public String getUeberweisungAn() {
        return this.ueberweisungAn;
    }

    public void setUeberweisungAn(String ueberweisungAn) {
        this.ueberweisungAn = ueberweisungAn;
    }

    public Boolean getIsIgel() {
        return this.isIgel;
    }

    public void setIsIgel(Boolean isIgel) {
        this.isIgel = isIgel;
    }

    public Hzv getHzvVertrag() {
        return this.hzvVertrag;
    }

    public void setHzvVertrag(Hzv hzvVertrag) {
        this.hzvVertrag = hzvVertrag;
    }

    public List<ScheinLeistung> getLeistungen() {
        return this.leistungen;
    }

    public List<ScheinDiagnose> getDiagnosen() {
        return this.diagnosen;
    }

    public List<ScheinDiagnose> getDauerdiagnosen() {
        return this.dauerdiagnosen;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.quartal).append(" ").append(this.patientName).append(", ").append(this.patientVorname).append(" - ").append(simpleDateFormat.format(this.patientGeburtsdatum)).append("\r\n");
        stringBuilder.append(this.leistungen.stream().map(ScheinLeistung::toString).collect(Collectors.joining("\r\n"))).append("\r\n");
        stringBuilder.append(this.diagnosen.stream().map(ScheinDiagnose::toString).collect(Collectors.joining(", ", "\t", ""))).append("\r\n");
        stringBuilder.append(this.dauerdiagnosen.stream().map(ScheinDiagnose::toString).collect(Collectors.joining(", ", "\t", "")));
        return stringBuilder.toString();
    }

    public boolean hasLeistung(String gnr) {
        gnr = gnr.replace("/", "|");
        gnr = "|" + gnr + "|";
        for (ScheinLeistung scheinLeistung : this.leistungen) {
            if (!gnr.contains("|" + scheinLeistung.getGnr() + "|")) continue;
            return true;
        }
        return false;
    }
}

