/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.k;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.VORSORGE)
public class b {
    private static final String a = "103511004|103511048|103511093|103511128|103511139|103511151|103511184|103511195|103511220|103511253|103511264|103511286|103511413|103711017|103711028|103711039|103711051|103711073|103711108|103711119|103711142|103711164|103711175|103711200|103711211|103711233|103711244|103711277|104212505|101519213|104112014|104112047|104112105|104112263|104212059|104212173|104212208|104212516|104212538|104212549|104212561|104212594|104212607|104412062|104412131|104412233|104512074|104512198|104512212|104612020|104612031|104612086|104612097|104612144|104612166|104612246|104812124|104812157|104812180|104812282|104912227|104912250|104912272|134280052";
    private static final String b = "101576623|101576623|100177504|100577508|100977502|101300130|101302655|101377508|101575519|101576020|101576086|101576111|101576188|101576645|101576656|101576667|101577500|101578603|101588821|101588843|101589310|101777502|103077509|103477503|104077501|105077504|105177505|106277508|106377509|106477500|106577501|106777503|107277500|107377501|107877506|108077500|108377013|108377503|109377505|109577006|109577507|109777509";
    private static final String c = "103505006|109906402|109906435|109919500|109990553|109919511|109905003|100105006|100705002|101005007|101305000|101505002|102105000|103105002|104405007|105505001|106005008|106205000|106305001|106405002|106505003|106905007|107405004|107705007|107805008|108005002|108405006|109305007|109505009|109705001|109990508|109906914";
    private static final String d = "103725342|103720893|661430091|103525909|105530422|104626903|104424830|103525567|103526659|103527466|103724294|100821957|103727093|103729701|103724249|105732324|104125509|102122557|101922110|102122410|102122955|103121046|102131320|100223522|102121486|102423697|107036370|105530331|103736722|103725547|103725525|103726069|103729778|103792572|105830517|101530753|105230101|108891551|105821242|101530764|103723317|103725364|103726548|103792663|106431652|106231821|106331764|106423925|106431550|106431663|106431674|106431696|106432038|106531631|106935274|106437453|106423630|105723301|105723312|105792190|105792203|107532042|107536035|107536182|102031410|102022204|102022248|102022501|102022863|102222013|102222024|102222035|107835242|109723913|101120702|101121930|101131921|101132294|101320043|101320236|101392368|102122294|103521790|103524350|103526012|103527295|103527308|103527514|103726398|104124962|104127157|104127215|104127567|104221492|104224678|104226464|104424761|104424772|104424794|104424863|104428480|104523340|104527220|104626889|104825254|104825846|104825879|104826108|104826131|104826197|104830638|104892110|104892358|104892369|104927008|104927714|105230383|105230418|105321236|105330179|105330191|105530262|105830232|107923192|107930658|107934550|108020999|108028394|108035348|108036134|108036463|108036474|108036485|108036496|108036500|108036511|108036522|108036533|108036544|108038181|108223541|108223596|108433215|108891584|109528698|109528723|109530976|109531114|109737010|103526615|103532065|104529255|100220415|100221472|100229891|100320611|100323099|100334526|100721525|101323160|101520966|103524394|103528274|103529457|103724352|103724374|103729621|103791504|104228796|104230745|104234921|104831946|105332160|105923973|106229451|107221809|107821703|108729450|108036577|108023140|107829563|104627595|106329566|106329793|106331548|106331606|106331617|106331640|106331775|106331811|106331877|107835311|107835992|107836367|109033360|109331908|108030775|103121091|103128851|103128862|103128873|103128884|103128895|103128908|103128919|103128920|103128931|103128942|103128953|107836210|108030786|108030797|108030800|108030811|108030822|108031914|108032458|108032469|108032470|108037099|108037102|108037113|108037124|108037135|108037146|108037157|108039650|108039661|108091030|108091041|109531136|108038078|103123674|103128964|108038089|108038090|108038103|106329236|106329225|101320032|101392164|101392222|101392255|101520283|101320942|101392266|101392460|108833505|107535751|108623102|108823455|108832946|108891595|106936311|106928388|108036441|108021400";
    private static final String e = "104491707|101120735|101123260|101320225|101332332|101391700|101391711|101392518|101520089|101520090|101520169|101520181|101520329|101521547|101522105|101522116|101532152|101592587|102022271|103524043|103524076|103524087|103524920|103524931|103524942|103525135|103525464|103526001|103526864|103526897|103527444|103527536|103601309|103725193|103725228|103726478|104127088|104225292|104229296|104424829|104424874|104437993|104491718|104521598|104525002|104525013|104525024|104525035|104525046|104526252|104528130|104528744|104621258|104621726|104628119|104628142|104826200|104926483|104926531|106331742|107435293|107720596|107720643|108031300";
    private static final String f = "104926702|104927473";
    private static final String g = "108008880|106908874|108608820|108508863|108609148|108808844|108809059|105508890|105509083|102108731|101908748|102408723|105508787|105208795|106408802|109308818|110687794|110687896|100609049|108209075|109709049|101308719|109008837|109108850|103708773|103708751|104208769";
    private static final String h = "104212505";
    private static final String i = "104940005|100180008|100189303|100189450|100189483|100189688|100220404|100580002|100589307|100589454|100589487|100589682|100821753|100980006|100989301|100989458|100989481|100989686|101380002|101389307|101389454|101389487|101389682|101579001|101579216|101580004|101589309|101589412|101589456|101589478|101589489|101589684|101780006|101789301|101789458|101789481|101789686|101829081|101829092|101921299|101922837|101930724|101939006|102022237|102023626|102030340|102121738|102121830|102122136|102122307|102122318|102122329|102122363|102122385|102122432|102122465|102129849|102129850|102178509|102222525|102422162|103080003|103089308|103089455|103089488|103089683|103480007|103489302|103489459|103489482|103489687|103524054|103525475|103526283|104080005|104089300|104089457|104089480|104089685|104224601|104224612|104224725|104226987|104228477|104232360|104232371|104239915|104239926|104625708|104625764|104625946|104926508|104926520|104927053|104927064|104927554|104940539|104940620|104941197|104941847|104942791|104946216|104978011|105080008|105089303|105089450|105089483|105089688|105180009|105189304|105189451|105189484|105189689|105530342|106280002|106289307|106289454|106289487|106289682|106380003|106389308|106389455|106389488|106389683|106480004|106489309|106489456|106489489|106489684|106531799|106580005|106589300|106589457|106589480|106589685|106780007|106789302|106789459|106789482|106789687|107280004|107289309|107289456|107289489|107289684|107380005|107389300|107389457|107389480|107389685|107536295|107720471|107723178|107880000|107889305|107889452|107889485|107889680|108035770|108079454|108079808|108080004|108089309|108089456|108089489|108089684|108221468|108353709|108380007|108389302|108389459|108389482|108389687|108423714|108429311|108431963|108431996|108432009|108433077|108433102|108433180|108433191|108433237|108632773|108633525|108633536|108729553|108732809|108733310|108733467|108737597|108821362|108833516|108891573|108933573|108933653|109129662|109132576|109132612|109139915|109139926|109380009|109389304|109389451|109389484|109389689|109521270|109530670|109538031|109580001|109580012|109589306|109589453|109589486|109589681|109723490|109723888|109780003|109789308|109789455|109789488|109789683|109920810|109920821|109920832|109920843|109920854|109920865|109921296|109931937|109932095|109932108|109932119|109932120|109932131|109932186|109932222|109932346|109934985|109934996|109939003|109939014|109939025|109939036|109939047|109939058|109939069|109939070|109939081|109939092|109939105|109939116|109939127|109939138|109939149|109939150|109939161|109939172|109939183|109939194|109939207|109939218|109939229|109991291|109991304|104940005";
    private static final String j = "103501080|103501091|104227169|104229582|104229606|108421335|108434261|109531476";
    private static final String k = "102122660|101520158|102022146|102122740|102122897|102192459|102722597|102732316|105430502|106020508|106023943|106229304|106231295|106428247|106428292|108029306|108029373|108029384|108029395|108029408|108029419|108029420|108029431|108031297|108035827|108092623|108092634|108092645|108633375|108729461|108729472|108729483|108729494|108891960|109033587|109033689";
    private static final String l = "104125509";
    private static final String m = "103526615|103524112|104927042|103532065";
    private static final String n = "105830016|100167999|100169991|100567993|100569995|100723572|100967997|100969999|101120677|101367993|101369995|101520103|101520147|101520352|101520454|101532301|101536919|101536920|101554718|101554730|101554752|101554763|101554785|101554821|101554832|101554843|101554876|101554898|101554923|101554967|101554978|101557608|101557653|101560000|101560523|101560556|101560590|101560614|101560625|101560636|101560658|101560670|101560681|101560705|101560716|101560749|101560761|101560783|101560807|101560818|101560841|101560874|101560896|101560910|101560932|101560976|101560987|101561056|101561125|101561136|101561216|101561238|101561249|101561261|101562570|101564399|101564413|101564446|101564457|101564468|101564479|101564491|101564505|101564527|101564550|101564572|101564583|101564594|101564607|101564641|101564674|101564721|101564754|101564834|101564845|101566778|101566825|101566858|101566870|101566881|101566994|101567995|101568008|101568075|101569997|101583622|101583633|101583644|101583699|101583713|101583724|101583735|101583746|101583779|101583791|101583826|101584166|101584202|101584213|101585065|101585087|101585101|101592235|101592280|101592612|101767997|101769999|101922859|103067994|103069996|103467998|103469990|103724330|103728301|104067996|104069998|104123437|104124029|104131368|104136911|104221619|104224623|104525068|104525080|104527231|104624400|104629508|104629699|105067999|105069991|105167990|105169992|105230087|105230098|105320805|105323535|105328426|105328437|105328448|105328459|105330204|105330215|105330226|105330453|105334583|105429872|105430056|105430114|105430249|105430250|105430307|105430396|105430409|105430498|105530320|105723356|105730037|105830528|105830540|105830608|105836717|105921210|106020655|106023705|106029734|106267993|106269995|106367994|106369996|106467995|106469997|106567996|106569998|106767998|106769990|106835364|106835375|106836387|106929904|106932204|106935285|107135212|107135780|107267995|107269997|107367996|107369998|107429741|107435306|107435408|107435419|107435420|107435590|107435603|107435910|107436158|107531940|107535396|107535409|107535864|107536013|107536024|107536331|107621415|107629981|107629992|107635046|107635353|107635810|107635832|107822975|107823603|107828185|107829712|107829723|107829734|107835060|107835139|107835173|107836232|107867991|107869993|107929713|107929724|108028407|108035462|108035952|108036407|108067995|108069997|108220764|108367998|108369990|108532863|108733309|108892095|109132565|109132725|109367990|109369992|109567992|109569994|109721341|109767994|109769996";
    private static final String o = "103500693|101003005|101534564|101900443|102100389|102100540|102700557|103500740|103500784|103500819|103500820|103500842|103500864|103500886|103500900|103500944|103500999|103501013|103501024|103501046|103501068|103529026|103700719|103700720|103700731|103700753|103700764|103700775|103700797|103700800|103700833|103700855|103700877|103700899|103700924|103700935|103700957|103700968|103700979|103700980|103701004|103701059|103701071|104001441|104101113|104101146|104201158|104201249|104401161|104401207|104401252|104401412|104501173|104501264|104501286|104501435|104601129|104601130|104601185|104601210|104601301|104601403|104801198|104801223|104801234|104801427|104901291|104901315|104901326|108303526|108402081|108403516|108502048|108502071|108502106|108602038|108602061|108702051|108702120|108702142|108702175|108703508|108802165|108902019|108902111|108902133|108902155|108902199|109102024|109102091|109102182|108001963|105801603|106801672|106801730|106901797|107001756|107001825|107101699|107101859|107401705|107401727|107401807|107501784|107501864|107501900|107501955|107601843|107801878|107801890|107801947|108001667|108001689|108001714|108001747|108001769|108001770|108001816|108001838|108001883|108001918|108001929|108001930|107202793|101002970|101534575|103500706|103529071|105201516|105201527|105301540|105301551|105301562|105301584|105401530|105501575|105801590|106003120|106103132|107202704|107702776|107702787|107902723|107902734|107902745|107902756|107902767|108001974|108202717|105903116|101500154";
    private static final String p = "102171012|100175502|100575506|100975500|101375506|101520363|101520900|101575508|101775500|102172422|102173127|102173786|102187771|103075507|103475501|104075509|104621748|104625695|105075502|105175503|106275506|106375507|106475508|106575509|106775501|107275508|107375509|107875504|108075508|108375501|108429333|108429344|108429355|108429366|108432429|108433135|108433146|108433157|108433168|108433179|108433692|108891664|109023665|109375503|109530885|109530998|109575505|109720750|109775507";
    private static final String q = "108035612|101320247|106020600|107820029|107835093|107835743|108035031|108035188|108092177|108532738|108533385|108538164|108733285|108833561|108891631|109132689|108034508|108092202";
    private static final String r = "101520078";
    private static final String s = "106492393|100720660|101822610|102022260|102121863|102122352|102122374|102129008|102192426|102222251|102422685|102522221|102522584|102522653|102522880|102722600|103121079|103521789|103525419|103526591|103730668|104123687|104621588|104621771|104621942|104624035|104624411|104624912|104625673|104625742|104625753|104625800|104625822|104625833|104625924|104625935|104626776|104626787|104627129|104627334|104627356|104627458|104628460|104628609|104826222|104921650|104926494|105328415|105330157|105832052|106229532|106231854|106321396|106421228|106431685|106431845|106492406|107931170|109132554";
    private static final String t = "108433896|108433248|101320349|101892147|102734283|103527284|103726401|104427582|104626925|104825857|104825880|104826836|104926713|105334220|105334231|107031126|107035563|107035621|107035632|107035643|107035676|107035698|107035712|107535988|107536284|107835878|107836209|108021308|108033244|108034176|108034212|108035019|108035020|108035382|108035439|108035440|108035451|108035484|108035495|108423428|108428720|108433259|108433705|108433716|108433727|108433738|108433749|108433750|108433761|108433772|108433783|108433794|108433807|108433818|108433829|108433830|108433841|108433852|108433863|108433874|108433885|108433909|108433910|108433921|108433932|108433943|108433954|108433976|108433987|108433998|108434001|108434012|108434023|108434034|108434045|108434056|108434067|108434078|108434103|108434125|108434136|108434158|108532874|108533476|108634194|108733296|108734184|108734208|108934255|109131438|109132623|109134248|108223858|104821604|107023228|107821326|108023139|108223723|108223734|108223745|108223756|108223767|108223778|108223789|108223790|108223803|108223814|108223825|108223836|108228318|109132280";
    private static final String u = "104526376|100220415|100221472|100229891|100320611|100323099|100334526|100721525|101320338|101323160|101520012|101520966|103524065|103524123|103524214|103524361|103524372|103524383|103524394|103524407|103524441|103524452|103524474|103524496|103524522|103524533|103524544|103525124|103525408|103525420|103525442|103525453|103525603|103525954|103525976|103525998|103526660|103526693|103526795|103526808|103526853|103526875|103526944|103526955|103526966|103527262|103527320|103527649|103528274|103529457|103721440|103723339|103724227|103724250|103724283|103724329|103724341|103724352|103724363|103724374|103725159|103725160|103725217|103725262|103725284|103725319|103725558|103725592|103725989|103726263|103726274|103726310|103726559|103727106|103727491|103727629|103728174|103729518|103729621|103791490|103791504|104224667|104224703|104226340|104227181|104227728|104227739|104227751|104227773|104227784|104227795|104228796|104229321|104229673|104230734|104230745|104234863|104234921|104234943|104424841|104424885|104424896|104427149|104526365|104529255|104529288|104826175|104826233|104826585|104827405|104829759|104831946|104926757|104926995|104927019|104927031|104927484|105228209|105230463|105230577|105230599|105330282|105332160|105923973|106224387|106229451|107221809|107821703|107835322|107923181|108533604|108723249|108729450|108733321|108891562";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Nordrhein");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="LKK U10 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN, gnr="91710|91711")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="AOK U10 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN, gnr="91810")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasLeistung("91810", c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="LKK U11 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN, gnr="91712|91713")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="AOK U11 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN, gnr="91811")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung("91811", c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="AOK J2 ohne gesicherte Z00.3", action=ActionType.UEBERPRUEFEN, gnr="91812")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.hasLeistung("91812", c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="BKK - Die Bergische / BKK Novitas J2 ohne gesicherte Z00.3", action=ActionType.UEBERPRUEFEN, gnr="91715")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistung("91715", c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="BKK Verband / BKK Novitas U10 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN, gnr="91705")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung("91705", c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="BKK Verband / BKK Novitas U11 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN, gnr="91706")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistung("91706", c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="Techniker KK oder Knappschaft U10 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN, gnr="81102")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung("81102", c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="Techniker KK oder Knappschaft U11 ohne gesicherte Z00.1", action=ActionType.UEBERPRUEFEN, gnr="81120")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistung("81120", c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="Techniker KK oder Knappschaft J2 ohne gesicherte Z00.3", action=ActionType.UEBERPRUEFEN, gnr="81121")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung("81121", c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="AOK Rheinland/Hamburg U10 Grundschulcheck (91810) bei 7 bis 8 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91810", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(a) && 6 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 9 && !patient.hasLeistung("91710", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="AOK Rheinland/Hamburg U11 (91811) bei 9 bis 10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91811", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean l(c c2, Patient patient) {
        if (patient.hasLeistung("91811", c2.c)) {
            return false;
        }
        if (patient.hasLeistung("91811", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(a) && 8 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 11;
    }

    @Rule(name="LKK U10 Grundschulcheck (91710) bei 7 bis 8 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91710", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(g) && 6 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 9 && !patient.hasLeistung("91710", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="LKK U10 Dokumentation/Auswertung des Fragebogens (91711) bei 7 bis 8 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91711", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(g) && 6 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 9 && !patient.hasLeistung("91711", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="LKK U11 (91712) bei 9 bis 10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91712", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(g) && 8 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 11 && !patient.hasLeistung("91712", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="LKK U11 Dokumentation/Auswertung des Fragebogens (91713) bei 9 bis 10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91713", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(g) && 8 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 11 && !patient.hasLeistung("91713", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="BKK - Die Bergische J2 (91715) bei 16 bis 17 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91715", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(f) && 15 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 18 && !patient.hasLeistung("91715", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="BKK Novitas U10 (91705) bei 7 bis 8 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91705", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(e) && 6 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 9 && !patient.hasLeistung("91705", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="BKK Novitas U11 (91706) bei 9 bis 10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91706", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(e) && 8 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 11 && !patient.hasLeistung("91706", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="BKK Novitas J2 (91715) bei 16 bis 17 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91715", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(e) && 15 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 18 && !patient.hasLeistung("91715", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="Techniker KK U10 (81102) bei 7 bis 8 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="81102", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(b) && 6 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 9 && !patient.hasLeistung("81102", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="Techniker KK U11 (81120) bei 9 bis 10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="81120", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(b) && 8 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 11 && !patient.hasLeistung("81120", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="Techniker KK J2 (81121) bei 16 bis 17 j\u00e4hrigen m\u00f6glich ", action=ActionType.POTENTIAL, gnr="81121", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(b) && 15 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 18 && !patient.hasLeistung("81121", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="Knappschaft U10 (81102) bei 7 bis 8 j\u00e4hrigen m\u00f6glich   ", action=ActionType.POTENTIAL, gnr="81102", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(c) && 6 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 9 && !patient.hasLeistung("81102", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="Knappschaft U11 (81120) bei 9 bis 10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="81120", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(c) && 8 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 11 && !patient.hasLeistung("81120", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="Knappschaft J2 (81121) bei 16 bis 17 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="81121", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(c) && 15 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 18 && !patient.hasLeistung("81121", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="BKK Verband  U10 (91705) bei 7 bis 8 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91705", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(d) && 6 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 9 && !patient.hasLeistung("91705", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="BKK Verband U11 (91706) bei 9 bis 10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="91706", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && patient.hasIk(d) && 8 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 11 && !patient.hasLeistung("91706", Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="LKK U10 bzw. Fragebogen (91710, 91711) \u00f6fter als 1 Mal im Leben abgerechnet", action=ActionType.ENTFERNEN, gnr="91710|91711")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getLeistungCount(string, Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="LKK U11 bzw. Fragebogen (91712, 91713) \u00f6fter als 1 Mal im Leben abgerechnet", action=ActionType.ENTFERNEN, gnr="91712|91713")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getLeistungCount(string, Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="BKK - Die Bergische oder BKK Novitas J2 (91715) \u00f6fter als 1 Mal im Leben abgerechnet", action=ActionType.ENTFERNEN, gnr="91715")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung("9715", c2.c) && patient.getLeistungCount("91715", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="BKK Verband oder BKK Novitas U10 (91705) \u00f6fter als 1 Mal im Leben abgerechnet", action=ActionType.ENTFERNEN, gnr="91705")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung("91705", c2.c) && patient.getLeistungCount("91705", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="BKK Verband oder BKK Novitas U11 (91706) \u00f6fter als 1 Mal im Leben abgerechnet", action=ActionType.ENTFERNEN, gnr="91706")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung("91706", c2.c) && patient.getLeistungCount("91706", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="Techniker KK oder Knappschaft U10 (81102) \u00f6fter als 1 Mal im Leben abgerechnet", action=ActionType.ENTFERNEN, gnr="81102")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung("81102", c2.c) && patient.getLeistungCount("81102", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="Techniker KK oder Knappschaft U11 (81120) \u00f6fter als 1 Mal im Leben abgerechnet", action=ActionType.ENTFERNEN, gnr="81120")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung("81120", c2.c) && patient.getLeistungCount("81120", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="Techniker KK oder Knappschaft J2 (81121) \u00f6fter als 1 Mal im Leben abgerechnet", action=ActionType.ENTFERNEN, gnr="81121")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung("81121", c2.c) && patient.getLeistungCount("81121", Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="U-Vorsorgediagnose Z00.1 vorhanden und eventuell Abrechnungsziffer U10 (91810 / 81102) noch nicht angesetzt", gnr="81102/91705/91710/91712", action=ActionType.UEBERPRUEFEN, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && !patient.hasLeistung("91810|81102", c2.c) && patient.hasDiagnose("Z00.1", true, c2.c) && 6 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 9;
    }

    @Rule(name="U-Vorsorgediagnose Z00.1 vorhanden und eventuell Abrechnungsziffer U-Untersuchung U11 (91811 / 81120) noch nicht angesetzt", gnr="81120/91706/91711/91713", action=ActionType.UEBERPRUEFEN, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && !patient.hasLeistung("91811|81120", c2.c) && patient.hasDiagnose("Z00.1", true, c2.c) && 8 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 11;
    }

    @Rule(name="J-Vorsorgediagnose Z00.3 gesichert vorhanden und eventuell Abrechnungsziffer J-Untersuchung noch nicht angesetzt", action=ActionType.UEBERPRUEFEN, gnr="81121/91715/91812", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistungBeginntMit("0300|0400", c2.c) && !patient.hasLeistung("81121|91715|91812", c2.c) && patient.hasDiagnose("Z00.3", true, c2.c) && 15 < patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) && patient.getAlterAnTag(patient.getLeistungBeginntMit("0300|0400", 1L, c2.c).getDatum()) < 18;
    }

    @Rule(name="Grippeimpfung 89111 \u00fcberpr\u00fcfen Patient muss \u00fcber 60 Jahre alt sein", action=ActionType.UEBERPRUEFEN, gnr="89111")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistung("89111", c2.c) && patient.getAlterAnTag(patient.getLeistung("89111", 1L, c2.c).getDatum()) < 60;
    }

    @Rule(name="Grippeimpfung 89112 \u00fcberpr\u00fcfen Patient ben\u00f6tigt chronische Diagnose", action=ActionType.UEBERPRUEFEN, gnr="89112")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient) {
        return patient.hasLeistung("89112", c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="Grippeimpfung 89112 muss unter 60 Jahre alt sein", action=ActionType.UEBERPRUEFEN, gnr="89112")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung("89112", c2.c) && patient.getAlterAnTag(patient.getLeistung("89112", 1L, c2.c).getDatum()) > 59;
    }

    @Rule(name="Grippeimpfung bei \u00fcber 60 j\u00e4hrigen m\u00f6glich.", action=ActionType.POTENTIAL, gnr="89111")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean O(c c2, Patient patient) {
        return !patient.hasLeistung("89111|89112", Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlter(c2.c) > 59;
    }

    @Rule(name="Grippeimpfung bei unter 60 j\u00e4hrigen Chronikern m\u00f6glich", action=ActionType.POTENTIAL, gnr="89112", apk=ApkModus.HAUSARZT_KINDERARZT)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean P(c c2, Patient patient) {
        if (!c2.a(new g("01", "02", "03", "34", "40"))) {
            return false;
        }
        if (!patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), "G", c2.c)) {
            return false;
        }
        return !patient.hasLeistung("89111|89112", Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlter(c2.c) < 60;
    }

    @Rule(name="Grippeimpfung 89112 bei \u00fcber 60j\u00e4hrigen in 89111 umsetzen", action=ActionType.UEBERPRUEFEN, gnr="89111")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung("89112", c2.c) && patient.getAlter(c2.c) > 59;
    }

    @Rule(name="Grippeimpfung als Satzungsimpfung (89112T) bei unter 60-J\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="89112T", apk=ApkModus.HAUSARZT_KINDERARZT)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient) {
        if (!c2.a(new g("01", "02", "03", "34", "40"))) {
            return false;
        }
        int n2 = LocalDate.now().getMonthValue();
        if (n2 > 3 && n2 < 10) {
            return false;
        }
        if (patient.hasLeistung("89112T", Arrays.asList(c2.c, c2.d, c2.e))) {
            return false;
        }
        return patient.getAlter(c2.c) < 60 && patient.hasIk(String.join((CharSequence)"|", Arrays.asList(h, i, f, j, k, l, m, n, o, p, q, r, s, t, b, u)));
    }

    @Rule(name="Grippeimpfung als Satzungsimpfung (89112T) nur bei unter 60-J\u00e4hrigen abrechenbar", action=ActionType.ENTFERNEN, gnr="89112T", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung("89112T", c2.c, date) && patient.getAlterAnTag(date) > 60;
    }

    @Rule(name="Grippeimpfung als Satzungsimpfung (89112T) mit chronischer Diagnose als Indikationsimpfung 89112 abrechnen", action=ActionType.UEBERPRUEFEN, gnr="89112T", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung("89112T", c2.c, date) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), "G", c2.c) && patient.getAlterAnTag(date) < 60;
    }
}

