/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.h.a;

import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.i;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.HZV)
public class g {
    private static final String a = "102122557|101931440|101922757|107832012|108035612|106492393|102137985";
    private static final String b = "F31|F32|F33|F34|F38|F39|F40|F41|F42|F43|F44|F45|F48|F50|F51|F52|F53|F54|F55|F59|F60|F61|F62|F63|F64|F65|F66|F68|F69|F70|F71|F72|F73|F74|F78|F79|F90|F91|F92|F93|F94|F95|F96|F97|F98|F99|Z55|Z56|Z59|Z62|Z63|Z72|Z73|Z74";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Hessen");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BUNDESWEIT_BKKSPECTRUM);
    }

    @Rule(name="HzV spectrumK Behandlungspauschale Chroniker (0003) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV spectrumK Behandlungspauschale Chroniker (0003) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV spectrumK Behandlungspauschale Chroniker (0003) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0003"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c);
    }

    @Rule(name="HzV spectrumK Vertreterpauschale (0004) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV spectrumK Vertreterpauschale (0004) am Behandlungstag nicht mit Zielauftragspauschale (0005) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme I (01100) am Behandlungstag nicht neben Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="01100", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0005"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme I (01100) in Ausnahmef\u00e4llen mehrfach am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100"), c2.c, date) > 1;
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme II (01101) am Behandlungstag nicht neben Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="01101", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme II (01101) in Ausnahmef\u00e4llen mehrfach am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101"), c2.c, date) > 1;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I (02300) nicht neben 02301,02302 abrechenbar", action=ActionType.ENTFERNEN, gnr="02300", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301|02302"), c2.c, date) && !patient.hasDiagnoseBeginntMit("D22|T01", c2.c);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff h\u00f6chstens 1 mal am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02300|02301|02302", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr(string), c2.c, date) > 1 && !patient.hasDiagnoseBeginntMit("D22|T01", c2.c);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II (02301) nicht neben 02302 abrechenbar", action=ActionType.ENTFERNEN, gnr="02301", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302"), c2.c, date) && !patient.hasDiagnoseBeginntMit("D22|T01", c2.c);
    }

    @Rule(name="HzV spectrumK Kleinchirurgische Eingriffe 02300/02301/02302 h\u00f6chstens 5 mal am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02300/02301/02302", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300|02301|02302"), c2.c, date) > 5 && patient.hasDiagnoseBeginntMit("D22|T01", c2.c);
    }

    @Rule(name="HzV spectrumK Haus\u00e4rztlichgeriatrisches Basisassessment (03240) h\u00f6chstens 2 Mal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("03240"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="HzV spectrumK Abdominelle Sonographie (33042) h\u00f6chstens 2 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("33042"), c2.c) > 2;
    }

    @Rule(name="HzV spectrumK Differentialdiagnostische Kl\u00e4rung psychosomatischer Krankheitszust\u00e4nde (35100) und Verbale Intervention (35110) am Behandlungstag nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="35110", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35100"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Verbale Intervention bei psychosomatischen Krankheitszust\u00e4nden (35110) h\u00f6chstens 3 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="35110", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110"), c2.c, date) > 3;
    }

    @Rule(name="HzV spectrumK Videosprechstunde (OVS) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="OVS", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("OVS"), c2.c) > 1;
    }

    @Rule(name="HzV spectrumK Koordinierungs- und Kommunikationspauschale (KKP) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="KKP", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("KKP"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV spectrumK Koordinierungs- und Kommunikationspauschale (KKP) nur einmal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="KKP", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("KKP"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("KKP"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) nur einmal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Patient ist zu jung f\u00fcr Krebsfr\u00fcherkennungsuntersuchung Mann (01731)", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) nicht neben {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="0004|0005", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr(string), c2.c, date);
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) einmal im Kalenderjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean l(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 44 && patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), c2.c) && !"M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV spectrumK Gesundheitsuntersuchung (01732) nur einmal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Gesundheitsuntersuchung (01732) einmal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean m(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 34;
    }

    @Rule(name="HzV spectrumK Patient ist zu jung f\u00fcr Gesundheitsuntersuchung (01732)", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV spectrumK Gesundheitsuntersuchung (01732) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV spectrumK Beratung zur Fr\u00fcherkennung des kolorektalen Karzinoms (01740) nur einmal abrechenbar", action=ActionType.ENTFERNEN, gnr="01740", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01740"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01740"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Beratung zur Fr\u00fcherkennung des kolorektalen Karzinoms (01740) einmal m\u00f6glich", action=ActionType.POTENTIAL, gnr="01740", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean o(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01740"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 49 && patient.getAlterAnTag(date) < 53;
    }

    @Rule(name="HzV spectrumK Patient ist zu jung f\u00fcr Beratung zur Fr\u00fcherkennung des kolorektalen Karzinoms (01740)", action=ActionType.ENTFERNEN, gnr="01740", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01740"), c2.c, date) && patient.getAlterAnTag(date) < 50;
    }

    @Rule(name="HzV spectrumK Hautkrebsscreening (01745) nicht neben {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="0004|0005", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr(string), c2.c, date);
    }

    @Rule(name="HzV spectrumK Hautkrebsscreening (01745) nur einmal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Hautkrebsscreening (01745) einmal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean q(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745|01746"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 34;
    }

    @Rule(name="HzV spectrumK Patient ist zu jung f\u00fcr Hautkrebsscreening (01745)", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV spectrumK Zuschlag HKS zur 01732 (01746) nicht neben {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="0004|0005", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr(string), c2.c, date);
    }

    @Rule(name="HzV spectrumK Zuschlag HKS zur 01732 (01746) nur einmal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Zuschlag HKS zur 01732 (01746) einmal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean s(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746|01745"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01746|01745", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) > 34;
    }

    @Rule(name="HzV spectrumK Patient ist zu jung f\u00fcr Zuschlag HKS zur 01732 (01746)", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV spectrumK Zuschlag HKS zur 01732 (01746) nur neben 01732 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), c2.c, date);
    }

    @Rule(name="HzV spectrumK erweitertes Neugeborenenscreening (01707) einmal bis 5. Lebenswoche m\u00f6glich", action=ActionType.POTENTIAL, gnr="01707", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean v(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) < 36;
    }

    @Rule(name="HzV spectrumK erweitertes Neugeborenenscreening (01707) nur einmal bis 5. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01707", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK erweitertes Neugeborenenscreening (01707) nur bis 5. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01707", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), c2.c, date) && patient.getAlterInTage(date) > 35;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U1 (01711) einmal bis 2. Lebenstag m\u00f6glich", action=ActionType.POTENTIAL, gnr="01711", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean x(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01711"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) < 3;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U1 (01711) nur einmal bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01711"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01711"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U1 (01711) nur bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01711"), c2.c, date) && patient.getAlterInTage(date) > 2;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U2 (01712) am 3. bis 14. Lebenstag m\u00f6glich", action=ActionType.POTENTIAL, gnr="01712", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean z(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 2 && patient.getAlterInTage(date) < 15;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U2 (01712) nur einmal bis 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U2 (01712) nur bis 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), c2.c, date) && patient.getAlterInTage(date) > 14;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U2 (01712) erst ab 3. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), c2.c, date) && patient.getAlterInTage(date) < 3;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U3 (01713) in der 3. bis 8. Lebenswoche m\u00f6glich", action=ActionType.POTENTIAL, gnr="01713", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean C(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 21 && patient.getAlterInTage(date) < 36;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U3 (01713) nur einmal bis 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U3 (01713) nur bis 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), c2.c, date) && patient.getAlterInTage(date) > 49;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U3 (01713) erst ab 3. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), c2.c, date) && patient.getAlterInTage(date) < 15;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U4 (01714) im 2. bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01714", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean F(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 30 && patient.getAlterInTage(date) < 136;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U4 (01714) nur einmal bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U4 (01714) nur bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), c2.c, date) && patient.getAlterInTage(date) > 135;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U4 (01714) erst ab 2. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), c2.c, date) && patient.getAlterInTage(date) < 31;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U5 (01715) im 5. bis 8. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01715", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean I(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 120 && patient.getAlterInTage(date) < 241;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U5 (01715) nur einmal bis 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U5 (01715) nur bis 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), c2.c, date) && patient.getAlterInTage(date) > 240;
    }

    @Rule(name="HzV spectrumKK Kindervorsorgeuntersuchung U5 (01715) erst ab 5. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), c2.c, date) && patient.getAlterInTage(date) < 121;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U6 (01716) im 9. bis 14. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01716", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean L(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 240 && patient.getAlterInTage(date) < 421;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U6 (01716) nur einmal bis 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U6 (01716) nur bis 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), c2.c, date) && patient.getAlterInTage(date) > 420;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U6 (01716) erst ab 9. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), c2.c, date) && patient.getAlterInTage(date) < 241;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7 (01717) im 20. bis 27. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean O(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 570 && patient.getAlterInTage(date) < 811;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7 (01717) nur einmal bis 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7 (01717) nur bis 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), c2.c, date) && patient.getAlterInTage(date) > 810;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7 (01717) erst ab 20. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), c2.c, date) && patient.getAlterInTage(date) < 571;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7a (01723) im 33. bis 38. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean R(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 960 && patient.getAlterInTage(date) < 1141;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7a (01723) nur einmal bis 38. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7a (01723) nur bis 38. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), c2.c, date) && patient.getAlterInTage(date) > 1140;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7a (01723) erst ab 33. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), c2.c, date) && patient.getAlterInTage(date) < 961;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U8 (01718) im 43. bis 50. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean U(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 1260 && patient.getAlterInTage(date) < 1501;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U8 (01718) nur einmal bis 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U8 (01718) nur bis 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), c2.c, date) && patient.getAlterInTage(date) > 1500;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U8 (01718) erst ab 43. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), c2.c, date) && patient.getAlterInTage(date) < 1261;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U9 (01719) im 58. bis 66. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean X(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 1710 && patient.getAlterInTage(date) < 1981;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U9 (01719) nur einmal bis 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U9 (01719) nur bis 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), c2.c, date) && patient.getAlterInTage(date) > 1980;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U9 (01719) erst ab 58. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Z(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), c2.c, date) && patient.getAlterInTage(date) < 1711;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U10 (U10) bei 7-8 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="U10", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean aa(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 6 && patient.getAlterAnTag(date) < 9;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U10 (U10) nur einmal bis 8 Jahre m\u00f6glich", action=ActionType.ENTFERNEN, gnr="U10", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U10 (U10) nur bis 8 Jahre m\u00f6glich", action=ActionType.ENTFERNEN, gnr="U10", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), c2.c, date) && patient.getAlterAnTag(date) > 8;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U10 (U10) erst ab 7 Jahren m\u00f6glich", action=ActionType.ENTFERNEN, gnr="U10", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ac(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), c2.c, date) && patient.getAlterAnTag(date) < 7;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U11 (U11) bei 9-10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean ad(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 8 && patient.getAlterAnTag(date) < 11;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U11 (U11) nur einmal bis 10 Jahre m\u00f6glich", action=ActionType.ENTFERNEN, gnr="U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U11 (U11) nur bis 10 Jahre m\u00f6glich", action=ActionType.ENTFERNEN, gnr="U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), c2.c, date) && patient.getAlterAnTag(date) > 10;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U11 (U11) erst ab 9 Jahren m\u00f6glich", action=ActionType.ENTFERNEN, gnr="U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), c2.c, date) && patient.getAlterAnTag(date) < 9;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J2 (J2) bei 16-17 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ag(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 15 && patient.getAlterAnTag(date) < 18;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J2 (J2) nur einmal bis 17 Jahre m\u00f6glich", action=ActionType.ENTFERNEN, gnr="J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J2 (J2) nur bis 17 Jahre m\u00f6glich", action=ActionType.ENTFERNEN, gnr="J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ah(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), c2.c, date) && patient.getAlterAnTag(date) > 17;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J2 (J2) erst ab 16 Jahren m\u00f6glich", action=ActionType.ENTFERNEN, gnr="J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ai(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), c2.c, date) && patient.getAlterAnTag(date) < 16;
    }

    @Rule(name="HzV spectrumK U-Vorsorgediagnose Z00.1 gesichert vorhanden, eventuell Abrechnungsziffer U-Untersuchung vergessen", action=ActionType.UEBERPRUEFEN, gnr="Z00.1", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707|01711|01712|01713|01714|01715|01716|01717|01718|01719|01723|U10|U11"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV spectrumK J-Vorsorgediagnose Z00.3 gesichert vorhanden, eventuell Abrechnungsziffer J-Untersuchung vergessen", action=ActionType.UEBERPRUEFEN, gnr="Z00.3", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01720|J2"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV spectrumK U-Untersuchung erfordert die Ansetzung der gesicherten Pr\u00e4ventionsdiagnose Z00.1", action=ActionType.UEBERPRUEFEN, gnr="01707|01711|01712|01713|01714|01715|01716|01717|01718|01719|01723|U10|U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr(string), c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV spectrumK J-Untersuchung erfordert die Ansetzung der gesicherten Pr\u00e4ventionsdiagnose Z00.3", action=ActionType.UEBERPRUEFEN, gnr="01720|J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr(string), c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV spectrumK die Kennzeichnungsziffer (88192) ist nur im KV-Schein abzurechnen, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("88192"), c2.c);
    }

    @Rule(name="HzV spectrumK die lebenslangen Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.ENTFERNEN, gnr="88192", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        if (patient.hasLeistung("88192", c2.c)) {
            String string = patient.getAPK(false, c2.c, 1L, i.a("88192")).getLanr();
            String string2 = null;
            if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0001"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0001"))).getLanr();
            }
            return string2 != null && !string2.equals(string);
        }
        return false;
    }

    @Rule(name="HzV spectrumK eine Doppelabrechnung von Betreuungspauschale (0000) im HzV-Schein und der Versichertenpauschale (0300*) im KV-Schein ist ausgeschlossen", action=ActionType.ENTFERNEN, gnr="03001|03002|03003|03004|03005")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV spectrumK f\u00fcr Patienten welche mit der Pseudoziffer 88192 gekennzeichnet wurden HzV-Schein anlegen und Pauschale ansetzen", action=ActionType.ENTFERNEN, gnr="88192", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String J(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000|0001|0002|0004"), c2.c) && patient.hasLeistung("88192", c2.c)) {
            if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0001"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnose("Z51.5", true, c2.c)) {
                return "0001";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV spectrumK psychosomatische Ziffer 35100 ohne leitliniengerechte Diagnose (Diagnose beginnend mit F31 bis F39, F40 bis F48, F50 bis F59, F60 bis F69, F70 bis F79, F90 bis F99, Z55, Z56, Z59, Z62, Z63, Z72 bis Z74)", action=ActionType.UEBERPRUEFEN, gnr="35100", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35100"), c2.c) && !patient.hasDiagnoseBeginntMit(b, "G", c2.c) && !patient.hasDiagnoseBeginntMit(b, "V", c2.c) && !patient.hasDiagnoseBeginntMit(b, "A", c2.c);
    }

    @Rule(name="HzV spectrumK psychosomatische Ziffer 35110 ohne gesicherte leitliniengerechte Diagnose (gesicherte Diagnose beginnend mit F31 bis F39, F40 bis F48, F50 bis F59, F60 bis F69, F70 bis F79, F90 bis F99, Z55, Z56, Z59, Z62, Z63, Z72 bis Z74)", action=ActionType.UEBERPRUEFEN, gnr="35110", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110"), c2.c) && !patient.hasDiagnoseBeginntMit(b, "G", c2.c);
    }

    @Rule(name="HzV spectrumK psychosomatische Ziffer 35100 mit gesicherter nicht leitliniengerechter F-Diagnose", action=ActionType.UEBERPRUEFEN, gnr="35100", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35100"), c2.c) && !patient.hasDiagnoseBeginntMit(b, "G", c2.c) && !patient.hasDiagnoseBeginntMit(b, "V", c2.c) && !patient.hasDiagnoseBeginntMit(b, "A", c2.c) && patient.hasDiagnoseBeginntMit("F", "G", c2.c);
    }

    @Rule(name="HzV spectrumK psychosomatische Ziffer 35110 mit gesicherter nicht leitliniengerechter F-Diagnose", action=ActionType.UEBERPRUEFEN, gnr="35110", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110"), c2.c) && !patient.hasDiagnoseBeginntMit(b, "G", c2.c) && patient.hasDiagnoseBeginntMit("F", "G", c2.c);
    }

    @Rule(name="HzV spectrumK gesicherte leitliniengerechte Diagnose ohne psychosomatische Ziffer (35100)", action=ActionType.UEBERPRUEFEN, gnr="35100", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Action action) {
        if (!patient.hasScheinInQuartal(c2.c) || !patient.hasDiagnoseBeginntMit(b, "G", c2.c) || patient.hasSchein(ContainerType.UEBERWEISUNG, c2.c) || patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35100|35110|08521"), c2.c)) {
            return false;
        }
        List list = patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01205|01207|01210|01212|01214|01216|01218|03230|04230|04231|04355|04356|14220|14221|14222|14223|14310|14311|16220|21220|21221|22220|22221|22222|23220|30702|35100|35110|35111|35112|35113|35120|35130|35131|35140|35141|35142|35150|35151|35152|35401|35402|35405|35411|35412|35415|35421|35422|35425|35431|35432|35435|35503|35504|35505|35506|35507|35508|35509|35513|35514|35515|35516|35517|35518|35519|35523|35524|35525|35526|35527|35528|35529|35533|35534|35535|35536|35537|35538|35539|35543|35544|35545|35546|35547|35548|35549|35553|35554|35555|35556|35557|35558|35559|35571|35572|35573|35591|35593|35594|35595|35596|35597|35598|35599|35703|35704|35705|35706|35707|35708|35709|35713|35714|35715|35716|35717|35718|35719").contains(scheinLeistung.getGnr())).map(ScheinLeistung::getDatum).collect(Collectors.toList());
        APK aPK = patient.getAPK(false, c2.c, 1L, scheinLeistung -> !list.contains(scheinLeistung.getDatum()));
        if (aPK != null) {
            action.setAPK(aPK);
            return true;
        }
        return false;
    }

    @Rule(name="HzV spectrumK gesicherte leitliniengerechte Diagnose ohne psychosomatische Ziffer 2ter Kontakt (35110)", action=ActionType.UEBERPRUEFEN, gnr="35110", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Action action) {
        if (!patient.hasScheinInQuartal(c2.c) || !patient.hasDiagnoseBeginntMit(b, "G", c2.c) || patient.hasSchein(ContainerType.UEBERWEISUNG, c2.c) || patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110|08521"), c2.c) || !patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35100"), c2.c)) {
            return false;
        }
        List list = patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01205|01207|01210|01212|01214|01216|01218|03230|04230|04231|04355|04356|14220|14221|14222|14223|14310|14311|16220|21220|21221|22220|22221|22222|23220|30702|35100|35110|35111|35112|35113|35120|35130|35131|35140|35141|35142|35150|35151|35152|35401|35402|35405|35411|35412|35415|35421|35422|35425|35431|35432|35435|35503|35504|35505|35506|35507|35508|35509|35513|35514|35515|35516|35517|35518|35519|35523|35524|35525|35526|35527|35528|35529|35533|35534|35535|35536|35537|35538|35539|35543|35544|35545|35546|35547|35548|35549|35553|35554|35555|35556|35557|35558|35559|35571|35572|35573|35591|35593|35594|35595|35596|35597|35598|35599|35703|35704|35705|35706|35707|35708|35709|35713|35714|35715|35716|35717|35718|35719").contains(scheinLeistung.getGnr())).map(ScheinLeistung::getDatum).collect(Collectors.toList());
        APK aPK = patient.getAPK(false, c2.c, 1L, scheinLeistung -> !list.contains(scheinLeistung.getDatum()));
        if (aPK != null) {
            action.setAPK(aPK);
            return true;
        }
        return false;
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean c(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

