/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.f.s;

import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;

@Rules(value=RuleCategory.VORSORGE)
public class a {
    private static final g a = new g("01", "02", "03", "15", "16", "17", "18", "21", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "67");

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a(a);
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="Beratung vor Beginn einer HIV-Pr\u00e4expositionsprophylaxe (01920) h\u00f6chstens dreimal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01920")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasLeistung("01920", c2.c) && patient.getLeistungCount("01920", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 3;
    }

    @Rule(name="Beratung vor Beginn einer HIV-Pr\u00e4expositionsprophylaxe (01920) dreimal im Krankheitsfall m\u00f6glich", action=ActionType.POTENTIAL, gnr="01920")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean a(c c2, Patient patient, Action action) {
        if (patient.getLeistungCount("01920", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2) {
            return false;
        }
        if (!patient.hasLeistung("03001|03002|03003|03004|03005|04001|04002|04003|04004|04005|08210|08211|08212|10210|10211|10212|26210|26211|26212", c2.c)) {
            return false;
        }
        if (!patient.hasDiagnose("Z29.22", true, c2.c)) {
            return false;
        }
        action.setAPK(patient.getAPK(true, c2.c, 1L, a));
        return true;
    }

    @Rule(name="Beratung vor Beginn einer HIV-Pr\u00e4expositionsprophylaxe (01920) ohne gesicherte Diagnose Z29.22", action=ActionType.UEBERPRUEFEN, gnr="01920")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung("01920", c2.c) && !patient.hasDiagnose("Z29.22", true, c2.c);
    }

    @Rule(name="Einleitung einer HIV-Pr\u00e4expositionsprophylaxe (01921) einmal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01921")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean d(c c2, Patient patient) {
        return patient.hasLeistung("01921", c2.c) && patient.getLeistungCount("01921", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="Einleitung einer HIV-Pr\u00e4expositionsprophylaxe (01921) einmal im Krankheitsfall m\u00f6glich", action=ActionType.POTENTIAL, gnr="01921")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean b(c c2, Patient patient, Action action) {
        if (patient.hasLeistung("01921", Arrays.asList(c2.c, c2.d, c2.e, c2.f))) {
            return false;
        }
        if (!patient.hasLeistung("01920", Arrays.asList(c2.c, c2.d, c2.e, c2.f))) {
            return false;
        }
        if (!patient.hasDiagnose("Z29.22", true, c2.c)) {
            return false;
        }
        action.setAPK(patient.getAPK(true, c2.c, 1L, a));
        return true;
    }

    @Rule(name="Einleitung einer HIV-Pr\u00e4expositionsprophylaxe (01921) ohne gesicherte Diagnose Z29.22", action=ActionType.UEBERPRUEFEN, gnr="01921")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistung("01921", c2.c) && !patient.hasDiagnose("Z29.22", true, c2.c);
    }

    @Rule(name="Kontrolle der HIV-Pr\u00e4expositionsprophylaxe (01922) einmal im Behandlungsfall m\u00f6glich", action=ActionType.POTENTIAL, gnr="01922")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean c(c c2, Patient patient, Action action) {
        if (patient.hasLeistung("01922", c2.c)) {
            return false;
        }
        if (!patient.hasLeistung("01921", Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        if (!patient.hasDiagnose("Z29.22", true, c2.c)) {
            return false;
        }
        action.setAPK(patient.getAPK(true, c2.c, 1L, a));
        return true;
    }

    @Rule(name="Kontrolle der HIV-Pr\u00e4expositionsprophylaxe (01922) ohne gesicherte Diagnose Z29.22", action=ActionType.UEBERPRUEFEN, gnr="01922")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung("01922", c2.c) && !patient.hasDiagnose("Z29.22", true, c2.c);
    }

    @Rule(name="Kontrolle der HIV-Pr\u00e4expositionsprophylaxe (01922) ohne abgerechnete 01921", action=ActionType.UEBERPRUEFEN, gnr="01922")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistung("01922", c2.c) && !patient.hasLeistung("01921", Arrays.asList(c2.c, c2.d));
    }

    @Rule(name="Kontrolle der HIV-Pr\u00e4expositionsprophylaxe (01922) am Behandlungstag nicht neben 01920 oder 01921 berechnungsf\u00e4hig", action=ActionType.ENTFERNEN, gnr="01922", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung("01922", c2.c, date) && patient.hasLeistung("01920|01921", c2.c, date);
    }

    @Rule(name="Kontrolle der HIV-Pr\u00e4expositionsprophylaxe (01922) fr\u00fchestens 4 Wochen nach Erbringung der 01921 abrechenbar", action=ActionType.ENTFERNEN, gnr="01922", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        if (!patient.hasLeistung("01922", c2.c, date)) {
            return false;
        }
        Optional<Date> optional = patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> scheinLeistung.getGnr().equals("01921")).map(ScheinLeistung::getDatum).filter(date2 -> !date2.after(date)).max(Comparator.naturalOrder());
        if (optional.isPresent()) {
            return patient.hasLeistungInDaysBefore(date, optional.get(), 27);
        }
        return false;
    }
}

