/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.b.a;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.i;
import com.nhochdrei.kvdt.optimizer.misc.m;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.HZV)
public class k {
    private static final String a = "100609049|102108731|103708751|103708773|104208769|105208795|105508787|105508890|106408802|106908874|108008880|108508863|108608820|108609148|108808844|108809059|109008837|109108850|109308818";
    private static final String b = "M15.0|M15.3|M15.4|M15.8|M15.9|M17.0|M17.1|M17.2|M17.3|M17.4|M17.5|M17.6|M17.7|M17.8|M17.9|M40.05|M40.06|M40.07|M40.08|M40.15|M40.16|M40.17|M40.18|M40.25|M40.26|M40.27|M40.28|M40.35|M40.36|M40.37|M40.38|M40.45|M40.46|M40.47|M40.48|M40.55|M40.56|M40.57|M40.58|M41.05|M41.06|M41.07|M41.08|M41.15|M41.16|M41.17|M41.18|M41.25|M41.26|M41.27|M41.28|M41.35|M41.36|M41.37|M41.38|M41.45|M41.46|M41.47|M41.48|M41.55|M41.56|M41.57|M41.58|M41.85|M41.86|M41.87|M41.88|M41.95|M41.96|M41.97|M41.98|M42.05|M42.06|M42.07|M42.08|M42.15|M42.16|M42.17|M42.18|M42.95|M42.96|M42.97|M42.98|M43.05|M43.06|M43.07|M43.08|M43.15|M43.16|M43.17|M43.18|M43.25|M43.26|M43.27|M43.28|M43.55|M43.56|M43.57|M43.58|M43.85|M43.86|M43.87|M43.88|M43.95|M43.96|M43.97|M43.98|M45.05|M45.06|M45.07|M45.08|M46.05|M46.06|M46.07|M46.08|M46.25|M46.26|M46.27|M46.28|M46.35|M46.36|M46.37|M46.38|M46.45|M46.46|M46.47|M46.48|M46.55|M46.56|M46.57|M46.58|M46.85|M46.86|M46.87|M46.88|M46.95|M46.96|M46.97|M46.98|M47.05|M47.06|M47.07|M47.08|M47.15|M47.16|M47.17|M47.18|M47.25|M47.26|M47.27|M47.28|M47.85|M47.86|M47.87|M47.88|M47.95|M47.96|M47.97|M47.98|M48.05|M48.06|M48.07|M48.08|M48.15|M48.16|M48.17|M48.18|M48.25|M48.26|M48.27|M48.28|M48.35|M48.36|M48.37|M48.38|M48.45|M48.46|M48.47|M48.48|M48.55|M48.56|M48.57|M48.58|M48.85|M48.86|M48.87|M48.88|M48.95|M48.96|M48.97|M48.98|M49.05|M49.06|M49.07|M49.08|M49.15|M49.16|M49.17|M49.18|M49.25|M49.26|M49.27|M49.28|M49.35|M49.36|M49.37|M49.38|M49.45|M49.46|M49.47|M49.48|M49.55|M49.56|M49.57|M49.58|M49.85|M49.86|M49.87|M49.88|M51.0|M51.1|M51.2|M53.25|M53.26|M53.27|M53.28|M53.3|M53.85|M53.86|M53.87|M53.88|M53.95|M53.96|M53.97|M53.98|M54.15|M54.16|M54.17|M54.18|M54.4|M54.5|M54.85|M54.86|M54.87|M54.88|M54.95|M54.96|M54.97|M54.98|S32.00|S32.01|S32.02|S32.03|S32.04|S32.05|S32.1|S32.2|S32.3|S32.7|S32.81|S32.82|S32.83|S32.89|S33.0|S33.1|S33.10|S33.11|S33.12|S33.13|S33.14|S33.15|S33.2|S33.3|S33.4|S33.50|S33.51|S33.6|S33.7";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Bayern");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BAYERN_LKK);
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) ist nur f\u00fcr Versicherte mit dem Status Mitglied (M) abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003"), c2.c) && !patient.isVersichertenArt(m.a);
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) angesetzt ohne gesicherte, endstellig codierte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV LKK Chronikerpauschale (0003) ansetzbar", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c) && patient.isVersichertenArt(m.a);
    }

    @Rule(name="HzV LKK kontaktabh\u00e4ngige Vertreterpauschale (0004) in BAG oder MVZ nicht abrechenbar, nur bei Einrichtungswechsel des Patienten", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c) && (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.e) || patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.d));
    }

    @Rule(name="HzV LKK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht \u00f6fter als 2 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("0004"), c2.c) > 2;
    }

    @Rule(name="HzV LKK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht neben Zielauftragspauschale (0005) am selben Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV LKK Zielauftragspauschale (0005) nicht neben {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="33012|33042|35100|35110|35110B|35110C", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0005"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c, date);
    }

    @Rule(name="HzV LKK Zielauftragspauschale (0005) nicht innerhalb einer BAG/MVZ abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0005"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Kleinkindpauschale (0006) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0006", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003|0006"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) < 5;
    }

    @Rule(name="HzV LKK Kleinkindpauschale (0006) nur bei Kindern j\u00fcnger als 5 Jahre", action=ActionType.ENTFERNEN, gnr="0006", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0006"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0006"), 1L, c2.c).getDatum()) > 4;
    }

    @Rule(name="HzV LKK Kleinkindpauschale (0006) ist nicht neben der Chronikerpauschale (0003) abrechenbar", action=ActionType.ENTFERNEN, gnr="0006", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0006"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV LKK Kleinkindpauschale (0006) ist nur als Zuschlag zur Grundpauschale (0000) abrechenbar", action=ActionType.ENTFERNEN, gnr="0006", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0006"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Kleinkindpauschale (0006) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0006", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0006"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Kleinkindpauschale (0006) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="0006", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0006"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Kleinkindpauschale (0006) ist nur ein Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0006", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("0006"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Pflegeheimpauschale (0008) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0008"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Pflegeheimpauschale (0008) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0008"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Pflegeheimpauschale (0008) ist nur ein Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("0008"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Pflegeheimpauschale (0008) ist nur als Zuschlag zur Grundpauschale (0000) abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0008"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Zuschlag Pflegeheimpauschale (0008) eventuell m\u00f6glich, da der Patient im Vorquartal diese Pauschale erhalten hat", action=ActionType.NACHTRAGEN, gnr="0008", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean q(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0008"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0008"), Arrays.asList(c2.d, c2.e));
    }

    @Rule(name="HzV LKK Zuschlag f\u00fcr Gerinnungsmanagement (0007) ist nur ein Mal pro Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="0007", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("0007"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Zuschlag f\u00fcr Gerinnungsmanagement (0007) ist nur als Zuschlag zur Grundpauschale (0000) abrechenbar", action=ActionType.ENTFERNEN, gnr="0007", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0007"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Zuschlag f\u00fcr Gerinnungsmanagement (0007) ohne gesicherte Leitdiagnose Dauertherapie mit Antikoagulanzien Z92.1", action=ActionType.UEBERPRUEFEN, gnr="0007", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0007"), c2.c) && !patient.hasDiagnose("Z92.1", true, c2.c);
    }

    @Rule(name="HzV LKK Pauschale Palliativpatienten (0001) ohne gesicherte Leitdiagnose Palliativbehandlung Z51.5", action=ActionType.UEBERPRUEFEN, gnr="0001", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV LKK gesicherte Leitdiagnose Palliativbehandlung Z51.5 bei einem haus\u00e4rztlich betreuten Patienten vorhanden, ohne Pauschale Palliativmedizin", action=ActionType.NACHTRAGEN, gnr="0001", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && patient.hasDiagnose("Z51.5", true, c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), c2.c);
    }

    @Rule(name="HzV LKK Pauschale Palliativpatient (0001) ersetzt die kontaktabh\u00e4ngige Grundpauschale (0000)", action=ActionType.ENTFERNEN, gnr="0000", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Pauschale Palliativmedizin (0001) nicht neben Pauschale Onkologie Patienten (0002) abrechenbar", action=ActionType.ENTFERNEN, gnr="0002", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), c2.c);
    }

    @Rule(name="HzV LKK Pauschale Palliativmedizin (0001) nicht neben Chronikerpauschale (0003) abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV LKK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht neben Pauschale Palliativmedizin (0001) abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV LKK Zielauftragspauschale (0005) nicht neben Pauschale Palliativmedizin (0001) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV LKK kontaktabh\u00e4ngige Vertreterpauschale (0004) nicht neben Pauschale onkologischer Patienten (0002) abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV LKK Zielauftragspauschale (0005) nicht neben Pauschale onkologischer Patienten (0002) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV LKK Pauschale onkologischer Patienten (0002) ohne gesicherte onkologische Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0002", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c);
    }

    @Rule(name="HzV LKK onkologische Leitdiagnose ({dia}) bei einem haus\u00e4rztlich betreuten Patienten vorhanden, ohne Pauschale onkologische Patienten (0002)", action=ActionType.UEBERPRUEFEN, gnr="0002", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Action action) {
        if (!patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c)) {
            return false;
        }
        action.setParameter("dia", patient.getFirstDiagnose(com.nhochdrei.kvdt.data.a.d(), c2.c));
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c);
    }

    @Rule(name="HzV LKK Pauschale Onkologiepatienten (0002) nicht neben Chronikerpauschale (0003) abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV LKK Pauschale Onkologiepatienten (0002) ersetzt die kontaktabh\u00e4ngige Grundpauschale (0000)", action=ActionType.ENTFERNEN, gnr="0000", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Pauschale onkologisches Konsil (2010) ist nur durch den Betreuungsarzt abrechenbar, nicht im Vertretungsfall (0004)", action=ActionType.ENTFERNEN, gnr="2010", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2010"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c);
    }

    @Rule(name="HzV LKK Pauschale onkologisches Konsil (2010) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="2010", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2010"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK onkologisches Konsil (2010) ist nur durch den Betreuungsarzt abrechenbar, nicht im Auftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="2010", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2010"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV LKK onkologisches Konsil (2010) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="2010", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2010"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK onkologisches Konsil (2010) ist nicht \u00f6fter als 1 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="2010", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("2010"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Pauschale Onkologiepatienten (0002) oder Pauschale Palliativbehandlung (0001) abgerechnet, eventuell ist ein onkologisches Konsil (2010) erfolgt, jedoch nicht abgerechnet worden", action=ActionType.NACHTRAGEN, gnr="2010", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2010"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001|0002"), c2.c);
    }

    @Rule(name="HzV LKK onkologisches Konsil (2010) ohne onkologische Diagnose", action=ActionType.UEBERPRUEFEN, gnr="2010", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2010"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c);
    }

    @Rule(name="HzV LKK die Kennzeichnungsziffer (88192) ist nur im KV-Schein abzurechnen, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("88192"), c2.c);
    }

    @Rule(name="HzV LKK die lebenslangen Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        if (patient.hasLeistung("88192", c2.c)) {
            String string = patient.getAPK(false, c2.c, 1L, i.a("88192")).getLanr();
            String string2 = null;
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BAYERN_LKK.gnr("0000"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BAYERN_LKK.gnr("0001"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BAYERN_LKK.gnr("0002"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BAYERN_LKK.gnr("0004"))).getLanr();
            }
            return string2 != null && !string2.equals(string);
        }
        return false;
    }

    @Rule(name="HzV LKK f\u00fcr Patienten welche mit der Pseudoziffer 88192 gekennzeichnet wurden HzV-Schein anlegen und Pauschale ansetzen", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String P(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000|0001|0002|0004"), c2.c) && patient.hasLeistung("88192", c2.c)) {
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0001"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnose("Z51.5", true, c2.c)) {
                return "0001";
            }
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0002"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnose(com.nhochdrei.kvdt.data.a.d(), true, c2.c)) {
                return "0002";
            }
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), Arrays.asList(c2.d, c2.e))) {
                return "0004";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV LKK eine Doppelabrechnung von Betreuungspauschalen (0000, 0001, 0002 oder 0004) im HzV-Schein und der Versichertenpauschale (0300x) im KV-Schein ist ausgeschlossen", action=ActionType.ENTFERNEN, gnr="0300*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        if (patient.hasLeistungBeginntMit("03008|04008", c2.c) && patient.hasLeistungBeginntMit("88196", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000|0001|0002|0004"), c2.c) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="HzV LKK {gnr} ist bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32880|32881|32882|32030|32025|32031|32042|32035|32036|32037|32038|32039|32045", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c);
    }

    @Rule(name="HzV LKK {gnr} ist bei HzV eingeschriebenen Patienten nicht zu Lasten der KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32880|32881|32882|32030|32025|32031|32042|32035|32036|32037|32038|32039|32045")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV LKK {gnr} ist bei HzV eingeschriebenen Patienten \u00fcber den KV-Schein abzurechnen", action=ActionType.UEBERPRUEFEN, gnr="32026|32027|32128|32135|32150", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c);
    }

    @Rule(name="HzV LKK Inanspruchnahme zur Unzeit (01100) ist nicht mehrfach am gleichen Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01100", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_LKK.gnr("01100"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK im Hausbesuch (1410) kann auch eine Wegepauschale (4401, 4402, 4403, 4404) abgerechnet werden", action=ActionType.NACHTRAGEN, hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static String c(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1410|1419"), c2.c, date) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("4401|4402|4403|4404"), c2.c, date)) {
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("4401"), Arrays.asList(c2.d, c2.e, c2.f))) {
                return "4401";
            }
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("4402"), Arrays.asList(c2.d, c2.e, c2.f))) {
                return "4402";
            }
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("4403"), Arrays.asList(c2.d, c2.e, c2.f))) {
                return "4403";
            }
            if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("4404"), Arrays.asList(c2.d, c2.e, c2.f))) {
                return "4404";
            }
            return "4401";
        }
        return null;
    }

    @Rule(name="HzV LKK neben der Wegepauschale (4401, 4402, 4403, 4404) sollte auch immer ein Hausbesuch abgerechnet werden", action=ActionType.NACHTRAGEN, gnr="1410|1419", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("4401|4402|4403|4404"), c2.c, date) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c, date);
    }

    @Rule(name="HzV LKK verschiedene Wegeziffern bei dem selben Patienten abgerechnet", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static String R(c c2, Patient patient) {
        List list = patient.getLeistungen(c2.c).stream().filter(i.a(Hzv.BAYERN_LKK.gnr("4401|4402|4403|4404"))).map(ScheinLeistung::getGnr).distinct().collect(Collectors.toList());
        if (list.size() > 1) {
            return list.stream().map(string -> string.substring(0, 4)).collect(Collectors.joining("/"));
        }
        return null;
    }

    @Rule(name="HzV LKK im Mitbesuch (1413) ist keine Wegepauschale (4401, 4402, 4403, 4404) abrechenbar", action=ActionType.ENTFERNEN, gnr="4401|4402|4403|4404", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1413"), c2.c, date);
    }

    @Rule(name="HzV LKK Mitbesuch (1413) ist nicht mehrfach am gleichen Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="1413", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_LKK.gnr("1413"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK ungeplanter eiliger Besuch / auch aus der Sprechstunde heraus / Begleitung Krankentransport (1419) nicht neben Zielauftragspauschale (0005) am gleichen Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1419"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV LKK im Heimbesuch (1418) ist keine Wegepauschale (4401, 4402, 4403, 4404) abrechenbar", action=ActionType.ENTFERNEN, gnr="4401|4402|4403|4404", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1418"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c, date);
    }

    @Rule(name="HzV LKK Heimbesuch (1418) ist nur ein Mal pro Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="1418", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_LKK.gnr("1418"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK Heimbesuch (1418) ist nur 5 mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="1418", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("1418"), c2.c) > 5;
    }

    @Rule(name="HzV LKK Zuschlag bei Besuch von Palliativpatienten (1490) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="1490", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c)) {
            return false;
        }
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1490"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1410|1419"), c2.c, date) && patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV LKK Zuschlag bei Besuch von Palliativpatienten (1490) erfordert die gesicherte Diagnose Palliativbehandlung (Z51.5)", action=ActionType.UEBERPRUEFEN, gnr="1490", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1490"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV LKK Zuschlag bei Besuch von Palliativpatienten (1490) erfordert die Abrechnung eines Besuchs (1410, 1419)", action=ActionType.NACHTRAGEN, gnr="1410|1419", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1490"), c2.c, date) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1410|1419"), c2.c, date);
    }

    @Rule(name="HzV LKK Zuschlag bei Besuch von Palliativpatienten (1490) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1490", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1490"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Zuschlag bei Besuch von Palliativpatienten (1490) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="1490", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1490"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Vorsorgesonographie ab 35 Jahren (33042V) ist ein Mal j\u00e4hrlich abrechenbar", action=ActionType.POTENTIAL, gnr="33042V", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean U(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("33042V"), Quartal.getBisJahresanfang(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV LKK Vorsorgesonographie ab 35 Jahren (33042V) ist f\u00fcr Patienten j\u00fcnger 35 Jahre nicht abrechenbar", action=ActionType.ENTFERNEN, gnr="33042V", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("33042V"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("33042V"), 1L, c2.c).getDatum()) < 35;
    }

    @Rule(name="HzV LKK Vorsorgesonographie ab 35 Jahren (33042V) ist nur ein Mal in Jahr abrechenbar", action=ActionType.ENTFERNEN, gnr="33042V", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean W(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("33042V"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("33042V"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01732"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist jedes Kalenderjahr abrechenbar", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BAYERN_LKK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean Z(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01732"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000|0001|0002"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000|0001|0002"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV LKK Gesundheitsvorsorgeuntersuchung ohne Hautkrebsscreening (01732) ist nur 1 Mal pro Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean aa(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01732"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01732"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV LKK Hautkrebsscreening (01745) ist jedes Kalenderjahr abrechenbar", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BAYERN_LKK, apk=ApkModus.HAUSARZT)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean ab(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01745"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745|01746", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000|0001|0002"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000|0001|0002"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV LKK das Hautkrebsscreening (01745) ist erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01745"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV LKK Hautkrebsscreening (01745) ist innerhalb des Kalenderjahrs nur 1 Mal abrechnungsf\u00e4hig", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean ac(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01745"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01745"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV LKK Hautkrebsscreening ohne Gesundheitsuntersuchung (01745) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01745"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Hautkrebsscreening ohne Gesundheitsuntersuchung (01745) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01745"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BAYERN_LKK, apk=ApkModus.HAUSARZT_UROLOGIE)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean af(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 44 && "M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) ist erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01731"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("01731"), 1L, c2.c).getDatum()) < 45;
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) ist nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean ah(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV LKK Krebsvorsorge Mann (01731) ist nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ai(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01731"), c2.c) && !"M".equals(patient.getGeschlecht());
    }

    @Rule(name="HzV LKK f\u00fcr die Krebsvorsorge Mann (01731) ist die Vorsorgediagnose Z12.5 gesichert zur Abrechung vorgesehen", action=ActionType.UEBERPRUEFEN, gnr="01731", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aj(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01731"), c2.c) && !patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV LKK Vorsorgediagnose Z12.5 gesichert wurde abgerechnet, die Krebsvorsorge Mann (01731) in der Ansetzung vergessen", action=ActionType.NACHTRAGEN, gnr="01731", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ak(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01731"), c2.c) && patient.hasDiagnose("Z12.5", true, c2.c);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U2 (01712) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01712", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean al(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01712"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 2 && patient.getAlterInTage() < 15;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U3 (01713) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01713", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean am(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01713"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 14 && patient.getAlterInTage() < 50;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U4 (01714) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01714", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean an(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01714"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 30 && patient.getAlterInTage() < 136;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U5 (01715) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01715", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ao(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01715"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 120 && patient.getAlterInTage() < 241;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U6 (01716) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01716", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ap(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01716"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 240 && patient.getAlterInTage() < 421;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7 (01717) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean aq(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01717"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 570 && patient.getAlterInTage() < 811;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7a (01723) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean ar(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01723"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 960 && patient.getAlterInTage() < 1141;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U8 (01718) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean as(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01718"), Arrays.asList(c2.c, c2.d)) && patient.getAlterInTage() > 1260 && patient.getAlterInTage() < 1501;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U9 (01719) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean at(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e)) && patient.getAlterInTage() > 1710 && patient.getAlterInTage() < 1981;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U10 (1725) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="1725", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean au(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1725"), Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 6 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) < 9;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U11 (1726) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="1726", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean av(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1726"), Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 8 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) < 11;
    }

    @Rule(name="HzV LKK Jugendvorsorgeuntersuchung J1 (01720) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="01720", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean aw(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01720"), Quartal.getBisVorvorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 11 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) < 16;
    }

    @Rule(name="HzV LKK Jugendvorsorgeuntersuchung J2 (1724) ist m\u00f6glich", action=ActionType.POTENTIAL, gnr="1724", hzv=Hzv.BAYERN_LKK, apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean ax(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("1724"), Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) > 15 && patient.getAlterAnTag(patient.getLeistung(Hzv.BAYERN_LKK.gnr("0000"), 1L, c2.c).getDatum()) < 19;
    }

    @Rule(name="HzV LKK U-Untersuchung {gnr} ohne Vorsorgediagnose Z00.1 gesichert vorhanden", action=ActionType.UEBERPRUEFEN, gnr="01712|01713|01714|01715|01716|01717|01718|01719|1725|1726|01723", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c) && !patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV LKK J-Untersuchung {gnr} ohne Vorsorgediagnose Z00.3 gesichert vorhanden", action=ActionType.UEBERPRUEFEN, gnr="01720|1724", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c) && !patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV LKK U-Vorsorgediagnose Z00.1 gesichert vorhanden und eventuell Abrechnungsziffer U-Untersuchung noch nicht angesetzt", gnr="01712/01713/01714/01715/01716/01717/01718/01719/1725/1726/01723", action=ActionType.NACHTRAGEN, hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ay(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01712|01713|01714|01715|01716|01717|01718|01719|1725|1726|01723"), c2.c) && patient.hasDiagnose("Z00.1", true, c2.c);
    }

    @Rule(name="HzV LKK J-Vorsorgediagnose Z00.3 gesichert vorhanden und eventuell Abrechnungsziffer J-Untersuchung noch nicht angesetzt", action=ActionType.NACHTRAGEN, gnr="01720/1724", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean az(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01720|1724"), c2.c) && patient.hasDiagnose("Z00.3", true, c2.c);
    }

    @Rule(name="HzV LKK Impfziffern ({gnr}) sind nur auf dem HzV-Schein abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="89*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, String string) {
        if (Hzv.BAYERN_LKK.hasVertragsIdentifikator(string)) {
            return false;
        }
        return patient.hasLeistungBeginntMit(string, c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK pr\u00e4station\u00e4re haus\u00e4rztliche Betreuung (2002) ist maximal 8 Mal im Quartal abrechenbar", action=ActionType.ENTFERNEN, gnr="2002", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aA(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("2002"), c2.c) > 8;
    }

    @Rule(name="HzV LKK pr\u00e4station\u00e4re haus\u00e4rztliche Betreuung (2002) ist maximal 1 Mal am Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="2002", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_LKK.gnr("2002"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK pr\u00e4station\u00e4re haus\u00e4rztliche Betreuung (2002) ist nicht am selben Tag wie die pr\u00e4operative haus\u00e4rztliche Betreuung einschl. pr\u00e4operativer Diagnostik (2003) abrechenbar", action=ActionType.ENTFERNEN, gnr="2002", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2002"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2003"), c2.c, date);
    }

    @Rule(name="HzV LKK pr\u00e4operative haus\u00e4rztliche Betreuung einschl. pr\u00e4operativer Diagnostik (2003) ist maximal 1 Mal pro Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="2003", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_LKK.gnr("2003"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK pr\u00e4operative haus\u00e4rztliche Betreuung einschl. pr\u00e4operativer Diagnostik (2003) ist nicht am gleichen Tag wie U1-U11, J1, J2 oder Gesundheitsuntersuchung (01732) abrechenbar", action=ActionType.ENTFERNEN, gnr="2002", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2003"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01732|01712|01713|01714|01715|01716|01717|01718|01719|1725|1726|01723|01720|1724"), c2.c, date);
    }

    @Rule(name="HzV LKK poststation\u00e4res \u00dcberleitungsmanagement (2004) ist maximal 1 Mal pro Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="2004", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BAYERN_LKK.gnr("2004"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK poststation\u00e4res \u00dcberleitungsmanagement (2004) und postoperative haus\u00e4rztliche Betreuung (2005) sind nicht am gleichen Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="2004", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2004"), c2.c, date) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("2005"), c2.c, date);
    }

    @Rule(name="HzV LKK Akupunkturleistungen (30790, 30791) sind nur \u00fcber den KV-Schein abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="30790|30791", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c);
    }

    @Rule(name="HzV LKK Akupunkturleistung ({gnr}) ohne Diagnose der Qualit\u00e4tssicherungsvereinbarung Akupunktur", action=ActionType.UEBERPRUEFEN, gnr="30790|30791")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && !patient.hasDiagnose(b, true, c2.c);
    }

    @Rule(name="HzV LKK CW-Doppler extrakranielle Gef\u00e4\u00dfe oder extremit\u00e4tenversorgende Gef\u00e4\u00dfe (33060, 33061) sind nur \u00fcber den KV-Schein abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="33060|33061", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c);
    }

    @Rule(name="HzV LKK palliative Leistungen ohne gesicherte Palliativdiagnose Z51.5", action=ActionType.UEBERPRUEFEN, gnr="37302H|37317H", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr(string), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV LKK Palliativpatient in weiterer Betreuung, ev. Koordinierungszuschlag 37302H m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="37302H", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean aB(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BAYERN_LKK.gnr("37302H"), c2.c) && patient.hasLeistung(Hzv.BAYERN_LKK.gnr("0000|0001"), c2.c) && patient.hasLeistung("37302H|37302", Arrays.asList(c2.e, c2.d));
    }

    @Rule(name="HzV LKK Zuschlag Erreichbarkeit / Besuchsbereitschaft (37317H) ist nur ein Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="37317H", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean aC(c c2, Patient patient) {
        return patient.hasLeistung("37317H", c2.c) && patient.hasLeistung("37317H|37317", Arrays.asList(c2.f, c2.e, c2.d));
    }

    @Rule(name="HzV LKK 37302H ist nur ein Mal im Behandlungsfall ansetzbar", action=ActionType.ENTFERNEN, gnr="37302H", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aD(c c2, Patient patient) {
        return patient.getLeistungCount("37302H", c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U1 (01711) nur einmal bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aE(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01711"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U1 (01711) nur bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01711"), c2.c, date) && patient.getAlterAnTag(date) > 2;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U2 (01712) nur einmal zwischen 3. und 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aF(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01712"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U2 (01712) erst ab 3. Lebenstag und nur bis 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01712"), c2.c, date) && (patient.getAlterAnTag(date) < 3 || patient.getAlterAnTag(date) > 14);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U3 (01713) nur einmal bis 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aG(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01713"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U3 (01713) nur zwischen 3. und 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01713"), c2.c, date) && (patient.getAlterAnTag(date) < 15 || patient.getAlterAnTag(date) > 49);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U4 (01714) nur einmal bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aH(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01714"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U4 (01714) nur zwischen 2. und 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01714"), c2.c, date) && (patient.getAlterAnTag(date) < 30 || patient.getAlterAnTag(date) > 136);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U5 (01715) nur einmal bis 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aI(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01715"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U5 (01715) nur zwischen 5. und 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01715"), c2.c, date) && (patient.getAlterAnTag(date) < 120 || patient.getAlterAnTag(date) > 241);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U6 (01716) nur einmal bis 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aJ(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01716"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U6 (01716) nur zwischen 9. und 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01716"), c2.c, date) && (patient.getAlterAnTag(date) < 241 || patient.getAlterAnTag(date) > 420);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7 (01717) nur einmal bis 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aK(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01717"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7 (01717) nur zwischen 20. und 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01717"), c2.c, date) && (patient.getAlterAnTag(date) < 571 || patient.getAlterAnTag(date) > 810);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7a (01723) nur einmal bis 38. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aL(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01723"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U7a (01723) nur zwischen 34. und 36. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01723"), c2.c, date) && (patient.getAlterAnTag(date) < 960 || patient.getAlterAnTag(date) > 1141);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U8 (01718) nur einmal bis 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aM(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01718"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U8 (01718) nur zwischen 43. und 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01718"), c2.c, date) && (patient.getAlterAnTag(date) < 1260 || patient.getAlterAnTag(date) > 1501);
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U9 (01719) nur einmal bis 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BAYERN_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aN(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BAYERN_LKK.gnr("01719"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Kindervorsorgeuntersuchung U9 (01719) nur zwischen 58. und 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BAYERN_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BAYERN_LKK.gnr("01719"), c2.c, date) && (patient.getAlterAnTag(date) < 1711 || patient.getAlterAnTag(date) > 1980);
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean b(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

