/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.a.a;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.HZV)
public class k {
    private static final String a = "100105006|100705002|101005007|101305000|101505002|102105000|103105002|103505006|104405007|105505001|106005008|106205000|106305001|106405002|106505003|106905007|107405004|107705007|107805008|108005002|108405006|109305007|109505009|109705001|109905003|109906048|109906710|109906914|109906925|109919500|109990508|109990553";
    private static final String b = "E41|F00|F01|F02|F03|F04|F05|F06|F07|F08|F09|F32|F33|F41|G20.1|G20.2|G20.3|G20.4|G20.5|G20.6|G20.7|G20.8|G20.9|G30|G31|G32|G54.6|G81.0|G81.1|H81|H82|I6|M80.0|M80.2|M80.3|M80.5|M80.8|N31.0|N39.3|N39.4|R13|R15|R26|R29.6|R32|R41|R42|R52.1|R54|R64|U50|U51|Z74|Z99.3";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Baden-W\u00fcrttemberg");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BW_KBS);
    }

    @Rule(name="HzV KBS Behandlungspauschale 0000 nur durch einen Arzt in der gleichen Betriebsst\u00e4tte abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> Hzv.BW_KBS.gnr("0000").equals(scheinLeistung.getGnr())).map(ScheinLeistung::getLanr).collect(Collectors.toSet()).size() > 1;
    }

    @Rule(name="HzV KBS Chronikerpauschale (0003) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0003"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV KBS Chronikerpauschale (0003) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_KBS.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV KBS Chronikerpauschale (0003) nur neben der Behandlungspauschale (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0003"), c2.c);
    }

    @Rule(name="HzV KBS Chronikerpauschale (0003) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_KBS.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_KBS.gnr("0003"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV KBS gesicherte Diagnose zu Chronikerpauschale (0003) in Vorquartalen vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean g(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_KBS.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, Arrays.asList(c2.d, c2.e)) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV KBS Chronikerpauschale (0003) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV KBS Vertreterpauschale (0004) muss nicht \u00f6fter als ein Mal im Behandlungsfall abgerechnet werden", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_KBS.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV KBS Vertreterpauschale (0004) ohne Kennzeichnung Arzt-Patienten-Kontakt (0000)", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0004"), c2.c);
    }

    @Rule(name="HzV KBS Vertreterpauschale (0004) am Behandlungstag nicht neben Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BW_KBS.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV KBS Zielauftrag (0005) nicht neben der 0000 innerhalb der gleichen BAG, MVZ abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.hasLeistung(Hzv.BW_KBS.gnr("0005"), c2.c);
    }

    @Rule(name="HzV KBS Zielauftragspauschale (0005) ohne Kennzeichnung Arzt-Patienten-Kontakt (0000)", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0005"), c2.c);
    }

    @Rule(name="HzV KBS Gesundheitsvorsorgeuntersuchung (01732) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV KBS Gesundheitsvorsorgeuntersuchung (01732) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean n(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_KBS.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_KBS.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_KBS.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV KBS Gesundheitsvorsorgeuntersuchung (01732) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV KBS Gesundheitsvorsorgeuntersuchung (01732) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_KBS.gnr("01732"), c2.c) > 1;
    }

    @Rule(name="HzV KBS Krebsvorsorge Mann (01731) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean p(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_KBS.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_KBS.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_KBS.gnr("0000"), 1L, c2.c).getDatum()) > 44 && patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV KBS Krebsvorsorge Mann (01731) erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV KBS Krebsvorsorge Mann (01731) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("01731"), c2.c) && !patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV KBS Hautkrebsscreening ab 35 Jahren (01745) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean r(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_KBS.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_KBS.gnr("01745|01746"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_KBS.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV KBS Hautkrebsscreening (01745) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("01745"), c2.c) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV KBS unvorhergesehene Inanspruchnahme I (01100) am Behandlungstag nicht neben der Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("01100"), c2.c, date) && patient.hasLeistung(Hzv.BW_KBS.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV KBS unvorhergesehene Inanspruchnahme I (01100) nur in begr\u00fcndeten Ausnahmef\u00e4llen mehrfach am gleichen Tag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_KBS.gnr("01100"), c2.c, date) > 1;
    }

    @Rule(name="HzV KBS unvorhergesehene Inanspruchnahme II (01101) am Behandlungstag nicht neben der Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("01101"), c2.c, date) && patient.hasLeistung(Hzv.BW_KBS.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV KBS unvorhergesehene Inanspruchnahme II (01101) nur in begr\u00fcndeten Ausnahmef\u00e4llen mehrfach am gleichen Tag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_KBS.gnr("01101"), c2.c, date) > 1;
    }

    @Rule(name="HzV KBS kleinchirurgischer Eingriff I (02300) am Behandlungstag nicht neben anderen kleinchirurgischen Eingriffen (02301, 02302) abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*), Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02300", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("02300"), c2.c, date) && patient.hasLeistung(Hzv.BW_KBS.gnr("02301|02302"), c2.c, date) && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV KBS kleinchirurgischer Eingriff I (02300) am Behandlungstag nicht mehrfach abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*), Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02300", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_KBS.gnr("02300"), c2.c, date) > 1 && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV KBS kleinchirurgischen Eingriffe (02300, 02301, 02302) am Behandlungstag bei Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*) oder Versorgung mehrerer offener Wunden (T01*) zusammen nicht \u00f6fter als 5 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="02300", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_KBS.gnr("02300|02301|02302"), c2.c, date) > 5;
    }

    @Rule(name="HzV KBS kleinchirurgischer Eingriff II (02301) am Behandlungstag nicht neben anderen kleinchirurgischen Eingriffen (02300, 02302) abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*) oder Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02301", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("02301"), c2.c, date) && patient.hasLeistung(Hzv.BW_KBS.gnr("02302"), c2.c, date) && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV KBS kleinchirurgischer Eingriff II (02301) am Behandlungstag nicht mehrfach abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*) oder Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02301", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_KBS.gnr("02301"), c2.c, date) > 1 && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV KBS kleinchirurgischer Eingriff III (02302) am Behandlungstag nicht mehrfach abrechenbar, Ausnahme Behandlung von N\u00e4vuszelln\u00e4vussyndrom (D22*), Versorgung mehrerer offener Wunden (T01*)", action=ActionType.ENTFERNEN, gnr="02302", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_KBS.gnr("02302"), c2.c, date) > 1 && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV KBS haus\u00e4rztlich geriatrisches Basisassessment (03240) m\u00f6glich", action=ActionType.POTENTIAL, gnr="03240", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasDiagnoseBeginntMit(b, c2.c) && patient.getLeistungCount(Hzv.BW_KBS.gnr("03240"), Arrays.asList(c2.d, c2.e, c2.f)) < 2 && !patient.hasLeistung(Hzv.BW_KBS.gnr("03240"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_KBS.gnr("0000"), 1L, c2.c).getDatum()) > 69;
    }

    @Rule(name="HzV KBS haus\u00e4rztlich geriatrisches Basisassessment (03240) h\u00f6chstens 2 Mal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("03240"), c2.c) && patient.getLeistungCount(Hzv.BW_KBS.gnr("03240"), Arrays.asList(c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="HzV KBS haus\u00e4rztlich geriatrisches Basisassessment (03240) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_KBS.gnr("03240"), c2.c) > 1;
    }

    @Rule(name="HzV KBS {gnr} bei HzV Patienten nicht auf KV-Schein abrechenbar", action=ActionType.ENTFERNEN, gnr="01611|01731|01732|01745|02300|02301|02302|03220|03221|03240|03360|03362|03321|33012|33042|35100|35110|01100|01101|89100A|89100B|89100R|89101A|89101B|89101R|89102A|89102B|89102R|89102V|89102W|89102X|89103A|89103B|89104A|89104B|89105A|89105B|89105R|89105V|89105W|89105X|89106A|89106B|89107A|89107B|89107R|89107V|89107W|89107X|89108A|89108B|89108R|89110A|89110B|89111|89112|89112Y|89113|89113A|89113B|89113V|89113W|89114|89115A|89115B|89115R|89115V|89115W|89115X|89116A|89116B|89116R|89117A|89117B|89118A|89118B|89119|89119R|89120|89120R|89120V|89120X|89121A|89121B|89121R|89122A|89122B|89122R|89122V|89122W|89122X|89123|89124A|89124B|89124R|89125A|89125B|89126A|89126B|89126V|89126W|89127A|89127B|89128A|89128B|89129A|89129B|89130V|89130W|89130X|89131A|89131B|89131R|89131Y|89132V|89132W|89132X|89133Y|89133V|89133W|89134V|89134W|89134X|89200A|89200B|89201A|89201B|89201R|89202A|89202B|89202R|89202V|89202W|89202X|89203A|89203B|89300A|89300B|89301A|89301B|89301V|89301W|89302|89302R|89303|89303R|89303Y|89400|89400R|89401A|89401B|89401V|89401W|89500A|89500B|89600A|89600B", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV KBS abdominelle Sonographie (33042) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_KBS.gnr("33042"), c2.c) > 1;
    }

    @Rule(name="HzV KBS differentialdiagnostische Kl\u00e4rung psychosomatischer Krankheitszust\u00e4nde (35100) am Behandlungstag nicht neben der verbalen Intervention bei psychosomatischen Krankheitszust\u00e4nden (35110) abrechenbar", action=ActionType.ENTFERNEN, gnr="35110", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("35100"), c2.c, date) && patient.hasLeistung(Hzv.BW_KBS.gnr("35110"), c2.c, date);
    }

    @Rule(name="HzV KBS verbale Intervention bei psychosomatischen Krankheitszust\u00e4nden (35110) h\u00f6chstens 3 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="35110", hzv=Hzv.BW_KBS, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_KBS.gnr("35110"), c2.c, date) > 3;
    }

    @Rule(name="HzV KBS Leistungen der Richtlinie Psychotherapie (35100, 35110) bei 15 Minuten Gespr\u00e4ch, entsprechender Dokumentation m\u00f6glich", action=ActionType.POTENTIAL, gnr="35100/35110", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_KBS.gnr("35100|35110"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasDiagnoseBeginntMit("F32|F33|F34.1|F40|F41|F42|F43|F44|F45|F50|F51|F52|F60|F61|F62|F63|F64|F65|F66|F67|F68|F69|F90|F91|F92|F93|F94|F95|F96|F97|F98", "G", c2.c);
    }

    @Rule(name="HzV KBS psychosomatische Leistunge ({gnr}) ohne leitliniengerechete Diagnose", action=ActionType.UEBERPRUEFEN, gnr="35100|35110", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr(string), c2.c) && !patient.hasDiagnoseBeginntMit("F32|F33|F34.1|F40|F41|F42|F43|F44|F45|F50|F51|F52|F60|F61|F62|F63|F64|F65|F66|F67|F68|F69|F90|F91|F92|F93|F94|F95|F96|F97|F98", "G", c2.c);
    }

    @Rule(name="HzV KBS \u00dcberpr\u00fcfung des Impfstatus (HIPST) nur ein Mal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="HIPST", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("HIPST"), c2.c) && patient.getLeistungCount(Hzv.BW_KBS.gnr("HIPST"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV KBS \u00dcberpr\u00fcfung des Impfstatus (HIPST) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="HIPST", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean y(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_KBS.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return !patient.hasLeistung(Hzv.BW_KBS.gnr("HIPST"), Quartal.getBisVorjahr(c2.c)) && patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c);
    }

    @Rule(name="HzV KBS \u00dcberpr\u00fcfung des Impfstatus (HIPST) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="HIPST", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("HIPST"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV KBS KV-Schein Pseudoziffer (88192, 88194) ohne HzV-Schein Betreuungspauschale (0000, 0004)", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static String A(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BW_KBS.gnr("0000|0004"), c2.c) && patient.hasLeistung("88192|88194", c2.c)) {
            if (patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BW_KBS.gnr("0004"), Arrays.asList(c2.d, c2.e))) {
                return "0004";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV KBS Kennzeichnungsziffer {gnr} nur im KV-Schein abrechenbar, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192|88194", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr(string), c2.c);
    }

    @Rule(name="HzV KBS lebenslange Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="0000/0004", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BW_KBS.gnr("0000|0004"), c2.c) || !patient.hasLeistung("88192|88194", c2.c)) {
            return false;
        }
        return !patient.getLeistung(Hzv.BW_KBS.gnr("0000|0004"), 1L, c2.c).getLanr().equals(patient.getLeistung("88192|88194", 1L, c2.c).getLanr());
    }

    @Rule(name="HzV KBS Doppelabrechnung von Betreuungspauschale (0000, 0004) im HzV-Schein und Versichertenpauschale (0300*) im KV-Schein ausgeschlossen", action=ActionType.ENTFERNEN, gnr="0300*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        if (patient.hasLeistungBeginntMit("03008|04008", c2.c) && patient.hasLeistungBeginntMit("88196", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000|0004"), c2.c) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="HzV KBS {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32040|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125|32128|32880|32881|32882", hzv=Hzv.BW_KBS)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_KBS.gnr(string), c2.c);
    }

    @Rule(name="HzV KBS {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32040|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125|32128|32880|32881|32882")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BW_KBS.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BW_KBS.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

