/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.a.a;

import com.nhochdrei.kvdt.data.a;
import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.SkipRuleInSingleMode;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.HZV)
public class f {
    private static final String a = "102020985|108023388|108036098|108036123";
    private static final String b = "E41|F00|F01|F02|F03|F04|F05|F06|F07|F08|F09|F32|F33|F41|G20.1|G20.2|G20.3|G20.4|G20.5|G20.6|G20.7|G20.8|G20.9|G30|G31|G32|G54.6|G81.0|G81.1|H81|H82|I6|M80.0|M80.2|M80.3|M80.5|M80.8|N31.0|N39.3|N39.4|R13|R15|R26|R29.6|R32|R41|R42|R52.1|R54|R64|U50|U51|Z74|Z99.3";
    private static final String c = "89100A|89100B|89100R|89101A|89101B|89101R|89102A|89102B|89102R|89103A|89103B|89104A|89104B|89105A|89105B|89105R|89106A|89106B|89107A|89107B|89107R|89108A|89108B|89108R|89110A|89110B|89111|89112|89113|89113A|89113B|89114|89115A|89115B|89115R|89116A|89116B|89116R|89117A|89117B|89118A|89118B|89119|89119R|89120|89120R|89121A|89121B|89121R|89122A|89122B|89122R|89123|89124A|89124B|89124R|89125A|89125B|89126A|89126B|89127A|89127B|89128A|89128B|89129A|89129B|89131A|89131B|89131R|89132|89133|89200A|89200B|89201A|89201B|89201R|89202A|89202B|89202R|89203A|89203B|89300A|89300B|89301A|89301B|89302|89302R|89303|89303R|89400|89400R|89401A|89401B|89500A|89500B|89600A|89600B|89600F";
    private static boolean d = false;

    @RulePrerequisite
    public static boolean a(c c2) {
        if (!c2.a("Baden-W\u00fcrttemberg")) {
            return false;
        }
        d = c2.b.getPatients().stream().filter(patient -> patient.hasIk(a)).flatMap(patient -> patient.getLeistungen(c2.c).stream()).anyMatch(scheinLeistung -> Hzv.BW_BOSCHBKK.gnr("56565").equals(scheinLeistung.getGnr()));
        return true;
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BW_BOSCHBKK);
    }

    @Rule(name="HzV Bosch BKK Behandlungspauschale 0000 nur durch einen Arzt in der gleichen Betriebsst\u00e4tte abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> Hzv.BW_BOSCHBKK.gnr("0000").equals(scheinLeistung.getGnr())).map(ScheinLeistung::getLanr).collect(Collectors.toSet()).size() > 1;
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (0003) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0003"), c2.c) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (0003) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (0003) nur neben der Behandlungspauschale (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0003"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (0003) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0003"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV Bosch BKK gesicherte Diagnose zu Chronikerpauschale (0003) in Vorquartalen vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean g(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, Arrays.asList(c2.d, c2.e)) && !patient.hasDiagnose(com.nhochdrei.kvdt.data.a.b(), true, c2.c);
    }

    @Rule(name="HzV Bosch BKK Chronikerpauschale (0003) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Pflegeheimpauschale (0008) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0008", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("0008"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK Pflegeheimpauschale (0008) nur mit einem Hausarzt-Patienten-Kontakt (Kennzeichnung 0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0008"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Arzt-Patienten-Kontakt ohne Pflegeheimpauschale (0008), Pflegeheimpauschale im Vorquartal vorhanden", action=ActionType.UEBERPRUEFEN, gnr="0008", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0008"), c2.d) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0008"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Vertreterpauschale (0004) muss nicht \u00f6fter als ein Mal im Behandlungsfall abgerechnet werden", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK Vertreterpauschale (0004) ohne Kennzeichnung Arzt-Patienten-Kontakt (0000)", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Vertreterpauschale (0004) am Behandlungstag nicht neben Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BW_BOSCHBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV Bosch BKK Zielauftrag (0005) nicht neben der 0000 innerhalb der gleichen BAG, MVZ abrechenbar", action=ActionType.ENTFERNEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Zielauftragspauschale (0005) ohne Kennzeichnung Arzt-Patienten-Kontakt (0000)", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0005"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Gesundheitsvorsorgeuntersuchung (01732) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Gesundheitsvorsorgeuntersuchung (01732) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean q(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV Bosch BKK Gesundheitsvorsorgeuntersuchung (01732) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_BOSCHBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV Bosch BKK Gesundheitsvorsorgeuntersuchung (01732) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("01732"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK Krebsvorsorge Mann (01731) m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean s(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), 1L, c2.c).getDatum()) > 44 && patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV Bosch BKK Krebsvorsorge Mann (01731) erst ab einem Alter von 45 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_BOSCHBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV Bosch BKK Krebsvorsorge Mann (01731) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("01731"), c2.c) && !patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV Bosch BKK Hautkrebsscreening ab 35 Jahren (01745) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean u(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("01745"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), 1L, c2.c).getDatum()) > 34;
    }

    @Rule(name="HzV Bosch BKK Hautkrebsscreening (01745) erst ab einem Alter von 35 Jahren +1 Tag abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BW_BOSCHBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("01745"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV Bosch BKK Impfzuschlag je Impfung nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="89100A|89100B|89100R|89101A|89101B|89101R|89102A|89102B|89102R|89103A|89103B|89104A|89104B|89105A|89105B|89105R|89106A|89106B|89107A|89107B|89107R|89108A|89108B|89108R|89110A|89110B|89111|89112|89113|89113A|89113B|89114|89115A|89115B|89115R|89116A|89116B|89116R|89117A|89117B|89118A|89118B|89119|89119R|89120|89120R|89121A|89121B|89121R|89122A|89122B|89122R|89123|89124A|89124B|89124R|89125A|89125B|89126A|89126B|89127A|89127B|89128A|89128B|89129A|89129B|89131A|89131B|89131R|89132|89133|89200A|89200B|89201A|89201B|89201R|89202A|89202B|89203A|89203B|89300A|89300B|89301A|89301B|89302|89302R|89303|89303R|89400|89400R|89401A|89401B|89500A|89500B|89600A|89600B|89600F", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr(string), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK gesicherte palliative Diagnose Z51.5 im Vorquartal vorhanden, fehlt im aktuellen Quartal", action=ActionType.UEBERPRUEFEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c) && patient.hasDiagnose("Z51.5", true, c2.d);
    }

    @Rule(name="HzV Bosch BKK haus\u00e4rztlich geriatrisches Basisassessment (03240) m\u00f6glich", action=ActionType.POTENTIAL, gnr="03240", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasDiagnoseBeginntMit(b, c2.c) && patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("03240"), Arrays.asList(c2.d, c2.e, c2.f)) < 2 && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("03240"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.getAlterAnTag(patient.getLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), 1L, c2.c).getDatum()) > 69;
    }

    @Rule(name="HzV Bosch BKK haus\u00e4rztlich geriatrisches Basisassessment (03240) h\u00f6chstens 2 Mal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("03240"), c2.c) && patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("03240"), Arrays.asList(c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="HzV Bosch BKK haus\u00e4rztlich geriatrisches Basisassessment (03240) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("03240"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK {gnr} bei HzV Patienten nicht auf KV-Schein abrechenbar", action=ActionType.ENTFERNEN, gnr="01731|01732|01745|03220|03221|03240|03360|03362|03321|33012|33042|89100A|89100B|89100R|89101A|89101B|89101R|89102A|89102B|89102R|89102V|89102W|89102X|89103A|89103B|89104A|89104B|89105A|89105B|89105R|89105V|89105W|89105X|89106A|89106B|89107A|89107B|89107R|89107V|89107W|89107X|89108A|89108B|89108R|89110A|89110B|89111|89112|89112Y|89113|89113A|89113B|89113V|89113W|89114|89115A|89115B|89115R|89115V|89115W|89115X|89116A|89116B|89116R|89117A|89117B|89118A|89118B|89119|89119R|89120|89120R|89120V|89120X|89121A|89121B|89121R|89122A|89122B|89122R|89122V|89122W|89122X|89123|89124A|89124B|89124R|89125A|89125B|89126A|89126B|89126V|89126W|89127A|89127B|89128A|89128B|89129A|89129B|89130V|89130W|89130X|89131A|89131B|89131R|89131Y|89132V|89132W|89132X|89133Y|89133V|89133W|89134V|89134W|89134X|89200A|89200B|89201A|89201B|89201R|89202A|89202B|89202R|89202V|89202W|89202X|89203A|89203B|89300A|89300B|89301A|89301B|89301V|89301W|89302|89302R|89303|89303R|89303Y|89400|89400R|89401A|89401B|89401V|89401W|89500A|89500B|89600A|89600B")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV Bosch BKK abdominelle Sonographie (33042) h\u00f6chstens 2 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("33042"), c2.c) > 2;
    }

    @Rule(name="HzV Bosch BKK \u00dcberpr\u00fcfung des Impfstatus (HIPST) nur ein Mal innerhalb von 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="HIPST", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("HIPST"), c2.c) && patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("HIPST"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV Bosch BKK \u00dcberpr\u00fcfung des Impfstatus (HIPST) alle 2 Kalenderjahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="HIPST", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean B(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("HIPST"), Quartal.getBisVorjahr(c2.c)) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK \u00dcberpr\u00fcfung des Impfstatus (HIPST) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="HIPST", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("HIPST"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) nur neben Arzt-Patienten-Kontakt (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56091"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="56091", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56091"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) nur einmalig durch betreuenden Hausarzt abrechenbar (erstmalig in Betrachtungsquartal + 5 Vorquartale)", action=ActionType.ENTFERNEN, gnr="56091", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVVQ})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56091"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56091"), Arrays.asList(c2.d, c2.e, c2.f, c2.g, c2.h));
    }

    @Rule(name="HzV Bosch BKK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="56091", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56091"), c2.c) && !patient.hasDiagnose("I24.0|I27.20|D68.5|D68.6", true, c2.c) && !patient.hasDiagnoseBeginntMit("I21.|I22.|I23.|I25.2|I26.|I48.|I50.|I63.|I65.|I66.|I69.|I74.|I80.|I81.|I82.|I83.|Z95.", "G", c2.c);
    }

    @Rule(name="HzV Bosch BKK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) bei entsprechender Verordnung m\u00f6glich", action=ActionType.POTENTIAL, gnr="56091", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean H(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56091"), Quartal.getBisVorvorjahr(c2.c)) && (patient.hasDiagnose("I24.0|I27.20|D68.5|D68.6", true, c2.c) || patient.hasDiagnoseBeginntMit("I21.|I22.|I23.|I25.2|I26.|I48.|I50.|I63.|I65.|I66.|I69.|I74.|I80.|I81.|I82.|I83.|Z95.", "G", c2.c));
    }

    @Rule(name="HzV Bosch BKK Einschreibung/Pauschale zur Einstellung auf dauerhafte Vitamin K-Antagonisten-Therapie (56091) im Behandlungsfall nicht neben der Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) abrechenbar", action=ActionType.ENTFERNEN, gnr="56092", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56091"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56092"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur neben Arzt-Patienten-Kontakt (0000) abrechenbar", action=ActionType.NACHTRAGEN, gnr="0000", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56092"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="56092", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56092"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV Bosch BKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56092", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("56092"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK dauerhafte Vitamin K-Antagonisten-Therapie (56091/56092) in Vorquartalen vorhanden, eventuell Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) im aktuellen Quartal abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56092", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean M(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56092"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56091|56092"), Arrays.asList(c2.d, c2.e));
    }

    @Rule(name="HzV Bosch BKK Aufwandspauschale bei dauerhafter Vitamin K-Antagonisten-Therapie (56092) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="56092", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56092"), c2.c) && !patient.hasDiagnose("I24.0|I27.20|D68.5|D68.6", true, c2.c) && !patient.hasDiagnoseBeginntMit("I21.|I22.|I23.|I25.2|I26.|I48.|I50.|I63.|I65.|I66.|I69.|I74.|I80.|I81.|I82.|I83.|Z95.", "G", c2.c);
    }

    @Rule(name="HzV Bosch BKK VERAH TopVersorgt (56565) nur durch Hausarzt abrechenbar, nicht im Vertreterfall (0004) oder Zielauftragsfall (0005)", action=ActionType.ENTFERNEN, gnr="0004|0005", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56565"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr(string), c2.c);
    }

    @Rule(name="HzV Bosch BKK VERAH TopVersorgt (56565) nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="56565", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("56565"), c2.c) > 1;
    }

    @Rule(name="HzV Bosch BKK Teilnahme an VERAH TopVersorgt (56565) m\u00f6glich", action=ActionType.POTENTIAL, gnr="56565", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    @SkipRuleInSingleMode
    public static boolean P(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (!d) {
            return false;
        }
        return !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56565|0004|0005"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.hasDiagnose("E11.01|E11.11|E11.20|E11.21|E11.30|E11.31|E11.40|E11.41|E11.50|E11.51|E11.60|E11.61|E11.72|E11.73|E11.74|E11.75|E11.80|E11.81|E11.91|E12.01|E12.11|E12.20|E12.21|E12.30|E12.31|E12.40|E12.41|E12.50|E12.51|E12.60|E12.61|E12.72|E12.73|E12.74|E12.75|E12.80|E12.81|E12.91|E13.01|E13.11|E13.20|E13.21|E13.30|E13.31|E13.40|E13.41|E13.50|E13.51|E13.60|E13.61|E13.72|E13.73|E13.74|E13.75|E13.80|E13.81|E13.91|I11.00|I11.01|I11.90|I11.91|I13.00|I13.01|I13.10|I13.11|I13.20|I13.21|I13.90|I13.91|I50.13|I50.14|I50.04|I50.05", true, c2.c) && !patient.hasDiagnose("Z51.5|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F03|F05.0|F05.1|H90.0|H90.2|H90.3|H90.5|H90.6|H90.8|H91.0|H91.8|H91.9|F80.1|F80.28|F80.8|F80.9|R47.8|H91.3|F70.1|F70.8|F70.9|F71.0|F71.1|F71.8|F71.9|F72.0|F72.1|F72.8|F72.9|F73.0|F73.1|F73.8|F73.9|F74.1|F74.8|F74.9|F78.1|F78.8|F78.9|F79.1|F79.8|F79.9|F84.4|", true, c2.c) && !patient.hasDiagnoseBeginntMit("F00.0|F00.1|F00.2|F00.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8", "G", c2.c);
    }

    @Rule(name="HzV Bosch BKK Teilnahme an VERAH TopVersorgt (56565) wegen Ausschlussdiagnose nicht mehr m\u00f6glich", action=ActionType.ENTFERNEN, gnr="56565", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56565"), c2.c) && (patient.hasDiagnose("Z51.5|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F03|F05.0|F05.1|H90.0|H90.2|H90.3|H90.5|H90.6|H90.8|H91.0|H91.8|H91.9|F80.1|F80.28|F80.8|F80.9|R47.8|H91.3|F70.1|F70.8|F70.9|F71.0|F71.1|F71.8|F71.9|F72.0|F72.1|F72.8|F72.9|F73.0|F73.1|F73.8|F73.9|F74.1|F74.8|F74.9|F78.1|F78.8|F78.9|F79.1|F79.8|F79.9|F84.4|", true, c2.c) || patient.hasDiagnoseBeginntMit("F00.0|F00.1|F00.2|F00.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8", "G", c2.c));
    }

    @Rule(name="HzV Bosch BKK Teilnahme an VERAH TopVersorgt (56565) ohne entsprechende gesicherte Einschlussdiagnose", action=ActionType.UEBERPRUEFEN, gnr="56565", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56565"), c2.c) && !patient.hasDiagnose("E11.01|E11.11|E11.20|E11.21|E11.30|E11.31|E11.40|E11.41|E11.50|E11.51|E11.60|E11.61|E11.72|E11.73|E11.74|E11.75|E11.80|E11.81|E11.91|E12.01|E12.11|E12.20|E12.21|E12.30|E12.31|E12.40|E12.41|E12.50|E12.51|E12.60|E12.61|E12.72|E12.73|E12.74|E12.75|E12.80|E12.81|E12.91|E13.01|E13.11|E13.20|E13.21|E13.30|E13.31|E13.40|E13.41|E13.50|E13.51|E13.60|E13.61|E13.72|E13.73|E13.74|E13.75|E13.80|E13.81|E13.91|I11.00|I11.01|I11.90|I11.91|I13.00|I13.01|I13.10|I13.11|I13.20|I13.21|I13.90|I13.91|I50.13|I50.14|I50.04|I50.05", true, c2.c);
    }

    @Rule(name="HzV Bosch BKK Teilnahme an VERAH TopVersorgt (56565) in Vorquartalen vorhanden, eventuell Teilnahme an VERAH TopVersorgt (56565) im aktuellen Quartal abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="56565", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean S(c c2, Patient patient) {
        return !patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56565|0004|0005"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("56565"), Arrays.asList(c2.d, c2.e)) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && !patient.hasDiagnose("Z51.5|F01.0|F01.1|F01.2|F01.3|F01.8|F01.9|F03|F05.0|F05.1|H90.0|H90.2|H90.3|H90.5|H90.6|H90.8|H91.0|H91.8|H91.9|F80.1|F80.28|F80.8|F80.9|R47.8|H91.3|F70.1|F70.8|F70.9|F71.0|F71.1|F71.8|F71.9|F72.0|F72.1|F72.8|F72.9|F73.0|F73.1|F73.8|F73.9|F74.1|F74.8|F74.9|F78.1|F78.8|F78.9|F79.1|F79.8|F79.9|F84.4|", true, c2.c) && !patient.hasDiagnoseBeginntMit("F00.0|F00.1|F00.2|F00.9|F02.0|F02.1|F02.2|F02.3|F02.4|F02.8", "G", c2.c);
    }

    @Rule(name="HzV Bosch BKK KV-Schein Pseudoziffer (88192, 88194) ohne HzV-Schein Betreuungspauschale (0000, 0004)", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static String T(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000|0004"), c2.c) && patient.hasLeistung("88192|88194", c2.c)) {
            if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0004"), Arrays.asList(c2.d, c2.e))) {
                return "0004";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV Bosch BKK Kennzeichnungsziffer {gnr} nur im KV-Schein abrechenbar, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192|88194", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr(string), c2.c);
    }

    @Rule(name="HzV Bosch BKK lebenslange Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="0000/0004", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000|0004"), c2.c) || !patient.hasLeistung("88192|88194", c2.c)) {
            return false;
        }
        return !patient.getLeistung(Hzv.BW_BOSCHBKK.gnr("0000|0004"), 1L, c2.c).getLanr().equals(patient.getLeistung("88192|88194", 1L, c2.c).getLanr());
    }

    @Rule(name="HzV Bosch BKK Doppelabrechnung von Betreuungspauschale (0000, 0004) im HzV-Schein und Versichertenpauschale (0300*) im KV-Schein ausgeschlossen", action=ActionType.ENTFERNEN, gnr="0300*")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000|0004"), c2.c) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="HzV Bosch BKK {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der HzV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32040|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125|32128|32880|32881|32882", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr(string), c2.c);
    }

    @Rule(name="HzV Bosch BKK {gnr} bei HzV eingeschriebenen Patienten nicht zu Lasten der KV-Abrechnung abrechenbar", action=ActionType.ENTFERNEN, gnr="32025|32026|32027|32030|32031|32032|32035|32036|32037|32038|32039|32040|32041|32042|32045|32046|32047|32050|32051|32052|32055|32056|32057|32058|32059|32060|32061|32062|32063|32064|32065|32066|32067|32068|32069|32070|32071|32072|32073|32074|32075|32076|32077|32078|32079|32081|32082|32083|32084|32085|32086|32087|32089|32092|32094|32101|32103|32104|32105|32106|32107|32110|32111|32112|32113|32114|32115|32116|32117|32120|32121|32122|32123|32124|32125|32128|32880|32881|32882")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, String string) {
        return patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="Zuschlag Videosprech-Konsultation (0000V) nur ein Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="0000V", hzv=Hzv.BW_BOSCHBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BW_BOSCHBKK.gnr("0000V"), c2.c, date) > 1;
    }

    @Rule(name="Zuschlag Videosprech-Konsultation (0000V) h\u00f6chstens 3 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0000V", hzv=Hzv.BW_BOSCHBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BW_BOSCHBKK.gnr("0000V"), c2.c) > 3;
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BW_BOSCHBKK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

