/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AbrechnungType {
    UNKNOWN(""),
    GKV(""),
    PKV("-PRIVAT"),
    BG("-BG"),
    HZV("");

    private final String suffix;

    private AbrechnungType(String suffix) {
        this.suffix = suffix;
    }

    private String gnr(String gnr, String sep, Function<String, String> map) {
        if (this == HZV) {
            throw new IllegalStateException("Bitte HzV-Klasse nutzen");
        }
        return Stream.of(gnr.split("[" + sep + "]")).map(map).collect(Collectors.joining(sep));
    }

    public String gnr(String gnr) {
        if (gnr == null || gnr.isEmpty()) {
            return "";
        }
        return this.gnr(gnr, "|", g2 -> {
            if (g2.contains("/")) {
                return this.gnr((String)g2, "/", this::addSuffix);
            }
            return this.addSuffix((String)g2);
        });
    }

    private String addSuffix(String g2) {
        return String.format("%s%s", g2, this.suffix);
    }

    public boolean hasSuffix(String gnr) {
        if (this == HZV) {
            throw new IllegalStateException("Bitte HzV-Klasse nutzen");
        }
        if (this.suffix.isEmpty() && gnr.contains("-")) {
            return false;
        }
        return gnr.endsWith(this.suffix);
    }
}

