/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import com.nhochdrei.kvdt.model.ScheinLeistung;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class APK
implements Comparable<APK> {
    public static final Comparator<APK> COMPARATOR = Comparator.comparing(APK::getDatum, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(APK::getLanr, Comparator.nullsFirst(Comparator.naturalOrder()));
    String lanr;
    String bsnr;
    Date datum;

    public APK(ScheinLeistung leistung) {
        this.lanr = leistung.getLanr();
        this.bsnr = leistung.getBsnr();
        this.datum = leistung.getDatum();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof APK)) {
            return false;
        }
        APK aPK = (APK)obj;
        return Objects.equals(this.lanr, aPK.lanr) && Objects.equals(this.datum, aPK.datum);
    }

    public int hashCode() {
        return (this.lanr + this.datum.getTime()).hashCode();
    }

    @Override
    public int compareTo(APK o2) {
        return COMPARATOR.compare(this, o2);
    }

    public String getLanr() {
        return this.lanr;
    }

    public Date getDatum() {
        return this.datum;
    }

    public String getBsnr() {
        return this.bsnr;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return (String)Optional.ofNullable(this.datum).map(simpleDateFormat::format).orElse(null) + " - " + this.lanr;
    }
}

