/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.importer;

import com.nhochdrei.kvdt.importer.AbrechnungImportException;
import com.nhochdrei.kvdt.importer.AbrechnungImporterSettings;
import com.nhochdrei.kvdt.importer.AbstractFileImporter;
import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.importer.HzvContext;
import com.nhochdrei.kvdt.model.AbrechnungType;
import com.nhochdrei.kvdt.model.Arzt;
import com.nhochdrei.kvdt.model.Betriebssteatte;
import com.nhochdrei.kvdt.model.ConFile;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.ScheinDiagnose;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HzvImport
extends AbstractFileImporter {
    private static final Logger d = LoggerFactory.getLogger(HzvImport.class);
    private HzvContext e = HzvContext.UNKNOWN;
    private File f;
    private Map<String, String> g;
    private Date h;
    private String i;
    private String j;
    private ConFile k;
    private Betriebssteatte l;
    private Arzt m;
    private Schein n;
    private ScheinLeistung o;
    private ScheinDiagnose p;
    private boolean q;
    private StringBuilder r = new StringBuilder();
    private String s;
    private final SimpleDateFormat t = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat u = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    private final a v = new a();

    @Override
    public void process(File file, InputStream input, AbrechnungImporterSettings settings) throws AbrechnungImportException {
        this.f = file;
        this.g = settings.getBetriebsstaettenMapping();
        this.a(file, this::a);
    }

    private void a(File file, Consumer<String> consumer) throws AbrechnungImportException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));){
            boolean bl = false;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.endsWith("body='")) {
                    this.h = this.u.parse(string);
                }
                if (string.startsWith("<StarteAbrechnung ")) {
                    bl = true;
                    stringBuilder.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                }
                if (bl) {
                    stringBuilder.append(string).append("\r\n");
                }
                if (!string.contains("</StarteAbrechnung>")) continue;
                bl = false;
                if (consumer != null) {
                    consumer.accept(stringBuilder.toString());
                }
                stringBuilder = new StringBuilder();
            }
        }
        catch (ParseException parseException) {
            throw new AbrechnungImportException("Error parsing log timestamp", parseException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AbrechnungImportException("Unsupported Encoding", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new AbrechnungImportException("Fehler beim Einlesen der HZV-Datei: " + file.getName(), iOException);
        }
    }

    private void a(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(new StringReader(string)), (DefaultHandler)this.v);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            d.error("Fehler beim Verarbeiten des HZV-XML", (Throwable)exception);
        }
    }

    private void b(String string) {
        switch (string) {
            case "VertragsIdentifikator": {
                this.k.setVertragsIdentifikator(this.s);
                break;
            }
            case "AbrechnungsJahr": {
                this.i = this.s;
                break;
            }
            case "AbrechnungsQuartal": {
                this.j = this.s;
                break;
            }
            case "Bsnr": {
                this.l = new Betriebssteatte();
                this.l.setBsnr(this.s);
                break;
            }
            case "Lanr": {
                this.m.setLanr(this.s);
                this.k.setHzvLanr(this.s);
                break;
            }
            case "Nachname": {
                this.m.setName(this.s);
                break;
            }
            case "Vorname": {
                this.m.setVorname(this.s);
                break;
            }
        }
    }

    private void c(String string) {
        switch (string) {
            case "Nachname": {
                this.n.setPatientName(this.s);
                break;
            }
            case "Vorname": {
                this.n.setPatientVorname(this.s);
                break;
            }
            case "Geburtsdatum": {
                try {
                    this.n.setPatientGeburtsdatum(this.t.parse(this.s));
                }
                catch (ParseException parseException) {
                    d.warn("Geburtsdatum '{}' konnte nicht ausgelesen werden", (Object)this.s);
                }
                break;
            }
            case "Geschlecht": {
                this.n.setPatientGeschlecht(this.s);
                break;
            }
            case "KrankenkassenIk": {
                this.n.setKostentraegerKennung(this.s);
                break;
            }
            case "VersichertenNummer": {
                this.n.setPatientVersichertenId(this.s);
                break;
            }
            case "VersichertenArt": {
                this.n.setPatientVersichertenArt(this.s);
                break;
            }
        }
    }

    private void d(String string) {
        switch (string) {
            case "Leistungsdatum": {
                try {
                    this.o.setDatum(this.t.parse(this.s));
                }
                catch (ParseException parseException) {
                    d.warn("Leistungsdatum '{}' konnte nicht ausgelesen werden", (Object)this.s);
                }
                break;
            }
            case "Leistungsziffer": {
                this.o.setGnr(this.s + "-" + this.k.getVertragsIdentifikator());
                break;
            }
            case "Lanr": {
                this.o.setLanr(this.s);
                break;
            }
        }
    }

    private void e(String string) {
        switch (string) {
            case "DiagnoseCode": {
                this.p.setIcdCode(this.s);
                break;
            }
            case "Sicherheit": {
                this.p.setSicherheit(this.s);
                break;
            }
            case "Seitenlokalisation": {
                this.p.setLokalisation(this.s);
                break;
            }
            case "IstDauerDiagnose": {
                this.q = Boolean.parseBoolean(this.s);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canReadFile(File file) {
        if (!file.getName().toLowerCase().endsWith(".log")) {
            return false;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));){
            boolean bl = bufferedReader.lines().anyMatch(string -> string.startsWith("<StarteAbrechnung "));
            return bl;
        }
        catch (IOException iOException) {
            d.error("Fehler beim Einlesen der HZV-Datei: " + file, (Throwable)iOException);
            return false;
        }
    }

    class a
    extends DefaultHandler {
        a() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            HzvImport.this.r.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            HzvImport.this.r = new StringBuilder();
            switch (localName) {
                case "container": {
                    HzvImport.this.e = HzvContext.CONTAINER;
                    HzvImport.this.k = new ConFile();
                    HzvImport.this.k.setAbrechnungsType(AbrechnungType.HZV);
                    HzvImport.this.k.setFile(HzvImport.this.f);
                    HzvImport.this.k.setErstellungsdatum(HzvImport.this.h);
                    HzvImport.this.m = new Arzt();
                    break;
                }
                case "Vertragskontext": {
                    HzvImport.this.e = HzvContext.VERTRAGSKONTEXT;
                    break;
                }
                case "Vertragsarzt": {
                    HzvImport.this.e = HzvContext.VERTRAGSARZT;
                    break;
                }
                case "AbrechnungsDokumentation": {
                    HzvImport.this.e = HzvContext.ABRECHNUNGSDOKUMENTATION;
                    HzvImport.this.n = new Schein();
                    break;
                }
                case "Patient": {
                    HzvImport.this.e = HzvContext.PATIENT;
                    break;
                }
                case "Leistung": {
                    HzvImport.this.e = HzvContext.LEISTUNG;
                    HzvImport.this.o = new ScheinLeistung();
                    break;
                }
                case "Diagnose": {
                    HzvImport.this.e = HzvContext.DIAGNOSE;
                    HzvImport.this.p = new ScheinDiagnose();
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            HzvImport.this.s = HzvImport.this.r.toString();
            switch (HzvImport.this.e) {
                case VERTRAGSARZT: 
                case VERTRAGSKONTEXT: {
                    HzvImport.this.b(localName);
                    break;
                }
                case PATIENT: {
                    HzvImport.this.c(localName);
                    break;
                }
                case LEISTUNG: {
                    HzvImport.this.d(localName);
                    break;
                }
                case DIAGNOSE: {
                    HzvImport.this.e(localName);
                    break;
                }
            }
            switch (localName) {
                case "container": {
                    if (!HzvImport.this.b) break;
                    HzvImport.this.a(HzvImport.this.k);
                    break;
                }
                case "Vertragskontext": {
                    HzvImport.this.k.setAbrechnungsquartal(Quartal.get(HzvImport.this.j + HzvImport.this.i));
                    break;
                }
                case "Vertragsarzt": {
                    HzvImport.this.l.getAerzte().put(HzvImport.this.m.getLanr(), HzvImport.this.m);
                    HzvImport.this.k.addBetriebsstaette(HzvImport.this.l.getBsnr(), HzvImport.this.l);
                    if (HzvImport.this.c == null) break;
                    HzvImport.this.c.accept(HzvImport.this.k);
                    for (Betriebssteatte betriebssteatte : HzvImport.this.k.getBetriebsstaetten().values()) {
                        HzvImport.this.c.accept(betriebssteatte);
                    }
                    break;
                }
                case "AbrechnungsDokumentation": {
                    HzvImport.this.n.setQuartal(HzvImport.this.k.getAbrechnungsquartal());
                    HzvImport.this.n.setArt(ContainerType.HZV);
                    HzvImport.this.n.setHzvVertrag(Hzv.get(HzvImport.this.k.getVertragsIdentifikator()));
                    String string = (String)HzvImport.this.g.get(HzvImport.this.l.getBsnr());
                    HzvImport.this.n.setAbrechnungBsnr(string);
                    if (HzvImport.this.c != null) {
                        HzvImport.this.c.accept(HzvImport.this.n);
                    }
                    HzvImport.this.k.getScheine().add(HzvImport.this.n);
                    break;
                }
                case "Leistung": {
                    HzvImport.this.o.setBsnr(HzvImport.this.l.getBsnr());
                    if (HzvImport.this.o.getLanr() == null) {
                        HzvImport.this.o.setLanr(HzvImport.this.m.getLanr());
                    }
                    HzvImport.this.n.getLeistungen().add(HzvImport.this.o);
                    HzvImport.this.e = HzvContext.UNKNOWN;
                    break;
                }
                case "Diagnose": {
                    if (HzvImport.this.q) {
                        HzvImport.this.n.getDauerdiagnosen().add(HzvImport.this.p);
                    } else {
                        HzvImport.this.n.getDiagnosen().add(HzvImport.this.p);
                    }
                    HzvImport.this.e = HzvContext.UNKNOWN;
                    break;
                }
            }
        }
    }
}

