/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.importer;

import com.nhochdrei.kvdt.importer.AbrechnungImporterSettings;
import com.nhochdrei.kvdt.importer.HzvXmlImport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HzvFptImport
extends HzvXmlImport {
    private static final Logger g = LoggerFactory.getLogger(HzvFptImport.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canReadFile(File file) {
        if (!file.getName().toLowerCase().endsWith(".fpt")) {
            return false;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            boolean bl = bufferedReader.lines().anyMatch(string -> string.startsWith("<AbrechnungsContainer "));
            return bl;
        }
        catch (IOException iOException) {
            g.error("Fehler beim Einlesen der FPT HZV-Datei: " + file, (Throwable)iOException);
            return false;
        }
    }

    @Override
    public void process(File file, InputStream input, AbrechnungImporterSettings settings) {
        this.d = file;
        this.e = settings.getBetriebsstaettenMapping();
        try {
            this.f = new Date(Files.getLastModifiedTime(Paths.get(file.toURI()), new LinkOption[0]).toMillis());
        }
        catch (IOException iOException) {
            this.f = new Date(0L);
            iOException.printStackTrace();
        }
        this.a(file, this::a);
    }

    private void a(File file, Consumer<String> consumer) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            boolean bl = false;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("<AbrechnungsContainer ")) {
                    bl = true;
                    stringBuilder.append("<?xml version=\"1.0\"?>");
                }
                if (bl) {
                    stringBuilder.append(string).append("\r\n");
                }
                if (!string.startsWith("</AbrechnungsContainer>")) continue;
                bl = false;
                if (consumer != null) {
                    consumer.accept(stringBuilder.toString());
                }
                stringBuilder = new StringBuilder();
            }
        }
        catch (IOException iOException) {
            g.error("Fehler beim Einlesen der FPT HZV-Datei: " + file.getName(), (Throwable)iOException);
        }
    }
}

