/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.o;

import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.g;
import com.nhochdrei.kvdt.optimizer.misc.i;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Rules(value=RuleCategory.DMP)
public class a {
    private static final g a = new g("01", "02", "03", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46");
    private static final String b = "101097008";
    private static final String c = "101097008|101202961|109905003";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Sachsen-Anhalt");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="DMP DM2 Ziffern nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="99819/99823/99828")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasLeistung("99819", c2.c, (Predicate<ScheinLeistung>)a) && patient.hasLeistung("99823|99828", c2.c, (Predicate<ScheinLeistung>)a) || patient.hasLeistung("99823", c2.c, (Predicate<ScheinLeistung>)a) && patient.hasLeistung("99828", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="DMP DM2 AOK Sachsen-Anhalt \u00dcbersicht der s\u00e4umigen Patienten (sind eingeschrieben, wegen Dokumentation in letzten 2 Quartalen), jedoch im aktuellen Quartal nicht dokumentiert, aber betreut worden, daher Dokuziffer 99823 oder Betreuungsziffer 99828 m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="99823/99828")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasIk(b) && patient.hasLeistung("99819|99823", Arrays.asList(c2.d, c2.e), (Predicate<ScheinLeistung>)a) && patient.hasLeistungBeginntMit("0300|0400", c2.c) && !patient.hasLeistung("99823|99828", c2.c);
    }

    @Rule(name="DMP DM2 \u00dcbersicht der s\u00e4umigen Patienten (sind eingeschrieben, wegen Dokumentation in letzten 2 Quartalen), jedoch im aktuellen Quartal nicht dokumentiert, aber betreut worden, daher Dokuziffer 99823 m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="99823")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean d(c c2, Patient patient) {
        return !patient.hasIk(b) && patient.hasLeistung("99819|99823", Arrays.asList(c2.d, c2.e), (Predicate<ScheinLeistung>)a) && patient.hasLeistungBeginntMit("0300|0400", c2.c) && !patient.hasLeistung("99823", c2.c);
    }

    @Rule(name="DMP DM2 Betreuungsziffer 99828 nur bei in der AOK Sachsen-Anhalt-Versicherten m\u00f6glich", action=ActionType.ENTFERNEN, gnr="99828")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return !patient.hasIk(b) && patient.hasLeistung("99828", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="DMP DM2 ohne gesicherte E11*", action=ActionType.UEBERPRUEFEN, gnr="99819|99823|99828")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c, (Predicate<ScheinLeistung>)a) && !patient.hasDiagnoseBeginntMit("E11", "G", c2.c);
    }

    @Rule(name="DMP DM2 Patienten mit 99828 ohne Dokumentationsziffer in letzten 2 Quartalen, Ausschreibung droht", action=ActionType.ENTFERNEN, gnr="99828")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean f(c c2, Patient patient) {
        return !patient.hasLeistung("99819|99823", Arrays.asList(c2.d, c2.e)) && patient.hasLeistung("99828", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="Patient kann nicht in 2 verschiedenen DMP\u00b4s eingeschrieben sein", action=ActionType.ENTFERNEN, gnr="99819|99823")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, String string) {
        return !patient.hasIk("100609049|105508890|101097008|101202961") && patient.hasLeistung(string, c2.c) && patient.hasLeistung("99849|99853|96319|96323|96019|96023", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="DMP DM2 m\u00f6glich", action=ActionType.POTENTIAL, gnr="99819/99823", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean g(c c2, Patient patient) {
        return !patient.hasIk("100609049|105508890|101097008|101202961") && patient.hasDiagnoseBeginntMit("E11|E14", "G", Arrays.asList(c2.c, c2.d, c2.e)) && !patient.hasLeistung("99819|99823", Arrays.asList(c2.c, c2.d, c2.e)) && patient.hasLeistungBeginntMit("0300|0400", c2.c) && !patient.hasLeistung("99849|99853|96319|96323|96019|96023", Arrays.asList(c2.c, c2.d));
    }

    @Rule(name="DMP DM2 m\u00f6glich", action=ActionType.POTENTIAL, gnr="99819/99823", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasIk("100609049|105508890|101097008|101202961") && patient.hasDiagnoseBeginntMit("E11|E14", "G", Arrays.asList(c2.c, c2.d, c2.e)) && !patient.hasLeistung("99819|99823", Arrays.asList(c2.c, c2.d, c2.e)) && patient.hasLeistungBeginntMit("0300|0400", c2.c);
    }

    @Rule(name="DMP DM2 {gnr} nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="99819|99823|99828")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.getLeistungCount(string, c2.c) > 1;
    }

    @Rule(name="Laborbefreiungsziffer 32022 eventuell vergessen/ansetzbar.", action=ActionType.UEBERPRUEFEN, gnr="32022")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return !patient.hasLeistung("32022", c2.c) && patient.hasLeistung("99819|99823|99828", c2.c);
    }

    @Rule(name="DMP KHK Ziffer nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="99849/99853/99858")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung("99849", c2.c, (Predicate<ScheinLeistung>)a) && patient.hasLeistung("99853|99858", c2.c, (Predicate<ScheinLeistung>)a) || patient.hasLeistung("99853", c2.c, (Predicate<ScheinLeistung>)a) && patient.hasLeistung("99858", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="DMP KHK \u00dcbersicht der s\u00e4umigen Patienten (sind eingeschrieben, wegen Dokumentation in letzten 2 Quartalen), jedoch im aktuellen Quartal nicht dokumentiert, aber betreut worden, daher Dokuziffer 99853 oder Betreuungsziffer 99858 m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="99853/99858")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean k(c c2, Patient patient) {
        return patient.hasIk(b) && patient.hasLeistung("99849|99853", Arrays.asList(c2.d, c2.e), (Predicate<ScheinLeistung>)a) && patient.hasLeistungBeginntMit("0300", c2.c) && !patient.hasLeistung("99853|99858", c2.c);
    }

    @Rule(name="DMP KHK \u00dcbersicht der s\u00e4umigen Patienten (sind eingeschrieben, wegen Dokumentation in letzten 2 Quartalen), jedoch im aktuellen Quartal nicht dokumentiert, aber betreut worden, daher Dokuziffer 99853 m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="99853")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean l(c c2, Patient patient) {
        return !patient.hasIk(b) && patient.hasLeistung("99849|99853", Arrays.asList(c2.d, c2.e), (Predicate<ScheinLeistung>)a) && patient.hasLeistungBeginntMit("0300", c2.c) && !patient.hasLeistung("99853", c2.c);
    }

    @Rule(name="DMP KHK Betreuungsziffer 99858 nur bei in der AOK Sachsen-Anhalt-Versicherten abrechenbar", action=ActionType.ENTFERNEN, gnr="99858")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient) {
        return !patient.hasIk(b) && patient.hasLeistung("99858", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="DMP KHK ohne gesicherte Leitdiagnose I25", action=ActionType.UEBERPRUEFEN, gnr="99849|99853|99858")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c, (Predicate<ScheinLeistung>)a) && !patient.hasDiagnoseBeginntMit("I25", "G", c2.c);
    }

    @Rule(name="DMP KHK Patienten mit 99858 ohne Dokumentationsziffer in letzten 2 Quartalen, Ausschreibung droht", action=ActionType.ENTFERNEN, gnr="99858")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung("99858", c2.c, (Predicate<ScheinLeistung>)a) && !patient.hasLeistung("99849|99853", Arrays.asList(c2.d, c2.e));
    }

    @Rule(name="Patient kann nicht in 2 verschiedenen DMP\u00b4s eingeschrieben sein", action=ActionType.ENTFERNEN, gnr="99849|99853")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return !patient.hasIk("100609049|105508890|101097008|101202961") && patient.hasLeistung(string, c2.c) && patient.hasLeistung("96319|96323|96019|96023", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="DMP KHK m\u00f6glich", action=ActionType.POTENTIAL, gnr="99849/99853", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean o(c c2, Patient patient) {
        return !patient.hasIk("100609049|105508890|101097008|101202961") && patient.hasDiagnoseBeginntMit("I25", "G", Arrays.asList(c2.c, c2.d, c2.e)) && !patient.hasLeistung("99849|99853", Arrays.asList(c2.c, c2.d, c2.e)) && patient.hasLeistungBeginntMit("0300", c2.c) && !patient.hasLeistung("99819|99823|96319|96323|96019|96023", Arrays.asList(c2.c, c2.d));
    }

    @Rule(name="DMP KHK m\u00f6glich", action=ActionType.POTENTIAL, gnr="99849/99853", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasIk("100609049|105508890|101097008|101202961") && patient.hasDiagnoseBeginntMit("I25", "G", Arrays.asList(c2.c, c2.d, c2.e)) && !patient.hasLeistung("99849|99853", Arrays.asList(c2.c, c2.d, c2.e)) && patient.hasLeistungBeginntMit("0300", c2.c);
    }

    @Rule(name="DMP KHK {gnr} nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="99849|99853|99858")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, String string) {
        return patient.getLeistungCount(string, c2.c) > 1;
    }

    @Rule(name="DMP Asthma-COPD Ziffern nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="96319/96323/96328")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung("96319", c2.c, (Predicate<ScheinLeistung>)a) && patient.hasLeistung("96323|96328", c2.c, (Predicate<ScheinLeistung>)a) || patient.hasLeistung("96323", c2.c, (Predicate<ScheinLeistung>)a) && patient.hasLeistung("96328", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="DMP Asthma-COPD \u00dcbersicht der s\u00e4umigen Patienten (sind eingeschrieben, wegen Dokumentation in letzten 2 Quartalen), jedoch im aktuellen Quartal nicht dokumentiert, aber betreut worden, daher Dokuziffer 96323 oder Betreuungsziffer 96328 m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="96323/96328")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasIk(b) && patient.hasLeistung("96319|96323", Arrays.asList(c2.d, c2.e), (Predicate<ScheinLeistung>)a) && patient.hasLeistungBeginntMit("0300|0400", c2.c) && !patient.hasLeistung("96323|96328", c2.c);
    }

    @Rule(name="DMP Asthma-COPD \u00dcbersicht der s\u00e4umigen Patienten (sind eingeschrieben, wegen Dokumentation in letzten 2 Quartalen), jedoch im aktuellen Quartal nicht dokumentiert, aber betreut worden, daher Dokuziffer 96323 m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="96323")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean s(c c2, Patient patient) {
        return !patient.hasIk(b) && patient.hasLeistung("96319|96323", Arrays.asList(c2.d, c2.e), (Predicate<ScheinLeistung>)a) && patient.hasLeistungBeginntMit("0300|0400", c2.c) && !patient.hasLeistung("96323", c2.c);
    }

    @Rule(name="DMP Asthma-COPD Betreuungsziffer 96328 nur bei in der AOK Sachsen-Anhalt-Versicherten abrechenbar", action=ActionType.ENTFERNEN, gnr="96328")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return !patient.hasIk(b) && patient.hasLeistung("96328", c2.c, (Predicate<ScheinLeistung>)a);
    }

    @Rule(name="DMP Asthma-COPD ohne gesicherte Leitdiagnose J44, J45", action=ActionType.UEBERPRUEFEN, gnr="96319|96323|96328")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c, (Predicate<ScheinLeistung>)a) && !patient.hasDiagnoseBeginntMit("J44|J45", "G", c2.c);
    }

    @Rule(name="DMP Asthma-COPD Patienten mit 96328 ohne Dokumentationsziffer in den letzten 2 Quartalen, Ausschreibung droht", action=ActionType.ENTFERNEN, gnr="96328")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistung("96328", c2.c, (Predicate<ScheinLeistung>)a) && !patient.hasLeistung("96319|96323", Arrays.asList(c2.d, c2.e));
    }

    @Rule(name="DMP Asthma-COPD Patient kann nicht in 2 verschiedenen DMP\u00b4s eingeschrieben sein", action=ActionType.ENTFERNEN, gnr="96319|96323")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, String string2) {
        if (patient.hasIk("100609049|105508890|101097008|101202961") || !patient.hasLeistung(string2, c2.c)) {
            return false;
        }
        Set set = patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> string2.equals(scheinLeistung.getGnr())).map(ScheinLeistung::getLanr).collect(Collectors.toSet());
        return patient.getLeistungen(c2.c).stream().filter(i.a("96219A|96219B|96219C|96218A|96218B|96218C|96218D|99855|99858|99856|96419|96423|96427|96428|96455|96456|96028|99872|96026|96027|99828|99822C|99822D|99826|99827|96328|96355|96356|96357")).map(ScheinLeistung::getLanr).anyMatch(string -> set.contains(string));
    }

    @Rule(name="DMP Asthma-COPD m\u00f6glich", action=ActionType.POTENTIAL, gnr="96319|96323", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean v(c c2, Patient patient) {
        return !patient.hasIk("100609049|105508890|101097008|101202961") && patient.hasDiagnoseBeginntMit("J44|J45", "G", Arrays.asList(c2.c, c2.d, c2.e)) && !patient.hasLeistung("96319|96323", Arrays.asList(c2.c, c2.d, c2.e)) && patient.hasLeistungBeginntMit("0300", c2.c) && !patient.hasLeistung("99819|99823|99849|99853|96019|96023|96219A|96219B|96219C|96218A|96218B|96218C|96218D|99855|99858|99856|96419|96423|96427|96428|96455|96456|99828|99822C|99822D|99826|99827|96328|96355|96356|96357", Arrays.asList(c2.c, c2.d));
    }

    @Rule(name="DMP Asthma m\u00f6glich", action=ActionType.POTENTIAL, gnr="96319|96323", apk=ApkModus.U_UNTERSUCHUNG)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean w(c c2, Patient patient) {
        return !patient.hasIk("100609049|105508890|101097008|101202961") && patient.hasDiagnoseBeginntMit("J45", "G", Arrays.asList(c2.c, c2.d, c2.e)) && !patient.hasLeistung("96319|96323", Arrays.asList(c2.c, c2.d, c2.e)) && patient.hasLeistungBeginntMit("0400", c2.c) && !patient.hasLeistung("99819|99823|99849|99853|96019|96023", Arrays.asList(c2.c, c2.d));
    }

    @Rule(name="DMP Asthma-COPD {gnr} nur ein Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="96319|96323|96328")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, String string) {
        return patient.getLeistungCount(string, c2.c) > 1;
    }

    @Rule(name="DMP COPD Behandlungsintensiver Therapiekomplex (96357) nur einmal im Krankheitsfall bei h\u00f6hergradiger Einschr\u00e4nkung (unter 50 %) der FEV1 abrechenbar", action=ActionType.ENTFERNEN, gnr="96357")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient) {
        return patient.getLeistungCount("96357", c2.c) > 1 && patient.hasDiagnose("J44.90|J44.91", true, c2.c);
    }

    @Rule(name="DMP COPD Behandlungsintensiver Therapiekomplex (96357) nur bei h\u00f6hergradiger Einschr\u00e4nkung (unter 50 %) der FEV1 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="96357")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung("96357", c2.c) && !patient.hasDiagnose("J44.90|J44.91", true, c2.c);
    }

    @Rule(name="DMP Asthma Behandlungsintensiver Therapiekomplex (96357) nur einmal im Krankheitsfall bis zur Vollendung des 18. Lebensjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="96357", daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung("96357", c2.c, date) && patient.getLeistungCount("96357", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1 && patient.getAlterAnTag(date) < 18;
    }

    @Rule(name="DMP COPD Behandlungsintensiver Therapiekomplex (96357) einmal im Krankheitsfall m\u00f6glich", action=ActionType.POTENTIAL, gnr="96357")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung("96319|96323", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.hasDiagnose("J44.90|J44.91", true, c2.c);
    }

    @Rule(name="DMP Asthma Behandlungsintensiver Therapiekomplex (96357) einmal im Krankheitsfall bei Patienten unter 18 Jahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="96357")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung("96319|96323", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) && patient.getAlterAnTag(new Date()) < 18;
    }

    @Rule(name="DMP Asthma-COPD Diagnostik- und Therapie-Komplex (96356) nur einmal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="96356")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean B(c c2, Patient patient) {
        return patient.getLeistungCount("96356", Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1 && patient.hasLeistungOnScheinArt("96356", Arrays.asList(c2.c, c2.d, c2.e, c2.f), ContainerType.UEBERWEISUNG);
    }

    @Rule(name="DMP Asthma-COPD Diagnostik- und Therapie-Komplex (96356) nur auf \u00dcberweisung des Hausarztes abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="96356")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung("96356", c2.c) && patient.hasLeistungOnScheinArt("96356", c2.c, ContainerType.AMBULANT);
    }

    @Rule(name="DMP Osteoporose bei AOK, Knappschaft und IKK m\u00f6glich", action=ActionType.POTENTIAL, gnr="96419", apk=ApkModus.HA_ORTHO)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient) {
        if (!patient.hasIk(c)) {
            return false;
        }
        return !patient.hasLeistung("96419|96423", Arrays.asList(c2.c, c2.d, c2.e)) && patient.hasDiagnoseBeginntMit("M81", "G", Arrays.asList(c2.c, c2.d, c2.e));
    }

    @Rule(name="DMP Osteoporose Erst-/Folgedokumentation (96419/96423) nur bei Versicherten der AOK, Knappschaft und IKK abrechenbar", action=ActionType.ENTFERNEN, gnr="96419|96423")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && !patient.hasIk(c);
    }

    @Rule(name="DMP Osteoporose Betreuungsziffer (96428) nur bei Versicherten der AOK Sachsen-Anhalt abrechenbar", action=ActionType.ENTFERNEN, gnr="96428")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung("96428", c2.c) && !patient.hasIk(b);
    }

    @Rule(name="DMP Osteoporose Sturzanamnese und Folgeabsch\u00e4tzung (96427) nur einmal alle 3 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="96427")
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung("96427", c2.c) && patient.hasLeistung("96427", Quartal.getBisVorVorjahrOhneAq(c2.c));
    }

    @Rule(name="DMP Osteoporose Folgedokumentation (96423) nur 1 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="96423")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient) {
        return patient.getLeistungCount("96423", c2.c) > 1;
    }

    @Rule(name="DMP Osteoporose Pr\u00e4diagnostik-Komplex (96455) nur einmal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="96455")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung("96455", c2.c) && patient.getLeistungCount("96455", Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="DMP Osteoporose Pr\u00e4diagnostik-Komplex (96455) nur auf \u00dcberweisung des Hausarztes abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="96455")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        return patient.hasLeistung("96455", c2.c) && patient.getScheine(c2.c).stream().filter(schein -> schein.getArt() == ContainerType.AMBULANT).anyMatch(schein -> schein.hasLeistung("96455"));
    }

    @Rule(name="DMP Osteoporose Diagnostik- und Therapie-Komplex (96456) nur auf \u00dcberweisung des Hausarztes abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="96456")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung("96456", c2.c) && patient.getScheine(c2.c).stream().filter(schein -> schein.getArt() == ContainerType.AMBULANT).anyMatch(schein -> schein.hasLeistung("96456"));
    }

    @Rule(name="DMP Osteoporose Sturzanamnese und Folgeabsch\u00e4tzung (96427) nur auf \u00dcberweisung des Hausarztes abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="96427")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung("96427", c2.c) && patient.getScheine(c2.c).stream().filter(schein -> schein.getArt() == ContainerType.AMBULANT).anyMatch(schein -> schein.hasLeistung("96427"));
    }

    @Rule(name="DMP Osteoporose Diagnostik- und Therapie-Komplex (96456) nur zweimal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="96456")
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistung("96456", c2.c) && patient.getLeistungCount("96456", Quartal.getBisJahresanfang(c2.c)) > 2;
    }

    @Rule(name="DMP Osteoporose Sturzanamnese und Folgeabsch\u00e4tzung (96427) im Behandlungsfall nicht neben 03360 abrechenbar", action=ActionType.ENTFERNEN, gnr="96427")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient) {
        return patient.hasLeistung("96427", c2.c) && patient.hasLeistung("03360", c2.c);
    }

    @Rule(name="DMP Osteoporose Betreuungsziffer (96428) nicht neben Folgedokumentation abrechenbar", action=ActionType.ENTFERNEN, gnr="96428")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung("96428", c2.c) && patient.hasLeistung("96423", c2.c);
    }

    @Rule(name="DMP Osteoporose Dokumentation und Betreuung (96419-96428) nur mit entsprechender gesicherter Diagnose abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="96419|96423|96428")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && !patient.hasDiagnoseBeginntMit("M81", "G", c2.c);
    }

    @Rule(name="DMP-Osteoporose Dokumentations- und Betreuungsziffern nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="96423|96428")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, String string) {
        return patient.hasLeistung("96419", c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="DMP Osteoporose Betreuungsziffer (96428) im Behandlungsfall nicht neben 96423 abrechenbar", action=ActionType.ENTFERNEN, gnr="96428")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        return patient.hasLeistung("96428", c2.c) && patient.hasLeistung("96423", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsprogramm ohne Insulin (99820D) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820D")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient) {
        return patient.hasLeistung("99820D", c2.c) && !patient.hasLeistung("99821D", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99821D) ohne abgerechnetes Schulungsprogramm", action=ActionType.UEBERPRUEFEN, gnr="99821D")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung("99821D", c2.c) && !patient.hasLeistung("99820D", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsprogramm mit Insulin (99820C) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820C")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient) {
        return patient.hasLeistung("99820C", c2.c) && !patient.hasLeistung("99821C", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99821C) ohne abgerechnetes Schulungsprogramm", action=ActionType.UEBERPRUEFEN, gnr="99821C")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient) {
        return patient.hasLeistung("99821C", c2.c) && !patient.hasLeistung("99820C", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Behandlungs- und Schulungsprogramm mit Normalinsulin (99820B) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820B")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient) {
        return patient.hasLeistung("99820B", c2.c) && !patient.hasLeistung("99821B", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99821B) ohne abgerechnetes Behandlungs- und Schulungsprogramm", action=ActionType.UEBERPRUEFEN, gnr="99821B")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient) {
        return patient.hasLeistung("99821B", c2.c) && !patient.hasLeistung("99820B", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsprogramm MEDIAS 2 (99820E) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820E")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung("99820E", c2.c) && !patient.hasLeistung("99821E", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99821E) ohne abgerechnetes Schulungsprogramm MEDIAS 2", action=ActionType.UEBERPRUEFEN, gnr="99821E")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        return patient.hasLeistung("99821E", c2.c) && !patient.hasLeistung("99820E", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Diabetes II im Gespr\u00e4ch (99820H) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820H")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient) {
        return patient.hasLeistung("99820H", c2.c) && !patient.hasLeistung("99821H", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99821H) ohne abgerechnetes Schulungsprogramm Diabetes II im Gespr\u00e4ch", action=ActionType.UEBERPRUEFEN, gnr="99821H")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient) {
        return patient.hasLeistung("99821H", c2.c) && !patient.hasLeistung("99820H", c2.c);
    }

    @Rule(name="DMP DM Behandlungs- und Schulungsprogramm f\u00fcr intensivierte Insulintherapie (99820K) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820K")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Z(c c2, Patient patient) {
        return patient.hasLeistung("99820K", c2.c) && !patient.hasLeistung("99821K", c2.c);
    }

    @Rule(name="DMP DM Schulungsmaterial (99821K) ohne abgerechnetes Behandlungs- und Schulungsprogramm f\u00fcr intensivierte Insulintherapie", action=ActionType.UEBERPRUEFEN, gnr="99821K")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient) {
        return patient.hasLeistung("99821K", c2.c) && !patient.hasLeistung("99820K", c2.c);
    }

    @Rule(name="DMP DM LINDA Diabetes-Selbstmanagementschulung (99820M) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820M")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient) {
        return patient.hasLeistung("99820M", c2.c) && !patient.hasLeistung("99821M", c2.c);
    }

    @Rule(name="DMP DM Schulungsmaterial (99821M) ohne abgerechnete LINDA Diabetes-Selbstmanagementschulung", action=ActionType.UEBERPRUEFEN, gnr="99821M")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ac(c c2, Patient patient) {
        return patient.hasLeistung("99821M", c2.c) && !patient.hasLeistung("99820M", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Diabetes & Verhalten-Schulungsprogramm (99820A) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820A")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient) {
        return patient.hasLeistung("99820A", c2.c) && !patient.hasLeistung("99821A", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99821A) ohne abgerechnetes Diabetes & Verhalten-Schulungsprogramm", action=ActionType.UEBERPRUEFEN, gnr="99821A")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient) {
        return patient.hasLeistung("99821A", c2.c) && !patient.hasLeistung("99820A", c2.c);
    }

    @Rule(name="DMP DM Typ 2 DiSko-Schulung (99820F) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820F")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient) {
        return patient.hasLeistung("99820F", c2.c) && !patient.hasLeistung("99821F", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99821F) ohne abgerechnete DiSko-Schulung", action=ActionType.UEBERPRUEFEN, gnr="99821F")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient) {
        return patient.hasLeistung("99821F", c2.c) && !patient.hasLeistung("99820F", c2.c);
    }

    @Rule(name="DMP DM MEDIAS 2 ICT (99830B) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99830B")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ah(c c2, Patient patient) {
        return patient.hasLeistung("99830B", c2.c) && !patient.hasLeistung("99831B", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99831B) ohne abgerechnete MEDIAS 2 ICT", action=ActionType.UEBERPRUEFEN, gnr="99831B")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ai(c c2, Patient patient) {
        return patient.hasLeistung("99831B", c2.c) && !patient.hasLeistung("99830B", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Strukturiertes Geriatrisches Schulungsprogramm (99830A) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99830A")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aj(c c2, Patient patient) {
        return patient.hasLeistung("99830A", c2.c) && !patient.hasLeistung("99831A", c2.c);
    }

    @Rule(name="DMP DM Typ 2 Schulungsmaterial (99831A) ohne Strukturiertes Geriatrisches Schulungsprogramm", action=ActionType.UEBERPRUEFEN, gnr="99831A")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ak(c c2, Patient patient) {
        return patient.hasLeistung("99831A", c2.c) && !patient.hasLeistung("99830A", c2.c);
    }

    @Rule(name="DMP Hypertonie Behandlungs- und Schulungsprogramm (99820S) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820S")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean al(c c2, Patient patient) {
        return patient.hasLeistung("99820S", c2.c) && !patient.hasLeistung("99821S", c2.c);
    }

    @Rule(name="DMP Hypertonie Schulungsmaterial (99821S) ohne Behandlungs- und Schulungsprogramm", action=ActionType.UEBERPRUEFEN, gnr="99821S")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean am(c c2, Patient patient) {
        return patient.hasLeistung("99821S", c2.c) && !patient.hasLeistung("99820S", c2.c);
    }

    @Rule(name="DMP Gerinnungsselbstmanagementschulung SPOG (99820G) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820G")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean an(c c2, Patient patient) {
        return patient.hasLeistung("99820G", c2.c) && !patient.hasLeistung("99821G", c2.c);
    }

    @Rule(name="DMP Schulungsmaterial (99821G) ohne abgerechnetes Gerinnungsselbstmanagementschulung SPOG", action=ActionType.UEBERPRUEFEN, gnr="99821G")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ao(c c2, Patient patient) {
        return patient.hasLeistung("99821G", c2.c) && !patient.hasLeistung("99820G", c2.c);
    }

    @Rule(name="DMP Asthma NASA und AFAS Schulungsprogramm (99820R) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820R")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ap(c c2, Patient patient) {
        return patient.hasLeistung("99820R", c2.c) && !patient.hasLeistung("99821R", c2.c);
    }

    @Rule(name="DMP Asthma Schulungsmaterial (99821R) ohne abgerechnetes NASA und AFAS Schulungsprogramm", action=ActionType.UEBERPRUEFEN, gnr="99821R")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aq(c c2, Patient patient) {
        return patient.hasLeistung("99821R", c2.c) && !patient.hasLeistung("99820R", c2.c);
    }

    @Rule(name="DMP Asthma Qualit\u00e4tsmanagement in der Asthmaschulung von Kindern und Jugendlichen (99820Q) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820Q")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ar(c c2, Patient patient) {
        return patient.hasLeistung("99820Q", c2.c) && !patient.hasLeistung("99821Q", c2.c);
    }

    @Rule(name="DMP Asthma Schulungsmaterial (99821Q) ohne Qualit\u00e4tsmanagement in der Asthmaschulung von Kindern und Jugendlichen", action=ActionType.UEBERPRUEFEN, gnr="99821Q")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean as(c c2, Patient patient) {
        return patient.hasLeistung("99821Q", c2.c) && !patient.hasLeistung("99820Q", c2.c);
    }

    @Rule(name="DMP Asthma Schulung von Vorschulkindern (ASEV) (99830D) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99830D")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean at(c c2, Patient patient) {
        return patient.hasLeistung("99830D", c2.c) && !patient.hasLeistung("99831D", c2.c);
    }

    @Rule(name="DMP Asthma Schulungsmaterial (99831D) ohne Asthmaschulung von Vorschulkindern (ASEV)", action=ActionType.UEBERPRUEFEN, gnr="99831D")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean au(c c2, Patient patient) {
        return patient.hasLeistung("99831D", c2.c) && !patient.hasLeistung("99830D", c2.c);
    }

    @Rule(name="DMP COPD Ambulantes Schulungsprogramm COBRA und AFBE (99820T) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820T")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean av(c c2, Patient patient) {
        return patient.hasLeistung("99820T", c2.c) && !patient.hasLeistung("99821T", c2.c);
    }

    @Rule(name="DMP COPD Schulungsmaterial (99821T) ohne Ambulantes Schulungsprogramm COBRA und AFBE", action=ActionType.UEBERPRUEFEN, gnr="99821T")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aw(c c2, Patient patient) {
        return patient.hasLeistung("99821T", c2.c) && !patient.hasLeistung("99820T", c2.c);
    }

    @Rule(name="DMP COPD Schulung Chr. Bronchitis und Lungenemphysem nach dem Bad Reichenhaller Modell (99820X) ohne Schulungsmaterial", action=ActionType.UEBERPRUEFEN, gnr="99820X")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ax(c c2, Patient patient) {
        return patient.hasLeistung("99820X", c2.c) && !patient.hasLeistung("99821X", c2.c);
    }

    @Rule(name="DMP COPD Schulungsmaterial (99821X) ohne Schulung Chr. Bronchitis und Lungenemphysem nach dem Bad Reichenhaller Modell", action=ActionType.UEBERPRUEFEN, gnr="99821X")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ay(c c2, Patient patient) {
        return patient.hasLeistung("99821X", c2.c) && !patient.hasLeistung("99820X", c2.c);
    }
}

