/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ScheinDiagnose {
    public static final Comparator<ScheinDiagnose> DEFAULT_ORDER = Comparator.comparing(ScheinDiagnose::getIcdCodeClean, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(ScheinDiagnose::getSicherheit, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ScheinDiagnose::getLokalisation, Comparator.nullsLast(Comparator.naturalOrder()));
    private String icdCode;
    private String icdCodeClean = "";
    private String sicherheit;
    private String lokalisation;
    private List<String> erlauterungen = new ArrayList<String>();

    public String getIcdCode() {
        return this.icdCode;
    }

    @JsonIgnore
    public String getIcdCodeClean() {
        return this.icdCodeClean;
    }

    public void setIcdCode(String icdCode) {
        this.icdCode = icdCode;
        if (icdCode != null) {
            this.icdCodeClean = icdCode.replace("-", "");
        }
    }

    public String getSicherheit() {
        return this.sicherheit;
    }

    public void setSicherheit(String sicherheit) {
        this.sicherheit = sicherheit;
    }

    public String getLokalisation() {
        return this.lokalisation;
    }

    public void setLokalisation(String lokalisation) {
        this.lokalisation = lokalisation;
    }

    public List<String> getErlauterungen() {
        return this.erlauterungen;
    }

    public String toString() {
        return this.icdCode + " " + this.lokalisation + " " + this.sicherheit;
    }

    boolean isGesichert() {
        return "G".equals(this.sicherheit);
    }
}

