/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.importer;

import com.nhochdrei.kvdt.importer.AbrechnungImportException;
import com.nhochdrei.kvdt.importer.AbrechnungImporterSettings;
import com.nhochdrei.kvdt.importer.AbstractFileImporter;
import com.nhochdrei.kvdt.importer.ContainerType;
import com.nhochdrei.kvdt.importer.FieldType;
import com.nhochdrei.kvdt.model.AbrechnungType;
import com.nhochdrei.kvdt.model.Arzt;
import com.nhochdrei.kvdt.model.Betriebssteatte;
import com.nhochdrei.kvdt.model.ConFile;
import com.nhochdrei.kvdt.model.OPS;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.Schein;
import com.nhochdrei.kvdt.model.ScheinDiagnose;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class KVDTImport
extends AbstractFileImporter {
    private Map<String, String> d;
    private Quartal e = null;
    private ConFile f = null;
    private ContainerType g = null;
    private String h = null;
    private Betriebssteatte i = null;
    private Arzt j = null;
    private Schein k = null;
    private Date l = null;
    private ScheinLeistung m = null;
    private ScheinDiagnose n = null;
    private OPS o = null;
    private final SimpleDateFormat p = new SimpleDateFormat("yyyyMMdd");
    private boolean q = false;

    @Override
    public void process(File file, InputStream input, AbrechnungImporterSettings settings) throws AbrechnungImportException {
        this.d = settings.getBetriebsstaettenMapping();
        this.a();
        this.f = new ConFile();
        this.f.setFile(file);
        this.f.setAbrechnungsType(AbrechnungType.GKV);
        int n2 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), Charset.forName("ISO-8859-15")));){
            bufferedReader.mark(4);
            int n3 = bufferedReader.read();
            if (n3 != 65279) {
                int n4 = bufferedReader.read();
                int n5 = bufferedReader.read();
                if (239 != n3 || 187 != n4 || 191 != n5) {
                    bufferedReader.reset();
                }
            }
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                ++n2;
                if (string.isEmpty()) continue;
                String string2 = string.substring(3, 7);
                String string3 = string.substring(7);
                try {
                    this.a(FieldType.get(string2), string3);
                }
                catch (ParseException parseException) {
                    throw new AbrechnungImportException("Feld " + string2 + " " + (Object)((Object)FieldType.get(string2)) + " konnte nicht geparst werden: " + string3, parseException);
                }
                if (!settings.isOnlyMetadata() || !this.q) continue;
                break;
            }
            if (this.b) {
                this.a(this.f);
            }
        }
        catch (AbrechnungImportException abrechnungImportException) {
            throw abrechnungImportException;
        }
        catch (Exception exception) {
            throw new AbrechnungImportException("Fehler beim Einlesen der KVDT-Datei: " + file.getName() + " in Zeile " + n2, exception);
        }
    }

    private void a() {
        this.g = null;
        this.h = null;
        this.i = null;
        this.j = null;
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = null;
        this.q = false;
        this.o = null;
    }

    private void a(FieldType fieldType, String string) throws ParseException {
        if (fieldType == FieldType.SATZART) {
            if (this.g != null) {
                this.c();
            }
            this.g = ContainerType.get(string);
            this.b();
            return;
        }
        switch (this.g) {
            case BETRIEBSSTAETTENDATEN: {
                this.c(fieldType, string);
                break;
            }
            case CON0: 
            case ADT0: {
                this.b(fieldType, string);
                break;
            }
            case AMBULANT: 
            case UEBERWEISUNG: 
            case BELEG_BEHANDLUNG: 
            case NOTFALL: {
                this.d(fieldType, string);
                break;
            }
        }
    }

    private void b() {
        switch (this.g) {
            case AMBULANT: 
            case UEBERWEISUNG: 
            case BELEG_BEHANDLUNG: 
            case NOTFALL: {
                this.k = new Schein();
                this.k.setArt(this.g);
                this.k.setAbrechnungBsnr(this.h);
                if (!this.b) break;
                this.f.getScheine().add(this.k);
                break;
            }
        }
    }

    private void c() {
        switch (this.g) {
            case ADT0: {
                if (this.c == null) break;
                this.c.accept(this.f);
                for (Betriebssteatte betriebssteatte : this.f.getBetriebsstaetten().values()) {
                    this.c.accept(betriebssteatte);
                }
                break;
            }
            case AMBULANT: 
            case UEBERWEISUNG: 
            case BELEG_BEHANDLUNG: 
            case NOTFALL: {
                if (this.c == null) break;
                this.c.accept(this.k);
                break;
            }
        }
    }

    private void b(FieldType fieldType, String string) throws ParseException {
        switch (fieldType) {
            case CON0_ERSTELLUNGSDATUM: {
                this.f.setErstellungsdatum(this.p.parse(string));
                this.d();
                break;
            }
            case ABRECHNUNGSQUARTAL: {
                Quartal quartal = Quartal.get(string);
                this.f.setAbrechnungsquartal(quartal);
                if (this.e == null || quartal.compareTo(this.e) > 0) {
                    this.e = quartal;
                }
                this.d();
                break;
            }
        }
    }

    private void c(FieldType fieldType, String string) {
        switch (fieldType) {
            case BETRIEBSSTAETTE_BSNR: {
                if (this.h == null) {
                    this.h = this.d.get(string);
                }
                if (this.f.getBetriebsstaetten().containsKey(string)) {
                    this.i = this.f.getBetriebsstaetten().get(string);
                    break;
                }
                this.i = new Betriebssteatte();
                this.i.setBsnr(string);
                this.f.addBetriebsstaette(string, this.i);
                this.d();
                break;
            }
            case BETRIEBSSTAETTE_BEZEICHNUNG: {
                this.i.setBezeichnung(string);
                break;
            }
            case BETRIEBSSTAETTE_PLZ: {
                this.i.setPlz(string);
                break;
            }
            case ARZT_LANR: {
                if (this.i.getAerzte().containsKey(string)) {
                    this.j = this.i.getAerzte().get(string);
                    break;
                }
                this.j = new Arzt();
                this.j.setLanr(string);
                this.i.getAerzte().put(string, this.j);
                break;
            }
            case ARZT_TITEL: {
                this.j.setTitel(string);
                break;
            }
            case ARZT_VORNAME: {
                this.j.setVorname(string);
                break;
            }
            case ARZT_NAMENSZUSATZ: {
                this.j.setNamenszusatz(string);
                break;
            }
            case ARZT_NAME: {
                this.j.setName(string);
                break;
            }
        }
    }

    private void d(FieldType fieldType, String string) throws ParseException {
        switch (fieldType) {
            case SCHEIN_QUARTAL: {
                this.k.setQuartal(Quartal.get(string));
                break;
            }
            case SCHEIN_ABRECHNUNGS_VKNR: {
                this.k.setAbrechnungsVknr(string);
                break;
            }
            case SCHEIN_KOSTENTRAEGER_KENNUNG: {
                this.k.setKostentraegerKennung(string);
                break;
            }
            case SCHEIN_KOSTENTRAEGER_NAME: {
                this.k.setKostentraegerName(string);
                break;
            }
            case SCHEIN_KOSTENTRAEGER_ABRECHNUNGSBEREICH: {
                this.k.setKostentraegerAbrechnungsbereich(string);
                break;
            }
            case SCHEIN_BESONDERE_PERSONENGRUPPE: {
                this.k.setBesonderePersonengruppe(string);
                break;
            }
            case SCHEIN_SKT_ZUSATZANGABEN: {
                this.k.setSktZusatzangaben(string);
                break;
            }
            case SCHEIN_UNTERGRUPPE: {
                this.k.setUntergruppe(string);
                break;
            }
            case SCHEIN_TSVG_VERMITTLUNG_KONTAKTART: {
                this.k.setTsvg(string);
                break;
            }
            case SCHEIN_AUSSTELLUNGSDATUM: {
                this.k.setAusstellungsdatum(this.p.parse(string));
                break;
            }
            case PATIENT_NUMMER: {
                this.k.setPatientNummer(string);
                break;
            }
            case PATIENT_VERSICHERTEN_ID: {
                this.k.setPatientVersichertenId(string);
                break;
            }
            case PATIENT_VERSICHERTEN_ART: {
                this.k.setPatientVersichertenArt(string);
                break;
            }
            case PATIENT_NAME: {
                this.k.setPatientName(string);
                break;
            }
            case PATIENT_VORNAME: {
                this.k.setPatientVorname(string);
                break;
            }
            case PATIENT_GEBURTSDATUM: {
                this.k.setPatientGeburtsdatum(this.p.parse(string));
                break;
            }
            case PATIENT_PLZ: {
                this.k.setPatientPlz(string);
                break;
            }
            case PATIENT_ORT: {
                this.k.setPatientOrt(string);
                break;
            }
            case PATIENT_STRASSE: {
                this.k.setPatientStrasse(string);
                break;
            }
            case PATIENT_GESCHLECHT: {
                this.k.setPatientGeschlecht(string);
                break;
            }
            case SCHEIN_UEBERWEISER_BSNR: {
                this.k.setUeberweiserBsnr(string);
                break;
            }
            case SCHEIN_UEBERWEISER_LANR: {
                this.k.setUeberweiserLanr(string);
                break;
            }
            case SCHEIN_UEBERWEISUNG_AN: {
                this.k.setUeberweisungAn(string);
                break;
            }
            case LEISTUNG_TAG: {
                this.l = this.p.parse(string);
                break;
            }
            case LEISTUNG_GNR: {
                this.m = new ScheinLeistung();
                this.k.getLeistungen().add(this.m);
                this.m.setGnr(string);
                this.m.setDatum(this.l);
                this.m.setSachkosten(0);
                break;
            }
            case LEISTUNG_ASVTEAMNUMMER: {
                this.m.setAsvteamnummer(string);
                break;
            }
            case LEISTUNG_BSNR: {
                this.m.setBsnr(string);
                break;
            }
            case LEISTUNG_LANR: {
                this.m.setLanr(string);
                break;
            }
            case LEISTUNG_ART: {
                this.m.setArt(string);
                break;
            }
            case LEISTUNG_MULTIPLIKATOR: {
                this.m.setMultiplikator(Integer.parseInt(string));
                break;
            }
            case LEISTUNG_OPSCHLUESSEL: {
                this.o = new OPS();
                this.o.setOpSchluessel(string);
                this.m.getOpSchluessel().add(this.o);
                break;
            }
            case LEISTUNG_SEITENLOKALISATIONOPS: {
                this.o.setSeitenLokalisation(string);
                break;
            }
            case LEISTUNG_SACHKOSTEN: {
                this.m.setSachkosten(this.m.getSachkosten() + Integer.valueOf(string));
                break;
            }
            case LEISTUNG_UMUHRZEIT: {
                this.m.setUhrzeit(string);
                break;
            }
            case DIAGNOSE_ICD: 
            case DAUERDIAGNOSE_ICD: {
                this.n = new ScheinDiagnose();
                this.n.setIcdCode(string);
                if (fieldType == FieldType.DIAGNOSE_ICD) {
                    this.k.getDiagnosen().add(this.n);
                    break;
                }
                this.k.getDauerdiagnosen().add(this.n);
                break;
            }
            case DIAGNOSE_SICHERHEIT: 
            case DAUERDIAGNOSE_SICHERHEIT: {
                this.n.setSicherheit(string);
                break;
            }
            case DIAGNOSE_LOKALISATION: 
            case DAUERDIAGNOSE_LOKALISATION: {
                this.n.setLokalisation(string);
                break;
            }
            case DIAGNOSE_ERLAUTERUNG: 
            case DAUERDIAGNOSE_ERLAUTERUNG: {
                this.n.getErlauterungen().add(string);
                break;
            }
        }
    }

    private void d() {
        if (this.f.getAbrechnungsquartal() != null && this.f.getFirstBsnr() != null && this.f.getErstellungsdatum() != null) {
            this.q = true;
        }
    }

    @Override
    public boolean canReadFile(File file) {
        String string = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            bufferedReader.mark(4);
            int n2 = bufferedReader.read();
            if (n2 != 65279) {
                int n3 = bufferedReader.read();
                int n4 = bufferedReader.read();
                if (239 != n2 || 187 != n3 || 191 != n4) {
                    bufferedReader.reset();
                }
            }
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return false;
        }
        if (string == null) {
            return false;
        }
        return "0138000con0".equals(string);
    }
}

