/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.data;

import com.nhochdrei.kvdt.data.b;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBM {
    private static final Logger a = LoggerFactory.getLogger(EBM.class);
    private static Map<String, b> b = new HashMap<String, b>();
    private static Set<String> c = new HashSet<String>();

    private EBM() {
    }

    public static void reset() {
        b.clear();
        c.clear();
    }

    public static void load(String kv) {
        a.info("EBM laden: " + kv);
        EBM.load(EBM.class.getClassLoader().getResourceAsStream("EBM/" + kv + ".csv"));
        a.info("APK laden: " + kv);
        EBM.loadAPK(EBM.class.getClassLoader().getResourceAsStream("EBM/APK/" + kv + "APK.csv"));
    }

    public static void load(InputStream input) {
        if (!b.isEmpty()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(input)));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                int n2 = string.indexOf(59);
                String string2 = string.substring(0, n2);
                b.put(string2, new b(string.substring(n2 + 1)));
            }
        }
        catch (Exception exception) {
            a.error("Fehler beim Laden des EBM", (Throwable)exception);
        }
    }

    public static void loadAPK(InputStream input) {
        String string;
        BufferedReader bufferedReader;
        if (!c.isEmpty()) {
            return;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(EBM.class.getClassLoader().getResourceAsStream("EBM/APK/BundesweitAPK.csv"))));
            string = "";
            while ((string = bufferedReader.readLine()) != null) {
                c.add(string);
            }
        }
        catch (Exception exception) {
            a.error("Fehler beim Laden der bundesweiten APK", (Throwable)exception);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(input)));
            string = "";
            while ((string = bufferedReader.readLine()) != null) {
                c.add(string);
            }
        }
        catch (Exception exception) {
            a.error("Fehler beim Laden der regionalen APK", (Throwable)exception);
        }
    }

    public static Float getWert(String gnr) {
        if (gnr == null || gnr.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        gnr = gnr.replace("/", "|");
        if (!b.containsKey(gnr = gnr.split("[|]")[0])) {
            a.warn("Ziffer {} nicht im EBM-Katalog", (Object)gnr);
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(b.get(gnr).a());
    }

    public static int getZeitTag(String gnr) {
        if (gnr == null || gnr.isEmpty()) {
            return 0;
        }
        gnr = gnr.replace("/", "|");
        if (!b.containsKey(gnr = gnr.split("[|]")[0])) {
            a.warn("Ziffer {} nicht im EBM-Katalog (Pr\u00fcfzeit-Tag ben\u00f6tigt)", (Object)gnr);
            return 0;
        }
        return b.get(gnr).b();
    }

    public static int getZeitQuartal(String gnr) {
        if (gnr == null || gnr.isEmpty()) {
            return 0;
        }
        gnr = gnr.replace("/", "|");
        if (!b.containsKey(gnr = gnr.split("[|]")[0])) {
            a.warn("Ziffer {} nicht im EBM-Katalog (Pr\u00fcfzeit-Quartal ben\u00f6tigt)", (Object)gnr);
            return 0;
        }
        return b.get(gnr).c();
    }

    public static List<String> listGnrStartWith(String gnr) {
        return b.keySet().stream().filter(string2 -> string2.startsWith(gnr)).collect(Collectors.toList());
    }

    public static List<String> listGnrStartWithHzv(String gnr, String hzv) {
        return b.keySet().stream().filter(string3 -> string3.startsWith(gnr) && string3.endsWith(hzv)).map(string -> string.substring(0, string.indexOf("-"))).collect(Collectors.toList());
    }

    public static String getHausarztPauschalen() {
        return "0300";
    }

    public static String getGrundpauschalen() {
        return "03001|03002|03003|03004|03005|03030|04001|04002|04003|04004|04005|04030|01320|01321|01700|01701|05210|05211|05212|06210|06211|06212|07210|07211|07212|08210|08211|08212|09210|09211|09212|10210|10211|10212|11210|11211|11212|11301|12220|12225|13210|13211|13212|13290|13291|13292|13340|13341|13342|13390|13391|13392|13490|13491|13492|13540|13541|13542|13590|13591|13592|13640|13641|13642|13690|13691|13692|14210|14211|15210|15211|15212|16210|16211|16212|18210|18211|18212|19401|19403|20210|20211|20212|21210|21211|21212|21213|21214|21215|22210|22211|22212|23210|23211|23212|23214|26210|26211|26212|27210|27211|27212|30700";
    }

    public static Set<String> getApks() {
        return c;
    }
}

