/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.n.a;

import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.HZV)
public class a {
    private static final String a = "102122557|103725364|106431572|101931440|105723301|101922757|102031410|103526615|107832012|108036577|107829563|102122660|103523440|106329225|108035612|106492393|102137985|108036441";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Sachsen");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BUNDESWEIT_BKKSPECTRUM);
    }

    @Rule(name="HzV spectrumK Behandlungspauschale Chroniker (0003) 1 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV spectrumK Behandlungspauschale Chroniker (0003) nur vom Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV spectrumK Behandlungspauschale Chroniker (0003) ben\u00f6tigt mind. 1 Arzt-Patienten-Kontakt", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0003"), c2.c);
    }

    @Rule(name="HzV spectrumK Behandlungspauschale Chroniker (0003) ben\u00f6tigt eine Chroniker Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        if (patient.hasDiagnose(com.nhochdrei.kvdt.data.a.m(), "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0003"), c2.c);
    }

    @Rule(name="HzV spectrumK Behandlungspauschale Chroniker (0003) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0003|0004|0005"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.hasDiagnose(com.nhochdrei.kvdt.data.a.m(), "G", c2.c);
    }

    @Rule(name="HzV spectrumK Vertreterpauschale (0004) nur 1 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV spectrumK Vertreterpauschale (0004) am Behandlungstag nicht mit Zielauftragspauschale (0005) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Vertreterpauschale (0004) ben\u00f6tigt mind. 1 Arzt-Patienten-Kontakt", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004"), c2.c);
    }

    @Rule(name="HzV spectrumK Zielauftragspauschale (0005) ben\u00f6tigt mind. 1 Arzt-Patienten-Kontakt", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0005"), c2.c);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme I (01100) nur in Ausnahmef\u00e4llen am Behandlungstag mehrfach abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100"), c2.c, date) && patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100"), c2.c, date) > 1;
    }

    @Rule(name="HzV spectrumK Zielauftragspauschale (0005) am Behandlungstag nicht neben Unvorhergesehene Inanspruchnahme I und II abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100|0110B|01100C|01101|01101B|01101C"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme I (2. am gleichen Tag) in 01100B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100"), c2.c, date) == 2;
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme I (3. am gleichen Tag) in 01100C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="01100/01100B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100|01100B"), c2.c, date) == 3;
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme I (01100B) (2. am gleichen Tag) nur neben 01100 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100B"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme I (01100C) (3. am gleichen Tag) nur neben 01100B abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100B"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01100C"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme II (01101) in Ausnahmef\u00e4llen am Behandlungstag mehrfach abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101"), c2.c, date) && patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101"), c2.c, date) > 1;
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme II (2. am gleichen Tag) (01101B) nur neben 01101 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101B"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme II (3. am gleichen Tag) (01101C) nur neben 01101B abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101B"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101C"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme II (2. am gleichen Tag) in 01101B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101"), c2.c, date) == 2;
    }

    @Rule(name="HzV spectrumK Unvorhergesehene Inanspruchnahme II (3. am gleichen Tag) in 01101C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="01101/01101B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01101|01101B"), c2.c, date) == 3;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff h\u00f6chstens 5 mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="02300/02301/02302/02300B/02301B/02302B/02300C/02301C/02302C/02300D/02301D/02302D/02300E/02301E/02302E", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean m(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300|02301|02302|02300B|02301B|02302B|02300C|02301C|02302C|02300D|02301D|02302D|02300E|02301E|02302E"), c2.c, date) > 5;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff am Behandlungstag mehrfach nebeneinander ohne entsprechende Diagnose nicht abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02300/02301/02302/02300B/02301B/02302B/02300C/02301C/02302C/02300D/02301D/02302D/02300E/02301E/02302E", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        if (patient.hasDiagnose("D22.0|D22.1|D22.2|D22.3|D22.4|D22.5|D22.6|D22.7|D22.9|T01.0|T01.1|T01.2|T01.3|T01.6|T01.8|T01.9", "G", c2.c)) {
            return false;
        }
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300|02301|02302|02300B|02301B|02302B|02300C|02301C|02302C|02300D|02301D|02302D|02300E|02301E|02302E"), c2.c, date) > 1;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I (02300) zweiter Eingriff in 02300B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02300", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300"), c2.c, date) && patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300"), c2.c, date) == 2;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I zweiter Eingriff (02300B) nur neben 02300 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02300B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300B"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I dritter Eingriff in 02300C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02300/02300B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300|02300B"), c2.c, date) == 3;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I vierter Eingriff in 02300D umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02300/02300B/02300C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300|02300B|02300C"), c2.c, date) == 4;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I f\u00fcnfter Eingriff in 02300E umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02300/02300B/02300C/02300D", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300|02300B|02300C|02300D"), c2.c, date) == 5;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II (02301) zweiter Eingriff in 02301B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02301", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301"), c2.c, date) && patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301"), c2.c, date) == 2;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II zweiter Eingriff (02301B) nur neben 02301 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02301B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301B"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II dritter Eingriff in 02301C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02301/02301B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301|02301B"), c2.c, date) == 3;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II vierter Eingriff in 02301D umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02301/02301B/02301C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301|02301B|02301C"), c2.c, date) == 4;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II f\u00fcnfter Eingriff in 02301E umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02301/02301B/02301C/02301D", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301|02301B|02301C|02301D"), c2.c, date) == 5;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff III (02302) zweiter Eingriff in 02302B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02302", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302"), c2.c, date) && patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302"), c2.c, date) == 2;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff III zweiter Eingriff (02302B) nur neben 02302 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02302B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302B"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff III dritter Eingriff in 02302C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02302/02302B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302|02302B"), c2.c, date) == 3;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff III vierter Eingriff in 02302D umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02302/02302B/02302C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302|02302B|02302C"), c2.c, date) == 4;
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff III f\u00fcnfter Eingriff in 02302E umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02302/02302B/02302C/02302D", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302|02302B|02302C|02302D"), c2.c, date) == 5;
    }

    @Rule(name="HzV spectrumK Haus\u00e4rztlichgeriatrisches Basisassessment (03240) h\u00f6chstens 2 Mal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("03240"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="HzV spectrumK Haus\u00e4rztlichgeriatrisches Basisassessment (03240) nur bei Patienten ab dem 61. Lebensjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("03240"), c2.c, date) && patient.getAlterAnTag(date) < 60;
    }

    @Rule(name="HzV spectrumK Haus\u00e4rztlichgeriatrisches Basisassessment (03240) max. 1 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean E(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("03240"), c2.c, date) > 1;
    }

    @Rule(name="HzV spectrumK Schilddr\u00fcsen-Sonographie (33012) max. 1 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="33012", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("33012"), c2.c, date) > 1;
    }

    @Rule(name="HzV spectrumK Abdominelle Sonographie (33042) max. 1 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean G(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("33042"), c2.c, date) > 1;
    }

    @Rule(name="HzV spectrumK Abdominelle Sonographie (33042) h\u00f6chstens 2 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("33042"), c2.c) > 2;
    }

    @Rule(name="HzV spectrumK Verbale Intervention (35110) am Behandlungstag nicht neben Differentialdiagnostische Kl\u00e4rung psychosomatischer Krankheitszust\u00e4nde (35100) abrechenbar", action=ActionType.ENTFERNEN, gnr="35110", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35100"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Verbale Intervention bei psychosomatischen Krankheitszust\u00e4nden (35110) 2. Intervention als 35110B zu dokumentieren", action=ActionType.UEBERPRUEFEN, gnr="35110", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110"), c2.c, date) == 2;
    }

    @Rule(name="HzV spectrumK Verbale Intervention bei psychosomatischen Krankheitszust\u00e4nden (35110) 3. Intervention als 35110C zu dokumentieren", action=ActionType.UEBERPRUEFEN, gnr="35110", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110|35110B"), c2.c, date) == 3;
    }

    @Rule(name="HzV spectrumK Videosprechstunde (OVS) nur 1 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="OVS", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("OVS"), c2.c) > 1;
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) nur 1 Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) f\u00fcr Versicherte ab 45 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) am Behandlungstag nicht neben 0004 und 0005 abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) 1 Mal im Kalenderjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean n(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.getGeschlecht().equals("M") && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterAnTag(new Date()) > 44;
    }

    @Rule(name="HzV spectrumK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) nur f\u00fcr M\u00e4nner abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        return !patient.getGeschlecht().equals("M") && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01731"), c2.c);
    }

    @Rule(name="HzV spectrumK Gesundheitsuntersuchung (01732) nur 1 Mal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Gesundheitsuntersuchung (01732) 1 Mal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean q(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterAnTag(new Date()) > 34;
    }

    @Rule(name="HzV spectrumK Gesundheitsuntersuchung (01732) f\u00fcr Versicherte erst ab 35 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV spectrumK Gesundheitsuntersuchung (01732) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV spectrumK Beratung zur Fr\u00fcherkennung des kolorektalen Karzinoms (01740) nur einmalig je Versicherten ab 50 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01740", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01740"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01740"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Beratung zur Fr\u00fcherkennung des kolorektalen Karzinoms (01740) nur f\u00fcr Versicherte ab 50 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="01740", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01740"), c2.c, date) && patient.getAlterAnTag(date) < 50;
    }

    @Rule(name="HzV spectrumK Hautkrebsscreening (01745) am Behandlungstag nicht neben 0004/0005/01732 abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005|01732"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Hautkrebsscreening (01745) nur 1 Mal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Hautkrebsscreening (01745) 1 Mal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean u(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732|01746"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterAnTag(new Date()) > 34;
    }

    @Rule(name="HzV spectrumK Hautkrebsscreening (01745) nur f\u00fcr Versicherte ab 35 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV spectrumK Hautkrebsscreening (01745) innerhalb von 2 Kalenderjahren nicht neben 01746 abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01745"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), Quartal.getBisVorjahr(c2.c));
    }

    @Rule(name="HzV spectrumK Zuschlag HKS zur 01732 (01746) nur von Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV spectrumK Zuschlag HKS (01746) nur 1 Mal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Zuschlag HKS (01746) 1 Mal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean y(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746|01745"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01746|01745", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0004|0005"), c2.c)) {
            return false;
        }
        return patient.getAlterAnTag(new Date()) > 34;
    }

    @Rule(name="HzV spectrumK Zuschlag HKS (01746) nur f\u00fcr Versicherte ab 35 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV spectrumK Zuschlag HKS (01746) nur neben 01732 abrechenbar", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01732"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01746"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Erweitertes Neugeborenenscreening (01707) 1 Mal bis 5. Lebenswoche m\u00f6glich", action=ActionType.POTENTIAL, gnr="01707", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean z(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) < 36;
    }

    @Rule(name="HzV spectrumK Erweitertes Neugeborenenscreening (01707) nur 1 Mal bis 5. Lebenswoche abrechenbar", action=ActionType.ENTFERNEN, gnr="01707", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Erweitertes Neugeborenenscreening (01707) nur bis 5. Lebenswoche abrechenbar", action=ActionType.ENTFERNEN, gnr="01707", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), c2.c, date) && patient.getAlterInTage(date) > 35;
    }

    @Rule(name="HzV spectrumK Erweitertes Neugeborenenscreening (01707) im Behandlungsfall nicht neben 01709 abrechenbar", action=ActionType.ENTFERNEN, gnr="01709", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01709"), c2.c);
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U1 (01711) nur 1 Mal bis 2. Lebenstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01711"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01711"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U1 (01711) 1 Mal bis 2. Lebenstag m\u00f6glich", action=ActionType.POTENTIAL, gnr="01711", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean D(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01711"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) < 3;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U1 (01711) nur bis 2. Lebenstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01711"), c2.c, date) && patient.getAlterInTage(date) > 2;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U2 (01712) am 3. bis 14. Lebenstag m\u00f6glich", action=ActionType.POTENTIAL, gnr="01712", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean E(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 2 && patient.getAlterInTage(new Date()) < 15;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U2 (01712) nur 1 Mal bis 14. Lebenstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U2 (01712) nur bis 14. Lebenstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), c2.c, date) && patient.getAlterInTage(date) > 14;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U2 (01712) erst ab 3. Lebenstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01712"), c2.c, date) && patient.getAlterInTage(date) < 3;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U3 (01713) in der 3. bis 8. Lebenswoche m\u00f6glich", action=ActionType.POTENTIAL, gnr="01713", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean G(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 14 && patient.getAlterInTage(new Date()) < 60;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U3 (01713) nur 1 Mal bis 8. Lebenswoche abrechenbar", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U3 (01713) nur bis 8. Lebenswoche abrechenbar", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), c2.c, date) && patient.getAlterInTage(date) > 59;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U3 (01713) erst ab 3. Lebenswoche abrechenbar", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01713"), c2.c, date) && patient.getAlterInTage(date) < 14;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U4 (01714) im 2. bis 4,5. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01714", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean I(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), Arrays.asList(c2.c, c2.d, c2.e))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 29 && patient.getAlterInTage(new Date()) < 136;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U4 (01714) nur 1 Mal bis 4,5. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean J(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U4 (01714) nur bis 4,5. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), c2.c, date) && patient.getAlterInTage(date) > 135;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U4 (01714) erst ab 2. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Z(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01714"), c2.c, date) && patient.getAlterInTage(date) < 30;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U5 (01715) im 5. bis 8. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01715", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean K(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), Arrays.asList(c2.c, c2.d, c2.e))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 119 && patient.getAlterInTage(new Date()) < 240;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U5 (01715) nur 1 Mal bis 8. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean L(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U5 (01715) nur bis 8. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), c2.c, date) && patient.getAlterInTage(date) > 239;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U5 (01715) erst ab 5. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01715"), c2.c, date) && patient.getAlterInTage(date) < 120;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U6 (01716) im 9. bis 14. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01716", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean M(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), Arrays.asList(c2.c, c2.d, c2.e))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 239 && patient.getAlterInTage(new Date()) < 420;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U6 (01716) nur 1 Mal bis 14. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean N(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U6 (01716) nur bis 14. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ac(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), c2.c, date) && patient.getAlterInTage(date) > 419;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U6 (01716) erst ab 9. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01716"), c2.c, date) && patient.getAlterInTage(date) < 240;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7 (01717) im 20. bis 27. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean O(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), Arrays.asList(c2.c, c2.d, c2.e, c2.f))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 569 && patient.getAlterInTage(new Date()) < 810;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7 (01717) nur 1 Mal bis 27. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean P(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7 (01717) nur bis 27. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), c2.c, date) && patient.getAlterInTage(date) > 809;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7 (01717) erst ab 20. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01717"), c2.c, date) && patient.getAlterInTage(date) < 570;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7a (01723) im 33. bis 38. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean Q(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), Arrays.asList(c2.c, c2.d, c2.e))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 959 && patient.getAlterInTage(new Date()) < 1140;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7a (01723) nur 1 Mal bis 38. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean R(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7a (01723) nur bis 38. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), c2.c, date) && patient.getAlterInTage(date) > 1139;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U7a (01723) erst ab 33. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ah(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01723"), c2.c, date) && patient.getAlterInTage(date) < 960;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U8 (01718) im 43. bis 50. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean S(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), Arrays.asList(c2.c, c2.d, c2.e))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 1259 && patient.getAlterInTage(new Date()) < 1500;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U8 (01718) nur 1 Mal bis 50. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean T(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U8 (01718) nur bis 50. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ai(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), c2.c, date) && patient.getAlterInTage(date) > 1499;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U8 (01718) erst ab 43. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aj(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01718"), c2.c, date) && patient.getAlterInTage(date) < 1260;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U9 (01719) im 58. bis 66. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean U(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e, c2.f))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterInTage(new Date()) > 1709 && patient.getAlterInTage(new Date()) < 1980;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U9 (01719) nur 1 Mal bis 66. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean V(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U9 (01719) nur bis 66. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ak(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), c2.c, date) && patient.getAlterInTage(date) > 1979;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U9 (01719) erst ab 58. Lebensmonat abrechenbar", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean al(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01719"), c2.c, date) && patient.getAlterInTage(date) < 1710;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U10 bei 7-8 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="U10", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean W(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterAnTag(new Date()) > 6 && patient.getAlterAnTag(new Date()) < 9;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U10 nur 1 Mal bis 8 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="U10", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean X(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U10 nur bis 8 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="U10", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean am(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), c2.c, date) && patient.getAlterAnTag(date) > 8;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U10 erst ab 7 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="U10", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean an(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U10"), c2.c, date) && patient.getAlterAnTag(date) < 7;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U11 bei 9-10 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean Y(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterAnTag(new Date()) > 8 && patient.getAlterAnTag(new Date()) < 11;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U11 nur 1 Mal bis 10 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean Z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U11 nur bis 10 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ao(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), c2.c, date) && patient.getAlterAnTag(date) > 10;
    }

    @Rule(name="HzV spectrumK Kindervorsorgeuntersuchung U11 erst ab 9 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="U11", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ap(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("U11"), c2.c, date) && patient.getAlterAnTag(date) < 9;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J2 bei 16-17 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean aa(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterAnTag(new Date()) > 15 && patient.getAlterAnTag(new Date()) < 18;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J2 nur 1 Mal bis 17 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ab(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J2 nur bis 17 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aq(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), c2.c, date) && patient.getAlterAnTag(date) > 17;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J2 erst ab 16 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="J2", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ar(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("J2"), c2.c, date) && patient.getAlterAnTag(date) < 16;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J1 (01720) bei 12-14 j\u00e4hrigen m\u00f6glich", action=ActionType.POTENTIAL, gnr="01720", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ac(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01720"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.getAlterAnTag(new Date()) > 11 && patient.getAlterAnTag(new Date()) < 15;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J1 (01720) nur 1 Mal bis 14 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="01720", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ad(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01720"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01720"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J1 (01720) nur bis 14 Jahre abrechenbar", action=ActionType.ENTFERNEN, gnr="01720", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean as(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01720"), c2.c, date) && patient.getAlterAnTag(date) > 14;
    }

    @Rule(name="HzV spectrumK Jugendvorsorgeuntersuchung J1 (01720) erst ab 12 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01720", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean at(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01720"), c2.c, date) && patient.getAlterAnTag(date) < 12;
    }

    @Rule(name="HzV spectrumK U-Vorsorgediagnose Z00.1 gesichert vorhanden, eventuell Abrechnungsziffer U-Untersuchung vergessen", action=ActionType.UEBERPRUEFEN, gnr="Z00.1", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707|01711|01712|01713|01714|01715|01716|01717|01718|01719|01723|U10|U11"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.hasDiagnose("Z00.1", "G", c2.c);
    }

    @Rule(name="HzV spectrumK J-Vorsorgediagnose Z00.3 gesichert vorhanden, eventuell Abrechnungsziffer J-Untersuchung vergessen", action=ActionType.UEBERPRUEFEN, gnr="Z00.3", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01720|J2"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("0000"), c2.c) && patient.hasDiagnose("Z00.3", "G", c2.c);
    }

    @Rule(name="HzV spectrumK U-Untersuchung erfordert die Ansetzung der gesicherten Pr\u00e4ventionsdiagnose Z00.1", action=ActionType.UEBERPRUEFEN, gnr="Z00.1", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient) {
        if (patient.hasDiagnose("Z00.1", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01707|01711|01712|01713|01714|01715|01716|01717|01718|01719|01723|U10|U11"), c2.c);
    }

    @Rule(name="HzV spectrumK J-Untersuchung erfordert die Ansetzung der gesicherten Pr\u00e4ventionsdiagnose Z00.3", action=ActionType.UEBERPRUEFEN, gnr="Z00.3", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ah(c c2, Patient patient) {
        if (patient.hasDiagnose("Z00.3", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("01720|J2"), c2.c);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I dritter Eingriff (02300C) nur neben 02300B abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02300C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean au(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300B"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300C"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I vierter Eingriff (02300D) nur neben 02300C abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02300D", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean av(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300C"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300D"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff I f\u00fcnfter Eingriff (02300E) nur neben 02300D abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02300E", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aw(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300D"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02300E"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II dritter Eingriff (02301C) nur neben 02301B abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02301C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ax(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301B"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301C"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II vierter Eingriff (02301D) nur neben 02301C abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02301D", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ay(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301C"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301D"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff II f\u00fcnfter Eingriff (02301E) nur neben 02301D abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02301E", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean az(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301D"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02301E"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff III dritter Eingriff (02302C) nur neben 02302B abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02302C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aA(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302B"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302C"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff III vierter Eingriff (02302D) nur neben 02302C abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02302D", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aB(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302C"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302D"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Kleinchirurgischer Eingriff III f\u00fcnfter Eingriff (02302E) nur neben 02302D abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02302E", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aC(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302D"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("02302E"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Psychosomatik II zweite Intervention (35110B) nur neben 35110 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="35110B", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aD(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110B"), c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110"), c2.c, date);
    }

    @Rule(name="HzV spectrumK Psychosomatik II dritte Intervention (35110C) nur neben 35110B abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="35110C", hzv=Hzv.BUNDESWEIT_BKKSPECTRUM, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aE(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110C"), c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_BKKSPECTRUM.gnr("35110B"), c2.c, date);
    }
}

