/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.k;

import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RuleConfigs;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.d;
import com.nhochdrei.kvdt.optimizer.rules.ApkModus;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@Rules(value=RuleCategory.DMP)
public class a {
    private static final List<d> a = Arrays.asList((d)((d)((d)((d)new d().h("DMP DM2")).a("90324", "90325")).f("E11.01|E11.11|E11.20|E11.21|E11.30|E11.31|E11.40|E11.41|E11.50|E11.51|E11.60|E11.61|E11.72|E11.73|E11.74|E11.75|E11.80|E11.81|E11.90|E11.91|O24.1")).e("32022"), (d)((d)((d)((d)new d().h("DMP DM1")).a("90334", "90335")).f("E10.01|E10.11|E10.20|E10.21|E10.30|E10.31|E10.40|E10.41|E10.50|E10.51|E10.60|E10.61|E10.72|E10.73|E10.74|E10.75|E10.80|E10.81|E10.90|E10.91|O24.0")).e("32022"), (d)((d)((d)new d().h("DMP KHK")).a("90510", "90511")).f("I20.0|I20.1|I20.8|I20.9|I25.0|I25.10|I25.11|I25.12|I25.13|I25.14|I25.15|I25.16|I25.19|I25.20|I25.21|I25.22|I25.29|I25.3|I25.4|I25.5|I25.6|I25.8|I25.9|I21.0|I21.1|I21.2|I21.3|I21.4|I21.9|I22.0|I22.1|I22.8|I22.9"), (d)((d)((d)new d().h("DMP COPD")).a("90224", "90225")).f(" J44.00|J44.01|J44.02|J44.03|J44.09|J44.10|J44.11|J44.12|J44.13|J44.19|J44.80|J44.81|J44.82|J44.83|J44.89|J44.90|J44.91|J44.92|J44.93|J44.99"), (d)((d)((d)new d().h("DMP Asthma")).a("90221", "90222")).f("J45.0|J45.00|J45.01|J45.02|J45.03|J45.04|J45.05|J45.09|J45.1|J45.10|J45.11|J45.12|J45.13|J45.14|J45.15|J45.19|J45.8|J45.80|J45.81|J45.82|J45.83|J45.84|J45.85|J45.89|J45.9|J45.90|J45.91|J45.92|J45.93|J45.94|J45.95|J45.99|J46"), (d)((d)((d)((d)new d().h("DMP Brustkrebs")).a("90500", "90504|90503")).f(" C50.0 |C50.1|C50.2|C50.3|C50.4|C50.5|C50.6|C50.8|C50.9|D05.0|D05.1|D05.7|D05.9")).e("32012"));

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Nordrhein");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @RuleConfigs
    public static List<d> a() {
        return a;
    }

    @Rule(name="{z1} und {z2} nicht nebeneinander abrechenbar.", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static String a(c c2, Patient patient, Action action, d d2) {
        action.setParameter("z1", d2.j());
        action.setParameter("z2", d2.k());
        if (d2.b(patient, c2.c) && d2.c(patient, c2.c)) {
            if (d2.d(patient, c2.d)) {
                return d2.j();
            }
            return d2.k();
        }
        return null;
    }

    @Rule(name="{ziffer} kann nachgetragen werden", action=ActionType.NACHTRAGEN, apk=ApkModus.HA_KIA_INTERNISTALLE)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String b(c c2, Patient patient, Action action, d d2) {
        action.setParameter("ziffer", d2.k());
        if (d2.d(patient, c2.d) && d2.d(patient, c2.e) && !d2.d(patient, c2.c) && patient.hasScheinInQuartal(c2.c)) {
            return d2.k();
        }
        return null;
    }

    @Rule(name="Laborbefreiungsziffer {ziffer} ansetzbar", action=ActionType.UEBERPRUEFEN, apk=ApkModus.HA_KIA_INTERNISTALLE)
    @RuleRequirement(value={Quartale.AQ})
    public static String c(c c2, Patient patient, Action action, d d2) {
        if (d2.l() != null && d2.d(patient, c2.c) && !patient.hasLeistung(d2.l(), c2.c)) {
            action.setParameter("ziffer", d2.l());
            return d2.l();
        }
        return null;
    }

    @Rule(name="ohne gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, apk=ApkModus.HA_KIA_INTERNISTALLE)
    @RuleRequirement(value={Quartale.AQ})
    public static String d(c c2, Patient patient, Action action, d d2) {
        action.setParameter("dmp", d2.p());
        if (d2.b(patient, c2.c) && !patient.hasDiagnose(d2.m(), true, c2.c)) {
            return d2.j();
        }
        if (d2.c(patient, c2.c) && !patient.hasDiagnose(d2.m(), true, c2.c)) {
            return d2.k();
        }
        return null;
    }

    @Rule(name="Potential vorhanden", action=ActionType.POTENTIAL, apk=ApkModus.HA_KIA_INTERNISTALLE)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String e(c c2, Patient patient, Action action, d d2) {
        action.setParameter("dmp", d2.p());
        if (!d2.d(patient, c2.c) && !d2.d(patient, c2.d) && !d2.d(patient, c2.e) && patient.hasDiagnose(d2.m(), true, c2.c)) {
            return d2.j();
        }
        return null;
    }

    @Rule(name="Mehrere DMP bei einem Arzt, im n\u00e4chsten Quartal DMP Vertr\u00e4ge auf verschiedene \u00c4rzte aufteilen", action=ActionType.UEBERPRUEFEN)
    @RuleRequirement(value={Quartale.AQ})
    public static String a(c c2, Patient patient, d d2) {
        Optional<ScheinLeistung> optional;
        if (d2.b(patient, c2.c) && (optional = d2.a(patient, c2.c, d2.j(), a).findAny()).isPresent()) {
            return optional.get().getGnr();
        }
        if (d2.c(patient, c2.c) && (optional = d2.a(patient, c2.c, d2.k(), a).findAny()).isPresent()) {
            return optional.get().getGnr();
        }
        return null;
    }

    @Rule(name="DMP Diabetes Typ 2 Betreuungskomplex (90321) am Behandlungstag nicht neben der 01732 abrechenbar, GOP auf 2 Leistungstage verteilen", action=ActionType.UEBERPRUEFEN, gnr="90321", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung("90321", c2.c, date) && patient.hasLeistung("01732", c2.c, date);
    }

    @Rule(name="Verbrauchsmaterialien zu Schulungen nach GOP 98110 bis 98118 je Grund- oder Wiederholungsschulung (98115) nicht neben Nachschulungen (98110N-98118N) abrechenbar", action=ActionType.ENTFERNEN, gnr="98115")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.hasLeistung("98115", c2.c) && patient.hasLeistung("98110N|98111N|98113N|98114N|98116N|98117N|98118N", c2.c);
    }

    @Rule(name="DMP Typ 1-Diabetes Nachschulungen {gnr} fr\u00fchestens ein Kalenderjahr nach Beendigung der Erstschulung (98110-98118) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="98110N|98111N|98113|98114N|98116N|98117N|98118N")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean a(c c2, Patient patient, String string) {
        return patient.hasLeistung("98110N|98111N|98113|98114N|98116N|98117N|98118N", c2.c) && patient.hasLeistung("98110|98111|98113|98114|98116|98117|98118", Arrays.asList(c2.c, c2.d, c2.e, c2.f, c2.g));
    }

    @Rule(name="Verbrauchsmaterialien zu Schulungen nach GOP 98013 bis 98032 je Grund- oder Wiederholungsschulung (98015) nicht neben Nachschulungen (98013N-98032N) abrechenbar", action=ActionType.ENTFERNEN, gnr="98015")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.hasLeistung("98015", c2.c) && patient.hasLeistung("98013N|98014N|98016N|98017N|98018N|98019N|98020N|98021N|98022N|98026N|98028N|98029N|98031N|98032N", c2.c);
    }

    @Rule(name="DMP Typ 1-Diabetes Nachschulungen (98110N-98118N) ein Kalenderjahr nach Beendigung der Erstschulung m\u00f6glich", action=ActionType.POTENTIAL, gnr="98110N|98111N|98112N|98113N|98114N|98115N|98116N|98116N|98117N|98118N")
    @RuleRequirement(value={Quartale.VVVVVQ})
    public static boolean b(c c2, Patient patient, String string) {
        return patient.hasLeistung("98110|98111|98113|98114|98116|98117|98118|", c2.h);
    }

    @Rule(name="DMP Typ 2-Diabetes Nachschulungen (98013N-98032N) ein Kalenderjahr nach Beendigung der Erstschulung m\u00f6glich", action=ActionType.POTENTIAL, gnr="98013N|98014N|98015N|98016N|98017N|98018N|98019N|98020N|98021N|98022N|98023N|98024N|98025N|98026N|98027N|98028N|98029N|98030N|98031N|98032N")
    @RuleRequirement(value={Quartale.VVVVVQ})
    public static boolean c(c c2, Patient patient, String string) {
        return patient.hasLeistung("98013|98014|98016|98017|98018|98019|98020|98021|98022|98026|98028|98029|98031|98032", c2.h);
    }

    @Rule(name="DMP Typ 2-Diabetes Nachschulungen {gnr} nur ein Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="98013N|98016N|98017N|98018N")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getLeistungCount(string, Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="DMP Typ 2-Diabetes Nachschulungen {gnr} nur 2 Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="98014N|98019N|98020N|98021N|98022N|98026N|98028N|98029N|98031N|98032N")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, String string) {
        return patient.hasLeistung(string, c2.c) && patient.getLeistungCount(string, Quartal.getBisJahresanfang(c2.c)) > 2;
    }
}

