/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.h.a;

import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.i;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.HZV)
public class f {
    private static final String a = "100609049|102108731|103708751|103708773|104208769|105208795|105508787|105508890|106408802|106908874|108008880|108508863|108608820|108609148|108808844|108809059|109008837|109108850|109308818";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Hessen");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BUNDESWEIT_LKK);
    }

    @Rule(name="HzV LKK Vertreterpauschale (0004) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Vertreterpauschale (0004) am Behandlungstag nicht mit Zielauftragspauschale (0005) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0005", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV LKK Zielauftragspauschale (0005) nur einmal im Behandlungsfall abrechenbar ", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("0005"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Betreuung von Palliativpatienten (0001) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0001", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("0001"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Betreuung von Palliativpatienten (0001) nicht neben Behandlungspauschale (0000) abrechenbar", action=ActionType.ENTFERNEN, gnr="0000", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0001"), c2.c, date);
    }

    @Rule(name="HzV LKK Betreuung von Palliativpatienten (0001) ohne entsprechend gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="0001", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0001"), c2.c) && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV LKK Betreuung von Palliativpatienten (0001) ist nur durch Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0001", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0001"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Besondere Betreuungspauschale f\u00fcr die Behandlung eines Patienten mit chronischer Erkrankung bei kontinuierlichem Betreuungsaufwand P3 (0003) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Betreuungspauschale Chroniker (0003) h\u00f6chstens 4 Mal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean h(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0003"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("0003"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 4;
    }

    @Rule(name="HzV LKK Betreuungspauschale Chroniker (0003) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0003"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Betreuungspauschale Chroniker (0003) ben\u00f6tigt mindestens einen pers\u00f6nlichen APK im Quartal", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0003"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV LKK Besuche von Palliativpatienten (1490) h\u00f6chstens 10 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="1490", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("1490"), c2.c) > 10;
    }

    @Rule(name="HzV LKK Besuche von Palliativpatienten (1490) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1490", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("1490"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Besuche von Palliativpatienten (1490) nur neben 01410,01414,1411P m\u00f6glich", action=ActionType.UEBERPRUEFEN, gnr="1490", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("1490"), c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01410|01414|1411P"), c2.c, date);
    }

    @Rule(name="HzV LKK Besuche von Palliativpatienten (1490) neben 01410,01414,1411P m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="1490", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01410|01414|1411P"), c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("1490"), c2.c, date) && patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV LKK Unvorhergesehene Inanspruchnahme I (01100) am Behandlungstag nicht neben Zielauftrag (0005) abrechenbar ", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0005"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01100"), c2.c, date);
    }

    @Rule(name="HzV LKK Unvorhergesehene Inanspruchnahme I (01100) in Ausnahmef\u00e4llen mehrfach am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_LKK.gnr("01100"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK Unvorhergesehene Inanspruchnahme II (01101) am Behandlungstag nicht neben Zielauftrag (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0005"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01101"), c2.c, date);
    }

    @Rule(name="HzV LKK Unvorhergesehene Inanspruchnahme II (01101) in Ausnahmef\u00e4llen mehrfach am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_LKK.gnr("01101"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK Gesundheitsuntersuchung (01732) nur einmal in 2 Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01732"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("01732"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV LKK Gesundheitsuntersuchung (01732) ab 36. Lebensjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean i(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), c2.c) && patient.getAlterAnTag(date) > 34;
    }

    @Rule(name="HzV LKK Patient ist zu jung f\u00fcr Gesundheitsuntersuchung (01732)", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV LKK Gesundheitsuntersuchung (01732) ist nur durch den Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01732"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Gesundheitsuntersuchung (01732) nicht neben 0005 abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01732"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV LKK Krebsfr\u00fcherkennungsuntersuchung M\u00e4nner (01731) nur einmal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean o(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV LKK Krebsfr\u00fcherkennungsuntersuchung M\u00e4nner (01731) nicht unter 45 Jahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV LKK Krebsfr\u00fcherkennungsuntersuchung M\u00e4nner (01731) einmal im Kalenderjahr abrechenbar", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean m(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_IKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), c2.c) && patient.getAlterAnTag(date) > 44 && patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV LKK Krebsfr\u00fcherkennungsuntersuchung M\u00e4nner (01731) ist nur durch den Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01731"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Krebsfr\u00fcherkennungsuntersuchung M\u00e4nner (01731) ist nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01731"), c2.c) && !patient.getGeschlecht().equals("M");
    }

    @Rule(name="HzV LKK Krebsfr\u00fcherkennungsuntersuchung M\u00e4nner (01731) nicht neben {gnr} abrechenbar", action=ActionType.ENTFERNEN, gnr="0004|0005", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01731"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr(string), c2.c, date);
    }

    @Rule(name="HzV LKK Verl\u00e4ngerte Sprechzeit (0010) h\u00f6chstens 2 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0010", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("0010"), c2.c) > 2;
    }

    @Rule(name="HzV LKK Verl\u00e4ngerte Sprechzeit (0010) am Behandlungstag nicht neben 35100 oder 35110 abrechenbar", action=ActionType.ENTFERNEN, gnr="0010", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0010"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("35100|35110"), c2.c, date);
    }

    @Rule(name="HzV LKK Verl\u00e4ngerte Sprechzeit (0010) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0010", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0010"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Versorgung chronischer Wunden (02310) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="02310", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("02310"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Haus\u00e4rztlichgeriatrisches Basisassessment (03240) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("03240"), c2.c) > 1;
    }

    @Rule(name="HzV LKK Patient ist zu jung f\u00fcr Haus\u00e4rztlichgeriatrisches Basisassessment (03240) ", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("03240"), c2.c, date) && patient.getAlterAnTag(date) < 60;
    }

    @Rule(name="HzV LKK Haus\u00e4rztlichgeriatrisches Basisassessment(03240) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("03240"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Ungeplanter eiliger Besuch (01411) am Behandlungstag nicht neben 0005 abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01411"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV LKK Ungeplanter eiliger Besuch (01411) h\u00f6chstens 3 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01411", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01411"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("01411"), c2.c) > 3 && !patient.hasDiagnose("Z51.5", true, c2.c);
    }

    @Rule(name="HzV LKK Mitbesuch (01413) einmal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01413", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01413"), c2.c, date) && patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_LKK.gnr("01413"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK Mitbesuch (01413) nicht neben 4401,4402,4403,01410,01414,1417 abrechenbar", action=ActionType.ENTFERNEN, gnr="01413", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01413"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("4401|4402|4403|01410|01414|1417"), c2.c, date);
    }

    @Rule(name="HzV LKK Mitbesuch (01413) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01413", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01413"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV LKK Heimbesuch (01414) h\u00f6chstens 4 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="01414", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01414"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("01414"), c2.c) > 4;
    }

    @Rule(name="HzV LKK Heimbesuch (01414) einmal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01414", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01414"), c2.c, date) && patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_LKK.gnr("01414"), c2.c, date) > 1;
    }

    @Rule(name="HzV LKK Heimbesuch (01414) am Behandlungstag nicht neben 01410 abrechenbar", action=ActionType.ENTFERNEN, gnr="01414", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01414"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01410"), c2.c, date);
    }

    @Rule(name="HzV LKK Heimbesuch (01414) nicht neben 4401,4402,4403 abrechenbar ", action=ActionType.ENTFERNEN, gnr="01414", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean u(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01414"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("4401|4402|4403"), c2.c, date);
    }

    @Rule(name="HzV LKK Besuch durch VERAH (1417) h\u00f6chstens 3 Mal im Behandlungsfall abrechenbar ", action=ActionType.ENTFERNEN, gnr="1417", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("1417"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("1417"), c2.c) > 3;
    }

    @Rule(name="HzV LKK Abdominelle Sonographie (33042) h\u00f6chstens 2 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("33042"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_LKK.gnr("33042"), c2.c) > 2;
    }

    @Rule(name="HzV LKK Wegepauschale Zone A (4401) nur neben 01410,1411,1490 abrechenbar ", action=ActionType.ENTFERNEN, gnr="4401", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("4401"), c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01410|1411|1490"), c2.c, date);
    }

    @Rule(name="HzV LKK Wegepauschale Zone A (4401) nicht neben 1417,4402,4403 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="4401", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean w(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("4401"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("1417|4402|4403"), c2.c, date);
    }

    @Rule(name="HzV LKK Wegepauschale Zone B (4402) nur neben 01410,1411,1490 abrechenbar", action=ActionType.ENTFERNEN, gnr="4402", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("4402"), c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01410|1411|1490"), c2.c, date);
    }

    @Rule(name="HzV LKK Wegepauschale Zone B (4402) nicht neben 1417,4403 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="4402", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("4402"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("1417|4403"), c2.c, date);
    }

    @Rule(name="HzV LKK Wegepauschale Zone C (4403) nur neben 01410,1411,1490 abrechenbar", action=ActionType.ENTFERNEN, gnr="4403", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("4403"), c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("01410|1411|1490"), c2.c, date);
    }

    @Rule(name="HzV LKK Wegepauschale Zone C (4403) nicht neben 1417 abrechenbar ", action=ActionType.UEBERPRUEFEN, gnr="4403", hzv=Hzv.BUNDESWEIT_LKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("4403"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("1417"), c2.c, date);
    }

    @Rule(name="HzV LKK die Kennzeichnungsziffer (88192) ist nur im KV-Schein abzurechnen, nicht im HzV-Schein", action=ActionType.UEBERPRUEFEN, gnr="88192", hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("88192"), c2.c);
    }

    @Rule(name="HzV LKK die lebenslangen Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean C(c c2, Patient patient) {
        if (patient.hasLeistung("88192", c2.c)) {
            String string = patient.getAPK(false, c2.c, 1L, i.a("88192")).getLanr();
            String string2 = null;
            if (patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BUNDESWEIT_LKK.gnr("0000"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0001"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BUNDESWEIT_LKK.gnr("0001"))).getLanr();
            }
            return string2 != null && !string2.equals(string);
        }
        return false;
    }

    @Rule(name="HzV LKK eine Doppelabrechnung von Betreuungspauschalen (0000, 0001) im HzV-Schein und der Versichertenpauschale (0300*) im KV-Schein ist ausgeschlossen ", action=ActionType.UEBERPRUEFEN, gnr="03001|03002|03003|03004|03005")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string) {
        if (patient.hasLeistungBeginntMit("03008|04008", c2.c) && patient.hasLeistungBeginntMit("88196", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000|0001"), c2.c) && patient.hasLeistung(string, c2.c);
    }

    @Rule(name="HzV LKK f\u00fcr Patienten welche mit der Pseudoziffer 88192 gekennzeichnet wurden HzV-Schein anlegen und Pauschale ansetzen", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BUNDESWEIT_LKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String D(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000|0001"), c2.c) && patient.hasLeistung("88192", c2.c)) {
            if (patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0001"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnose("Z51.5", true, c2.c)) {
                return "0001";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean a(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BUNDESWEIT_LKK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

