/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules.h.a;

import com.nhochdrei.kvdt.model.APK;
import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.model.Quartal;
import com.nhochdrei.kvdt.model.ScheinLeistung;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Hzv;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import com.nhochdrei.kvdt.optimizer.misc.i;
import java.util.Arrays;
import java.util.Date;

@Rules(value=RuleCategory.HZV)
public class b {
    private static final String a = "109928636|109936829|109937944|109938320|109938503|109938331|109936852|109936874|109531272|109920514|109920525|109920569|109920536|109920547|109920558|109936830|109937955|109936841|109936863|109938319|109938342|109929114|109929249|109938353";
    private static final String b = "E10|E11|E12|E13|E14|I10|I11|I12|I13|I15";
    private static final String c = "F32.0|F32.1|F32.2|F32.3|F33.0|F33.1|F33.2|F33.3|F33.4";
    private static final String d = "01707|01711|01712|01713|01714|01715|01716|01717|01718|01719|01723";

    @RulePrerequisite
    public static boolean a(c c2) {
        return c2.a("Hessen");
    }

    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return patient.hasIk(a) && c2.a(patient) && patient.hasHzvVertrag(Hzv.BUNDESWEIT_BAHNBKK);
    }

    @Rule(name="HzV BAHN-BKK Behandlungspauschale Chroniker (0003) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("0003"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Behandlungspauschale Chroniker (0003) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0003"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0003"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Behandlungspauschale Chroniker (0003) ben\u00f6tigt im Behandlungsfall mind. einen Arzt-Patienten-Kontakt", action=ActionType.UEBERPRUEFEN, gnr="0003", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0003"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Vertreterpauschale (0004) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0004", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean e(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Vertreterpauschale (0004) am Behandlungstag nicht mit Zielauftragspauschale (0005) abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="0005", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Vertreterpauschale (0004) ben\u00f6tigt im Behandlungsfall mind. einen Arzt-Patienten-Kontakt", action=ActionType.UEBERPRUEFEN, gnr="0004", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Zielauftragspauschale (0005) ben\u00f6tigt im Behandlungsfall mind. einen Arzt-Patienten-Kontakt", action=ActionType.UEBERPRUEFEN, gnr="0005", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Zielauftragspauschale (0005) max. 1 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="0005", daily=true, hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK ePA-Aktualisierung (1641) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="1641", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean h(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("1641"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK ePA-Aktualisierung (1641) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1641", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1641"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK ePA-Start (1640) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1640", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean j(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1640"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK ePA-Start (1640) max. 1 Mal pro Versichertenteilnahme abrechenbar", action=ActionType.ENTFERNEN, gnr="1640", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean k(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1640"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("1640"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Videosprechstunde (OVS) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="OVS", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("OVS"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) nur einmal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean m(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01731"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Patient ist zu jung f\u00fcr Krebsfr\u00fcherkennungsuntersuchung Mann (01731)", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01731"), c2.c, date) && patient.getAlterAnTag(date) < 45;
    }

    @Rule(name="HzV BAHN-BKK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) einmal im Kalenderjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01731", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.BIS_JAHRESANFANG})
    public static boolean d(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01731"), Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01731", Quartal.getBisJahresanfang(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 44 && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient) {
        if (patient.getGeschlecht().equals("M")) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01731"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Krebsfr\u00fcherkennungsuntersuchung Mann (01731) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01731", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean o(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01731"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01731"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Gesundheitsuntersuchung (01732) nur einmal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean p(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Gesundheitsuntersuchung (01732) einmal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01732", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean e(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01732", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 34 && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Patient ist zu jung f\u00fcr Gesundheitsuntersuchung (01732)", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean f(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV BAHN-BKK Gesundheitsuntersuchung (01732) nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="01732", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean q(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Hautkrebsscreening (01745) nicht neben 0004 / 0005 abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean g(c c2, Patient patient, Date date) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01745"), c2.c, date)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c, date)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01745"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Hautkrebsscreening (01745) nur einmal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean r(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01745"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01745"), Quartal.getBisVorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Hautkrebsscreening (01745) einmal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01745", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean h(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01745|01746"), Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 34 && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Patient ist zu jung f\u00fcr Hautkrebsscreening (01745)", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean i(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01745"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV BAHN-BKK Hautkrebsscreening (01745) im Behandlungsfall nicht neben 01732 / 01746 abrechenbar", action=ActionType.ENTFERNEN, gnr="01745", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean s(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01745"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732|01746"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Zuschlag HKS zur 01732 (01746) nur einmal in zwei Kalenderjahren abrechenbar", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean t(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01746"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01746"), Quartal.getBisVorjahrOhneAq(c2.c));
    }

    @Rule(name="HzV BAHN-BKK Zuschlag HKS zur 01732 (01746) einmal in zwei Kalenderjahren m\u00f6glich", action=ActionType.POTENTIAL, gnr="01746", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean j(c c2, Patient patient, Date date) {
        if (patient.hasLeistung("01745|01746", Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01745|01746"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), c2.c, date) && patient.getAlterAnTag(date) > 34;
    }

    @Rule(name="HzV BAHN-BKK Patient ist zu jung f\u00fcr Zuschlag HKS zur 01732 (01746)", action=ActionType.ENTFERNEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean k(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01746"), c2.c, date) && patient.getAlterAnTag(date) < 35;
    }

    @Rule(name="HzV BAHN-BKK Zuschlag HKS zur 01732 (01746) nur neben 01732 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01746", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean l(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01732"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01746"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK erweitertes Neugeborenenscreening (01707) einmal bis 5. Lebenswoche m\u00f6glich", action=ActionType.POTENTIAL, gnr="01707", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean m(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01707"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) < 36;
    }

    @Rule(name="HzV BAHN-BKK erweitertes Neugeborenenscreening (01707) nur einmal bis 5. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01707", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean u(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01707"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01707"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK erweitertes Neugeborenenscreening (01707) nur bis 5. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01707", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean n(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01707"), c2.c, date) && patient.getAlterInTage(date) > 35;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U1 (01711) einmal bis 2. Lebenstag m\u00f6glich", action=ActionType.POTENTIAL, gnr="01711", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean o(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01711"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) < 3;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U1 (01711) nur einmal bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean v(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01711"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01711"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U1 (01711) nur bis 2. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01711", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean p(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01711"), c2.c, date) && patient.getAlterInTage(date) > 2;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U2 (01712) am 3. bis 14. Lebenstag m\u00f6glich", action=ActionType.POTENTIAL, gnr="01712", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean q(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01712"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 2 && patient.getAlterInTage(date) < 15;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U2 (01712) nur einmal zwischen 3. und 14. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean w(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01712"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01712"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U2 (01712) nur bis 14. Lebenstag m\u00f6glich und erst ab 3. Lebenstag m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01712", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean r(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01712"), c2.c, date) && (patient.getAlterInTage(date) < 3 || patient.getAlterInTage(date) > 14);
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U3 (01713) in der 3. bis 8. Lebenswoche m\u00f6glich", action=ActionType.POTENTIAL, gnr="01713", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean s(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01713"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 14 && patient.getAlterInTage(date) < 50;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U3 (01713) nur einmal bis 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean x(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01713"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01713"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U3 (01713) nur zwischen 3. und 8. Lebenswoche m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01713", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean t(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01713"), c2.c, date) && (patient.getAlterInTage(date) < 15 || patient.getAlterInTage(date) > 49);
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U4 (01714) im 2. bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01714", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean u(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01714"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 30 && patient.getAlterInTage(date) < 136;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U4 (01714) nur einmal bis 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01714"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01714"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U4 (01714) nur zwischen 2. und 4.5 Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01714", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean v(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01714"), c2.c, date) && (patient.getAlterInTage(date) < 30 || patient.getAlterInTage(date) > 136);
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U5 (01715) im 5. bis 8. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01715", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean w(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01715"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 120 && patient.getAlterInTage(date) < 241;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U5 (01715) nur einmal bis 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01715"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01715"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U5 (01715) nur zwischen 5. und 8. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01715", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean x(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01715"), c2.c, date) && (patient.getAlterInTage(date) < 120 || patient.getAlterInTage(date) > 241);
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U6 (01716) im 9. bis 14. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01716", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean y(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01716"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 241 && patient.getAlterInTage(date) < 420;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U6 (01716) nur einmal bis 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01716"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01716"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U6 (01716) nur zwischen 9. und 14. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01716", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean z(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01716"), c2.c, date) && (patient.getAlterInTage(date) < 241 || patient.getAlterInTage(date) > 420);
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U7 (01717) im 20. bis 27. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01717", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean A(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01717"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 570 && patient.getAlterInTage(date) < 811;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U7 (01717) nur einmal bis 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean B(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01717"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01717"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U7 (01717) nur zwischen 20. und 27. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01717", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean B(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01717"), c2.c, date) && (patient.getAlterInTage(date) < 571 || patient.getAlterInTage(date) > 810);
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U7a (01723) im 33. bis 38. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01723", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean C(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01723"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 960 && patient.getAlterInTage(date) < 1141;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U7a (01723) nur einmal bis 38. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean C(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01723"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01723"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U7a (01723) nur zwischen 34. und 36. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01723", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean D(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01723"), c2.c, date) && (patient.getAlterInTage(date) < 960 || patient.getAlterInTage(date) > 1141);
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U8 (01718) im 43. bis 50. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01718", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean E(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01718"), Arrays.asList(c2.c, c2.d))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 1260 && patient.getAlterInTage(date) < 1501;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U8 (01718) nur einmal bis 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static boolean D(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01718"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01718"), Arrays.asList(c2.c, c2.d)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U8 (01718) nur zwischen 43. und 50. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01718", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean F(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01718"), c2.c, date) && (patient.getAlterInTage(date) < 1260 || patient.getAlterInTage(date) > 1501);
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U9 (01719) im 58. bis 66. Lebensmonat m\u00f6glich", action=ActionType.POTENTIAL, gnr="01719", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean G(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterInTage(date) > 1710 && patient.getAlterInTage(date) < 1981;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U9 (01719) nur einmal bis 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean E(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01719"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01719"), Arrays.asList(c2.c, c2.d, c2.e)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Kindervorsorgeuntersuchung U9 (01719) nur zwischen 58. und 66. Lebensmonat m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01719", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01719"), c2.c, date) && (patient.getAlterInTage(date) < 1711 || patient.getAlterInTage(date) > 1980);
    }

    @Rule(name="HzV BAHN-BKK Jugendgesundheitsuntersuchung J1 (01720) im 13. bis 15. Lebensjahr m\u00f6glich", action=ActionType.POTENTIAL, gnr="01720", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.BIS_VORVORJAHR})
    public static boolean I(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01720"), Quartal.getBisVorvorjahr(c2.c))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date) && patient.getAlterAnTag(date) > 11 && patient.getAlterAnTag(date) < 15;
    }

    @Rule(name="HzV BAHN-BKK Jugendgesundheitsuntersuchung J1 (01720) nur einmal bis 15. Lebensjahr m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01720", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.BIS_VORVORJAHR})
    public static boolean F(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01720"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01720"), Quartal.getBisVorvorjahr(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Jugendgesundheitsuntersuchung J1 (01720) nur zwischen 13. und 15. Lebensjahr m\u00f6glich", action=ActionType.ENTFERNEN, gnr="01720", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01720"), c2.c, date) && patient.getAlterAnTag(date) > 14 && patient.getAlterAnTag(date) < 12;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-LUTS (00030) nur einmal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="00030", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.BIS_JAHRESANFANG})
    public static boolean G(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-LUTS (00030) und Nachsorge (00031) im Behandlungsfall nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="00030", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean H(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00031"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-LUTS (00030) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00030", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean I(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-LUTS (00030) nur mit gesicherter Diabetesdiagnose abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="00030", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean J(c c2, Patient patient) {
        if (patient.hasDiagnoseBeginntMit("E1", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-LUTS (00030) nur ohne bisher bekannte neurologische Komplikationen abrechenbar", action=ActionType.ENTFERNEN, gnr="00030", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean K(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030"), c2.c) && patient.hasDiagnoseBeginntMit("E10.4|E11.4|E12.4|E13.4|E14.4|N31.1|N31.2", "G", Arrays.asList(c2.d, c2.e, c2.f, c2.g));
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Nachsorge (00031) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="00031", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00031"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Nachsorgekontrolle (00031) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung LUTS (00030) m\u00f6glich", action=ActionType.POTENTIAL, gnr="00031", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030|00031"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c)) {
            return false;
        }
        ScheinLeistung scheinLeistung = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), 1L, c2.c);
        if (patient.getLeistungen(Arrays.asList(c2.d, c2.e, c2.f)).stream().anyMatch(scheinLeistung2 -> scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("00030")) && scheinLeistung2.getLanr().equals(scheinLeistung.getLanr()))) {
            return false;
        }
        if (patient.getLeistungen(c2.c).stream().anyMatch(scheinLeistung2 -> (scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004")) || scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"))) && scheinLeistung2.getLanr().equals(scheinLeistung.getLanr()))) {
            return false;
        }
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00031"), Arrays.asList(c2.d, c2.e, c2.f)) < 2 && patient.hasDiagnose("E10.4|E11.4|E12.4|E13.4|E14.4|E10.7|E11.7|E12.7|E13.7|E14.7|N31.1|N31.2", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Nachsorgekontrolle bei positiven Befund (00031) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00031", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00031"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00031"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Nachsorgekontrolle bei positiven Befund (00031) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="00031", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient) {
        if (patient.hasDiagnoseBeginntMit("E10.4|E11.4|E12.4|E13.4|E14.4|E10.7|E11.7|E12.7|E13.7|E14.7|N31.1|N31.2", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00031"), c2.d);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Diabetische Neuropathie (00032) nur einmal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="00032", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.BIS_JAHRESANFANG})
    public static boolean P(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032"), c2.d) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032"), Quartal.getBisJahresanfang(c2.d)) > 2;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Diabetische Neuropathie (00032) und Nachsorge (00033) im Behandlungsfall nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="00032", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032"), c2.d) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00033"), c2.d);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Diabetische Neuropathie (00032) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00032", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Diabetische Neuropathie (00032) nur mit gesicherter Diabetesdiagnose abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="00032", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient) {
        if (patient.hasDiagnoseBeginntMit("E1", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032"), c2.d);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Diabetische Neuropathie (00032) nur ohne bisher bekannte Neuropathie abrechenbar", action=ActionType.ENTFERNEN, gnr="00032", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean T(c c2, Patient patient) {
        if (!patient.hasDiagnoseBeginntMit("E10.4|E11.4|E12.4|E13.4|E14.4|G59.0|G63.2|G99.0", "G", Arrays.asList(c2.d, c2.e, c2.f, c2.g))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Nachsorgekontrolle bei positiven Befund (00033) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="00033", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00033"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Nachsorgekontrolle bei positiven Befund (00033) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung Diabetische Neuropathie (00032) m\u00f6glich", action=ActionType.POTENTIAL, gnr="00033", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean V(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032|00033"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c)) {
            return false;
        }
        ScheinLeistung scheinLeistung = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), 1L, c2.c);
        if (patient.getLeistungen(Arrays.asList(c2.d, c2.e, c2.f)).stream().anyMatch(scheinLeistung2 -> scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("00032")) && scheinLeistung2.getLanr().equals(scheinLeistung.getLanr()))) {
            return false;
        }
        if (patient.getLeistungen(c2.c).stream().anyMatch(scheinLeistung2 -> (scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004")) || scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"))) && scheinLeistung2.getLanr().equals(scheinLeistung.getLanr()))) {
            return false;
        }
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00033"), Arrays.asList(c2.d, c2.e, c2.f)) < 2 && patient.hasDiagnose("E10.4|E11.4|E12.4|E13.4|E14.4|E10.7|E11.7|E12.7|E13.7|E14.7|N31.1|N31.2", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Nachsorgekontrolle bei positiven Befund (00033) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00033", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00033"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00033"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes-Nachsorgekontrolle bei positiven Befund (00033) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="00033", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient) {
        if (patient.hasDiagnoseBeginntMit("E10.4|E11.4|E12.4|E13.4|E14.4|E10.7|E11.7|E12.7|E13.7|E14.7|G99.0|G59.0|G63.2", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00033"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-pAVK (00034) nur einmal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="00034", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.BIS_JAHRESANFANG})
    public static boolean Y(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-pAVK (00034) und Nachsorge (00035) im Behandlungsfall nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="00034", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Z(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00035"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-pAVK (00034) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00034", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Patient ist zu jung f\u00fcr Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-pAVK (00034)", action=ActionType.ENTFERNEN, gnr="00034", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean K(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), c2.c, date) && patient.getAlterAnTag(date) < 66;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-pAVK (00034) nur mit gesicherter Diabetes- oder Hypertoniediagnose abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="00034", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient) {
        if (patient.hasDiagnoseBeginntMit(b, "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-pAVK (00034) nur ohne bisher bekannte Atherosklerose abrechenbar", action=ActionType.ENTFERNEN, gnr="00034", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean ac(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), c2.c) && patient.hasDiagnoseBeginntMit("I70", "G", Arrays.asList(c2.d, c2.e, c2.f, c2.g));
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-pAVK (00034) eventuell m\u00f6glich", action=ActionType.POTENTIAL, gnr="00034", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.BIS_JAHRESANFANG})
    public static boolean a(c c2, Patient patient, Date date, Action action) {
        String string;
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c, date)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), Quartal.getBisJahresanfang(c2.d))) {
            return false;
        }
        if (patient.hasDiagnoseBeginntMit("I70", "G", Arrays.asList(c2.d, c2.e, c2.f, c2.g))) {
            return false;
        }
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), 1L, c2.c).getLanr();
        return !string2.equals(string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr()) && patient.getAlterAnTag(date) > 65 && patient.hasDiagnoseBeginntMit(b, "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-Nachsorgekontrolle bei positiven Befund (00035) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="00035", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00035"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-Nachsorgekontrolle bei positiven Befund (00035) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung pAVK (00034) m\u00f6glich", action=ActionType.POTENTIAL, gnr="00035", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean ae(c c2, Patient patient) {
        String string;
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00035"), c2.c)) {
            return false;
        }
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), 1L, c2.c).getLanr();
        return !string2.equals(string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr()) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), Arrays.asList(c2.d, c2.e, c2.f)) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00035"), Arrays.asList(c2.d, c2.e, c2.f)) < 2 && patient.hasDiagnose("I70.2|E10.5|E11.5|E12.5|E13.5|E14.5|E10.7|E11.7|E12.7|E13.7|E14.7", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-Nachsorgekontrolle bei positiven Befund (00035) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00035", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00035"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00035"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-Nachsorgekontrolle bei positiven Befund (00035) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="00035", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean ag(c c2, Patient patient) {
        if (patient.hasDiagnoseBeginntMit("I70.2|E10.5|E11.5|E12.5|E13.5|E14.5|E10.7|E11.7|E12.7|E13.7|E14.7", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00035"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-chron. Nierenkrankheit (00036) nur einmal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="00036", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.BIS_JAHRESANFANG})
    public static boolean ah(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00036"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00036"), Quartal.getBisJahresanfang(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-chron. Nierenkrankheit (00036) und Nachsorge (00037) im Behandlungsfall nicht nebeneinander abrechenbar", action=ActionType.ENTFERNEN, gnr="00036", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ai(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00036"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00037"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-chron. Nierenkrankheit (00036) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00036", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aj(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00036"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00036"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-chron. Nierenkrankheit (00036) nur mit gesicherter Diabetes- oder Hypertoniediagnose abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="00036", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ak(c c2, Patient patient) {
        if (patient.hasDiagnoseBeginntMit(b, "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00036"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-chron. Nierenkrankheit (00036) nur ohne bisher bekannte Nierenerkrankung abrechenbar", action=ActionType.ENTFERNEN, gnr="00034", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ, Quartale.VVVVQ})
    public static boolean al(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00034"), c2.c) && patient.hasDiagnoseBeginntMit("N18|N19|I12.0|I13.1|I13.2|Z49|Z99.2", "G", Arrays.asList(c2.d, c2.e, c2.f, c2.g));
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-Nachsorgekontrolle bei positivem Befund (00037) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="00037", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean am(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00037"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-Nachsorgekontrolle bei positivem Befund (00037) bis zu 2 Mal innerhalb eines Jahres nach Fr\u00fcherkennungsuntersuchung-chron. Nierenkrankheit (00036) m\u00f6glich", action=ActionType.POTENTIAL, gnr="00037", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean an(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00036|00037"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c)) {
            return false;
        }
        ScheinLeistung scheinLeistung = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), 1L, c2.c);
        if (patient.getLeistungen(Arrays.asList(c2.d, c2.e, c2.f)).stream().anyMatch(scheinLeistung2 -> scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("00036")) && scheinLeistung2.getLanr().equals(scheinLeistung.getLanr()))) {
            return false;
        }
        if (patient.getLeistungen(c2.c).stream().anyMatch(scheinLeistung2 -> (scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004")) || scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"))) && scheinLeistung2.getLanr().equals(scheinLeistung.getLanr()))) {
            return false;
        }
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00037"), Arrays.asList(c2.d, c2.e, c2.f)) < 2 && patient.hasDiagnose("E10.2|E11.2|E12.2|E13.2|E14.2|E10.7|E11.7|E12.7|E13.7|E14.7|I12|I13.1|I13.2|N18|Z49", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-Nachsorgekontrolle bei positivem Befund (00037) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00037", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ao(c c2, Patient patient) {
        String string;
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00037"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00037"), 1L, c2.c).getLanr();
        return !string2.equals(string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr());
    }

    @Rule(name="HzV BAHN-BKK Fr\u00fcherkennung der Begleiterkrankungen von Diabetes oder Hypertonie-Nachsorge (00037) ohne entsprechende gesicherte Diagnose", action=ActionType.UEBERPRUEFEN, gnr="00035", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean ap(c c2, Patient patient) {
        if (patient.hasDiagnoseBeginntMit("E10.2|E11.2|E12.2|E13.2|E14.2|E10.7|E11.7|E12.7|E13.7|E14.7|I12.|I13.1|I13.2|N18|Z49|N19|Z99.2", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00037"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme I (01100) am Behandlungstag nicht neben Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="01100", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean L(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01100"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme I (01100) in Ausnahmef\u00e4llen mehrfach am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean M(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01100"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme I zweite am gleichen Tag in 01100B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean N(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01100"), c2.c, date) == 2;
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme I dritte am gleichen Tag in 01100C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="01100", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean O(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01100|01100B"), c2.c, date) == 3;
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme I dritte am gleichen Tag (01100C) nur 1 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01100C", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean P(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01100C"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme II (01101) am Behandlungstag nicht neben Zielauftragspauschale (0005) abrechenbar", action=ActionType.ENTFERNEN, gnr="01101", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Q(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01101"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme II (01101) in Ausnahmef\u00e4llen mehrfach am Behandlungstag abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean R(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01101"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme II zweite am gleichen Tag in 01101B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean S(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01101"), c2.c, date) == 2;
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme II dritte am gleichen Tag in 01101C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="01101", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean T(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01101|01101B"), c2.c, date) == 3;
    }

    @Rule(name="HzV BAHN-BKK Unvorhergesehene Inanspruchnahme II dritte am gleichen Tag (01101C) nur 1 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="01101C", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean U(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01101C"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Patient ist zu jung f\u00fcr Beratung zum Ultraschallscreening auf Bauchaortenaneurysmen (01747)", action=ActionType.ENTFERNEN, gnr="01747", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean V(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01747"), c2.c, date) && patient.getAlterAnTag(date) < 65;
    }

    @Rule(name="HzV BAHN-BKK Beratung zum Ultraschallscreening auf Bauchaortenaneurysmen (01747) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01747", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aq(c c2, Patient patient) {
        if (!patient.getGeschlecht().equals("M")) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01747"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Beratung zum Ultraschallscreening auf Bauchaortenaneurysmen (01747) nur 1 Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="01747", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean ar(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01747"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01747"), Quartal.getBisVorjahrOhneAq(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Sonographische Untersuchung auf Bauchaortenaneurysmen (01748) nur 1 Mal im Leben abrechenbar", action=ActionType.ENTFERNEN, gnr="01748", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean as(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01748"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("01748"), Quartal.getBisVorjahrOhneAq(c2.c)) > 1;
    }

    @Rule(name="HzV BAHN-BKK Patient ist zu jung f\u00fcr Sonographische Untersuchung auf Bauchaortenaneurysmen (01748)", action=ActionType.ENTFERNEN, gnr="01748", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean W(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01748"), c2.c, date) && patient.getAlterAnTag(date) < 65;
    }

    @Rule(name="HzV BAHN-BKK Sonographische Untersuchung auf Bauchaortenaneurysmen (01748) nur bei M\u00e4nnern abrechenbar", action=ActionType.ENTFERNEN, gnr="01748", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean at(c c2, Patient patient) {
        if (!patient.getGeschlecht().equals("M")) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01748"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Haus\u00e4rztlichgeriatrisches Basisassessment (03240) h\u00f6chstens 2 Mal im Versichertenteilnahmejahr abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean au(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("03240"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("03240"), Arrays.asList(c2.c, c2.d, c2.e, c2.f)) > 2;
    }

    @Rule(name="HzV BAHN-BKK Haus\u00e4rztlichgeriatrisches Basisassessment (03240) max. 1 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="03240", daily=true, hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean X(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("03240"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Abdominelle Sonographie (33042) h\u00f6chstens 2 Mal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean av(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("33042"), c2.c) > 2;
    }

    @Rule(name="HzV BAHN-BKK Abdominelle Sonographie (33042) max. 1 Mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="33042", daily=true, hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Y(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("33042"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Hausbesuch (01410) am Behandlungstag max. 1 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="01410", daily=true, hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean Z(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("01410"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Mitbesuch (1413) einmal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="1413", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aa(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("1413"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Mitbesuch (1413) nicht neben 1410|1416|1417 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="1413", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ab(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1413"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1410|1416|1417"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Einsatz von arriba (00038) h\u00f6chstens 2 Mal im Kalenderjahr abrechenbar", action=ActionType.ENTFERNEN, gnr="00038", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.BIS_JAHRESANFANG})
    public static boolean ac(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00038"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00038"), Quartal.getBisJahresanfang(c2.c)) > 2;
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Einsatz von arriba (00038) einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="00038", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aw(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00038"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Einsatz von arriba (00038) nicht neben 00039 abrechenbar", action=ActionType.ENTFERNEN, gnr="00039", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ad(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00038"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00039"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Einsatz von arriba (00038) nur durch den Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00038", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ax(c c2, Patient patient) {
        String string;
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00038"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00038"), 1L, c2.c).getLanr();
        return !string2.equals(string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr());
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Nachsorgekontrolle bei positivem Befund (00039) einmal im Folgequartal nach Einsatz von arriba (00038) abrechenbar", action=ActionType.NACHTRAGEN, gnr="00039", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean ay(c c2, Patient patient) {
        if (!patient.hasDiagnoseBeginntMit(c, "G", Arrays.asList(c2.d, c2.e, c2.f, c2.g))) {
            return false;
        }
        if (!patient.hasDiagnoseBeginntMit(c, "G", c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00039"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c)) {
            return false;
        }
        ScheinLeistung scheinLeistung = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), 1L, c2.c);
        if (patient.getLeistungen(c2.c).stream().anyMatch(scheinLeistung2 -> (scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004")) || scheinLeistung2.getGnr().equals(Hzv.BUNDESWEIT_BAHNBKK.gnr("0005"))) && scheinLeistung2.getLanr().equals(scheinLeistung.getLanr()))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00038"), c2.d) && patient.hasDiagnose(c, "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Nachsorgekontrolle bei positivem Befund (00039) nur im Folgequartal nach Einsatz von arriba (00038) abrechenbar", action=ActionType.ENTFERNEN, gnr="00039", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ae(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00038"), c2.d)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00039"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Nachsorgekontrolle bei positivem Befund (00039) nur einmal im Folgequartal nach Einsatz von arriba (00038) abrechenbar", action=ActionType.ENTFERNEN, gnr="00039", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean az(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("00039"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Nachsorgekontrolle bei positivem Befund (00039) nur durch den Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="00039", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aA(c c2, Patient patient) {
        String string;
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00039"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00039"), 1L, c2.c).getLanr();
        return !string2.equals(string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr());
    }

    @Rule(name="HzV BAHN-BKK Modul \u201eShared-Decision-Making\u201c-Nachsorgekontrolle bei positivem Befund (00039) nur ohne vorher bekannte Depression abrechenbar", action=ActionType.ENTFERNEN, gnr="00039", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean aB(c c2, Patient patient) {
        if (!patient.hasDiagnoseBeginntMit(c, "G", Arrays.asList(c2.d, c2.e, c2.f, c2.g))) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("00039"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH (1417) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1417", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aC(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1417"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1417"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH (1417) und Besuch durch VERAH bei Einsatz telemedizinischer Ausstattung (1416) h\u00f6chstens 10 Mal zusammen im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="1417", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ, Quartale.VVVVQ})
    public static boolean a(c c2, Patient patient, Action action) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1417"), c2.c) && patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("1416"), c2.c) + patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("1417"), c2.c) > 10;
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH (1417) am Behandlungstag nicht neben 1416 abrechenbar", action=ActionType.ENTFERNEN, gnr="1417", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean af(c c2, Patient patient, Date date) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1416"), c2.c, date) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1417"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH (1417) ben\u00f6tigt im Behandlungsfall mind. 1 Arzt-Patienten-Kontakt", action=ActionType.UEBERPRUEFEN, gnr="1417", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aD(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1417"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH (1417) im Behandlungsfall nur neben 0001/0003 abrechenbar", action=ActionType.ENTFERNEN, gnr="1417", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aE(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1417"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001|0003"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH (1417) am Behandlungstag max. 1 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="1417", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ag(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("1417"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH bei Einsatz telemedizinischer Ausstattung (1416) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1416", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aF(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1416"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1416"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH bei Einsatz telemedizinischer Ausstattung (1416) ben\u00f6tigt im Behandlungsfall mind. 1 Arzt-Patienten-Kontakt", action=ActionType.UEBERPRUEFEN, gnr="1416", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aG(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1416"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH bei Einsatz telemedizinischer Ausstattung (1416) im Behandlungsfall nur neben 0001/0003 abrechenbar", action=ActionType.ENTFERNEN, gnr="1416", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aH(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1416"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001|0003"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Besuch durch VERAH bei Einsatz telemedizinischer Ausstattung (1416) am Behandlungstag max. 1 Mal abrechenbar", action=ActionType.ENTFERNEN, gnr="1416", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ah(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("1416"), c2.c, date) > 1;
    }

    @Rule(name="HzV BAHN-BKK Betreuung von Palliativpatienten (0001) einmal im Behandlungsfall abrechenbar", action=ActionType.NACHTRAGEN, gnr="0001", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aI(c c2, Patient patient) {
        String string;
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), c2.c)) {
            return false;
        }
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), 1L, c2.c).getLanr();
        return !string2.equals(string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr()) && patient.hasDiagnose("Z51.5", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Betreuung von Palliativpatienten (0001) nur einmal im Behandlungsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="0001", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aJ(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), c2.c) > 1;
    }

    @Rule(name="HzV BAHN-BKK Betreuung von Palliativpatienten (0001) ohne entsprechende gesicherte Diagnose (Z51.5G)", action=ActionType.UEBERPRUEFEN, gnr="0001", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aK(c c2, Patient patient) {
        if (patient.hasDiagnose("Z51.5", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Betreuung von Palliativpatienten (0001) ist nur durch den Betreuungsarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="0001", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aL(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Betreuung von Palliativpatienten (0001) ben\u00f6tigt im Behandlungsfall mind. 1 Arzt-Patienten-Kontakt", action=ActionType.UEBERPRUEFEN, gnr="0001", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aM(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), c2.c) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK Betreuung von Palliativpatienten (0001) max. 4 Mal im Leben pro HzV-Patient abrechenbar", action=ActionType.ENTFERNEN, gnr="0001", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.BIS_VORVORJAHR})
    public static boolean aN(c c2, Patient patient) {
        return patient.getLeistungCount(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), Quartal.getBisVorvorjahr(c2.c)) > 4;
    }

    @Rule(name="HzV BAHN-BKK Zuschlag Besuche von Palliativpatienten (1490) ist nur durch Betreuarzt abrechenbar", action=ActionType.ENTFERNEN, gnr="1490", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aO(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1490"), c2.c)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), c2.c)) {
            return false;
        }
        String string = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1490"), 1L, c2.c).getLanr();
        String string2 = patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0004|0005"), 1L, c2.c).getLanr();
        return string.equals(string2);
    }

    @Rule(name="HzV BAHN-BKK Zuschlag Besuche von Palliativpatienten (1490) nur neben 01410 m\u00f6glich", action=ActionType.UEBERPRUEFEN, gnr="1490", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ai(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1410"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1490"), c2.c, date);
    }

    @Rule(name="HzV BAHN-BKK Zuschlag Besuche von Palliativpatienten (1490) neben 01410 m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="1490", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aj(c c2, Patient patient, Date date) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1490|0004|0005"), c2.c, date)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("1410"), c2.c, date) && patient.hasDiagnose("Z51.5", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK U-Vorsorgediagnose Z00.1 gesichert vorhanden, eventuell Abrechnungsziffer U-Untersuchung vergessen", action=ActionType.UEBERPRUEFEN, gnr="Z00.1", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aP(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr(d), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK J-Vorsorgediagnose Z00.3 gesichert vorhanden, eventuell Abrechnungsziffer J-Untersuchung vergessen", action=ActionType.UEBERPRUEFEN, gnr="Z00.3", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aQ(c c2, Patient patient) {
        if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01720"), c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK U-Untersuchung erfordert die Ansetzung der gesicherten Pr\u00e4ventionsdiagnose Z00.1", action=ActionType.UEBERPRUEFEN, gnr="Z00.1", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aR(c c2, Patient patient) {
        if (patient.hasDiagnose("Z00.1", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr(d), c2.c);
    }

    @Rule(name="HzV BAHN-BKK J-Untersuchung erfordert die Ansetzung der gesicherten Pr\u00e4ventionsdiagnose Z00.3", action=ActionType.UEBERPRUEFEN, gnr="Z00.3", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aS(c c2, Patient patient) {
        if (patient.hasDiagnose("Z00.3", "G", c2.c)) {
            return false;
        }
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("01720"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK die Kennzeichnungsziffer (88192) ist nur im KV-Schein abzurechnen, nicht im HzV-Schein", action=ActionType.ENTFERNEN, gnr="88192", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aT(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("88192"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK die lebenslangen Arztnummern im HzV-Schein und im KV-Schein sollten der gleiche Betreuungsarzt sein", action=ActionType.UEBERPRUEFEN, gnr="88192")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aU(c c2, Patient patient) {
        if (patient.hasLeistung("88192", c2.c)) {
            String string = patient.getAPK(false, c2.c, 1L, i.a("88192")).getLanr();
            String string2 = null;
            if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"))).getLanr();
            } else if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), c2.c)) {
                string2 = patient.getAPK(false, c2.c, 1L, i.a(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"))).getLanr();
            }
            return string2 != null && !string2.equals(string);
        }
        return false;
    }

    @Rule(name="HzV BAHN-BKK eine Doppelabrechnung von Betreuungspauschale (0000) im HzV-Schein und der Versichertenpauschale (0300*) im KV-Schein ist ausgeschlossen", action=ActionType.ENTFERNEN, gnr="0300*", hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aV(c c2, Patient patient) {
        return patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c) && patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0300*"), c2.c);
    }

    @Rule(name="HzV BAHN-BKK f\u00fcr Patienten welche mit der Pseudoziffer 88192 gekennzeichnet wurden HzV-Schein anlegen und Pauschale ansetzen", action=ActionType.UEBERPRUEFEN, hzv=Hzv.BUNDESWEIT_BAHNBKK)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String aW(c c2, Patient patient) {
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000|0001|0002|0004"), c2.c) && patient.hasLeistung("88192", c2.c)) {
            if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), Arrays.asList(c2.d, c2.e))) {
                return "0000";
            }
            if (patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0001"), Arrays.asList(c2.d, c2.e)) || patient.hasDiagnose("Z51.5", true, c2.c)) {
                return "0001";
            }
            return "0000";
        }
        return null;
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff h\u00f6chstens 5 mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="02300|02301|02302|02300B|02301B|02302B|02300C|02301C|02302C|02300D|02301D|02302D|02300E|02301E|02302E", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, Date date, String string) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr(string), c2.c, date) > 5 && !patient.hasDiagnose("D22.0|D22.1|D22.2|D22.3|D22.4|D22.5|D22.6|D22.7|D22.9|T01.0|T01.1|T01.2|T01.3|T01.6|T01.8|T01.9", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff am Behandlungstag mehrfach nebeneinander ohne entsprechende Diagnose nicht abrechenbar", action=ActionType.ENTFERNEN, gnr="02300|02301|02302|02300B|02301B|02302B|02300C|02301C|02302C|02300D|02301D|02302D|02300E|02301E|02302E", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date, String string) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr(string), c2.c, date) > 1 && !patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgische Eingriffe h\u00f6chstens 5 mal am Behandlungstag abrechenbar", action=ActionType.ENTFERNEN, gnr="02300/02301/02302/02300B/02301B/02302B/02300C/02301C/02302C/02300D/02301D/02302D/02300E/02301E/02302E", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ak(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02300|02301|02302|02300B|02301B|02302B|02300C|02301C|02302C|02300D|02301D|02302D|02300E|02301E|02302E"), c2.c, date) > 1 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff I (02300) zweiter Eingriff in 02300B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02300", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean al(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02300"), c2.c, date) == 2 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff I zweiter Eingriff (02300B) nur neben 02300 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02300B", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean am(c c2, Patient patient, Date date) {
        return patient.hasLeistung("02300B", c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("02300"), c2.c, date) && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff I dritter Eingriff in 02300C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02300", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean an(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02300|02300B"), c2.c, date) == 3 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff I vierter Eingriff in 02300D umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02300", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ao(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02300|02300B|02300C"), c2.c, date) == 4 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff I f\u00fcnfter Eingriff in 02300E umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02300", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ap(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02300|02300B|02300C|02300D"), c2.c, date) == 5 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff II (02301) zweiter Eingriff in 02301B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02301", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aq(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02301"), c2.c, date) == 2 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff II zweiter Eingriff (02301B) nur neben 02301 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02301B", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ar(c c2, Patient patient, Date date) {
        return patient.hasLeistung("02301B", c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("02301"), c2.c, date) && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff II dritter Eingriff in 02301C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02301", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean as(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02301|02301B"), c2.c, date) == 3 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff II vierter Eingriff in 02301D umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02301", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean at(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02301|02301B|02301C"), c2.c, date) == 4 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff II f\u00fcnfter Eingriff in 02301E umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02301", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean au(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02301|02301B|02301C|02301D"), c2.c, date) == 5 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff III (02302) zweiter Eingriff in 02302B umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02302", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean av(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02302"), c2.c, date) == 2 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff III zweiter Eingriff (02302B) nur neben 02302 abrechenbar", action=ActionType.UEBERPRUEFEN, gnr="02302B", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean aw(c c2, Patient patient, Date date) {
        return patient.hasLeistung("02302B", c2.c, date) && !patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("02302"), c2.c, date) && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff III dritter Eingriff in 02302C umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02302", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ax(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02301|02301B"), c2.c, date) == 3 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff III vierter Eingriff in 02302D umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02302", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean ay(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02302|02302B|02302C"), c2.c, date) == 4 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="HzV BAHN-BKK Kleinchirurgischer Eingriff III f\u00fcnfter Eingriff in 02302E umsetzen", action=ActionType.UEBERPRUEFEN, gnr="02302", hzv=Hzv.BUNDESWEIT_BAHNBKK, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean az(c c2, Patient patient, Date date) {
        return patient.getLeistungCountFromDate(Hzv.BUNDESWEIT_BAHNBKK.gnr("02302|02302B|02302C|02302D"), c2.c, date) == 5 && patient.hasDiagnoseBeginntMit("D22|T01", "G", c2.c);
    }

    @Rule(name="Beratung \u00fcber Organ- und Gewebespenden gem\u00e4\u00df \u00a7 2 Abs. 1a TPG (01480) alle zwei Jahre m\u00f6glich", action=ActionType.POTENTIAL, gnr="01480")
    @RuleRequirement(value={Quartale.BIS_VORJAHR})
    public static boolean b(c c2, Patient patient, Action action) {
        if (c2.b(patient)) {
            return false;
        }
        if (!patient.hasLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), c2.c)) {
            return false;
        }
        action.setAPK(new APK(patient.getLeistung(Hzv.BUNDESWEIT_BAHNBKK.gnr("0000"), 1L, c2.c)));
        return !patient.hasLeistung("01480", Quartal.getBisVorjahr(c2.c)) && patient.getAlterAnTag(new Date()) > 13;
    }
}

