/*
 * Decompiled with CFR 0.152.
 */
package com.nhochdrei.kvdt.optimizer.rules;

import com.nhochdrei.kvdt.model.Action;
import com.nhochdrei.kvdt.model.ActionType;
import com.nhochdrei.kvdt.model.Patient;
import com.nhochdrei.kvdt.optimizer.Rule;
import com.nhochdrei.kvdt.optimizer.RuleCategory;
import com.nhochdrei.kvdt.optimizer.RulePrerequisite;
import com.nhochdrei.kvdt.optimizer.RuleRequirement;
import com.nhochdrei.kvdt.optimizer.Rules;
import com.nhochdrei.kvdt.optimizer.c;
import com.nhochdrei.kvdt.optimizer.misc.Quartale;
import java.util.Date;

@Rules(value=RuleCategory.HAUS_UND_HEIM)
public class h {
    @RulePrerequisite
    public static boolean a(c c2, Patient patient) {
        return c2.b(patient) && !c2.a(patient);
    }

    @Rule(name="{gnr} ist nur ein Mal im Behandlungsfall ansetzbar", action=ActionType.ENTFERNEN, gnr="37100 / 37102 / 37105")
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient) {
        return patient.getLeistungCount("37100|37102|37105", c2.c) > 1;
    }

    @Rule(name="37100 ist h\u00f6chstens zwei Mal im Krankheitsfall abrechenbar", action=ActionType.ENTFERNEN, gnr="37100")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean c(c c2, Patient patient) {
        if (!patient.hasLeistung("37100", c2.c)) {
            return false;
        }
        int n2 = 0;
        n2 += patient.hasLeistung("37100", c2.f) ? 1 : 0;
        n2 += patient.hasLeistung("37100", c2.e) ? 1 : 0;
        return (n2 += patient.hasLeistung("37100", c2.d) ? 1 : 0) >= 2;
    }

    @Rule(name="Koordinationspauschalen nicht im gleichen Behandlungsfall nebeneinander abrechnenbar", action=ActionType.ENTFERNEN)
    @RuleRequirement(value={Quartale.AQ})
    public static String d(c c2, Patient patient) {
        if (patient.hasLeistung("37100", c2.c) && patient.hasLeistung("37102", c2.c)) {
            if (patient.hasLeistungBeginntMit("01410|01413", c2.c)) {
                return "37100";
            }
            return "37102";
        }
        if (patient.hasLeistung("37100", c2.c) && patient.hasLeistung("37105", c2.c)) {
            return "37100";
        }
        if (patient.hasLeistung("37102", c2.c) && patient.hasLeistung("37105", c2.c)) {
            return "37102";
        }
        return null;
    }

    @Rule(name="37102 ist nur als Zuschlag zu den Ziffern 01410 bzw. 01413 (evtl. inkl. Suffix) abrechenbar", action=ActionType.NACHTRAGEN, daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static String a(c c2, Patient patient, Date date) {
        if (patient.hasLeistung("37102", c2.c, date) && !patient.hasLeistungBeginntMit("01410|01413", c2.c, date)) {
            return "01410/01410H/01413/01413H/01413K/01413L/01413P";
        }
        return null;
    }

    @Rule(name="37105 ist nur als Zuschlag zu den Ziffern 0300x, ggf. 03030 oder 0400x, ggf. 04030 bei Haus\u00e4rzten oder Kinder\u00e4rzten abrechenbar", action=ActionType.ENTFERNEN, gnr="37105", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean b(c c2, Patient patient, Date date) {
        return patient.hasLeistung("37015", c2.c, date) && !patient.hasLeistungBeginntMit("0300", c2.c, date) && !patient.hasLeistungBeginntMit("0400", c2.c, date) && !patient.hasLeistung("03030|04030", c2.c, date);
    }

    @Rule(name="37113 ohne Betreuungsziffer (37100 oder 37102 oder 37105) im aktuellen Quartal", action=ActionType.NACHTRAGEN, daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static String a(c c2, Patient patient, Date date, Action action) {
        if (!patient.hasLeistung("37113", c2.c, date) || patient.hasLeistung("37100|37102|37105", c2.c)) {
            return null;
        }
        if (patient.hasLeistung("37105", c2.d) || patient.hasLeistung("37105", c2.e)) {
            return "37105";
        }
        if ((patient.hasLeistung("37102", c2.d) || patient.hasLeistung("37102", c2.e)) && patient.hasLeistungBeginntMit("01410|01413", c2.c, date)) {
            return "37102";
        }
        if (patient.hasLeistung("37100", c2.d) || patient.hasLeistung("37100", c2.e)) {
            return "37100";
        }
        action.setActionType(ActionType.UEBERPRUEFEN);
        return "37113";
    }

    @Rule(name="s\u00e4umige Heimpatienten (eventuell nicht mehr im Heim betreut) / sonst Koordinationsziffer und Zuschl\u00e4ge m\u00f6glich", action=ActionType.NACHTRAGEN)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ})
    public static String e(c c2, Patient patient) {
        if (!patient.hasLeistungBeginntMit("371", c2.c) && patient.hasLeistungBeginntMit("371", c2.d) && (patient.hasLeistungBeginntMit("0300", c2.c) || patient.hasLeistungBeginntMit("0400", c2.c) || patient.hasLeistung("03030|04030", c2.c))) {
            if (patient.hasLeistung("37105", c2.d)) {
                return "37105";
            }
            if (patient.hasLeistung("37102", c2.d) && patient.hasLeistungBeginntMit("01410|01413", c2.c)) {
                return "37102";
            }
            if (patient.hasLeistung("37100", c2.d)) {
                return "37100";
            }
        }
        return null;
    }

    @Rule(name="Mitbesuchszuschlag f\u00fcr den Besuch eines Patienten im Pflegeheim mit Kooperationsvertrag (37113) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="37113", daily=true)
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ})
    public static boolean c(c c2, Patient patient, Date date) {
        return (patient.hasLeistungBeginntMit("371", c2.e) || patient.hasLeistungBeginntMit("371", c2.d) || patient.hasLeistungBeginntMit("371", c2.c)) && patient.hasLeistungBeginntMit("01413", c2.c, date) && !patient.hasLeistung("37113", c2.c, date);
    }

    @Rule(name="Mitbesuchsziffer 01413 (evtl. inkl. Suffix) m\u00f6glich", action=ActionType.NACHTRAGEN, gnr="01413", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean d(c c2, Patient patient, Date date) {
        return patient.hasLeistung("37113", c2.c, date) && !patient.hasLeistung("01413|01413H|01100|01101|01410|01411|01412|01414|01415|01418|01721|05230", c2.c, date) && !patient.hasLeistungBeginntMit("01413", c2.c, date);
    }

    @Rule(name="Zuschlag zur 01413 f\u00fcr den Besuch eines Patienten im Pflegeheim mit Kooperationsvertrag (37113) nur neben 01413 abrechenbar, nicht neben 01410, 01411, 01412", action=ActionType.UEBERPRUEFEN, gnr="01410|01411|01412", daily=true)
    @RuleRequirement(value={Quartale.AQ})
    public static boolean a(c c2, Patient patient, String string, Date date) {
        return patient.hasLeistung("37113", c2.c, date) && patient.hasLeistung(string, c2.c, date) && !patient.hasLeistungBeginntMit("01413", c2.c, date);
    }

    @Rule(name="37120 Fallkonferenzpauschale \u00f6fter als drei Mal im Krankheitsfall abgerechnet / H\u00f6chstmenge erreicht", action=ActionType.ENTFERNEN, gnr="37120")
    @RuleRequirement(value={Quartale.AQ, Quartale.VQ, Quartale.VVQ, Quartale.VVVQ})
    public static boolean f(c c2, Patient patient) {
        long l2 = 0L;
        l2 += patient.getLeistungen(c2.c).stream().filter(scheinLeistung -> "37120".equals(scheinLeistung.getGnr())).count();
        l2 += patient.getLeistungen(c2.d).stream().filter(scheinLeistung -> "37120".equals(scheinLeistung.getGnr())).count();
        l2 += patient.getLeistungen(c2.e).stream().filter(scheinLeistung -> "37120".equals(scheinLeistung.getGnr())).count();
        return patient.hasLeistung("37120", c2.c) && (l2 += patient.getLeistungen(c2.f).stream().filter(scheinLeistung -> "37120".equals(scheinLeistung.getGnr())).count()) > 3L;
    }
}

